/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import java.util.Map;

public class MemorySliceUtils {
    public static final String MEMORY_POINTER = "#memory_$Pointer$";
    public static final String MEMORY_INT = "#memory_int";
    public static final String MEMORY_REAL = "#memory_real";
    public static final String INIT_TO_ZERO_AT_POINTER_BASE_ADDRESS_POINTER = "~initToZeroAtPointerBaseAddress~$Pointer$";
    public static final String INIT_TO_ZERO_AT_POINTER_BASE_ADDRESS_INT = "~initToZeroAtPointerBaseAddress~int";
    public static final String WRITE_POINTER = "write~$Pointer$";
    public static final String WRITE_UNCHECKED_POINTER = "write~unchecked~$Pointer$";
    public static final String WRITE_INIT_POINTER = "write~init~$Pointer$";
    public static final String READ_POINTER = "read~$Pointer$";
    public static final String READ_UNCHECKED_POINTER = "read~unchecked~$Pointer$";
    public static final String WRITE_INT = "write~int";
    public static final String WRITE_UNCHECKED_INT = "write~unchecked~int";
    public static final String WRITE_INIT_INT = "write~init~int";
    public static final String READ_INT = "read~int";
    public static final String READ_UNCHECKED_INT = "read~unchecked~int";
    public static final String WRITE_REAL = "write~real";
    public static final String WRITE_UNCHECKED_REAL = "write~unchecked~real";
    public static final String WRITE_INIT_REAL = "write~init~real";
    public static final String READ_REAL = "read~real";
    public static final String READ_UNCHECKED_REAL = "read~unchecked~real";
    public static final String ALLOC_ON_STACK = "#Ultimate.allocOnStack";
    public static final String ALLOC_ON_HEAP = "#Ultimate.allocOnHeap";
    public static final String ALLOC_INIT = "#Ultimate.allocInit";
    public static final String ULTIMATE_DEALLOC = "ULTIMATE.dealloc";
    public static final String PTHREADS_FORK_COUNT = "#PthreadsForkCount";
    public static final String PTHREADS_MUTEX = "#PthreadsMutex";
    public static final String PTHREADS_MUTEX_LOCK = "#PthreadsMutexLock";
    public static final String PTHREADS_MUTEX_UNLOCK = "#PthreadsMutexUnlock";
    public static final String PTHREADS_MUTEX_TRYLOCK = "#PthreadsMutexTryLock";
    public static final String PTHREADS_RWLOCK = "#PthreadsRwLock";
    public static final String PTHREADS_RWLOCK_READLOCK = "#PthreadsRwLockReadLock";
    public static final String PTHREADS_RWLOCK_WRITELOCK = "#PthreadsRwLockWriteLock";
    public static final String PTHREADS_RWLOCK_UNLOCK = "#PthreadsRwLockUnlock";
    public static final String ULTIMATE_C_MEMCPY = "#Ultimate.C_memcpy";
    public static final String ULTIMATE_C_MEMMOVE = "#Ultimate.C_memmove";
    public static final String ULTIMATE_C_MEMSET = "#Ultimate.C_memset";
    public static final String ULTIMATE_C_STRCPY = "#Ultimate.C_strcpy";
    public static final String ULTIMATE_C_REALLOC = "#Ultimate.C_realloc";

    private MemorySliceUtils() {
    }

    public static VariableLHS replaceLeftHandSide(LeftHandSide leftHandSide, Map<String, String> map, String string, String string2) {
        if (leftHandSide instanceof VariableLHS) {
            VariableLHS variableLHS = (VariableLHS)leftHandSide;
            String string3 = map.get(variableLHS.getIdentifier());
            DeclarationInformation declarationInformation = MemorySliceUtils.updateDeclarationInformation(variableLHS.getDeclarationInformation(), string, string2);
            if (string3 != null) {
                VariableLHS variableLHS2 = new VariableLHS(leftHandSide.getLoc(), leftHandSide.getType(), string3, declarationInformation);
                ModelUtils.copyAnnotations((IElement)leftHandSide, (IElement)variableLHS2);
                return variableLHS2;
            }
            if (declarationInformation != variableLHS.getDeclarationInformation()) {
                VariableLHS variableLHS3 = new VariableLHS(leftHandSide.getLoc(), leftHandSide.getType(), variableLHS.getIdentifier(), declarationInformation);
                ModelUtils.copyAnnotations((IElement)leftHandSide, (IElement)variableLHS3);
                return variableLHS3;
            }
        }
        return null;
    }

    public static IdentifierExpression replaceIdentifierExpression(Expression expression, Map<String, String> map, String string, String string2) {
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            String string3 = map.get(identifierExpression.getIdentifier());
            DeclarationInformation declarationInformation = MemorySliceUtils.updateDeclarationInformation(identifierExpression.getDeclarationInformation(), string, string2);
            if (string3 != null) {
                IdentifierExpression identifierExpression2 = new IdentifierExpression(identifierExpression.getLoc(), identifierExpression.getType(), string3, declarationInformation);
                ModelUtils.copyAnnotations((IElement)expression, (IElement)identifierExpression2);
                return identifierExpression2;
            }
            if (declarationInformation != identifierExpression.getDeclarationInformation()) {
                IdentifierExpression identifierExpression3 = new IdentifierExpression(identifierExpression.getLoc(), identifierExpression.getType(), identifierExpression.getIdentifier(), declarationInformation);
                ModelUtils.copyAnnotations((IElement)expression, (IElement)identifierExpression3);
                return identifierExpression3;
            }
        }
        return null;
    }

    private static DeclarationInformation updateDeclarationInformation(DeclarationInformation declarationInformation, String string, String string2) {
        if (string == null && string2 == null) {
            return declarationInformation;
        }
        if (declarationInformation.getProcedure() == null) {
            return declarationInformation;
        }
        String string3 = string + string2;
        if (!declarationInformation.getProcedure().equals(string)) {
            throw new AssertionError((Object)String.format("No match! Existing procId %s, oldProcId %s, newProcId %s", declarationInformation.getProcedure(), string, string3));
        }
        return new DeclarationInformation(declarationInformation.getStorageClass(), string3);
    }

    public static String constructMemorySliceSuffix(int n) {
        return "#" + n;
    }

    public static boolean isPointerArray(LeftHandSide leftHandSide) {
        VariableLHS variableLHS;
        return leftHandSide instanceof VariableLHS && (variableLHS = (VariableLHS)leftHandSide).getIdentifier().equals(MEMORY_POINTER);
    }

    public static boolean isIntArray(LeftHandSide leftHandSide) {
        VariableLHS variableLHS;
        return leftHandSide instanceof VariableLHS && (variableLHS = (VariableLHS)leftHandSide).getIdentifier().equals(MEMORY_INT);
    }

    public static boolean isRealArray(LeftHandSide leftHandSide) {
        VariableLHS variableLHS;
        return leftHandSide instanceof VariableLHS && (variableLHS = (VariableLHS)leftHandSide).getIdentifier().equals(MEMORY_REAL);
    }

    public static boolean containsMemoryArrays(BoogieASTNode boogieASTNode) {
        String string = boogieASTNode.toString();
        return string.contains(MEMORY_POINTER) || string.contains(MEMORY_INT) || string.contains(MEMORY_REAL);
    }
}

