/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;

public class AcslTypeUtils {
    public static ICType translateAcslTypeToCType(ACSLType aCSLType) {
        return new CPrimitive(AcslTypeUtils.translatePrimitiveAcslTypeToCType(aCSLType));
    }

    private static CPrimitive.CPrimitives translatePrimitiveAcslTypeToCType(ACSLType aCSLType) {
        switch (aCSLType.getTypeName()) {
            case "char": {
                return CPrimitive.CPrimitives.CHAR;
            }
            case "signed char": {
                return CPrimitive.CPrimitives.SCHAR;
            }
            case "unsigned char": {
                return CPrimitive.CPrimitives.UCHAR;
            }
            case "short int": 
            case "signed short int": 
            case "short": 
            case "signed short": {
                return CPrimitive.CPrimitives.SHORT;
            }
            case "unsigned short": 
            case "unsigned short int": {
                return CPrimitive.CPrimitives.USHORT;
            }
            case "signed int": 
            case "int": {
                return CPrimitive.CPrimitives.INT;
            }
            case "unsigned": 
            case "unsigned int": {
                return CPrimitive.CPrimitives.UINT;
            }
            case "long int": 
            case "signed long": 
            case "long": 
            case "signed long int": {
                return CPrimitive.CPrimitives.LONG;
            }
            case "unsigned long": 
            case "unsigned long int": {
                return CPrimitive.CPrimitives.ULONG;
            }
            case "signed long long int": 
            case "long long": 
            case "long long int": 
            case "signed long long": {
                return CPrimitive.CPrimitives.LONGLONG;
            }
            case "unsigned long long int": 
            case "size_t": 
            case "unsigned long long": {
                return CPrimitive.CPrimitives.ULONGLONG;
            }
            case "__int128": {
                return CPrimitive.CPrimitives.INT128;
            }
            case "unsigned __int128": {
                return CPrimitive.CPrimitives.UINT128;
            }
            case "float": {
                return CPrimitive.CPrimitives.FLOAT;
            }
            case "double": {
                return CPrimitive.CPrimitives.DOUBLE;
            }
            case "long double": {
                return CPrimitive.CPrimitives.LONGDOUBLE;
            }
            case "__float128": {
                return CPrimitive.CPrimitives.FLOAT128;
            }
            case "_Bool": {
                return CPrimitive.CPrimitives.BOOL;
            }
        }
        throw new UnsupportedOperationException("Unhandled ACSL type " + String.valueOf(aCSLType));
    }

    public static ACSLType translateCTypeToAcslType(ICType iCType) {
        if (!(iCType instanceof CPrimitive)) {
            throw new UnsupportedOperationException("Currently only primitive types are supported, got " + iCType.getClass().getSimpleName());
        }
        CPrimitive cPrimitive = (CPrimitive)iCType;
        return new ACSLType(cPrimitive.getType().getTypeName());
    }
}

