/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiToGeneralizedBuchi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.AbstractGeneralizedAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GetLassoRunFromLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.LassoConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class GetLassoRunFromLassoWord<LETTER, STATE>
extends AbstractGeneralizedAutomatonReachableStates<LETTER, STATE> {
    private final IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    protected final IStateFactory<STATE> mStateFactory;
    private final Map<STATE, StateContainer<LETTER, STATE>> mStates = new HashMap<STATE, StateContainer<LETTER, STATE>>();
    private final ReachableStatesComputationTarjan mReach;
    private final NestedWord<LETTER> mStem;
    private final NestedWord<LETTER> mLoop;

    public GetLassoRunFromLassoWord(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, NestedLassoWord<LETTER> nestedLassoWord) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet());
        this.mStateFactory = iNwaOutgoingLetterAndTransitionProvider.getStateFactory();
        this.mDownStates.add(iNwaOutgoingLetterAndTransitionProvider.getEmptyStackState());
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider instanceof IGeneralizedNwaOutgoingLetterAndTransitionProvider ? (IGeneralizedNwaOutgoingLetterAndTransitionProvider)iNwaOutgoingLetterAndTransitionProvider : new BuchiToGeneralizedBuchi<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider);
        this.mStem = nestedLassoWord.getStem();
        this.mLoop = nestedLassoWord.getLoop();
        if (!this.mOperand.getVpAlphabet().getCallAlphabet().isEmpty() || !this.mOperand.getVpAlphabet().getReturnAlphabet().isEmpty()) {
            throw new UnsupportedOperationException("Calls or Returns are not empty");
        }
        if (this.mLoop.length() == 0) {
            throw new UnsupportedOperationException("Loop is empty");
        }
        try {
            this.mReach = new ReachableStatesComputationTarjan();
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            throw toolchainCanceledException;
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.stateContainerInformation());
        }
    }

    protected int getNextState(int n) {
        if (n < this.mStem.length() + this.mLoop.length()) {
            return n + 1;
        }
        assert (n == this.mStem.length() + this.mLoop.length());
        return this.mStem.length() + 1;
    }

    protected LETTER getNextLetter(int n) {
        assert (n <= this.mStem.length() + this.mLoop.length());
        if (n < this.mStem.length()) {
            return this.mStem.getSymbol(n);
        }
        if (n < this.mStem.length() + this.mLoop.length()) {
            return this.mLoop.getSymbol(n - this.mStem.length());
        }
        assert (n == this.mStem.length() + this.mLoop.length());
        return this.mLoop.getSymbol(0);
    }

    @Override
    protected StateContainer<LETTER, STATE> getStateContainer(STATE STATE) {
        return this.mStates.get(STATE);
    }

    private String stateContainerInformation() {
        return this.mStates.size() + " StateContainers ";
    }

    private StateContainer<LETTER, STATE> getOrAddState(STATE STATE) {
        StateContainer<LETTER, STATE> stateContainer = this.mStates.get(STATE);
        if (stateContainer == null) {
            stateContainer = new StateContainer(STATE);
            this.mStates.put(STATE, stateContainer);
        }
        return stateContainer;
    }

    @Override
    public Boolean isEmpty() {
        return this.mReach.isEmpty();
    }

    @Override
    public NestedLassoRun<LETTER, STATE> getNestedLassoRun() throws AutomataOperationCanceledException {
        if (this.mReach.isEmpty().booleanValue()) {
            return null;
        }
        if (this.mLasso == null) {
            for (List list : this.mReach.getLoopList()) {
                LassoConstructor lassoConstructor = new LassoConstructor(this.mServices, this, list);
                NestedLassoRun nestedLassoRun = lassoConstructor.getNestedLassoRun();
                if (this.mLasso != null && this.mLasso.getStem().getLength() + this.mLasso.getLoop().getLength() <= nestedLassoRun.getStem().getLength() + nestedLassoRun.getLoop().getLength()) continue;
                this.mLasso = nestedLassoRun;
            }
        }
        return this.mLasso;
    }

    @Override
    public Set<STATE> getStates() {
        return this.mStates.keySet();
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        return this.mStates.get(STATE).lettersInternalIncoming();
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalPredecessors(LETTER);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        return this.mStates.get(STATE).internalPredecessors();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalSuccessors(LETTER);
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        return null;
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mOperand.getEmptyStackState();
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mOperand.isInitial(STATE);
    }

    @Override
    public int getAcceptanceSize() {
        return this.mOperand.getAcceptanceSize();
    }

    @Override
    public boolean isFinal(STATE STATE, int n) {
        return this.mOperand.isFinal(STATE, n);
    }

    @Override
    public Set<Integer> getAcceptanceLabels(STATE STATE) {
        return this.mOperand.getAcceptanceLabels(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return !this.getAcceptanceLabels(STATE).isEmpty();
    }

    class ReachableStatesComputationTarjan {
        private final de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GetLassoRunFromLassoWord$ReachableStatesComputationTarjan.Tarjan mTarjan;

        public ReachableStatesComputationTarjan() throws AutomataOperationCanceledException {
            GetLassoRunFromLassoWord.this.mNumberOfConstructedStates = 0;
            this.mTarjan = new Tarjan();
        }

        public Boolean isEmpty() {
            return this.mTarjan.mIsEmpty;
        }

        public List<List<STATE>> getLoopList() {
            return this.mTarjan.mSCC;
        }

        private class Tarjan {
            private int mIndex = 0;
            private final Stack<STATE> mStack = new Stack();
            private final TObjectIntMap<STATE> mIndexMap = new TObjectIntHashMap();
            private final TObjectIntMap<STATE> mLowlinkMap = new TObjectIntHashMap();
            private final List<List<STATE>> mSCC = new ArrayList();
            private Boolean mIsEmpty = null;

            public Tarjan() throws AutomataOperationCanceledException {
                for (Object STATE : ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mOperand.getInitialStates()) {
                    ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mInitialStates.add(STATE);
                    if (this.mIndexMap.containsKey(STATE)) continue;
                    this.strongConnect(STATE, 0);
                }
                if (this.mIsEmpty == null) {
                    this.mIsEmpty = true;
                }
            }

            private AutomataLibraryServices getServices() {
                return ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mServices;
            }

            private RunningTaskInfo constructRunningTaskInfo() {
                String string = GetLassoRunFromLassoWord.constructRunningTaskInfoMessage(((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mNumberOfConstructedStates, ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mOperand.getClass());
                return new RunningTaskInfo(this.getClass(), string);
            }

            void strongConnect(STATE STATE, int n) throws AutomataOperationCanceledException {
                Object bl;
                this.mStack.push(STATE);
                this.mIndexMap.put(STATE, this.mIndex);
                this.mLowlinkMap.put(STATE, this.mIndex);
                ++this.mIndex;
                ++((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mNumberOfConstructedStates;
                StateContainer stateContainer = GetLassoRunFromLassoWord.this.getOrAddState(STATE);
                for (OutgoingInternalTransition object2 : ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mOperand.internalSuccessors(STATE, GetLassoRunFromLassoWord.this.getNextLetter(n))) {
                    if (!this.getServices().getProgressAwareTimer().continueProcessing()) {
                        bl = this.constructRunningTaskInfo();
                        throw new AutomataOperationCanceledException((RunningTaskInfo)bl);
                    }
                    bl = object2.getSucc();
                    if (!this.mIndexMap.containsKey(bl)) {
                        this.strongConnect(bl, GetLassoRunFromLassoWord.this.getNextState(n));
                        this.mLowlinkMap.put(STATE, Math.min(this.mLowlinkMap.get(STATE), this.mLowlinkMap.get(bl)));
                    } else if (this.mStack.contains(bl)) {
                        this.mLowlinkMap.put(STATE, Math.min(this.mLowlinkMap.get(STATE), this.mIndexMap.get(bl)));
                    }
                    stateContainer.addInternalOutgoing(object2);
                    StateContainer stateContainer2 = GetLassoRunFromLassoWord.this.getOrAddState(bl);
                    stateContainer2.addInternalIncoming(new IncomingInternalTransition(STATE, object2.getLetter()));
                }
                if (this.mLowlinkMap.get(STATE) == this.mIndexMap.get(STATE)) {
                    boolean bl2;
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    ArrayList arrayList = new ArrayList();
                    while (!this.mStack.empty()) {
                        bl = this.mStack.pop();
                        hashSet.addAll(((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mOperand.getAcceptanceLabels(bl));
                        arrayList.add(bl);
                        if (bl.equals(STATE)) break;
                    }
                    boolean bl3 = bl2 = ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GetLassoRunFromLassoWord.this.mOperand.getAcceptanceSize() == hashSet.size();
                    if (arrayList.size() == 1 && bl2 && !stateContainer.hashSelfloop()) {
                        bl2 = false;
                    }
                    if (bl2) {
                        this.mIsEmpty = false;
                        this.mSCC.add(arrayList);
                        if (Options.verbose) {
                            System.out.println("Loop: " + String.valueOf(arrayList));
                        }
                    }
                }
            }
        }
    }
}

