/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.StringRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.isDetereministic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AGetRandomFtaBU
extends GeneralOperation<StringRankedLetter, String, IStateFactory<String>> {
    private static final String LETTER_PREFIX = "a";
    private static final String STATE_PREFIX = "q";
    private final double mAcceptanceDensity;
    private final boolean mGenerateOnlyDeterministic;
    private final int mNumberOfStates;
    private final int[] mRankToNumberOfLetters;
    protected final int[] mRankToNumberOfTransitionsPerLetter;
    private TreeAutomatonBU<StringRankedLetter, String> mResult = null;
    private long mSeed;

    protected static int densityToAbsolute(double d, int n) {
        int n2 = (int)(d * (double)n);
        if (n2 > 0) {
            return n2;
        }
        if (d == 0.0) {
            return 0;
        }
        return 1;
    }

    public AGetRandomFtaBU(AutomataLibraryServices automataLibraryServices, int n, int[] nArray, int[] nArray2, double d, boolean bl, long l) {
        super(automataLibraryServices);
        this.mNumberOfStates = n;
        this.mRankToNumberOfLetters = nArray;
        this.mRankToNumberOfTransitionsPerLetter = nArray2;
        this.mAcceptanceDensity = d;
        this.mGenerateOnlyDeterministic = bl;
        this.mSeed = l;
    }

    @Override
    public TreeAutomatonBU<StringRankedLetter, String> getResult() {
        assert (new isDetereministic<StringRankedLetter, String>(this.mServices, this.mResult).getResult().booleanValue());
        return this.mResult;
    }

    private void addStates(TreeAutomatonBU<StringRankedLetter, String> treeAutomatonBU, String[] stringArray) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to generate states");
        }
        int n = AGetRandomFtaBU.densityToAbsolute(this.mAcceptanceDensity, this.mNumberOfStates);
        int n2 = 0;
        while (n2 < this.mNumberOfStates) {
            String string = STATE_PREFIX + Integer.toString(n2);
            if (n2 < n) {
                treeAutomatonBU.addFinalState(string);
            } else {
                treeAutomatonBU.addState(string);
            }
            stringArray[n2] = string;
            ++n2;
        }
    }

    private void addTransitionsAndLetters(TreeAutomatonBU<StringRankedLetter, String> treeAutomatonBU, String[] stringArray, Random random) throws IllegalStateException, AutomataOperationCanceledException {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to generate transitions and letters");
        }
        int n2 = Math.min(this.mRankToNumberOfLetters.length, this.mRankToNumberOfTransitionsPerLetter.length) - 1;
        int n3 = 0;
        while (n3 <= n2) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Generating transitions and letters for rank " + n3));
            }
            int n4 = this.mRankToNumberOfLetters[n3];
            int n5 = this.mRankToNumberOfTransitionsPerLetter[n3];
            int n6 = 0;
            while (n6 < n4) {
                Set set;
                Set set2;
                String string = LETTER_PREFIX + n3 + "_" + Integer.toString(n6);
                StringRankedLetter stringRankedLetter = new StringRankedLetter(string, n3);
                treeAutomatonBU.addLetter(stringRankedLetter);
                if (this.mGenerateOnlyDeterministic) {
                    set2 = new HashSet(n5);
                    set = Collections.emptySet();
                } else {
                    set2 = Collections.emptySet();
                    set = new HashSet(n5);
                }
                int n7 = 0;
                while (n7 < n5) {
                    List list;
                    int n8 = random.nextInt(this.mNumberOfStates);
                    String string2 = stringArray[n8];
                    do {
                        if (n3 != 0) continue;
                        list = Collections.emptyList();
                        break;
                    } while (set2.contains(list = (List)random.ints(n3, 0, this.mNumberOfStates).sequential().boxed().collect(Collectors.toCollection(ArrayList::new))));
                    if (this.mGenerateOnlyDeterministic) {
                        set2.add(list);
                    }
                    ArrayList arrayList = ((Stream)list.stream().sequential()).map(n -> stringArray[n]).collect(Collectors.toCollection(ArrayList::new));
                    TreeAutomatonRule<StringRankedLetter, String> treeAutomatonRule = new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter, arrayList, string2);
                    if (!this.mGenerateOnlyDeterministic) {
                        if (set.contains(treeAutomatonRule)) continue;
                        set.add(treeAutomatonRule);
                    }
                    treeAutomatonBU.addRule(treeAutomatonRule);
                    ++n7;
                }
                if (this.mServices.getProgressAwareTimer() != null && this.isCancellationRequested()) {
                    this.mLogger.debug((Object)"Stopped at creating transitions for letters");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                ++n6;
            }
            ++n3;
        }
    }

    protected void checkInputValidity() throws IllegalArgumentException {
        int n;
        if (this.mNumberOfStates < 0) {
            throw new IllegalArgumentException("Negative number of states.");
        }
        int[] nArray = this.mRankToNumberOfLetters;
        int n2 = this.mRankToNumberOfLetters.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            if (n < 0) {
                throw new IllegalArgumentException("Negative number of letters.");
            }
            ++n3;
        }
        n = 0;
        while (n < this.mRankToNumberOfTransitionsPerLetter.length) {
            n3 = this.mRankToNumberOfTransitionsPerLetter[n];
            if (n3 < 0) {
                throw new IllegalArgumentException("Negative number of transitions per letter.");
            }
            if (n3 > 0 && n < this.mRankToNumberOfLetters.length && this.mRankToNumberOfLetters[n] <= 0) {
                throw new IllegalArgumentException("Impossible to have transitions without letters.");
            }
            ++n;
        }
        n = Math.min(this.mRankToNumberOfLetters.length, this.mRankToNumberOfTransitionsPerLetter.length);
        if (n > this.mNumberOfStates) {
            throw new IllegalArgumentException("Impossible to have letters with a rank greater than the amount of states.");
        }
        if (this.mAcceptanceDensity < 0.0 || this.mAcceptanceDensity > 1.0) {
            throw new IllegalArgumentException("Illegal acceptance density.");
        }
    }

    protected TreeAutomatonBU<StringRankedLetter, String> generateAutomaton(long l) throws AutomataOperationCanceledException {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Starting generation using the seed " + l));
        }
        TreeAutomatonBU<StringRankedLetter, String> treeAutomatonBU = new TreeAutomatonBU<StringRankedLetter, String>();
        if (this.mNumberOfStates == 0) {
            return treeAutomatonBU;
        }
        Random random = new Random(l);
        String[] stringArray = new String[this.mNumberOfStates];
        this.addStates(treeAutomatonBU, stringArray);
        if (this.mServices.getProgressAwareTimer() != null && this.isCancellationRequested()) {
            this.mLogger.debug((Object)"Stopped between creating states and transitions");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        this.addTransitionsAndLetters(treeAutomatonBU, stringArray, random);
        return treeAutomatonBU;
    }

    protected void startGeneration() throws AutomataOperationCanceledException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.checkInputValidity();
        this.mResult = this.generateAutomaton(this.mSeed);
        ++this.mSeed;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }
}

