/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheckCraig;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.Activator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class LoopCannibalizer<LETTER extends IIcfgTransition<?>> {
    private final NestedLassoRun<LETTER, IPredicate> mCounterexample;
    private final PredicateFactory mPredicateFactory;
    private final PredicateUnifier mPredicateUnifier;
    private final CfgSmtToolkit mCsToolkit;
    private final Set<IPredicate> mResultPredicates;
    private final Set<IPredicate> mOriginalLoopInterpolants;
    private final NestedWord<LETTER> mLoop;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final IPredicate mRankEqAndSi;
    private final IPredicate mHondaPredicate;

    public LoopCannibalizer(NestedLassoRun<LETTER, IPredicate> nestedLassoRun, Set<IPredicate> set, IPredicate iPredicate, IPredicate iPredicate2, PredicateUnifier predicateUnifier, CfgSmtToolkit cfgSmtToolkit, InterpolationTechnique interpolationTechnique, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mCounterexample = nestedLassoRun;
        this.mRankEqAndSi = iPredicate;
        this.mHondaPredicate = iPredicate2;
        this.mPredicateFactory = (PredicateFactory)predicateUnifier.getPredicateFactory();
        this.mPredicateUnifier = predicateUnifier;
        this.mCsToolkit = cfgSmtToolkit;
        this.mOriginalLoopInterpolants = set;
        this.mResultPredicates = new HashSet<IPredicate>(set);
        this.mLoop = this.mCounterexample.getLoop().getWord();
        this.cannibalize(interpolationTechnique);
        this.mLogger.info((Object)this.exitMessage());
    }

    private StringBuilder exitMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mOriginalLoopInterpolants.size());
        stringBuilder.append(" predicates before loop cannibalization ");
        stringBuilder.append(this.mResultPredicates.size());
        stringBuilder.append(" predicates after loop cannibalization ");
        return stringBuilder;
    }

    private void cannibalize(InterpolationTechnique interpolationTechnique) {
        int n;
        int n2 = this.mLoop.isCallPosition(0) && !this.mLoop.isPendingCall(0) ? (n = this.mLoop.getReturnPosition(0)) : 1;
        n = n2;
        while (n < this.mLoop.length() - 1) {
            if (this.mLoop.isCallPosition(n) && !this.mLoop.isPendingCall(n)) {
                int n3;
                n = n3 = this.mLoop.getReturnPosition(n);
                continue;
            }
            if (this.checkForNewPredicates(n)) {
                NestedWord nestedWord = this.mLoop.getSubWord(0, n + 1);
                NestedWord nestedWord2 = this.mLoop.getSubWord(n + 1, this.mLoop.length() - 1);
                NestedWord nestedWord3 = nestedWord2.concatenate(nestedWord);
                InterpolatingTraceCheck<IIcfgTransition<?>> interpolatingTraceCheck = this.getTraceCheck(nestedWord3, interpolationTechnique);
                Script.LBool lBool = interpolatingTraceCheck.isCorrect();
                if (lBool == Script.LBool.UNSAT) {
                    IPredicate[] iPredicateArray = interpolatingTraceCheck.getInterpolants();
                    Set set = this.mPredicateUnifier.cannibalizeAll(false, Arrays.asList(iPredicateArray));
                    this.mResultPredicates.addAll(set);
                } else {
                    this.mLogger.info((Object)"termination argument not suffcient for all loop shiftings");
                }
            }
            ++n;
        }
    }

    private InterpolatingTraceCheck<? extends IIcfgTransition<?>> getTraceCheck(NestedWord<? extends IIcfgTransition<?>> nestedWord, InterpolationTechnique interpolationTechnique) {
        Counterexample counterexample = new Counterexample(nestedWord);
        return switch (interpolationTechnique) {
            case InterpolationTechnique.Craig_NestedInterpolation, InterpolationTechnique.Craig_TreeInterpolation -> new InterpolatingTraceCheckCraig(this.mRankEqAndSi, this.mHondaPredicate, new TreeMap(), counterexample, this.mServices, this.mCsToolkit, this.mPredicateFactory, (IPredicateUnifier)this.mPredicateUnifier, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, false, false, interpolationTechnique, true, this.mSimplificationTechnique);
            case InterpolationTechnique.ForwardPredicates, InterpolationTechnique.BackwardPredicates, InterpolationTechnique.FPandBP, InterpolationTechnique.FPandBPonlyIfFpWasNotPerfect -> new TraceCheckSpWp(this.mRankEqAndSi, this.mHondaPredicate, new TreeMap(), counterexample, this.mCsToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL, true, this.mServices, false, this.mPredicateFactory, (IPredicateUnifier)this.mPredicateUnifier, interpolationTechnique, this.mCsToolkit.getManagedScript(), this.mSimplificationTechnique, false);
            default -> throw new UnsupportedOperationException("unsupported interpolation");
        };
    }

    private boolean checkForNewPredicates(int n) {
        if (this.codeBlockContainsVarOfHondaPredicate((IIcfgTransition)this.mLoop.getSymbol(n))) {
            return true;
        }
        if (this.mLoop.isReturnPosition(n)) {
            assert (!this.mLoop.isPendingReturn(n)) : "not yet supported";
            return true;
        }
        return this.mLoop.isCallPosition(n + 1) && !this.mLoop.isPendingCall(n + 1);
    }

    private boolean codeBlockContainsVarOfHondaPredicate(LETTER LETTER) {
        Set set;
        Set set2 = this.mHondaPredicate.getVars();
        if (!Collections.disjoint(set2, set = LETTER.getTransformula().getInVars().keySet())) {
            return true;
        }
        Set set3 = LETTER.getTransformula().getOutVars().keySet();
        return !Collections.disjoint(set2, set3);
    }

    public Set<IPredicate> getResult() {
        return this.mResultPredicates;
    }
}

