/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.srparse.pattern;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScope;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.AbsencePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.BndEntryConditionPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ConditionalResponseBoundL1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ConstrainedChainPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DurationBoundLPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DurationBoundUPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.EdgeResponseBoundL2Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.EdgeResponseBoundU1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.EdgeResponseDelayBoundL2Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.EdgeResponseDelayPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ExistenceBoundUPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InitializationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InvarianceBoundL2Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InvarianceDelayPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InvariancePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PersistencePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PrecedenceChain12Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PrecedenceChain21Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PrecedencePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ReccurrenceBoundLPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseBoundL12Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseBoundL1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseChain12Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseDelayBoundL1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseDelayBoundL2Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseDelayPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponsePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.TriggerResponseBoundL1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.TriggerResponseDelayBoundL1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.UniversalityDelayPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.UniversalityPattern;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PatternBuilder {
    private static final Class<?>[] PATTERNS = new Class[]{ResponseDelayBoundL2Pattern.class, ResponseDelayBoundL1Pattern.class, EdgeResponseBoundL2Pattern.class, EdgeResponseDelayBoundL2Pattern.class, EdgeResponseBoundU1Pattern.class, BndEntryConditionPattern.class, ExistenceBoundUPattern.class, InvarianceBoundL2Pattern.class, ReccurrenceBoundLPattern.class, ResponseBoundL12Pattern.class, ResponseBoundL1Pattern.class, ResponseDelayPattern.class, TriggerResponseBoundL1Pattern.class, TriggerResponseDelayBoundL1Pattern.class, ConstrainedChainPattern.class, EdgeResponseDelayPattern.class, DeclarationPattern.class, AbsencePattern.class, InitializationPattern.class, InvariancePattern.class, DurationBoundUPattern.class, DurationBoundLPattern.class, PersistencePattern.class, PrecedenceChain12Pattern.class, PrecedenceChain21Pattern.class, PrecedencePattern.class, ResponseChain12Pattern.class, ResponsePattern.class, UniversalityPattern.class, UniversalityDelayPattern.class, InvarianceDelayPattern.class, ConditionalResponseBoundL1Pattern.class};
    private static final Map<Class<? extends PatternType<?>>, PatternTypeConstructor> CONSTRUCTORS = new HashMap();
    private final List<CDD> mCDDs = new ArrayList<CDD>();
    private final List<Rational> mDurations = new ArrayList<Rational>();
    private final List<String> mDurationNames = new ArrayList<String>();
    private String mId;
    private Class<? extends PatternType<?>> mClazz;
    private SrParseScope<?> mScope;

    static {
        Class<?>[] classArray = PATTERNS;
        int n = PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            PatternTypeConstructor patternTypeConstructor = (srParseScope, string, list, list2, list3) -> {
                try {
                    return (PatternType)clazz.getConstructor(SrParseScope.class, String.class, List.class, List.class, List.class).newInstance(srParseScope, string, list, list2, list3);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new RuntimeException(throwable);
                }
            };
            CONSTRUCTORS.put(clazz, patternTypeConstructor);
            ++n2;
        }
    }

    public PatternBuilder addCdd(CDD ... cDDArray) {
        PatternBuilder.add(this.mCDDs, cDDArray);
        return this;
    }

    public PatternBuilder addDuration(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                Rational rational;
                String string2 = stringArray2[n2];
                try {
                    rational = SmtUtils.toRational((String)string2);
                    string = null;
                }
                catch (Exception exception) {
                    rational = null;
                    string = string2;
                }
                this.mDurations.add(rational);
                this.mDurationNames.add(string);
                ++n2;
            }
        }
        return this;
    }

    public PatternBuilder setId(String string) {
        this.mId = string;
        return this;
    }

    public PatternBuilder setType(Class<? extends PatternType<?>> clazz) {
        this.mClazz = clazz;
        return this;
    }

    public PatternBuilder setScope(SrParseScope<?> srParseScope) {
        this.mScope = srParseScope;
        return this;
    }

    @SafeVarargs
    private static <T> void add(Collection<T> collection, T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return;
        }
        Arrays.stream(TArray).forEachOrdered(collection::add);
    }

    public PatternType<?> build(Durations durations) {
        if (this.mClazz == null) {
            throw new IllegalStateException("Type of pattern not yet specified");
        }
        if (this.mId == null) {
            throw new IllegalStateException("Id of pattern not yet specified");
        }
        if (this.mScope == null) {
            throw new IllegalStateException("Scope of pattern not yet specified");
        }
        PatternTypeConstructor patternTypeConstructor = PatternBuilder.getConstructor(this.mClazz);
        if (this.mDurationNames.stream().allMatch(Objects::isNull)) {
            return patternTypeConstructor.construct(this.mScope, this.mId, this.mCDDs, this.mDurations, Collections.emptyList());
        }
        int n = 0;
        while (n < this.mDurations.size()) {
            Rational rational = this.mDurations.get(n);
            if (rational == null) {
                String string = this.mDurationNames.get(n);
                Rational rational2 = durations.getConstantValue(string);
                if (rational2 == null) {
                    return null;
                }
                this.mDurations.set(n, rational2);
            }
            ++n;
        }
        return patternTypeConstructor.construct(this.mScope, this.mId, this.mCDDs, this.mDurations, this.mDurationNames);
    }

    public static PatternTypeConstructor getConstructor(Class<? extends PatternType<?>> clazz) {
        PatternTypeConstructor patternTypeConstructor = CONSTRUCTORS.get(clazz);
        if (patternTypeConstructor == null) {
            throw new UnsupportedOperationException("Unknown pattern type " + String.valueOf(clazz));
        }
        return patternTypeConstructor;
    }

    public static PatternType<?> normalize(PatternType<?> patternType, Durations durations) {
        if (patternType instanceof DeclarationPattern) {
            return patternType;
        }
        PatternBuilder patternBuilder = new PatternBuilder();
        patternBuilder.mId = patternType.getId();
        patternBuilder.mScope = patternType.getScope();
        patternBuilder.mClazz = patternType.getClass();
        patternBuilder.mDurationNames.addAll(patternType.getDurationNames());
        patternBuilder.mCDDs.addAll(patternType.getCdds());
        Rational rational = durations.computeScalingFactor();
        for (Rational rational2 : patternType.getDurations()) {
            patternBuilder.mDurations.add(rational2.mul(rational));
        }
        return patternBuilder.build(durations);
    }

    @FunctionalInterface
    public static interface PatternTypeConstructor {
        public PatternType<?> construct(SrParseScope<?> var1, String var2, List<CDD> var3, List<Rational> var4, List<String> var5);
    }
}

