/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.List;

public final class LassoExtractor<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mReach;
    private final List<NestedLassoRun<LETTER, STATE>> mNestedLassoRuns;
    private final List<NestedLassoWord<LETTER>> mNestedLassoWords;

    public LassoExtractor(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mLogger.info((Object)this.startMessage());
        this.mReach = this.mOperand instanceof NestedWordAutomatonReachableStates ? (NestedWordAutomatonReachableStates)this.mOperand : new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, this.mOperand);
        this.mReach.getOrComputeAcceptingComponents();
        this.mNestedLassoRuns = this.mReach.getOrComputeAcceptingComponents().getAllNestedLassoRuns();
        this.mNestedLassoWords = new ArrayList<NestedLassoWord<LETTER>>(this.mNestedLassoRuns.size());
        if (this.mNestedLassoRuns.isEmpty() && this.mReach.getOrComputeAcceptingComponents().getNestedLassoRun() == null) {
            assert (new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mReach).getResult().booleanValue());
        } else {
            for (NestedLassoRun<LETTER, STATE> nestedLassoRun : this.mNestedLassoRuns) {
                this.mNestedLassoWords.add(nestedLassoRun.getNestedLassoWord());
            }
        }
        this.mLogger.info((Object)this.exitMessage());
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public List<NestedLassoWord<LETTER>> getResult() {
        return this.mNestedLassoWords;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Found " + this.mNestedLassoRuns.size() + " examples of accepted words.";
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

