/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.PetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.HashSet;
import java.util.Set;

public final class Accepts<LETTER, PLACE>
extends UnaryNetOperation<LETTER, PLACE, IPetriNet2FiniteAutomatonStateFactory<PLACE>> {
    private final IPetriNetTransitionProvider<LETTER, PLACE> mOperand;
    private final Word<LETTER> mWord;
    private final boolean mResult;

    public Accepts(AutomataLibraryServices automataLibraryServices, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider, Word<LETTER> word) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mOperand = iPetriNetTransitionProvider;
        this.mWord = word;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.getResultHelper(0, new Marking(ImmutableSet.of(iPetriNetTransitionProvider.getInitialPlaces())));
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Operand " + this.mOperand.sizeInformation();
    }

    @Override
    protected IPetriNetTransitionProvider<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    private boolean getResultHelper(int n, Marking<PLACE> marking) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        if (n >= this.mWord.length()) {
            return this.mOperand.isAccepting(marking);
        }
        if (this.isCancellationRequested()) {
            throw new AutomataOperationCanceledException(this.getClass());
        }
        LETTER LETTER = this.mWord.getSymbol(n);
        if (!this.mOperand.getAlphabet().contains(LETTER)) {
            throw new IllegalArgumentException("Symbol " + String.valueOf(LETTER) + " not in alphabet");
        }
        int n2 = n + 1;
        boolean bl = false;
        for (Transition<LETTER, PLACE> transition : this.activeTransitionsWithSymbol(marking, LETTER)) {
            Marking<PLACE> marking2 = marking.fireTransition(transition);
            if (!this.getResultHelper(n2, marking2)) continue;
            bl = true;
        }
        return bl;
    }

    private Set<Transition<LETTER, PLACE>> activeTransitionsWithSymbol(Marking<PLACE> marking, LETTER LETTER) {
        HashSet<Transition<LETTER, PLACE>> hashSet = new HashSet<Transition<LETTER, PLACE>>();
        for (PLACE PLACE : marking) {
            this.mOperand.getSuccessors(PLACE).stream().filter(transition -> transition.getSymbol().equals(LETTER)).filter(marking::isTransitionEnabled).forEach(hashSet::add);
        }
        return hashSet;
    }

    @Override
    public boolean checkResult(IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory) throws AutomataLibraryException {
        boolean bl;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Testing correctness of accepts");
        }
        NestedWord<LETTER> nestedWord = NestedWord.nestedWord(this.mWord);
        boolean bl2 = new de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Accepts(this.mServices, new PetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, iPetriNet2FiniteAutomatonStateFactory, this.mOperand).getResult(), nestedWord).getResult();
        boolean bl3 = bl = this.mResult == bl2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Finished testing correctness of accepts");
        }
        return bl;
    }
}

