/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import java.util.ArrayList;
import java.util.List;

public class Backbone {
    private final List<IcfgEdge> mTransitions;

    public Backbone(IcfgEdge icfgEdge) {
        this.mTransitions = new ArrayList<IcfgEdge>();
        this.mTransitions.add(icfgEdge);
    }

    public Backbone(Backbone backbone) {
        this.mTransitions = new ArrayList<IcfgEdge>(backbone.mTransitions);
    }

    public void addTransition(IcfgEdge icfgEdge) {
        this.mTransitions.add(icfgEdge);
    }

    public boolean containsLocation(IcfgLocation icfgLocation) {
        for (IcfgEdge icfgEdge : this.mTransitions) {
            if (!((IcfgLocation)icfgEdge.getSource()).equals((Object)icfgLocation)) continue;
            return true;
        }
        return this.getLastLocation().equals((Object)icfgLocation);
    }

    public boolean endsInLoop() {
        IcfgLocation icfgLocation = this.getLastLocation();
        for (IcfgEdge icfgEdge : this.mTransitions) {
            if (!((IcfgLocation)icfgEdge.getSource()).equals((Object)icfgLocation)) continue;
            return true;
        }
        return false;
    }

    public IcfgLocation getLastLocation() {
        return (IcfgLocation)this.mTransitions.get(this.mTransitions.size() - 1).getTarget();
    }

    public IcfgEdge getLoopEntryTransition() {
        IcfgLocation icfgLocation = this.getLastLocation();
        for (IcfgEdge icfgEdge : this.mTransitions) {
            if (!((IcfgLocation)icfgEdge.getSource()).equals((Object)icfgLocation)) continue;
            return icfgEdge;
        }
        return null;
    }

    public List<IcfgEdge> getTransitions() {
        return this.mTransitions;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (IcfgEdge icfgEdge : this.mTransitions) {
            stringBuilder.append(icfgEdge.getSource());
            stringBuilder.append(", ");
        }
        stringBuilder.append(this.getLastLocation());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

