/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cli;

import de.uni_freiburg.informatik.ultimate.cli.ParsedParameter;
import de.uni_freiburg.informatik.ultimate.cli.options.OptionBuilder;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.util.LoggerOutputStream;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.function.Predicate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class CommandLineParser {
    private static final int DESC_PADDING = 6;
    private static final String USAGE = "Ultimate [OPTIONS] -tc <FILE> -i <FILE> [<FILE> ...]";
    private static final String HEADER = null;
    private static final String FOOTER = null;
    private final ILogger mLogger;
    private final Options mOptionsForParser;
    private final Options mOptionsForHelp;
    private final OptionBuilder mOptionBuilder;
    private final DefaultParser mParser;
    private final ICore<RunDefinition> mCore;

    private CommandLineParser(ICore<RunDefinition> iCore, Predicate<String> predicate, boolean bl, boolean bl2) {
        if (predicate == null) {
            throw new IllegalArgumentException("pluginNameFilter");
        }
        if (iCore == null) {
            throw new IllegalArgumentException("core");
        }
        this.mCore = iCore;
        this.mLogger = iCore.getCoreLoggingService().getControllerLogger();
        this.mParser = new DefaultParser();
        this.mOptionBuilder = new OptionBuilder(iCore, bl, bl2);
        this.mOptionsForParser = this.mOptionBuilder.getParserOptions(predicate);
        this.mOptionsForHelp = this.mOptionBuilder.getHelpOptions(predicate);
    }

    public static CommandLineParser createParser(ICore<RunDefinition> iCore, Predicate<String> predicate, boolean bl) {
        return new CommandLineParser(iCore, predicate, bl, false);
    }

    public void printHelp() {
        CommandLineParser.printHelp(this.mLogger, this.mOptionBuilder.filterExperimentalOptions(this.mOptionsForHelp), USAGE, HEADER, FOOTER);
    }

    public void printHelpWithExperimentals() {
        CommandLineParser.printHelp(this.mLogger, this.mOptionsForHelp, USAGE, HEADER, FOOTER);
    }

    public ParsedParameter parse(String[] stringArray) throws ParseException {
        CommandLine commandLine = this.mParser.parse(this.mOptionsForParser, stringArray);
        this.validateParsedOptionsWithValidators(commandLine);
        this.validateParsedOptionsByConversion(commandLine);
        return new ParsedParameter(this.mCore, commandLine, this.mOptionBuilder);
    }

    private static void printHelp(ILogger iLogger, Options options, String string, String string2, String string3) {
        HelpFormatter helpFormatter = new HelpFormatter();
        PrintWriter printWriter = new PrintWriter((OutputStream)new LoggerOutputStream(arg_0 -> ((ILogger)iLogger).info(arg_0)));
        helpFormatter.setLeftPadding(0);
        helpFormatter.setDescPadding(6);
        helpFormatter.setWidth(OptionBuilder.calculateMaxWidth(options));
        helpFormatter.setOptionComparator(null);
        helpFormatter.printHelp(printWriter, helpFormatter.getWidth(), string, string2, options, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), string3, false);
        printWriter.flush();
        printWriter.close();
    }

    private void validateParsedOptionsByConversion(CommandLine commandLine) throws ParseException {
        Option[] optionArray = commandLine.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            String string = option.getOpt();
            if (string == null) {
                string = option.getLongOpt();
            }
            Object object = commandLine.getParsedOptionValue(string);
            if (this.mLogger.isDebugEnabled() && object != null) {
                this.mLogger.debug((Object)("Option " + string + " has value of type " + object.getClass().getCanonicalName() + ": " + String.valueOf(object)));
            }
            ++n2;
        }
    }

    private void validateParsedOptionsWithValidators(CommandLine commandLine) throws ParseException {
        Option[] optionArray = commandLine.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            UltimatePreferenceItem.IUltimatePreferenceItemValidator<Object> iUltimatePreferenceItemValidator;
            Option option = optionArray[n2];
            String string = option.getLongOpt();
            if (string != null && (iUltimatePreferenceItemValidator = this.mOptionBuilder.getValidator(string)) != null) {
                Object object = commandLine.getParsedOptionValue(string);
                if (object == null) {
                    throw new ParseException("Invalid option value for " + string + ": " + String.valueOf(object));
                }
                if (!iUltimatePreferenceItemValidator.isValid(object)) {
                    throw new ParseException("Invalid option value for " + string + ": " + String.valueOf(object));
                }
            }
            ++n2;
        }
    }
}

