/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.NumberOfTransitions;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.ReachableStatesCopy;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public abstract class StateRemoval<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final boolean CHECK_WORKLIST_EMTPY = false;
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;

    public StateRemoval(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.printStartMessage();
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public abstract IDoubleDeckerAutomaton<LETTER, STATE> getResult();

    protected abstract NestedWordAutomatonReachableStates<LETTER, STATE> getReach();

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Reduced from " + this.mOperand.size() + " states to " + this.getResult().sizeInformation();
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        int n = this.getOperand().size();
        int n2 = this.getResult().size();
        automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_INPUT, n);
        automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_OUTPUT, n2);
        automataOperationStatistics.addDifferenceData(StatisticsType.STATES_INPUT, StatisticsType.STATES_OUTPUT, StatisticsType.STATES_REDUCTION_ABSOLUTE);
        automataOperationStatistics.addPercentageDataInverted(StatisticsType.STATES_INPUT, StatisticsType.STATES_OUTPUT, StatisticsType.STATES_REDUCTION_RELATIVE);
        int n3 = new NumberOfTransitions<LETTER, STATE>(this.mServices, this.getReach()).getResult();
        int n4 = new NumberOfTransitions(this.mServices, this.getResult()).getResult();
        automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_REDUCTION_ABSOLUTE, n3 - n4);
        return automataOperationStatistics;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        this.printStartCheckMessage();
        ReachableStatesCopy<LETTER, STATE> reachableStatesCopy = new ReachableStatesCopy<LETTER, STATE>(this.mServices, this.mOperand, false, false, false, false);
        this.modifyReachableStatesCopyForCheckResult(reachableStatesCopy);
        Object object = this.getResult();
        Object object2 = reachableStatesCopy.getResult();
        boolean bl = object2.getStates().containsAll(object.getStates());
        assert (bl) : this.getOperationName() + " incorrect: too few states";
        assert (bl &= this.checkEachState((DoubleDeckerAutomaton)object2, (IDoubleDeckerAutomaton<LETTER, STATE>)object)) : this.getOperationName() + " incorrect: checkEachState failed";
        assert (bl &= this.checkResultFurther((IDoubleDeckerAutomaton<LETTER, STATE>)object2)) : this.getOperationName() + " incorrect: further tests failed";
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mOperand);
        }
        this.printExitCheckMessage();
        return bl;
    }

    protected abstract void modifyReachableStatesCopyForCheckResult(ReachableStatesCopy<LETTER, STATE> var1) throws AutomataOperationCanceledException;

    protected final boolean checkAllStatesAreInReachableStatesCopy(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        boolean bl = this.getResult().getStates().containsAll(iNestedWordAutomaton.getStates());
        assert (bl) : this.getOperationName() + " incorrect: too many states";
        return bl;
    }

    private boolean checkEachState(DoubleDeckerAutomaton<LETTER, STATE> doubleDeckerAutomaton, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
        boolean bl = true;
        NestedWordAutomatonReachableStates nestedWordAutomatonReachableStates = this.getReach();
        for (Object STATE : iDoubleDeckerAutomaton.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : doubleDeckerAutomaton.internalSuccessors(STATE)) {
                assert (bl &= nestedWordAutomatonReachableStates.containsInternalTransition(STATE, outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc()));
            }
            for (OutgoingCallTransition outgoingCallTransition : doubleDeckerAutomaton.callSuccessors(STATE)) {
                assert (bl &= nestedWordAutomatonReachableStates.containsCallTransition(STATE, outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc()));
            }
            for (OutgoingReturnTransition outgoingReturnTransition : doubleDeckerAutomaton.returnSuccessors(STATE)) {
                assert (bl &= nestedWordAutomatonReachableStates.containsReturnTransition(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc()));
            }
            for (OutgoingInternalTransition outgoingInternalTransition : iDoubleDeckerAutomaton.internalSuccessors(STATE)) {
                assert (bl &= doubleDeckerAutomaton.containsInternalTransition(STATE, outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc()));
            }
            for (OutgoingCallTransition outgoingCallTransition : iDoubleDeckerAutomaton.callSuccessors(STATE)) {
                boolean bl2 = bl = bl && doubleDeckerAutomaton.containsCallTransition(STATE, outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc());
                assert (bl);
            }
            for (OutgoingReturnTransition outgoingReturnTransition : iDoubleDeckerAutomaton.returnSuccessors(STATE)) {
                assert (bl &= doubleDeckerAutomaton.containsReturnTransition(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc()));
            }
            assert (bl &= this.checkDownStates(STATE, doubleDeckerAutomaton, nestedWordAutomatonReachableStates));
        }
        return bl;
    }

    protected abstract boolean checkDownStates(STATE var1, DoubleDeckerAutomaton<LETTER, STATE> var2, NestedWordAutomatonReachableStates<LETTER, STATE> var3);

    protected abstract boolean checkResultFurther(IDoubleDeckerAutomaton<LETTER, STATE> var1) throws AutomataLibraryException;

    public String toString() {
        Object object = this.getResult();
        return object == null ? "Result not computed yet." : object.toString();
    }
}

