/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetAndAutomataInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.IsEquivalent;

public final class Automaton2Net<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IPetriNetAndAutomataInclusionStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final BoundedPetriNet<LETTER, STATE> mNet;

    public Automaton2Net(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mNet = new BoundedPetriNet<LETTER, STATE>(this.mServices, this.mOperand);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public IPetriNet<LETTER, STATE> getResult() {
        return this.mNet;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". PetriNet " + this.mNet.sizeInformation();
    }

    @Override
    public boolean checkResult(IPetriNetAndAutomataInclusionStateFactory<STATE> iPetriNetAndAutomataInclusionStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Testing correctness of constructor" + this.mNet.getClass().getSimpleName()));
        }
        boolean bl = new IsEquivalent<LETTER, STATE>(this.mServices, iPetriNetAndAutomataInclusionStateFactory, this.mNet, this.mOperand).getResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of constructor " + this.mNet.getClass().getSimpleName()));
        }
        return bl;
    }
}

