/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.DataRaceChecker;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ResultWithSideEffects;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class StdioLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final ExpressionTranslation mExpressionTranslation;
    private final TypeSizes mTypeSizes;
    private final MemoryHandler mMemoryHandler;
    private final DataRaceChecker mDataRaceChecker;
    private final ITypeHandler mTypeHandler;

    public StdioLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, AuxVarInfoBuilder auxVarInfoBuilder, ExpressionTranslation expressionTranslation, TypeSizes typeSizes, MemoryHandler memoryHandler, DataRaceChecker dataRaceChecker, ITypeHandler iTypeHandler) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeSizes = typeSizes;
        this.mMemoryHandler = memoryHandler;
        this.mDataRaceChecker = dataRaceChecker;
        this.mTypeHandler = iTypeHandler;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("printf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handlePrintF(iDispatcher, iASTFunctionCallExpression, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("fgets", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("fgetc", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("wprintf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handlePrintF(iDispatcher, iASTFunctionCallExpression, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("fprintf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handlePrintFunction(iDispatcher, iASTFunctionCallExpression, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("sprintf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleSPrintF(iDispatcher, iASTFunctionCallExpression, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("snprintf", this::handleSnPrintF));
        arrayList.add(new ILibraryModel.FunctionModel("swprintf", this::handleSnPrintF));
        arrayList.add(new ILibraryModel.FunctionModel("scanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 1)));
        arrayList.add(new ILibraryModel.FunctionModel("scanf_s", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 1)));
        arrayList.add(new ILibraryModel.FunctionModel("fscanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("fscanf_s", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("sscanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("sscanf_s", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("wscanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 1)));
        arrayList.add(new ILibraryModel.FunctionModel("wscanf_s", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 1)));
        arrayList.add(new ILibraryModel.FunctionModel("fwscanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("fwscanf_s", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("swscanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("swscanf_s", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleScanf(string, iDispatcher, iASTFunctionCallExpression, iLocation, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("puts", this::handlePuts));
        arrayList.add(new ILibraryModel.FunctionModel("fflush", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("fopen", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, CPointer.voidPointer())));
        arrayList.add(new ILibraryModel.FunctionModel("fclose", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("feof", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("fseek", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("fread", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("ferror", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("fputs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("fwrite", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.ULONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("setbuf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.VOID))));
        arrayList.add(new ILibraryModel.FunctionModel("clearerr", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleVoidFunctionBySkipAndDispatch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1)));
        return arrayList;
    }

    private Result handleSPrintF(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation) {
        Statement statement2;
        Object object;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        assert (iASTInitializerClauseArray.length >= 1) : "insufficient arguments to snprintf";
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        Overapprox overapprox = new Overapprox("snprintf", iLocation);
        expressionResultBuilder.addOverapprox(overapprox);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        int n = 1;
        while (n < iASTInitializerClauseArray.length) {
            if (!this.mHelper.isStringLiteral(iASTInitializerClauseArray[n])) {
                object = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[n]);
                expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
            }
            ++n;
        }
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), SFO.AUXVAR.LOOPCTR);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        object = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, new CPrimitive(CPrimitive.CPrimitives.CHAR), SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration((AuxVarInfo)object);
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
        AssignmentStatement assignmentStatement = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)expression);
        expressionResultBuilder.addStatement((Statement)assignmentStatement);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HavocStatement havocStatement = new HavocStatement(iLocation, new VariableLHS[]{((AuxVarInfo)object).getLhs()});
        arrayList.add(havocStatement);
        Expression expression2 = this.mMemoryHandler.addExpressionToPointer(iLocation, expressionResult.getLrValue().getValue(), (Expression)auxVarInfo.getExp());
        HeapLValue heapLValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, expression2, expressionResult.getCType(), null);
        List<Statement> list = this.mMemoryHandler.getWriteCall(iLocation, heapLValue, (Expression)((AuxVarInfo)object).getExp(), (ICType)new CPrimitive(CPrimitive.CPrimitives.CHAR), false);
        for (Statement statement2 : list) {
            overapprox.annotate((IElement)statement2);
        }
        arrayList.addAll(list);
        if (this.mDataRaceChecker != null) {
            this.mDataRaceChecker.checkOnWrite(expressionResultBuilder, iLocation, heapLValue);
        }
        statement2 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)this.mExpressionTranslation.constructArithmeticIntegerExpression(iLocation, 4, (Expression)auxVarInfo.getExp(), this.mExpressionTranslation.getCTypeOfPointerComponents(), this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ONE), this.mExpressionTranslation.getCTypeOfPointerComponents()));
        arrayList.add(statement2);
        WhileStatement whileStatement = new WhileStatement(iLocation, (Expression)new WildcardExpression(iLocation), new LoopInvariantSpecification[0], (Statement[])arrayList.toArray(Statement[]::new));
        expressionResultBuilder.addStatement((Statement)whileStatement);
        AuxVarInfo auxVarInfo2 = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, new CPrimitive(CPrimitive.CPrimitives.CHAR), SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo2);
        expressionResultBuilder.setLrValue(new LocalLValue((LeftHandSide)auxVarInfo2.getLhs(), (ICType)new CPrimitive(CPrimitive.CPrimitives.CHAR), null));
        return expressionResultBuilder.build();
    }

    private Result handleSnPrintF(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        Statement statement2;
        Object object;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        assert (iASTInitializerClauseArray.length >= 2) : "insufficient arguments to snprintf";
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        Overapprox overapprox = new Overapprox(string, iLocation);
        expressionResultBuilder.addOverapprox(overapprox);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[1], this.mExpressionTranslation.getCTypeOfPointerComponents());
        expressionResultBuilder.addAllExceptLrValue(expressionResult2);
        int n = 2;
        while (n < iASTInitializerClauseArray.length) {
            if (!this.mHelper.isStringLiteral(iASTInitializerClauseArray[n])) {
                object = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[n]);
                expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
            }
            ++n;
        }
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), SFO.AUXVAR.LOOPCTR);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        object = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, new CPrimitive(CPrimitive.CPrimitives.CHAR), SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration((AuxVarInfo)object);
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
        AssignmentStatement assignmentStatement = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)expression);
        expressionResultBuilder.addStatement((Statement)assignmentStatement);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 8, (Expression)auxVarInfo.getExp(), this.mExpressionTranslation.getCTypeOfPointerComponents(), expressionResult2.getLrValue().getValue(), this.mExpressionTranslation.getCTypeOfPointerComponents()));
        arrayList.add(assumeStatement);
        HavocStatement havocStatement = new HavocStatement(iLocation, new VariableLHS[]{((AuxVarInfo)object).getLhs()});
        arrayList.add(havocStatement);
        Expression expression2 = this.mMemoryHandler.addExpressionToPointer(iLocation, expressionResult.getLrValue().getValue(), (Expression)auxVarInfo.getExp());
        HeapLValue heapLValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, expression2, expressionResult.getCType(), null);
        List<Statement> list = this.mMemoryHandler.getWriteCall(iLocation, heapLValue, (Expression)((AuxVarInfo)object).getExp(), (ICType)new CPrimitive(CPrimitive.CPrimitives.CHAR), false);
        for (Statement statement2 : list) {
            overapprox.annotate((IElement)statement2);
        }
        arrayList.addAll(list);
        if (this.mDataRaceChecker != null) {
            this.mDataRaceChecker.checkOnWrite(expressionResultBuilder, iLocation, heapLValue);
        }
        statement2 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)this.mExpressionTranslation.constructArithmeticIntegerExpression(iLocation, 4, (Expression)auxVarInfo.getExp(), this.mExpressionTranslation.getCTypeOfPointerComponents(), this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ONE), this.mExpressionTranslation.getCTypeOfPointerComponents()));
        arrayList.add(statement2);
        WhileStatement whileStatement = new WhileStatement(iLocation, (Expression)new WildcardExpression(iLocation), new LoopInvariantSpecification[0], (Statement[])arrayList.toArray(Statement[]::new));
        expressionResultBuilder.addStatement((Statement)whileStatement);
        AuxVarInfo auxVarInfo2 = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, new CPrimitive(CPrimitive.CPrimitives.CHAR), SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo2);
        expressionResultBuilder.setLrValue(new LocalLValue((LeftHandSide)auxVarInfo2.getLhs(), (ICType)new CPrimitive(CPrimitive.CPrimitives.CHAR), null));
        return expressionResultBuilder.build();
    }

    private Result handleScanf(String string, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, int n) {
        Object object;
        Object object2;
        ICType iCType;
        Object object3;
        boolean bl = string.startsWith("sscanf") || string.startsWith("swscanf");
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        int n2 = 0;
        while (n2 < iASTInitializerClauseArray.length) {
            if (n2 < n) {
                if (!this.mHelper.isStringLiteral(iASTInitializerClauseArray[n2])) {
                    expressionResultBuilder.addAllExceptLrValue(this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[n2]));
                }
            } else {
                object3 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[n2]);
                expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object3);
                iCType = ((CPointer)((ExpressionResult)object3).getCType()).getPointsToType();
                object2 = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.NONDET);
                expressionResultBuilder.addAuxVarWithDeclaration((AuxVarInfo)object2);
                this.mExpressionTranslation.addAssumeValueInRangeStatements(iLocation, (Expression)((AuxVarInfo)object2).getExp(), iCType, expressionResultBuilder);
                object = this.mExprResultTransformer.makePointerAssignment(iLocation, ((ExpressionResult)object3).getLrValue(), (Expression)((AuxVarInfo)object2).getExp());
                if (bl) {
                    ((ResultWithSideEffects)object).getStatements().forEach(arg_0 -> ((Overapprox)new Overapprox(string, iLocation)).annotate(arg_0));
                }
                expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
            }
            ++n2;
        }
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.LONG);
        object3 = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration((AuxVarInfo)object3);
        iCType = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
        object2 = ((AuxVarInfo)object3).getExp();
        object = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, (Expression)iCType, cPrimitive, (Expression)object2, cPrimitive);
        int n3 = iASTInitializerClauseArray.length - n;
        Expression expression = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(n3));
        Expression expression2 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, (Expression)object2, cPrimitive, expression, cPrimitive);
        expressionResultBuilder.addStatement((Statement)new AssumeStatement(iLocation, ExpressionFactory.and((ILocation)iLocation, List.of(object, expression2))));
        expressionResultBuilder.setLrValue(new RValue((Expression)object2, cPrimitive));
        if (bl) {
            expressionResultBuilder.addOverapprox(new Overapprox(string, iLocation));
        }
        return expressionResultBuilder.build();
    }

    private ExpressionResult handlePrintFunction(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo.getLhs()}));
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), new CPrimitive(CPrimitive.CPrimitives.INT));
        expressionResultBuilder.setLrValue(rValue);
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        int n = iASTInitializerClauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause iASTInitializerClause = iASTInitializerClauseArray[n2];
            if (!this.mHelper.isStringLiteral(iASTInitializerClause)) {
                ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClause);
                expressionResultBuilder.addAllExceptLrValue(expressionResult);
            }
            ++n2;
        }
        return expressionResultBuilder.build();
    }

    private Result handlePrintF(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation) {
        return this.handlePrintFunction(iDispatcher, iASTFunctionCallExpression, iLocation);
    }

    private Result handlePuts(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        this.mHelper.checkArguments(iLocation, 1, string, iASTFunctionCallExpression.getArguments());
        return this.handlePrintFunction(iDispatcher, iASTFunctionCallExpression, iLocation);
    }

    private static ICType getFileType() {
        CPointer cPointer = new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR));
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        return new CStructOrUnion(CStructOrUnion.StructOrUnion.STRUCT, "FILE", List.of("_ptr", "_cnt", "_base", "_flag", "_file", "_charbuf", "_bufsiz", "_tmpfname"), List.of(cPointer, cPrimitive, cPointer, cPrimitive, cPrimitive, cPrimitive, cPrimitive, cPointer), List.of(Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1)));
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        return List.of(new ILibraryModel.TypeModel("FILE", StdioLibraryModel.getFileType()));
    }
}

