/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cli;

import de.uni_freiburg.informatik.ultimate.cli.Activator;
import de.uni_freiburg.informatik.ultimate.cli.CommandLineParser;
import de.uni_freiburg.informatik.ultimate.cli.ParsedParameter;
import de.uni_freiburg.informatik.ultimate.cli.ToolchainLocator;
import de.uni_freiburg.informatik.ultimate.cli.exceptions.InvalidFileArgumentException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.DefaultToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultSummarizer;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.util.RcpUtils;
import de.uni_freiburg.informatik.ultimate.preferencejson.PreferenceUtil;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.csv.CsvUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;

public class CommandLineController
implements IController<RunDefinition> {
    private ILogger mLogger;
    private IToolchainData<RunDefinition> mToolchain;
    private ParsedParameter mCliParams;
    private String mCsvPrefix;

    public int init(ICore<RunDefinition> iCore) {
        ParsedParameter parsedParameter;
        CommandLineParser commandLineParser;
        String[] stringArray;
        block19: {
            ParsedParameter parsedParameter2;
            if (iCore == null) {
                return -1;
            }
            this.mLogger = iCore.getCoreLoggingService().getControllerLogger();
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"Initializing CommandlineController...");
                this.mLogger.debug((Object)("Data directory is " + String.valueOf(Platform.getLocation())));
                this.mLogger.debug((Object)("Working directory is " + String.valueOf(Platform.getInstallLocation().getURL())));
                this.mLogger.debug((Object)("user.dir is " + System.getProperty("user.dir")));
                this.mLogger.debug((Object)("CLI Controller version is " + RcpUtils.getVersion((String)Activator.PLUGIN_ID)));
            }
            stringArray = Platform.getCommandLineArgs();
            CommandLineParser commandLineParser2 = CommandLineParser.createParser(iCore, this.getCoreAndControllerPluginFilter(), false);
            CommandLineParser commandLineParser3 = CommandLineParser.createParser(iCore, string -> true, false);
            try {
                parsedParameter2 = commandLineParser3.parse(stringArray);
            }
            catch (ParseException parseException) {
                this.printParseException(stringArray, parseException);
                commandLineParser2.printHelp();
                return -1;
            }
            if (parsedParameter2.isVersionRequested()) {
                this.printVersion(iCore);
                return IApplication.EXIT_OK;
            }
            if (parsedParameter2.isFrontendSettingsRequested()) {
                this.mLogger.info((Object)PreferenceUtil.generateFrontendSettingsJsonFromDefaultSettings(iCore));
                return IApplication.EXIT_OK;
            }
            if (parsedParameter2.isBackendWhitelistRequested()) {
                this.mLogger.info((Object)PreferenceUtil.generateBackendWhitelistJsonFromDefaultSettings(iCore));
                return IApplication.EXIT_OK;
            }
            if (!parsedParameter2.hasToolchain()) {
                if (parsedParameter2.isHelpRequested()) {
                    CommandLineController.printHelp(commandLineParser2, parsedParameter2);
                    return IApplication.EXIT_OK;
                }
                this.mLogger.info((Object)"Missing required option: tc");
                CommandLineController.printHelp(commandLineParser2, parsedParameter2);
                this.printAvailableToolchains(iCore);
                return IApplication.EXIT_OK;
            }
            Predicate<String> predicate = string -> true;
            commandLineParser = CommandLineParser.createParser(iCore, predicate, true);
            parsedParameter = commandLineParser.parse(stringArray);
            if (parsedParameter.isHelpRequested()) {
                CommandLineController.printHelp(commandLineParser, parsedParameter);
                return IApplication.EXIT_OK;
            }
            if (parsedParameter.hasInputFiles()) break block19;
            this.printParseException(stringArray, new ParseException("Missing required option: i"));
            CommandLineController.printHelp(commandLineParser, parsedParameter);
            return -1;
        }
        try {
            this.mCliParams = parsedParameter;
            this.mLogger.info((Object)("This is Ultimate " + iCore.getUltimateVersionString()));
            if (parsedParameter.generateCsvs()) {
                this.mCsvPrefix = this.mCliParams.getCsvPrefix();
            }
            IToolchainData<RunDefinition> iToolchainData = this.prepareToolchain(iCore, parsedParameter);
            assert (iToolchainData == this.mToolchain);
            if (parsedParameter.isFrontendSettingsDeltaRequested()) {
                this.mLogger.info((Object)PreferenceUtil.generateFrontendSettingsJsonFromDeltaSettings((IUltimateServiceProvider)this.mToolchain.getServices(), iCore));
                return IApplication.EXIT_OK;
            }
            if (parsedParameter.isBackendWhitelistDeltaRequested()) {
                this.mLogger.info((Object)PreferenceUtil.generateBackendWhitelistJsonFromDeltaSettings((IUltimateServiceProvider)this.mToolchain.getServices(), iCore));
                return IApplication.EXIT_OK;
            }
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new SigIntTrap(iToolchainData, this.mLogger), "SigIntTrap"));
            this.startExecutingToolchain(iCore, parsedParameter, this.mLogger, iToolchainData);
        }
        catch (ParseException parseException) {
            this.printParseException(stringArray, parseException);
            commandLineParser.printHelp();
            return -1;
        }
        catch (InvalidFileArgumentException invalidFileArgumentException) {
            this.mLogger.error((Object)invalidFileArgumentException.getMessage());
            this.printArgs(stringArray);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            this.mLogger.fatal((Object)"Exception during execution of toolchain", (Throwable)interruptedException);
            return -1;
        }
        return IApplication.EXIT_OK;
    }

    private void printVersion(ICore<RunDefinition> iCore) {
        String[] stringArray;
        this.mLogger.info((Object)("This is Ultimate " + iCore.getUltimateVersionString()));
        this.mLogger.info((Object)("Version is " + RcpUtils.getVersion((String)Activator.PLUGIN_ID)));
        this.mLogger.info((Object)("Maximal heap size is set to " + CoreUtil.humanReadableByteCount((long)Runtime.getRuntime().maxMemory(), (boolean)true)));
        String[] stringArray2 = stringArray = new String[]{"java.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.runtime.version", "java.vm.name", "java.vm.vendor", "java.vm.version"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            String string2 = System.getProperty(string);
            if (string2 == null) {
                string2 = "unknown";
            }
            this.mLogger.info((Object)("Value of " + string + " is " + string2));
            ++n2;
        }
    }

    protected void startExecutingToolchain(ICore<RunDefinition> iCore, ParsedParameter parsedParameter, ILogger iLogger, IToolchainData<RunDefinition> iToolchainData) throws ParseException, InvalidFileArgumentException, InterruptedException {
        File[] fileArray = parsedParameter.getInputFiles();
        this.executeToolchain(iCore, fileArray, iLogger, iToolchainData);
    }

    protected void executeToolchain(ICore<RunDefinition> iCore, File[] fileArray, ILogger iLogger, IToolchainData<RunDefinition> iToolchainData) throws InterruptedException {
        DefaultToolchainJob defaultToolchainJob = new DefaultToolchainJob("Processing Toolchain", iCore, (IController)this, iLogger, fileArray);
        defaultToolchainJob.schedule();
        defaultToolchainJob.join();
    }

    private IToolchainData<RunDefinition> prepareToolchain(ICore<RunDefinition> iCore, ParsedParameter parsedParameter) throws ParseException, InvalidFileArgumentException {
        iCore.resetPreferences(false);
        if (parsedParameter.hasSettings()) {
            iCore.loadPreferences(parsedParameter.getSettingsFile(), false);
        }
        this.mToolchain = parsedParameter.createToolchainData();
        parsedParameter.applyCliSettings(this.mToolchain.getServices());
        return this.mToolchain;
    }

    private static void printHelp(CommandLineParser commandLineParser, ParsedParameter parsedParameter) {
        if (parsedParameter.showExperimentals()) {
            commandLineParser.printHelpWithExperimentals();
        } else {
            commandLineParser.printHelp();
        }
    }

    private void printParseException(String[] stringArray, ParseException parseException) {
        this.mLogger.error((Object)parseException.getMessage());
        this.printArgs(stringArray);
        this.mLogger.error((Object)"--");
    }

    private void printArgs(String[] stringArray) {
        this.mLogger.error((Object)("Arguments were \"" + String.join((CharSequence)" ", stringArray) + "\""));
    }

    public ISource selectParser(IToolchain<RunDefinition> iToolchain, Collection<ISource> collection) {
        throw new UnsupportedOperationException("Interactively selecting parsers is not supported in CLI mode");
    }

    public String getPluginName() {
        return "Ultimate Commandline Interface";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IToolchainData<RunDefinition> selectTools(IToolchain<RunDefinition> iToolchain, List<ITool> list) {
        return this.mToolchain;
    }

    public List<String> selectModel(IToolchain<RunDefinition> iToolchain, List<String> list) {
        throw new UnsupportedOperationException("Interactively selecting models is not supported in CLI mode");
    }

    public void displayToolchainResults(IToolchain<RunDefinition> iToolchain, Map<String, List<IResult>> map) {
        ResultSummarizer resultSummarizer = new ResultSummarizer(map);
        switch (resultSummarizer.getResultSummary()) {
            case CORRECT: {
                this.mLogger.info((Object)"RESULT: Ultimate proved your program to be correct!");
                break;
            }
            case INCORRECT: {
                this.mLogger.info((Object)"RESULT: Ultimate proved your program to be incorrect!");
                break;
            }
            default: {
                this.mLogger.info((Object)("RESULT: Ultimate could not prove your program: " + resultSummarizer.getResultDescription()));
            }
        }
        if (this.mCliParams.generateCsvs()) {
            List<ICsvProviderProvider<?>> list = ResultUtil.filterResults(map, StatisticsResult.class).stream().map(StatisticsResult::getStatistics).collect(Collectors.toList());
            this.writeCsvLogs(list, resultSummarizer);
        }
    }

    private void writeCsvLogs(List<ICsvProviderProvider<?>> list, ResultSummarizer resultSummarizer) {
        if (list == null || list.isEmpty()) {
            return;
        }
        String string = CoreUtil.getCurrentDateTimeAsString();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (ICsvProviderProvider<?> iCsvProviderProvider : list) {
            ICsvProvider iCsvProvider;
            if (iCsvProviderProvider == null || (iCsvProvider = iCsvProviderProvider.createCsvProvider()).isEmpty()) continue;
            ICsvProvider<Object> iCsvProvider2 = CommandLineController.getEnrichedProvider((ICsvProvider<Object>)iCsvProvider, resultSummarizer, this.mCliParams);
            String string2 = iCsvProviderProvider.getClass().getSimpleName();
            Integer n = (Integer)hashMap.get(string2);
            n = n == null ? Integer.valueOf(0) : Integer.valueOf(n + 1);
            hashMap.put(string2, n);
            String string3 = Paths.get(this.mCsvPrefix, "Csv-" + iCsvProviderProvider.getClass().getSimpleName() + "-" + String.valueOf(n) + "-" + string + ".csv").toString();
            try {
                File file = CoreUtil.writeFile((String)string3, (String)iCsvProvider2.toCsv(null, null, true).toString());
                if (file == null) continue;
                this.mLogger.info((Object)("Written .csv to " + file.getAbsolutePath()));
            }
            catch (IOException iOException) {
                this.mLogger.error((Object)("Could not write .csv log for " + string3 + ":"), (Throwable)iOException);
            }
        }
    }

    private static ICsvProvider<Object> getEnrichedProvider(ICsvProvider<Object> iCsvProvider, ResultSummarizer resultSummarizer, ParsedParameter parsedParameter) {
        int n = iCsvProvider.getRowCount();
        try {
            iCsvProvider = CsvUtils.addColumn(iCsvProvider, (String)"AnalysisResult", (int)0, CommandLineController.repeatValue(n, resultSummarizer.getResultSummary()));
            iCsvProvider = CsvUtils.addColumn((ICsvProvider)iCsvProvider, (String)"Inputfiles", (int)0, CommandLineController.repeatValue(n, parsedParameter.getInputFiles()));
            iCsvProvider = CsvUtils.addColumn((ICsvProvider)iCsvProvider, (String)"Settingsfile", (int)0, CommandLineController.repeatValue(n, parsedParameter.getSettingsFile()));
            iCsvProvider = CsvUtils.addColumn((ICsvProvider)iCsvProvider, (String)"Toolchainfile", (int)0, CommandLineController.repeatValue(n, parsedParameter.getToolchainFile()));
        }
        catch (InvalidFileArgumentException | ParseException throwable) {
            throw new RuntimeException(throwable);
        }
        return iCsvProvider;
    }

    private static List<Object> repeatValue(int n, Object object) {
        String string = object instanceof Object[] ? Arrays.stream((Object[])object).map(String::valueOf).collect(Collectors.joining(";")) : (object instanceof Collection ? ((Collection)object).stream().map(String::valueOf).collect(Collectors.joining(";")) : String.valueOf(object));
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    public void displayException(IToolchain<RunDefinition> iToolchain, String string, Throwable throwable) {
        this.mLogger.fatal((Object)("RESULT: An exception occured during the execution of Ultimate: " + string), throwable);
    }

    public IPreferenceInitializer getPreferences() {
        return null;
    }

    private Predicate<String> getCoreAndControllerPluginFilter() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("de.uni_freiburg.informatik.ultimate.core");
        hashSet.add(this.getPluginID());
        return CommandLineController.getLowerCaseFilter(hashSet);
    }

    private Predicate<String> getToolchainBasedPluginFilter(ICore<RunDefinition> iCore, File file) {
        ToolchainLocator toolchainLocator = new ToolchainLocator(file, iCore, this.mLogger);
        HashSet<String> hashSet = new HashSet<String>(toolchainLocator.createFilterForAvailableTools());
        hashSet.add("de.uni_freiburg.informatik.ultimate.core");
        hashSet.add(this.getPluginID());
        Arrays.stream(iCore.getRegisteredUltimatePlugins()).filter(iUltimatePlugin -> iUltimatePlugin instanceof ISource).map(IUltimatePlugin::getPluginID).forEach(hashSet::add);
        return CommandLineController.getLowerCaseFilter(hashSet);
    }

    private static Predicate<String> getLowerCaseFilter(Set<String> set) {
        Set set2 = set.stream().map(String::toLowerCase).collect(Collectors.toSet());
        return string -> set2.contains(string.toLowerCase());
    }

    private void printAvailableToolchains(ICore<RunDefinition> iCore) {
        File file = RcpUtils.getWorkingDirectory();
        ToolchainLocator toolchainLocator = new ToolchainLocator(file, iCore, this.mLogger);
        Map<File, IToolchainData<RunDefinition>> map = toolchainLocator.locateToolchains();
        if (map.isEmpty()) {
            this.mLogger.warn((Object)("There are no toolchains in Ultimates working directory " + String.valueOf(file)));
            return;
        }
        this.mLogger.info((Object)"The following toolchains are available:");
        for (Map.Entry<File, IToolchainData<RunDefinition>> entry : map.entrySet()) {
            this.mLogger.info((Object)entry.getKey());
            this.mLogger.info((Object)("    " + ((RunDefinition)entry.getValue().getRootElement()).getName()));
        }
    }

    public IToolchainData<RunDefinition> prerun(IToolchain<RunDefinition> iToolchain) {
        return iToolchain.getCurrentToolchainData();
    }

    private static final class SigIntTrap
    implements Runnable {
        private static final int SHUTDOWN_GRACE_PERIOD_SECONDS = 5;
        private final IToolchainData<RunDefinition> mCurrentToolchain;
        private final ILogger mLogger;

        public SigIntTrap(IToolchainData<RunDefinition> iToolchainData, ILogger iLogger) {
            this.mCurrentToolchain = iToolchainData;
            this.mLogger = iLogger;
        }

        @Override
        public void run() {
            this.mLogger.warn((Object)"Received shutdown request...");
            IUltimateServiceProvider iUltimateServiceProvider = this.mCurrentToolchain.getServices();
            if (iUltimateServiceProvider == null) {
                return;
            }
            IProgressMonitorService iProgressMonitorService = iUltimateServiceProvider.getProgressMonitorService();
            if (iProgressMonitorService == null) {
                return;
            }
            CountDownLatch countDownLatch = iProgressMonitorService.cancelToolchain();
            try {
                if (countDownLatch.await(5L, TimeUnit.SECONDS)) {
                    this.mLogger.info((Object)"Completed graceful shutdown");
                } else {
                    this.mLogger.fatal((Object)"Cannot interrupt operation gracefully because timeout expired. Forcing shutdown");
                }
            }
            catch (InterruptedException interruptedException) {
                this.mLogger.fatal((Object)("Received interrupt while waiting for graceful shutdown: " + interruptedException.getMessage()));
                return;
            }
        }
    }
}

