/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SharingSet<E>
extends AbstractSet<E> {
    private SharingSetData<E> mData;

    public SharingSet() {
        this.mData = new SharingSetData();
    }

    public SharingSet(SharingSet<E> sharingSet) {
        this.mData = sharingSet.mData.share();
    }

    public SharingSet(E e) {
        this.mData = new SharingSetData<E>(e);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> mSink;
            {
                this.mSink = SharingSet.this.mData.mRep.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mSink.hasNext();
            }

            @Override
            public E next() {
                return this.mSink.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not allowed on SharingSet iterator");
            }
        };
    }

    @Override
    public int size() {
        return this.mData.mRep.size();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        SharingSetData<E> sharingSetData = this.mData.detach();
        boolean bl = sharingSetData.mRep.removeAll(collection);
        if (bl) {
            this.mData = sharingSetData;
        }
        return bl;
    }

    @Override
    public boolean add(E e) {
        if (this.mData.mRep.contains(e)) {
            return false;
        }
        this.mData = this.mData.detach();
        return this.mData.mRep.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.mData.mRep.containsAll(collection)) {
            return false;
        }
        this.mData = this.mData.detach();
        return this.mData.mRep.addAll(collection);
    }

    public boolean addShared(SharingSet<E> sharingSet) {
        if (sharingSet == null) {
            return false;
        }
        if (this.mData.mRep.isEmpty() && this.mData.mSharing == 0) {
            this.mData = sharingSet.mData.share();
            return true;
        }
        return this.addAll(sharingSet.mData.mRep);
    }

    @Override
    public boolean contains(Object object) {
        return this.mData.mRep.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mData.mRep.containsAll(collection);
    }

    @Override
    public boolean remove(Object object) {
        if (this.mData.mRep.contains(object)) {
            this.mData = this.mData.detach();
            return this.mData.mRep.remove(object);
        }
        return false;
    }

    private static final class SharingSetData<E> {
        Set<E> mRep;
        int mSharing;

        SharingSetData() {
            this.mRep = new HashSet();
            this.mSharing = 0;
        }

        SharingSetData(SharingSetData<E> sharingSetData) {
            this.mRep = new HashSet<E>(sharingSetData.mRep);
            this.mSharing = 0;
        }

        SharingSetData(E e) {
            this.mRep = Collections.singleton(e);
            this.mSharing = 1;
        }

        SharingSetData<E> share() {
            ++this.mSharing;
            return this;
        }

        SharingSetData<E> detach() {
            if (this.mSharing != 0) {
                --this.mSharing;
                return new SharingSetData<SharingSetData>(this);
            }
            return this;
        }
    }
}

