/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.chcprinter;

import de.uni_freiburg.informatik.ultimate.chcprinter.Activator;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcAsserter;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClauseAST;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ChcSmtPrinterObserver
extends BaseObserver {
    private static final boolean PRODUCE_UNSAT_CORES = false;
    private static final boolean ADD_COMMENTS = false;
    private static final boolean USE_CSE = true;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final IPreferenceProvider mPref;

    public ChcSmtPrinterObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mPref = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
    }

    public boolean process(IElement iElement) throws IOException {
        if (!(iElement instanceof HornClauseAST)) {
            return true;
        }
        HornAnnot hornAnnot = HornAnnot.getAnnotation((IElement)iElement);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Printing the following HornClause set:");
            this.mLogger.debug((Object)hornAnnot);
        }
        List list = hornAnnot.getHornClauses();
        HcSymbolTable hcSymbolTable = hornAnnot.getSymbolTable();
        ManagedScript managedScript = hornAnnot.getScript();
        File file = this.openTempFile(iElement);
        this.mLogger.info((Object)("Writing to file " + file.getAbsolutePath()));
        LoggingScript loggingScript = new LoggingScript((Script)new NoopScript(), file.getAbsolutePath(), true, true);
        loggingScript.setLogic(Logics.HORN);
        loggingScript.setInfo(":source", (Object)new QuotedObject("CHC Constraint Logic: " + String.valueOf(hornAnnot.getChcCategoryInfo().getConstraintLogic()) + "\n                   Contains non-linear Horn clauses: " + hornAnnot.getChcCategoryInfo().containsNonLinearHornClauses()));
        new ChcAsserter(managedScript, (Script)loggingScript, false, false, true).assertClauses(hcSymbolTable, list);
        loggingScript.checkSat();
        return true;
    }

    private File openTempFile(IElement iElement) {
        String string;
        File file;
        Object object;
        if (this.mPref.getBoolean("Save file in source directory")) {
            object = ILocation.getAnnotation((IElement)iElement);
            file = new File(object.getFileName());
            string = file.isDirectory() ? file.getPath() : file.getParent();
            if (string == null) {
                this.mLogger.warn((Object)"Model does not provide a valid source location, falling back to default dump path...");
                string = this.mPref.getString("Dump path");
            }
        } else {
            string = this.mPref.getString("Dump path");
        }
        if (this.mPref.getBoolean("Use automatic naming")) {
            try {
                return File.createTempFile("ChcSmtPrinter_" + new File(ILocation.getAnnotation((IElement)iElement).getFileName()).getName() + "_UID", ".smt2", new File(string));
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not create temporary file", iOException);
            }
        }
        object = this.mPref.getString("File name");
        file = new File(string + File.separatorChar + (String)object);
        if (file.exists()) {
            if (!file.isFile() || !file.canWrite()) {
                throw new IllegalStateException("Cannot write to " + file.getAbsolutePath());
            }
            this.mLogger.info((Object)("File already exists and will be overwritten: " + file.getAbsolutePath()));
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not create file: " + file.toString(), iOException);
            }
        }
        return file;
    }
}

