/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ProfileInfoProvider {
    private static ProfileInfoProvider fInstance;
    private CfgDiscoveredPathManager fMngr = CfgDiscoveredPathManager.getInstance();

    private ProfileInfoProvider() {
    }

    public static ProfileInfoProvider getInstance() {
        if (fInstance == null) {
            fInstance = new ProfileInfoProvider();
        }
        return fInstance;
    }

    public ICLanguageSettingEntry[] getEntryValues(BuildLanguageData lData, int kind, int flags) {
        IProject project;
        IResourceInfo rcInfo = lData.getTool().getParentResourceInfo();
        IResource rc = rcInfo.getParent().getOwner();
        IProject iProject = project = rc != null ? rc.getProject() : null;
        if (project != null) {
            try {
                CfgInfoContext context = new CfgInfoContext(rcInfo, lData.getTool(), lData.getInputType());
                PathInfo info = this.fMngr.getDiscoveredInfo(project, context);
                if (info != null) {
                    return this.entriesForKind(kind, flags, info);
                }
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        return new ICLanguageSettingEntry[0];
    }

    private ICLanguageSettingEntry[] entriesForKind(int kind, int flags, PathInfo info) {
        switch (kind) {
            case 1: {
                ICLanguageSettingEntry[] incPaths = this.calculateEntries(kind, flags, info.getIncludePaths());
                IPath[] quotedPaths = info.getQuoteIncludePaths();
                if (quotedPaths.length != 0) {
                    if (incPaths.length != 0) {
                        ICLanguageSettingEntry[] quotedEntries = this.calculateEntries(kind, flags, quotedPaths);
                        ICLanguageSettingEntry[] tmp = new ICLanguageSettingEntry[incPaths.length + quotedEntries.length];
                        System.arraycopy(incPaths, 0, tmp, 0, incPaths.length);
                        System.arraycopy(quotedEntries, 0, tmp, incPaths.length, quotedEntries.length);
                        incPaths = tmp;
                    } else {
                        incPaths = this.calculateEntries(kind, flags, quotedPaths);
                    }
                }
                return incPaths;
            }
            case 4: {
                return this.calculateEntries(kind, flags, info.getSymbols());
            }
            case 8: {
                return this.calculateEntries(kind, flags, info.getMacroFiles());
            }
            case 2: {
                return this.calculateEntries(kind, flags, info.getIncludeFiles());
            }
        }
        return new ICLanguageSettingEntry[0];
    }

    private ICLanguageSettingEntry[] calculateEntries(int kind, int flags, Map<String, String> map) {
        ICLanguageSettingEntry[] entries = new ICLanguageSettingEntry[map.size()];
        int num = 0;
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String name = entry.getKey();
            String value = entry.getValue();
            entries[num++] = (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)name, (String)value, null, (int)flags);
        }
        return entries;
    }

    private ICLanguageSettingEntry[] calculateEntries(int kind, int flags, IPath[] values) {
        ICLanguageSettingEntry[] entries = new ICLanguageSettingEntry[values.length];
        int i = 0;
        while (i < values.length) {
            String name = values[i].toString();
            entries[i] = (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)name, null, null, (int)flags);
            ++i;
        }
        return entries;
    }
}

