/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.List;

public class QuantAnnotation
implements IAnnotation {
    private final Term mQuantClauseTerm;
    private final TermVariable[] mVars;
    private final Term[] mSubs;
    private final Term mInstClauseTerm;
    private final QuantifierTheory.InstanceOrigin mOrigin;
    private final SourceAnnotation mSource;
    private final IProofTracker mProofTracker;

    public QuantAnnotation(QuantClause quantClause, List<Term> list, Term term, QuantifierTheory.InstanceOrigin instanceOrigin) {
        this.mQuantClauseTerm = quantClause.getClauseWithProof();
        this.mVars = quantClause.getVars();
        this.mSubs = list.toArray(new Term[list.size()]);
        this.mInstClauseTerm = term;
        this.mOrigin = instanceOrigin;
        this.mSource = quantClause.getQuantSource();
        this.mProofTracker = quantClause.getQuantTheory().getClausifier().getTracker();
    }

    public SourceAnnotation getSource() {
        return this.mSource;
    }

    @Override
    public Term toTerm(Clause clause, ProofRules proofRules) {
        Term term;
        ProofLiteral[] proofLiteralArray;
        Term term2 = this.mProofTracker.getProvedTerm(this.mQuantClauseTerm);
        Theory theory = proofRules.getTheory();
        ProofLiteral[] proofLiteralArray2 = new ProofLiteral[]{new ProofLiteral(term2, true)};
        Annotation annotation = new Annotation(":input", this.mSource.getAnnotation().isEmpty() ? null : this.mSource.getAnnotation());
        if (this.mProofTracker instanceof ProofTracker) {
            proofLiteralArray = new Annotation[]{new Annotation(":proves", (Object)ProofRules.convertProofLiteralsToAnnotation(proofLiteralArray2)), annotation};
            term = theory.annotatedTerm((Annotation[])proofLiteralArray, ((ProofTracker)this.mProofTracker).getProof(this.mQuantClauseTerm));
        } else {
            term = proofRules.oracle(proofLiteralArray2, new Annotation[]{annotation});
        }
        proofLiteralArray = clause.toProofLiterals(proofRules);
        ProofLiteral[] proofLiteralArray3 = new ProofLiteral[proofLiteralArray.length + 1];
        proofLiteralArray3[0] = new ProofLiteral(term2, false);
        System.arraycopy(proofLiteralArray, 0, proofLiteralArray3, 1, proofLiteralArray.length);
        boolean bl = this.mProofTracker instanceof ProofTracker;
        Object[] objectArray = new Object[bl ? 5 : 3];
        objectArray[0] = ":subs";
        objectArray[1] = this.mSubs;
        objectArray[2] = this.mOrigin.getOrigin();
        if (bl) {
            objectArray[3] = ":subproof";
            objectArray[4] = ((ProofTracker)this.mProofTracker).getProof(this.mInstClauseTerm);
        }
        Annotation[] annotationArray = new Annotation[]{new Annotation(":inst", (Object)objectArray)};
        Term term3 = proofRules.oracle(proofLiteralArray3, annotationArray);
        return proofRules.resolutionRule(term2, term, term3);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":inst ").append(this.mQuantClauseTerm.toString());
        stringBuilder.append(" :vars ").append(this.mVars.toString());
        stringBuilder.append(" :subs ").append(this.mSubs.toString());
        return stringBuilder.toString();
    }
}

