/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.sifa.CallGraph;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ProcedureResources;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import java.util.HashMap;
import java.util.Map;

public class ProcedureResourceCache {
    private final SifaStats mStats;
    private final CallGraph mCallGraph;
    private final IIcfg<IcfgLocation> mIcfg;
    private final Map<String, ProcedureResources> mProcResources = new HashMap<String, ProcedureResources>();

    public ProcedureResourceCache(SifaStats sifaStats, CallGraph callGraph, IIcfg<IcfgLocation> iIcfg) {
        this.mStats = sifaStats;
        this.mCallGraph = callGraph;
        this.mIcfg = iIcfg;
    }

    public ProcedureResources resourcesOf(String string) {
        return this.mProcResources.computeIfAbsent(string, this::computeProcResources);
    }

    private ProcedureResources computeProcResources(String string) {
        return new ProcedureResources(this.mStats, this.mIcfg, string, this.mCallGraph.locationsOfInterest(string), this.mCallGraph.successorsOfInterest(string));
    }
}

