/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.IOException;
import java.util.Map;

public class Scriptor
extends NoopScript {
    protected Executor mExecutor;
    private Script.LBool mStatus = Script.LBool.UNKNOWN;

    public Scriptor(String string, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, String string2, String string3) throws IOException {
        this.mExecutor = new Executor(string, (Script)this, iLogger, iUltimateServiceProvider, string2, string3);
        super.setOption(":print-success", (Object)true);
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        super.setLogic(logics);
        this.mExecutor.input(SmtCommandUtils.SetLogicCommand.buildString(logics.name()));
        this.mExecutor.parseSuccess();
    }

    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        if (!string.equals(":print-success")) {
            this.mExecutor.input(SmtCommandUtils.SetOptionCommand.buildString(string, object));
            this.mExecutor.parseSuccess();
        }
    }

    public void setInfo(String string, Object object) {
        this.mExecutor.input(SmtCommandUtils.SetInfoCommand.buildString(string, object));
        this.mExecutor.parseSuccess();
    }

    public void declareSort(String string, int n) throws SMTLIBException {
        super.declareSort(string, n);
        this.mExecutor.input(SmtCommandUtils.DeclareSortCommand.buildString(string, n));
        this.mExecutor.parseSuccess();
    }

    public void defineSort(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        super.defineSort(string, sortArray, sort);
        this.mExecutor.input(SmtCommandUtils.DefineSortCommand.buildString(string, sortArray, sort));
        this.mExecutor.parseSuccess();
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        super.declareFun(string, sortArray, sort);
        this.mExecutor.input(SmtCommandUtils.DeclareFunCommand.buildString(string, sortArray, sort));
        this.mExecutor.parseSuccess();
    }

    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        super.defineFun(string, termVariableArray, sort, term);
        this.mExecutor.input(SmtCommandUtils.DefineFunCommand.buildString(string, termVariableArray, sort, term));
        this.mExecutor.parseSuccess();
    }

    public void push(int n) throws SMTLIBException {
        super.push(n);
        this.mExecutor.input("(push " + n + ")");
        this.mExecutor.parseSuccess();
    }

    public void pop(int n) throws SMTLIBException {
        super.pop(n);
        this.mExecutor.input("(pop " + n + ")");
        this.mExecutor.parseSuccess();
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mExecutor.input(SmtCommandUtils.AssertCommand.buildString(term));
        this.mExecutor.parseSuccess();
        this.mStatus = Script.LBool.UNKNOWN;
        return Script.LBool.UNKNOWN;
    }

    public Script.LBool checkSat() throws SMTLIBException {
        this.mExecutor.input(SmtCommandUtils.CheckSatCommand.buildString());
        this.mStatus = this.mExecutor.parseCheckSatResult();
        return this.mStatus;
    }

    public Term[] getAssertions() throws SMTLIBException {
        this.mExecutor.input("(get-assertions)");
        return this.mExecutor.parseGetAssertionsResult();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Proofs are not supported");
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input(SmtCommandUtils.GetUnsatCoreCommand.buildString());
        return this.mExecutor.parseGetUnsatCoreResult();
    }

    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if (!(term.getSort().isNumericSort() || term.getSort() == this.getTheory().getBooleanSort() || term.getSort().getRealSort().getName().equals("BitVec") || term.getSort().getRealSort().getName().equals("FloatingPoint"))) {
                throw new UnsupportedOperationException("Cannot provide value for term " + term.toStringDirect() + " of sort " + String.valueOf(term.getSort().getRealSort()));
            }
            ++n2;
        }
        this.mExecutor.input(SmtCommandUtils.GetValueCommand.buildString(termArray));
        return this.mExecutor.parseGetValueResult();
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input("(get-assignment)");
        return this.mExecutor.parseGetAssignmentResult();
    }

    public Object getOption(String string) throws UnsupportedOperationException {
        this.mExecutor.input("(get-option " + string + ")");
        return this.mExecutor.parseGetOptionResult();
    }

    public Object getInfo(String string) throws UnsupportedOperationException {
        this.mExecutor.input("(get-info " + string + ")");
        Object[] objectArray = this.mExecutor.parseGetInfoResult();
        if (objectArray.length == 1) {
            return objectArray[0];
        }
        return objectArray;
    }

    public void exit() {
        this.mExecutor.exit();
    }

    public Term simplify(Term term) throws SMTLIBException {
        this.mExecutor.input("(simplify " + String.valueOf(term) + ")");
        return this.mExecutor.parseTerm();
    }

    public void reset() {
        super.reset();
        try {
            this.mExecutor.reset();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input("(get-model)");
        return this.mExecutor.parseGetModelResult();
    }

    public Script.LBool getStatus() {
        return this.mStatus;
    }
}

