/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Trigger
extends Attribute {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Trigger.class);
    Expression[] triggers;

    public Trigger(ILocation iLocation, Expression[] expressionArray) {
        super(iLocation);
        this.triggers = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Trigger: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Trigger").append('[');
        if (this.triggers == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.triggers.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.triggers[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Expression[] getTriggers() {
        return this.triggers;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.triggers != null) {
            list.addAll(Arrays.asList(this.triggers));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Attribute)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.triggers != null) {
            Expression[] expressionArray = this.triggers;
            int n = this.triggers.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                expression.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Attribute accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Attribute attribute = generatedBoogieAstTransformer.transform(this);
        if (attribute != this) {
            return attribute;
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.triggers != null) {
            Expression[] expressionArray = this.triggers;
            int n = this.triggers.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                Expression expression2 = expression.accept(generatedBoogieAstTransformer);
                bl = bl || expression2 != expression;
                arrayList.add(expression2);
                ++n2;
            }
        }
        if (bl) {
            return new Trigger(this.loc, arrayList.toArray(new Expression[0]));
        }
        return this;
    }
}

