/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.DefaultIndependenceCache;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.DisjunctiveConditionalIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.PredicateTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceSettings;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticConditionEliminator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceConditionGenerator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.IRefinableAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.RefinableCachedAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.SpecificVariableAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.VariableAbstraction;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.IRefinableIndependenceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.IndependenceProviderForLoopers;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.IndependenceProviderWithAbstraction;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.PartialOrderCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.StaticIndependenceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IndependenceProviderFactory<L extends IIcfgTransition<?>> {
    private static final boolean REDUCE_CONTEXT_PREDICATES = true;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final TAPreferences mPref;
    private final ICopyActionFactory<L> mCopyFactory;
    private ManagedScript mIndependenceScript;
    private TransferrerWithVariableCache mTransferrer;
    private CfgSmtToolkit mCachedCsToolkit;
    private BasicPredicateFactory mIndepScriptPredicateFactory;
    private PredicateTransferrer mPredicateTransferrer;
    private final DefaultIndependenceCache<IPredicate, L> mIndependenceCache = new DefaultIndependenceCache();

    public IndependenceProviderFactory(IUltimateServiceProvider iUltimateServiceProvider, TAPreferences tAPreferences, ICopyActionFactory<L> iCopyActionFactory) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(IndependenceProviderFactory.class);
        this.mPref = tAPreferences;
        this.mCopyFactory = iCopyActionFactory;
    }

    public List<IRefinableIndependenceProvider<L>> createProviders(IIcfg<?> iIcfg, PredicateFactory predicateFactory) {
        this.mIndependenceCache.clearConditional();
        int n = this.mPref.getNumberOfIndependenceRelations();
        ArrayList<IRefinableIndependenceProvider<L>> arrayList = new ArrayList<IRefinableIndependenceProvider<L>>(n);
        int n2 = 0;
        while (n2 < n) {
            IndependenceSettings independenceSettings = this.mPref.porIndependenceSettings(n2);
            this.mLogger.info("Independence Relation #%d: %s", new Object[]{n2 + 1, independenceSettings});
            IRefinableIndependenceProvider<L> iRefinableIndependenceProvider = this.constructIndependenceProvider(iIcfg, independenceSettings, predicateFactory);
            arrayList.add(iRefinableIndependenceProvider);
            ++n2;
        }
        this.mPredicateTransferrer = null;
        return arrayList;
    }

    private IRefinableIndependenceProvider<L> constructIndependenceProvider(IIcfg<?> iIcfg, IndependenceSettings independenceSettings, PredicateFactory predicateFactory) {
        IRefinableAbstraction<NestedWordAutomaton<L, IPredicate>, ?, L> iRefinableAbstraction;
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        if (independenceSettings.getAbstractionType() == IndependenceSettings.AbstractionType.LOOPER) {
            return new IndependenceProviderForLoopers(this.mServices, cfgSmtToolkit, (Lazy<ManagedScript>)new Lazy(() -> {
                this.mIndependenceScript = this.constructIndependenceScript(independenceSettings);
                return this.mIndependenceScript;
            }), independenceSettings.getIndependenceType());
        }
        if (this.mIndependenceScript == null) {
            this.mIndependenceScript = this.constructIndependenceScript(independenceSettings);
            this.mTransferrer = new TransferrerWithVariableCache(cfgSmtToolkit.getManagedScript().getScript(), this.mIndependenceScript);
        }
        if (this.mCachedCsToolkit != cfgSmtToolkit) {
            this.mCachedCsToolkit = cfgSmtToolkit;
            iRefinableAbstraction = this.mTransferrer.transferSymbolTable(cfgSmtToolkit.getSymbolTable(), cfgSmtToolkit.getProcedures());
            this.mIndepScriptPredicateFactory = new BasicPredicateFactory(this.mServices, this.mIndependenceScript, iRefinableAbstraction);
        }
        if (this.mPredicateTransferrer == null) {
            this.mPredicateTransferrer = new PredicateTransferrer(this.mTransferrer, (SmtFreePredicateFactory)predicateFactory, (SmtFreePredicateFactory)this.mIndepScriptPredicateFactory);
        }
        if (independenceSettings.getAbstractionType() == IndependenceSettings.AbstractionType.NONE) {
            iRefinableAbstraction = this.constructIndependence(independenceSettings, false, predicateFactory, this.mPredicateTransferrer);
            return new StaticIndependenceProvider(iRefinableAbstraction);
        }
        iRefinableAbstraction = this.constructAbstraction(iIcfg, independenceSettings, this.mIndependenceScript);
        RefinableCachedAbstraction refinableCachedAbstraction = new RefinableCachedAbstraction(iRefinableAbstraction);
        IIndependenceRelation<IPredicate, L> iIndependenceRelation = this.constructIndependence(independenceSettings, true, predicateFactory, this.mPredicateTransferrer);
        return new IndependenceProviderWithAbstraction(refinableCachedAbstraction, iIndependenceRelation);
    }

    private IIndependenceRelation<IPredicate, L> constructIndependence(IndependenceSettings independenceSettings, boolean bl, PredicateFactory predicateFactory, PredicateTransferrer predicateTransferrer) {
        if (independenceSettings.getIndependenceType() == IndependenceSettings.IndependenceType.SYNTACTIC) {
            return ((IndependenceBuilder.ActionIndependenceBuilder)IndependenceBuilder.syntactic().cached()).threadSeparated().build();
        }
        assert (independenceSettings.getIndependenceType() == IndependenceSettings.IndependenceType.SEMANTIC) : "unsupported independence type";
        return ((IndependenceBuilder.PredicateActionIndependenceBuilder)((IndependenceBuilder.PredicateActionIndependenceBuilder)((IndependenceBuilder.PredicateActionIndependenceBuilder)((IndependenceBuilder.PredicateActionIndependenceBuilder)((IndependenceBuilder.PredicateActionIndependenceBuilder)((IndependenceBuilder.PredicateActionIndependenceBuilder)IndependenceBuilder.semantic((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mIndependenceScript, (boolean)independenceSettings.useConditional(), (!independenceSettings.useSemiCommutativity() ? 1 : 0) != 0, (SemanticIndependenceRelation.IndependenceConditions)this.mPref.getSymbolicRelationMode(), (BasicPredicateFactory)this.mIndepScriptPredicateFactory, (SemanticIndependenceConditionGenerator)this.getGenerator(independenceSettings)).ifThen(!bl || independenceSettings.useConditional(), predicateActionIndependenceBuilder -> predicateActionIndependenceBuilder.transferTerms(this.mTransferrer, predicateTransferrer, this.mCopyFactory, bl))).protectAgainstQuantifiers()).withSyntacticCheck()).cached(this.mIndependenceCache)).withConditionElimination(PartialOrderCegarLoop::isFalseLiteral).withFilteredConditions(iPredicate -> !predicateFactory.isDontCare(iPredicate))).withDisjunctivePredicates(PartialOrderCegarLoop::getConjuncts, ImmutableList::new, IndependenceProviderFactory.getConditionMerger(predicateFactory)).threadSeparated()).build();
    }

    private static <L extends IIcfgTransition<?>, C extends Collection<IPredicate>> DisjunctiveConditionalIndependenceRelation.IConditionMerger<L, IPredicate, C> getConditionMerger(PredicateFactory predicateFactory) {
        return (collection, iIcfgTransition, iIcfgTransition2) -> {
            List list = collection.stream().filter(iPredicate -> SemanticConditionEliminator.isRelevant((IPredicate)iPredicate, (IAction)iIcfgTransition) || SemanticConditionEliminator.isRelevant((IPredicate)iPredicate, (IAction)iIcfgTransition2)).collect(Collectors.toList());
            if (list.isEmpty()) {
                return null;
            }
            return predicateFactory.and(list);
        };
    }

    private SemanticIndependenceConditionGenerator getGenerator(IndependenceSettings independenceSettings) {
        if (this.mPref.getSymbolicRelationMode().requiresConditionGenerator()) {
            return new SemanticIndependenceConditionGenerator(this.mServices, this.mIndependenceScript, this.mIndepScriptPredicateFactory, !independenceSettings.useSemiCommutativity(), true);
        }
        return null;
    }

    private ManagedScript constructIndependenceScript(IndependenceSettings independenceSettings) {
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setDumpSmtScriptToFile(this.mPref.dumpIndependenceScript(), this.mPref.independenceScriptDumpPath(), "commutativity", false);
        solverSettings = independenceSettings.getSolver() == SolverBuilder.ExternalSolver.SMTINTERPOL ? solverSettings.setSolverMode(SolverBuilder.SolverMode.Internal_SMTInterpol).setSmtInterpolTimeout(independenceSettings.getSolverTimeout()) : solverSettings.setSolverMode(SolverBuilder.SolverMode.External_DefaultMode).setUseExternalSolver(independenceSettings.getSolver(), independenceSettings.getSolverTimeout());
        return new ManagedScript(this.mServices, SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)solverSettings, (String)"SemanticIndependence"));
    }

    private IRefinableAbstraction<NestedWordAutomaton<L, IPredicate>, ?, L> constructAbstraction(IIcfg<?> iIcfg, IndependenceSettings independenceSettings, ManagedScript managedScript2) {
        if (independenceSettings.getAbstractionType() == IndependenceSettings.AbstractionType.NONE) {
            return null;
        }
        Set set2 = IcfgUtils.collectAllProgramVars((CfgSmtToolkit)iIcfg.getCfgSmtToolkit());
        SpecificVariableAbstraction.TransFormulaAuxVarEliminator transFormulaAuxVarEliminator = (managedScript, term, set) -> TransFormulaUtils.tryAuxVarEliminationLight((IUltimateServiceProvider)this.mServices, (ManagedScript)managedScript, (Term)term, (Set)set);
        switch (independenceSettings.getAbstractionType()) {
            case VARIABLES_GLOBAL: {
                return new VariableAbstraction(this.mCopyFactory, managedScript2, this.mTransferrer, transFormulaAuxVarEliminator, set2);
            }
            case VARIABLES_LOCAL: {
                if (this.mPref.interpolantAutomatonEnhancement() != TAPreferences.InterpolantAutomatonEnhancement.NONE) {
                    throw new UnsupportedOperationException("specific variable abstraction is only supported with interpolant automaton enhancement NONE");
                }
                Set set3 = new IcfgEdgeIterator(iIcfg).asStream().map(icfgEdge -> icfgEdge).collect(Collectors.toSet());
                return new SpecificVariableAbstraction(this.mCopyFactory, managedScript2, this.mTransferrer, transFormulaAuxVarEliminator, set3, set2);
            }
        }
        throw new UnsupportedOperationException("Unknown abstraction type: " + String.valueOf(independenceSettings.getAbstractionType()));
    }

    public void shutdown() {
        if (this.mIndependenceScript != null) {
            this.mIndependenceScript.getScript().exit();
        }
    }

    private static /* synthetic */ IPredicate lambda$8(PredicateFactory predicateFactory, Collection collection, IIcfgTransition iIcfgTransition, IIcfgTransition iIcfgTransition2) {
        return predicateFactory.and(collection);
    }
}

