/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DataTypeInterpretation
implements SortInterpretation {
    Model mModel;
    Sort mSort;
    Set<Term> mExistingTerms = new LinkedHashSet<Term>();
    private FunctionSymbol mInfiniteConstructor;
    private int mInfiniteConsArg;

    public DataTypeInterpretation(Model model, Sort sort) {
        this.mModel = model;
        this.mSort = sort;
    }

    @Override
    public Term toSMTLIB(Theory theory, Sort sort) {
        throw new InternalError("Should never be called!");
    }

    @Override
    public Term extendFresh(Sort sort) {
        assert (this.mSort == sort);
        return this.extendFreshOrLast(new HashSet<Sort>());
    }

    private boolean isInfinite(Sort sort, Map<Sort, Boolean> map) {
        DataType dataType = (DataType)sort.getSortSymbol();
        if (map.containsKey(sort)) {
            return map.get(sort);
        }
        map.put(sort, true);
        DataType.Constructor[] constructorArray = dataType.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType.Constructor constructor = constructorArray[n2];
            Sort[] sortArray = constructor.getArgumentSorts();
            int n3 = sortArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Sort sort2 = sortArray[n4];
                Sort sort3 = sort2.mapSort(sort.getArguments());
                if (sort3.isNumericSort() || sort3.isArraySort() || (sort3.getSortSymbol().isDatatype() ? this.isInfinite(sort3, map) : !sort3.isInternal())) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        map.put(sort, false);
        return false;
    }

    private void findInfiniteConstructor() {
        DataType dataType = (DataType)this.mSort.getSortSymbol();
        HashMap<Sort, Boolean> hashMap = new HashMap<Sort, Boolean>();
        hashMap.put(this.mSort, true);
        DataType.Constructor[] constructorArray = dataType.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Sort[] sortArray;
            DataType.Constructor constructor = constructorArray[n2];
            Sort[] sortArray2 = sortArray = constructor.getArgumentSorts();
            if (this.mSort.getArguments().length > 0) {
                sortArray2 = new Sort[sortArray.length];
                n3 = 0;
                while (n3 < sortArray.length) {
                    sortArray2[n3] = sortArray[n3].mapSort(this.mSort.getArguments());
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < sortArray.length) {
                if (sortArray2[n3].isNumericSort() || sortArray2[n3].isArraySort() || (sortArray2[n3].getSortSymbol().isDatatype() ? this.isInfinite(sortArray2[n3], hashMap) : !sortArray2[n3].isInternal())) {
                    this.mInfiniteConsArg = n3;
                    Sort sort = constructor.needsReturnOverload() ? this.mSort : null;
                    this.mInfiniteConstructor = this.mModel.getTheory().getFunctionWithResult(constructor.getName(), null, sort, sortArray2);
                }
                ++n3;
            }
            ++n2;
        }
    }

    private Term createSomeTerm(HashSet<Sort> hashSet) {
        if (!this.mExistingTerms.isEmpty()) {
            return this.mExistingTerms.iterator().next();
        }
        if (!hashSet.add(this.mSort)) {
            return null;
        }
        DataType dataType = (DataType)this.mSort.getSortSymbol();
        DataType.Constructor[] constructorArray = dataType.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                DataTypeInterpretation dataTypeInterpretation;
                int n3;
                Sort[] sortArray;
                DataType.Constructor constructor = constructorArray[n2];
                Sort[] sortArray2 = sortArray = constructor.getArgumentSorts();
                Term[] termArray = new Term[sortArray.length];
                if (this.mSort.getArguments().length > 0) {
                    sortArray2 = new Sort[sortArray.length];
                    n3 = 0;
                    while (n3 < sortArray.length) {
                        sortArray2[n3] = sortArray[n3].mapSort(this.mSort.getArguments());
                        ++n3;
                    }
                }
                n3 = 0;
                while (n3 < sortArray.length) {
                    if (sortArray2[n3].getSortSymbol().isDatatype()) {
                        dataTypeInterpretation = (DataTypeInterpretation)this.mModel.provideSortInterpretation(sortArray2[n3]);
                        termArray[n3] = dataTypeInterpretation.createSomeTerm(hashSet);
                        if (termArray[n3] == null) {
                            break block9;
                        }
                    } else {
                        termArray[n3] = this.mModel.getSomeValue(sortArray2[n3]);
                    }
                    ++n3;
                }
                Sort sort = constructor.needsReturnOverload() ? this.mSort : null;
                dataTypeInterpretation = this.mModel.getTheory().term(constructor.getName(), null, sort, termArray);
                this.register((Term)dataTypeInterpretation);
                return dataTypeInterpretation;
            }
            ++n2;
        }
        throw new AssertionError((Object)"DataType is empty");
    }

    private Term getLastAddedTerm() {
        if (this.mExistingTerms.isEmpty()) {
            Term term = this.createSomeTerm(new HashSet<Sort>());
            assert (term != null) : "DataType is empty";
            return term;
        }
        Iterator<Term> iterator = this.mExistingTerms.iterator();
        Term term = iterator.next();
        while (iterator.hasNext()) {
            term = iterator.next();
        }
        return term;
    }

    private Term extendFreshOrLast(Set<Sort> set) {
        if (!set.add(this.mSort)) {
            return this.getLastAddedTerm();
        }
        if (this.mInfiniteConstructor == null) {
            this.findInfiniteConstructor();
        }
        Sort[] sortArray = this.mInfiniteConstructor.getParameterSorts();
        Term[] termArray = new Term[sortArray.length];
        int n = 0;
        while (n < termArray.length) {
            if (n != this.mInfiniteConsArg) {
                termArray[n] = this.mModel.getSomeValue(sortArray[n]);
            } else if (sortArray[n].getSortSymbol().isDatatype()) {
                DataTypeInterpretation dataTypeInterpretation = (DataTypeInterpretation)this.mModel.provideSortInterpretation(sortArray[n]);
                termArray[n] = dataTypeInterpretation.extendFreshOrLast(set);
            } else {
                termArray[n] = this.mModel.extendFresh(sortArray[n]);
            }
            ++n;
        }
        Term term = this.mModel.getTheory().term(this.mInfiniteConstructor, termArray);
        this.register(term);
        return term;
    }

    @Override
    public void register(Term term) {
        assert (term.getSort() == this.mSort && ((ApplicationTerm)term).getFunction().isConstructor());
        this.mExistingTerms.add(term);
    }

    public String toString() {
        return "datatypeSort" + String.valueOf(this.mExistingTerms);
    }

    @Override
    public Term getModelValue(int n, Sort sort) {
        if (this.mExistingTerms.size() == 0) {
            this.createSomeTerm(new HashSet<Sort>());
        }
        while (n >= this.mExistingTerms.size()) {
            this.extendFresh(sort);
        }
        Iterator<Term> iterator = this.mExistingTerms.iterator();
        while (n-- > 0) {
            iterator.next();
        }
        return iterator.next();
    }
}

