/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IStateWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StateWa
implements IStateWa,
Comparable<StateWa> {
    private final int mId;
    private final Map<Integer, IntSet> mSuccessors;

    public StateWa(int n) {
        this.mId = n;
        this.mSuccessors = new HashMap<Integer, IntSet>();
    }

    @Override
    public int getId() {
        return this.mId;
    }

    @Override
    public void addSuccessor(int n, int n2) {
        IntSet intSet = this.mSuccessors.get(n);
        if (intSet == null) {
            intSet = UtilIntSet.newIntSet();
        }
        intSet.set(n2);
        this.mSuccessors.put(n, intSet);
    }

    @Override
    public IntSet getSuccessors(int n) {
        IntSet intSet = this.mSuccessors.get(n);
        if (intSet == null) {
            return UtilIntSet.newIntSet();
        }
        return intSet.clone();
    }

    @Override
    public Set<Integer> getEnabledLetters() {
        return Collections.unmodifiableSet(this.mSuccessors.keySet());
    }

    @Override
    public int compareTo(StateWa stateWa) {
        return this.mId - stateWa.mId;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StateWa stateWa = (StateWa)object;
        return stateWa.mId == this.mId;
    }

    @Override
    public int hashCode() {
        return this.mId;
    }

    @Override
    public String toString() {
        return "s" + this.mId;
    }
}

