/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class AssertStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(AssertStatement.class);
    NamedAttribute[] attributes;
    Expression formula;

    public AssertStatement(ILocation iLocation, Expression expression) {
        super(iLocation);
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid AssertStatement: " + String.valueOf((Object)this);
    }

    public AssertStatement(ILocation iLocation, NamedAttribute[] namedAttributeArray, Expression expression) {
        super(iLocation);
        this.attributes = namedAttributeArray;
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid AssertStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AssertStatement").append('[');
        if (this.attributes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.attributes.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.attributes[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.formula);
        return stringBuffer.append(']').toString();
    }

    public NamedAttribute[] getAttributes() {
        return this.attributes;
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.attributes != null) {
            list.addAll(Arrays.asList(this.attributes));
        }
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.attributes != null) {
                NamedAttribute[] namedAttributeArray = this.attributes;
                int n = this.attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    NamedAttribute namedAttribute = namedAttributeArray[n2];
                    namedAttribute.accept(generatedBoogieAstVisitor);
                    ++n2;
                }
            }
            if (this.formula != null) {
                this.formula.accept(generatedBoogieAstVisitor);
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        BoogieASTNode boogieASTNode;
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<NamedAttribute> arrayList = new ArrayList<NamedAttribute>();
        if (this.attributes != null) {
            NamedAttribute[] namedAttributeArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                boogieASTNode = namedAttributeArray[n2];
                NamedAttribute namedAttribute = (NamedAttribute)((NamedAttribute)boogieASTNode).accept(generatedBoogieAstTransformer);
                bl = bl || namedAttribute != boogieASTNode;
                arrayList.add(namedAttribute);
                ++n2;
            }
        }
        boogieASTNode = null;
        if (this.formula != null) {
            boogieASTNode = this.formula.accept(generatedBoogieAstTransformer);
        }
        if (bl || this.formula != boogieASTNode) {
            return new AssertStatement(this.loc, arrayList.toArray(new NamedAttribute[0]), (Expression)boogieASTNode);
        }
        return this;
    }
}

