/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlphaSolver<INLOC extends IcfgLocation> {
    private final UnmodifiableTransFormula mOriginalTransFormula;
    private final ILogger mLogger;
    private final Map<Integer, Map<Term, Term>> mMatrix;
    private final Map<Integer, Map<Term, Term>> mLGS;
    private final IProgramVar[] mProgramVar;
    private final Script mScript;
    private final ManagedScript mMgScript;
    private List<Term> mVectorTerms;
    private Map<IProgramVar, TermVariable[]> mAlphaMap;
    private final TermVariable[] mAlphaN = new TermVariable[2];
    private final Map<Term, Term> mAlphaDefaultConstant = new HashMap<Term, Term>();
    private TermVariable mNVar;
    private Term mFinalTerm;
    private final Map<IProgramVar, Term> mValues = new HashMap<IProgramVar, Term>();

    public AlphaSolver(ILogger iLogger, UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript, Map<Integer, Map<Term, Term>> map, Map<Integer, Map<Term, Term>> map2, IUltimateServiceProvider iUltimateServiceProvider, int n) {
        this.mMgScript = managedScript;
        this.mScript = this.mMgScript.getScript();
        this.mOriginalTransFormula = unmodifiableTransFormula;
        this.mLogger = iLogger;
        Set set = this.mOriginalTransFormula.getAssignedVars();
        this.mProgramVar = set.toArray(new IProgramVar[set.size()]);
        this.mMatrix = map;
        this.mLGS = map2;
        this.mMgScript.lock((Object)this);
        this.initAlphas(n);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n2 = this.mProgramVar.length;
        int n3 = 0;
        while (n3 < n2) {
            IProgramVar iProgramVar = iProgramVarArray[n3];
            this.mVectorTerms = new ArrayList<Term>();
            this.lgsTermN0(iProgramVar);
            this.lgsTermN1(iProgramVar);
            this.lgsTermN2(iProgramVar);
            Term term = this.mScript.term("and", this.mVectorTerms.toArray(new Term[this.mVectorTerms.size()]));
            Term term2 = this.solveTerm(term, iProgramVar);
            arrayList.add(term2);
            ++n3;
        }
        this.mFinalTerm = arrayList.isEmpty() ? null : (arrayList.size() == 1 ? (Term)arrayList.get(0) : this.mScript.term("and", arrayList.toArray(new Term[arrayList.size()])));
        this.mMgScript.unlock((Object)this);
    }

    private Term solveTerm(Term term, IProgramVar iProgramVar) {
        Term term2 = Substitution.apply((ManagedScript)this.mMgScript, this.mAlphaDefaultConstant, (Term)term);
        this.mScript.push(1);
        Script.LBool lBool = AlphaSolver.checkSat(this.mScript, term2);
        Term term3 = null;
        try {
            if (lBool == Script.LBool.SAT) {
                IProgramVar iProgramVar2;
                Collection<Term> collection = this.mAlphaDefaultConstant.values();
                Map map = SmtUtils.getValues((Script)this.mScript, collection);
                Term term4 = this.mScript.decimal("0.0");
                ArrayList<Term> arrayList = new ArrayList<Term>();
                IProgramVar[] iProgramVarArray = this.mProgramVar;
                int n = this.mProgramVar.length;
                int n2 = 0;
                while (n2 < n) {
                    iProgramVar2 = iProgramVarArray[n2];
                    if (!((Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(iProgramVar2)[0]))).equals(term4)) {
                        arrayList.add(this.mScript.term("*", new Term[]{this.mScript.term("to_int", new Term[]{(Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(iProgramVar2)[0]))}), (Term)this.mOriginalTransFormula.getInVars().get(iProgramVar2)}));
                    }
                    if (!((Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(iProgramVar2)[1]))).equals(term4)) {
                        arrayList.add(this.mScript.term("*", new Term[]{this.mScript.term("to_int", new Term[]{(Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(iProgramVar2)[1]))}), (Term)this.mOriginalTransFormula.getInVars().get(iProgramVar2), this.mNVar}));
                    }
                    ++n2;
                }
                iProgramVar2 = arrayList.size() == 1 ? (Term)arrayList.get(0) : this.mScript.term("+", arrayList.toArray(new Term[arrayList.size()]));
                ArrayList<Term> arrayList2 = new ArrayList<Term>();
                if (!((Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaN[0]))).equals(term4)) {
                    arrayList2.add(this.mScript.term("*", new Term[]{(Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaN[0])), this.mScript.term("to_real", new Term[]{this.mNVar})}));
                }
                if (!((Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaN[1]))).equals(term4)) {
                    arrayList2.add(this.mScript.term("*", new Term[]{(Term)map.get(this.mAlphaDefaultConstant.get(this.mAlphaN[1])), this.mScript.term("to_real", new Term[]{this.mNVar}), this.mScript.term("to_real", new Term[]{this.mNVar})}));
                }
                Term term5 = arrayList2.size() == 1 ? this.mScript.term("to_int", new Term[]{(Term)arrayList2.get(0)}) : this.mScript.term("to_int", new Term[]{this.mScript.term("+", arrayList2.toArray(new Term[arrayList2.size()]))});
                term3 = this.mScript.term("=", new Term[]{(Term)this.mOriginalTransFormula.getOutVars().get(iProgramVar), this.mScript.term("+", new Term[]{iProgramVar2, term5})});
                this.mValues.put(iProgramVar, this.mScript.term("+", new Term[]{iProgramVar2, term5}));
            }
        }
        finally {
            this.mScript.pop(1);
        }
        return term3;
    }

    public Map<IProgramVar, Term> getValues() {
        return this.mValues;
    }

    public Term getResult() {
        return this.mFinalTerm;
    }

    public TermVariable getN() {
        return this.mNVar;
    }

    private static Script.LBool checkSat(Script script, Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        Term[] termArray = new Term[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            termArray[n] = AlphaSolver.termVariable2constant(script, termVariableArray[n]);
            ++n;
        }
        Term term2 = script.let(termVariableArray, termArray, term);
        Script.LBool lBool = script.assertTerm(term2);
        if (lBool == Script.LBool.UNKNOWN) {
            lBool = script.checkSat();
        }
        return lBool;
    }

    private static Term termVariable2constant(Script script, TermVariable termVariable) {
        String string = termVariable.getName() + "_const_" + termVariable.hashCode();
        script.declareFun(string, Script.EMPTY_SORT_ARRAY, termVariable.getSort());
        return script.term(string, new Term[0]);
    }

    private void initAlphas(int n) {
        this.mAlphaMap = new HashMap<IProgramVar, TermVariable[]>();
        this.mNVar = this.mScript.variable("n", this.mScript.sort("Int", new Sort[0]));
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n2 = this.mProgramVar.length;
        int n3 = 0;
        while (n3 < n2) {
            IProgramVar iProgramVar = iProgramVarArray[n3];
            TermVariable termVariable = this.mScript.variable("alpha" + iProgramVar.toString(), this.mScript.sort("Real", new Sort[0]));
            TermVariable termVariable2 = this.mScript.variable("alpha" + iProgramVar.toString() + "n", this.mScript.sort("Real", new Sort[0]));
            TermVariable[] termVariableArray = new TermVariable[]{termVariable, termVariable2};
            this.mAlphaMap.put(iProgramVar, termVariableArray);
            this.mAlphaDefaultConstant.put((Term)termVariable, (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)termVariable.getSort(), (String)(termVariable.getName() + n)));
            this.mAlphaDefaultConstant.put((Term)termVariable2, (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)termVariable2.getSort(), (String)(termVariable2.getName() + n)));
            ++n3;
        }
        this.mAlphaN[0] = this.mScript.variable("alpha_n", this.mScript.sort("Real", new Sort[0]));
        this.mAlphaN[1] = this.mScript.variable("alpha_nn", this.mScript.sort("Real", new Sort[0]));
        this.mAlphaDefaultConstant.put((Term)this.mAlphaN[0], (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)this.mAlphaN[0].getSort(), (String)(this.mAlphaN[0].getName() + n)));
        this.mAlphaDefaultConstant.put((Term)this.mAlphaN[1], (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)this.mAlphaN[1].getSort(), (String)(this.mAlphaN[1].getName() + n)));
    }

    private void lgsTermN0(IProgramVar iProgramVar) {
        Term term = this.mScript.decimal("1.0");
        Term term2 = this.mScript.decimal("0.0");
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n = this.mProgramVar.length;
        int n2 = 0;
        while (n2 < n) {
            IProgramVar iProgramVar2 = iProgramVarArray[n2];
            if (iProgramVar2 == iProgramVar) {
                this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("*", new Term[]{term, this.mAlphaMap.get(iProgramVar2)[0]}), term}));
            } else {
                this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("*", new Term[]{term, this.mAlphaMap.get(iProgramVar2)[0]}), term2}));
            }
            ++n2;
        }
    }

    private void lgsTermN1(IProgramVar iProgramVar) {
        int n = 0;
        while (n < this.mMatrix.size() - 1) {
            Map<Term, Term> map = this.mMatrix.get(n);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IProgramVar[] iProgramVarArray = this.mProgramVar;
            int n2 = this.mProgramVar.length;
            int n3 = 0;
            while (n3 < n2) {
                IProgramVar iProgramVar2 = iProgramVarArray[n3];
                arrayList.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(iProgramVar2)[0], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(iProgramVar2))})}));
                arrayList.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(iProgramVar2)[1], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(iProgramVar2))})}));
                ++n3;
            }
            arrayList.add(this.mAlphaN[0]);
            arrayList.add(this.mAlphaN[1]);
            this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("+", arrayList.toArray(new Term[this.mProgramVar.length])), this.mScript.term("to_real", new Term[]{this.mLGS.get(n).get(this.mOriginalTransFormula.getOutVars().get(iProgramVar))})}));
            ++n;
        }
    }

    private void lgsTermN2(IProgramVar iProgramVar) {
        int n = this.mMatrix.size() - 1;
        Map<Term, Term> map = this.mMatrix.get(n);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n2 = this.mProgramVar.length;
        int n3 = 0;
        while (n3 < n2) {
            IProgramVar iProgramVar2 = iProgramVarArray[n3];
            arrayList.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(iProgramVar2)[0], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(iProgramVar2))})}));
            arrayList.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(iProgramVar2)[1], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(iProgramVar2))}), this.mScript.decimal("2.0")}));
            ++n3;
        }
        arrayList.add(this.mScript.term("*", new Term[]{this.mAlphaN[0], this.mScript.decimal("2.0")}));
        arrayList.add(this.mScript.term("*", new Term[]{this.mAlphaN[1], this.mScript.decimal("4.0")}));
        this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("+", arrayList.toArray(new Term[this.mProgramVar.length])), this.mScript.term("to_real", new Term[]{this.mLGS.get(n).get(this.mOriginalTransFormula.getOutVars().get(iProgramVar))})}));
    }
}

