/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithLocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class ResultService
implements IStorable,
IResultService {
    private final Map<String, List<IResult>> mResults = new HashMap<String, List<IResult>>();
    private final Map<String, Function<IResult, IResult>> mTransformers = new LinkedHashMap<String, Function<IResult, IResult>>();
    private static final String KEY = "ResultService";

    private ResultService() {
    }

    public void destroy() {
        this.mResults.clear();
        this.mTransformers.clear();
    }

    public Map<String, List<IResult>> getResults() {
        return this.mResults;
    }

    public void reportResult(String string, IResult iResult) {
        IResult iResult2 = this.applyTransformers(iResult);
        if (iResult2 == null) {
            return;
        }
        if (iResult2 instanceof IResultWithLocation && ((IResultWithLocation)iResult2).getLocation() == null) {
            throw new IllegalArgumentException("Location is null");
        }
        if (iResult2.getShortDescription() == null) {
            throw new IllegalArgumentException("ShortDescription is null");
        }
        if (iResult2.getLongDescription() == null) {
            throw new IllegalArgumentException("LongDescription is null");
        }
        List<IResult> list = this.mResults.get(string);
        if (list == null) {
            list = new ArrayList<IResult>();
        }
        list.add(iResult2);
        this.mResults.put(string, list);
    }

    private IResult applyTransformers(IResult iResult) {
        if (this.mTransformers.isEmpty()) {
            return iResult;
        }
        Iterator<Map.Entry<String, Function<IResult, IResult>>> iterator = this.mTransformers.entrySet().iterator();
        IResult iResult2 = iResult;
        while (iResult2 != null && iterator.hasNext()) {
            Map.Entry<String, Function<IResult, IResult>> entry = iterator.next();
            if (entry.getValue() == null) continue;
            iResult2 = entry.getValue().apply(iResult2);
        }
        return iResult2;
    }

    static IResultService getService(IToolchainStorage iToolchainStorage) {
        assert (iToolchainStorage != null);
        IStorable iStorable = iToolchainStorage.getStorable(KEY);
        if (iStorable == null) {
            iStorable = new ResultService();
            iToolchainStorage.putStorable(KEY, iStorable);
        }
        return (IResultService)iStorable;
    }

    public String toString() {
        if (this.mResults.isEmpty()) {
            return "No Results";
        }
        return this.mResults.toString();
    }

    public void registerTransformer(String string, UnaryOperator<IResult> unaryOperator) {
        this.mTransformers.put(string, unaryOperator);
    }
}

