/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TypeSizeAndOffsetComputer {
    private final LinkedHashSet<ConstDeclaration> mConstants;
    private final LinkedHashSet<Axiom> mAxioms;
    private final HashMap<ICType, SizeTValue> mTypeSizeCache;
    private final HashMap<CStructOrUnion, Offset[]> mStructOffsets;
    private final ITypeHandler mTypeHandler;
    private final TypeSizes mTypeSizes;
    private final ExpressionTranslation mExpressionTranslation;
    private final boolean mBitPreciseBitfields;
    private final boolean mPreferConstantsOverValues = false;
    private SizeTValue mTypeSizePointer = null;

    public TypeSizeAndOffsetComputer(TypeSizes typeSizes, ExpressionTranslation expressionTranslation, ITypeHandler iTypeHandler, boolean bl) {
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizes = typeSizes;
        this.mTypeSizeCache = new HashMap();
        this.mStructOffsets = new HashMap();
        this.mConstants = new LinkedHashSet();
        this.mAxioms = new LinkedHashSet();
        this.mBitPreciseBitfields = bl;
    }

    public Expression constructBytesizeExpression(ILocation iLocation, ICType iCType) {
        SizeTValue sizeTValue = this.computeSize(iLocation, iCType);
        return sizeTValue.asExpression(iLocation);
    }

    public Offset constructOffsetForField(ILocation iLocation, CStructOrUnion cStructOrUnion, int n) {
        if (!this.mTypeSizeCache.containsKey(cStructOrUnion)) {
            assert (!this.mStructOffsets.containsKey(cStructOrUnion)) : "both or none";
            this.computeSize(iLocation, cStructOrUnion);
        }
        Offset[] offsetArray = this.mStructOffsets.get(cStructOrUnion);
        assert (offsetArray.length == cStructOrUnion.getFieldCount()) : "inconsistent struct";
        return offsetArray[n];
    }

    public Offset constructOffsetForField(ILocation iLocation, CStructOrUnion cStructOrUnion, String string) {
        int n = Arrays.asList(cStructOrUnion.getFieldIds()).indexOf(string);
        return this.constructOffsetForField(iLocation, cStructOrUnion, n);
    }

    private Expression constructTypeSizeConstant(ILocation iLocation, ICType iCType) {
        String string = "#sizeof~" + iCType.toString();
        this.declareConstant(iLocation, string);
        return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)BoogieType.TYPE_INT, (String)string, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
    }

    private Expression constructTypeSizeConstant_Pointer(ILocation iLocation) {
        this.declareConstant(iLocation, "#sizeof~$Pointer$");
        return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)BoogieType.TYPE_INT, (String)"#sizeof~$Pointer$", (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
    }

    private void declareConstant(ILocation iLocation, String string) {
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, this.getSizeT());
        VarList varList = new VarList(iLocation, new String[]{string}, aSTType);
        ConstDeclaration constDeclaration = new ConstDeclaration(iLocation, new Attribute[0], false, varList, null, false);
        this.mConstants.add(constDeclaration);
    }

    private SizeTValue computeSize(ILocation iLocation, ICType iCType) {
        ICType iCType2 = iCType.getUnderlyingType();
        if (iCType2 instanceof CPointer) {
            if (this.mTypeSizePointer == null) {
                this.mTypeSizePointer = this.constructSizeTValuePointer(iLocation);
            }
            return this.mTypeSizePointer;
        }
        if (iCType2 instanceof CEnum) {
            return this.computeSize(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT));
        }
        SizeTValue sizeTValue = this.mTypeSizeCache.get(iCType2);
        if (sizeTValue == null) {
            if (iCType2 instanceof CPrimitive) {
                CPrimitive cPrimitive = (CPrimitive)iCType2;
                sizeTValue = this.constructSizeTValuePrimitive(iLocation, cPrimitive);
            } else if (iCType2 instanceof CArray) {
                CArray cArray = (CArray)iCType2;
                sizeTValue = this.constructSizeTValueArray(iLocation, cArray);
            } else if (iCType2 instanceof CStructOrUnion) {
                CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType2;
                sizeTValue = this.constructSizeTValueAndOffsetsStructAndUnion(iLocation, cStructOrUnion);
            } else if (iCType2 instanceof CFunction) {
                sizeTValue = new SizeTValueInteger(BigInteger.ONE);
            } else {
                throw new UnsupportedOperationException("Unsupported type" + String.valueOf(iCType2));
            }
            this.mTypeSizeCache.put(iCType2, sizeTValue);
        }
        return sizeTValue;
    }

    private SizeTValue constructSizeTValuePrimitive(ILocation iLocation, CPrimitive cPrimitive) {
        if (this.mTypeSizes.useFixedTypeSizes()) {
            int n = this.mTypeSizes.getSize(cPrimitive.getType());
            return new SizeTValueInteger(BigInteger.valueOf(n));
        }
        Expression expression = this.constructTypeSizeConstant(iLocation, cPrimitive);
        SizeTValueExpression sizeTValueExpression = new SizeTValueExpression(expression);
        Axiom axiom = this.constructNonNegativeAxiom(iLocation, expression);
        this.mAxioms.add(axiom);
        return sizeTValueExpression;
    }

    private SizeTValue constructSizeTValueArray(ILocation iLocation, CArray cArray) {
        SizeTValue sizeTValue = this.computeSize(iLocation, cArray.getValueType());
        SizeTValue sizeTValue2 = this.extractSizeTValue(cArray.getBound());
        SizeTValue sizeTValue3 = new SizeTValueAggregatorMultiply().aggregate(iLocation, Arrays.asList(sizeTValue, sizeTValue2));
        return sizeTValue3;
    }

    private SizeTValue constructSizeTValueAndOffsetsStructAndUnion(ILocation iLocation, CStructOrUnion cStructOrUnion) {
        if (cStructOrUnion.isIncomplete()) {
            throw new IllegalArgumentException("cannot determine size of incomplete type");
        }
        if (this.mStructOffsets.containsKey(cStructOrUnion)) {
            throw new AssertionError((Object)"must not be computed");
        }
        int n = cStructOrUnion.getFieldCount();
        Offset[] offsetArray = new Offset[n];
        this.mStructOffsets.put(cStructOrUnion, offsetArray);
        if (n == 0) {
            return new SizeTValueInteger(BigInteger.ZERO);
        }
        if (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION) {
            SizeTValue[] sizeTValueArray = new SizeTValue[n];
            int n2 = 0;
            while (n2 < n) {
                ICType iCType = cStructOrUnion.getFieldTypes()[n2];
                int n3 = this.mBitPreciseBitfields ? cStructOrUnion.getBitFieldWidths().get(n2) : -1;
                int n4 = n3 == -1 ? -1 : 0;
                offsetArray[n2] = new Offset(new SizeTValueInteger(BigInteger.ZERO), n4, n3);
                sizeTValueArray[n2] = this.computeOffsetOfNextByte(offsetArray[n2], iCType, iLocation);
                ++n2;
            }
            return new SizeTValueAggregatorMax().aggregate(iLocation, Arrays.asList(sizeTValueArray));
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = this.mBitPreciseBitfields ? cStructOrUnion.getBitFieldWidths().get(n5) : -1;
            if (n5 == 0) {
                int n7 = n6 == -1 ? -1 : 0;
                offsetArray[n5] = new Offset(new SizeTValueInteger(BigInteger.ZERO), n7, n6);
            } else {
                offsetArray[n5] = this.computeMemberOffset(offsetArray[n5 - 1], cStructOrUnion.getFieldTypes()[n5 - 1], n6, iLocation);
            }
            ++n5;
        }
        ICType iCType = cStructOrUnion.getFieldTypes()[n - 1];
        n5 = iCType instanceof CArray && iCType.isIncomplete() ? n - 2 : n - 1;
        return this.computeOffsetOfNextByte(offsetArray[n5], cStructOrUnion.getFieldTypes()[n5], iLocation);
    }

    private SizeTValue constructSizeTValuePointer(ILocation iLocation) {
        if (this.mTypeSizes.useFixedTypeSizes()) {
            int n = this.mTypeSizes.getSizeOfPointer();
            return new SizeTValueInteger(BigInteger.valueOf(n));
        }
        Expression expression = this.constructTypeSizeConstant_Pointer(iLocation);
        SizeTValueExpression sizeTValueExpression = new SizeTValueExpression(expression);
        Axiom axiom = this.constructNonNegativeAxiom(iLocation, expression);
        this.mAxioms.add(axiom);
        return sizeTValueExpression;
    }

    private Axiom constructNonNegativeAxiom(ILocation iLocation, Expression expression) {
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.getSizeT(), BigInteger.ZERO);
        Expression expression3 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, expression, this.getSizeT(), expression2, this.getSizeT());
        return new Axiom(iLocation, new Attribute[0], expression3);
    }

    private SizeTValue extractSizeTValue(RValue rValue) {
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(rValue);
        if (bigInteger != null) {
            return new SizeTValueInteger(bigInteger);
        }
        return new SizeTValueExpression(rValue.getValue());
    }

    public CPrimitive getSizeT() {
        return this.mTypeSizes.getSizeT();
    }

    public Set<ConstDeclaration> getConstants() {
        return this.mConstants;
    }

    public Set<Axiom> getAxioms() {
        return this.mAxioms;
    }

    private Offset computeMemberOffset(Offset offset, ICType iCType, int n, ILocation iLocation) {
        boolean bl;
        boolean bl2 = bl = n != -1;
        if (offset.isBitfieldOffset()) {
            if (offset.getBitFieldSize() == 0) {
                throw new UnsupportedOperationException("Bitfields: case that previous is zero not yet implemented.");
            }
            if (bl) {
                int n2 = offset.getStartBit() + offset.getBitFieldSize();
                int n3 = n2 / 2;
                int n4 = n2 % 8;
                return new Offset(new SizeTValueInteger(offset.getAddressOffset().getInteger().add(BigInteger.valueOf(n3))), n4, n);
            }
            SizeTValueInteger sizeTValueInteger = (SizeTValueInteger)this.computeOffsetOfNextByte(offset, iCType, iLocation);
            return new Offset(sizeTValueInteger, -1, -1);
        }
        if (bl) {
            return new Offset(offset.getAddressOffset(), 0, n);
        }
        SizeTValue sizeTValue = this.computeSize(iLocation, iCType);
        if (!(sizeTValue instanceof SizeTValueInteger)) {
            throw new AssertionError((Object)"only flexible array member at the end can have non-constant size");
        }
        return new Offset(new SizeTValueInteger(offset.getAddressOffset().getInteger().add(((SizeTValueInteger)sizeTValue).getInteger())), -1, -1);
    }

    private SizeTValue computeOffsetOfNextByte(Offset offset, ICType iCType, ILocation iLocation) {
        if (offset.getStartBit() == -1) {
            SizeTValue sizeTValue = this.computeSize(iLocation, iCType);
            return new SizeTValueAggregatorAdd().aggregate(iLocation, Arrays.asList(offset.getAddressOffset(), sizeTValue));
        }
        if (offset.getBitFieldSize() == 0) {
            return new SizeTValueInteger(offset.getAddressOffset().getInteger().add(BigInteger.ONE));
        }
        int n = offset.getStartBit() + offset.getBitFieldSize();
        int n2 = n / 8 + 1;
        return new SizeTValueInteger(offset.getAddressOffset().getInteger().add(BigInteger.valueOf(n2)));
    }

    public class Offset {
        private final SizeTValueInteger mAddressOffset;
        private final int mStartBit;
        private final int mBitsize;

        public Offset(SizeTValueInteger sizeTValueInteger, int n, int n2) {
            this.mAddressOffset = sizeTValueInteger;
            this.mStartBit = n;
            this.mBitsize = n2;
            assert (n == -1 && n2 == -1 || n >= 0 && n2 >= 0);
        }

        public Expression getAddressOffsetAsExpression(ILocation iLocation) {
            return this.mAddressOffset.asExpression(iLocation);
        }

        public SizeTValueInteger getAddressOffset() {
            return this.mAddressOffset;
        }

        public int getStartBit() {
            return this.mStartBit;
        }

        public int getBitFieldSize() {
            return this.mBitsize;
        }

        public boolean isBitfieldOffset() {
            return this.getStartBit() != -1;
        }

        public String toString() {
            if (!this.isBitfieldOffset()) {
                return String.valueOf(this.getAddressOffset()) + "bytes";
            }
            return String.valueOf(this.getAddressOffset()) + "bytes+bit" + this.getStartBit() + "to" + (this.getStartBit() + this.getBitFieldSize() - 1);
        }
    }

    private static interface SizeTValue {
        public Expression asExpression(ILocation var1);
    }

    private abstract class SizeTValueAggregator {
        private SizeTValueAggregator() {
        }

        public SizeTValue aggregate(ILocation iLocation, List<SizeTValue> list) {
            if (list.isEmpty()) {
                return new SizeTValueInteger(this.resultForZeroOperandCase());
            }
            LinkedList<SizeTValue> linkedList = new LinkedList<SizeTValue>(list);
            BigInteger bigInteger = null;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                SizeTValue sizeTValue = (SizeTValue)iterator.next();
                if (!(sizeTValue instanceof SizeTValueInteger)) continue;
                BigInteger bigInteger2 = ((SizeTValueInteger)sizeTValue).getInteger();
                bigInteger = bigInteger == null ? bigInteger2 : this.aggregateIntegers(bigInteger, bigInteger2);
                iterator.remove();
            }
            if (linkedList.isEmpty()) {
                return new SizeTValueInteger(bigInteger);
            }
            if (bigInteger != null) {
                linkedList.add(new SizeTValueInteger(bigInteger));
            }
            if (linkedList.size() == 1) {
                return linkedList.getFirst();
            }
            return this.aggregateExpressions(iLocation, linkedList);
        }

        private SizeTValue aggregateExpressions(ILocation iLocation, LinkedList<SizeTValue> linkedList) {
            assert (!linkedList.isEmpty()) : "at least one needed";
            SizeTValue sizeTValue = linkedList.removeFirst();
            Expression expression = sizeTValue.asExpression(iLocation);
            for (SizeTValue sizeTValue2 : linkedList) {
                Expression expression2 = sizeTValue2.asExpression(iLocation);
                expression = this.aggregateExpressions(iLocation, expression, expression2);
            }
            return new SizeTValueExpression(expression);
        }

        protected abstract Expression aggregateExpressions(ILocation var1, Expression var2, Expression var3);

        protected abstract BigInteger aggregateIntegers(BigInteger var1, BigInteger var2);

        protected abstract BigInteger resultForZeroOperandCase();
    }

    private class SizeTValueAggregatorAdd
    extends SizeTValueAggregator {
        private SizeTValueAggregatorAdd() {
        }

        @Override
        protected Expression aggregateExpressions(ILocation iLocation, Expression expression, Expression expression2) {
            return TypeSizeAndOffsetComputer.this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, expression, TypeSizeAndOffsetComputer.this.getSizeT(), expression2, TypeSizeAndOffsetComputer.this.getSizeT());
        }

        @Override
        protected BigInteger aggregateIntegers(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.add(bigInteger2);
        }

        @Override
        protected BigInteger resultForZeroOperandCase() {
            return BigInteger.ZERO;
        }
    }

    private class SizeTValueAggregatorMax
    extends SizeTValueAggregator {
        private SizeTValueAggregatorMax() {
        }

        @Override
        protected Expression aggregateExpressions(ILocation iLocation, Expression expression, Expression expression2) {
            Expression expression3 = TypeSizeAndOffsetComputer.this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, expression, TypeSizeAndOffsetComputer.this.getSizeT(), expression2, TypeSizeAndOffsetComputer.this.getSizeT());
            return ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression3, (Expression)expression, (Expression)expression2);
        }

        @Override
        protected BigInteger aggregateIntegers(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.max(bigInteger2);
        }

        @Override
        protected BigInteger resultForZeroOperandCase() {
            return BigInteger.ZERO;
        }
    }

    private class SizeTValueAggregatorMultiply
    extends SizeTValueAggregator {
        private SizeTValueAggregatorMultiply() {
        }

        @Override
        protected Expression aggregateExpressions(ILocation iLocation, Expression expression, Expression expression2) {
            return TypeSizeAndOffsetComputer.this.mExpressionTranslation.constructArithmeticExpression(iLocation, 1, expression, TypeSizeAndOffsetComputer.this.getSizeT(), expression2, TypeSizeAndOffsetComputer.this.getSizeT());
        }

        @Override
        protected BigInteger aggregateIntegers(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.multiply(bigInteger2);
        }

        @Override
        protected BigInteger resultForZeroOperandCase() {
            return BigInteger.ONE;
        }
    }

    private static class SizeTValueExpression
    implements SizeTValue {
        private final Expression mValue;

        public SizeTValueExpression(Expression expression) {
            this.mValue = expression;
        }

        @Override
        public Expression asExpression(ILocation iLocation) {
            return this.mValue;
        }

        public String toString() {
            return String.valueOf(this.mValue);
        }
    }

    class SizeTValueInteger
    implements SizeTValue {
        private final BigInteger mValue;

        public SizeTValueInteger(BigInteger bigInteger) {
            this.mValue = bigInteger;
        }

        @Override
        public Expression asExpression(ILocation iLocation) {
            return TypeSizeAndOffsetComputer.this.mTypeSizes.constructLiteralForIntegerType(iLocation, TypeSizeAndOffsetComputer.this.getSizeT(), this.mValue);
        }

        public BigInteger getInteger() {
            return this.mValue;
        }

        public String toString() {
            return String.valueOf(this.mValue);
        }
    }
}

