/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class LetTerm
extends Term {
    private final TermVariable[] mVariables;
    private final Term[] mValues;
    private final Term mSubterm;
    private final Sort mSort;

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term[] getValues() {
        return this.mValues;
    }

    public Term getSubTerm() {
        return this.mSubterm;
    }

    LetTerm(TermVariable[] termVariableArray, Term[] termArray, Term term, int n) {
        super(n);
        this.mVariables = termVariableArray;
        this.mValues = termArray;
        this.mSubterm = term;
        this.mSort = term.getSort();
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    public static final int hashLet(TermVariable[] termVariableArray, Term[] termArray, Term term) {
        return HashUtils.hashJenkins((int)HashUtils.hashJenkins((int)term.hashCode(), (Object[])termArray), (Object[])termVariableArray);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        arrayDeque.addLast(")");
        arrayDeque.addLast(this.getSubTerm());
        arrayDeque.addLast(")) ");
        TermVariable[] termVariableArray = this.getVariables();
        Term[] termArray = this.getValues();
        int n = termArray.length - 1;
        while (n > 0) {
            arrayDeque.addLast(termArray[n]);
            arrayDeque.addLast(") (" + termVariableArray[n].toString() + " ");
            --n;
        }
        arrayDeque.addLast(termArray[0]);
        arrayDeque.addLast("(let ((" + termVariableArray[0].toString() + " ");
    }
}

