/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;

public abstract class GeneralOperation<LETTER, STATE, CRSF extends IStateFactory<STATE>>
implements IOperation<LETTER, STATE, CRSF> {
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;

    public GeneralOperation(AutomataLibraryServices automataLibraryServices) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
    }

    protected final boolean isCancellationRequested() {
        return !this.mServices.getProgressAwareTimer().continueProcessing();
    }

    protected final void printStartMessage() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
    }

    protected final void printExitMessage() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    protected final void printStartCheckMessage() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
    }

    protected final void printExitCheckMessage() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        if (this.mLogger.isWarnEnabled()) {
            this.mLogger.warn((Object)("No result check for " + this.getOperationName() + " available yet."));
        }
        return true;
    }

    protected String generateGenericRunningTaskDescription() {
        return "applying " + this.getOperationName();
    }

    protected final void addGenericRunningTaskInfo(AutomataOperationCanceledException automataOperationCanceledException) {
        this.addRunningTaskInfo(automataOperationCanceledException, this.generateGenericRunningTaskDescription());
    }

    protected final void addRunningTaskInfo(AutomataOperationCanceledException automataOperationCanceledException, String string) {
        automataOperationCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
    }
}

