/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.nwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.DelayedGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.MultipleDataOption;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.INwaGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.NwaGameGraphGeneration;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import java.util.Collection;
import java.util.Set;

public final class DelayedNwaGameGraph<LETTER, STATE>
extends DelayedGameGraph<LETTER, STATE>
implements INwaGameGraph<LETTER, STATE> {
    private final NwaGameGraphGeneration<LETTER, STATE> mGeneration;
    private final IDoubleDeckerAutomaton<LETTER, STATE> mNwa;

    public DelayedNwaGameGraph(AutomataLibraryServices automataLibraryServices, IMergeStateFactory<STATE> iMergeStateFactory, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, Collection<Set<STATE>> collection) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMergeStateFactory, iProgressAwareTimer, iLogger, iDoubleDeckerAutomaton);
        INestedWordAutomaton iNestedWordAutomaton = this.getAutomaton();
        this.mNwa = iNestedWordAutomaton instanceof IDoubleDeckerAutomaton ? (IDoubleDeckerAutomaton)iNestedWordAutomaton : new RemoveUnreachable(automataLibraryServices, iNestedWordAutomaton).getResult();
        this.mGeneration = new NwaGameGraphGeneration<LETTER, STATE>(automataLibraryServices, this.getProgressTimer(), this.getLogger(), this.mNwa, this, SimulationOrMinimizationType.DELAYED, collection, true);
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph() throws AutomataOperationCanceledException {
        SimulationPerformance simulationPerformance = this.getSimulationPerformance();
        if (simulationPerformance != null) {
            simulationPerformance.startTimeMeasure(TimeMeasure.BUILD_RESULT);
        }
        INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton = this.mGeneration.generateAutomatonFromGraph(false);
        if (simulationPerformance != null) {
            simulationPerformance.stopTimeMeasure(TimeMeasure.BUILD_RESULT);
            simulationPerformance.addAllMeasures(this.mGeneration.getSimulationPerformance());
        }
        return iNestedWordAutomaton;
    }

    @Override
    public void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException {
        this.mGeneration.generateGameGraphFromAutomaton();
        SimulationPerformance simulationPerformance = this.mGeneration.getSimulationPerformance();
        this.setGraphBuildTime(simulationPerformance.getTimeMeasureResult(TimeMeasure.BUILD_GRAPH, MultipleDataOption.ADDITIVE));
    }

    @Override
    public DuplicatorVertex<LETTER, STATE> getDuplicatorVertex(STATE STATE, STATE STATE2, LETTER LETTER, boolean bl) {
        throw new UnsupportedOperationException("Use getDuplicatorVertex(q0, q1, a, bit, transType, summarizeEdge, sink) instead.");
    }

    @Override
    public SpoilerVertex<LETTER, STATE> getSpoilerVertex(STATE STATE, STATE STATE2, boolean bl) {
        throw new UnsupportedOperationException("Use getSpoilerVertex(q0, q1, a, bit, summarizeEdge, sink) instead.");
    }

    @Override
    public void undoRemovedReturnBridgesChanges() {
        this.undoChanges(this.mGeneration.getRemovedReturnBridgesChanges());
    }

    @Override
    public void verifyAutomatonValidity(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
    }
}

