/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DirectGameGraph<LETTER, STATE>
extends AGameGraph<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mBuechi;
    private long mGraphBuildTime;
    private final AutomataLibraryServices mServices;
    private final IMergeStateFactory<STATE> mStateFactory;

    public DirectGameGraph(AutomataLibraryServices automataLibraryServices, IMergeStateFactory<STATE> iMergeStateFactory, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMergeStateFactory, iProgressAwareTimer, iLogger, iNestedWordAutomaton);
        INestedWordAutomaton iNestedWordAutomaton2 = this.getAutomaton();
        this.verifyAutomatonValidity(iNestedWordAutomaton2);
        this.mServices = automataLibraryServices;
        this.mBuechi = iNestedWordAutomaton2;
        this.mStateFactory = iMergeStateFactory;
        this.mGraphBuildTime = 0L;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph() throws AutomataOperationCanceledException {
        Object object;
        Object object22;
        Object object32;
        SimulationPerformance simulationPerformance = this.getSimulationPerformance();
        if (simulationPerformance != null) {
            simulationPerformance.startTimeMeasure(TimeMeasure.BUILD_RESULT);
        }
        UnionFind unionFind = new UnionFind();
        for (Object object32 : this.mBuechi.getStates()) {
            unionFind.makeEquivalenceClass(object32);
        }
        object32 = new HashRelation();
        for (SpoilerVertex spoilerVertex : this.getSpoilerVertices()) {
            if (spoilerVertex.getPM(null, this.getGlobalInfinity()) < this.getGlobalInfinity()) {
                object22 = spoilerVertex.getQ0();
                Iterator<Object> iterator = spoilerVertex.getQ1();
                if (object22 != null && iterator != null) {
                    object32.addPair(object22, iterator);
                }
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.getLogger().debug((Object)"Stopped in generateBuchiAutomatonFromGraph/filling table");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        for (Object object4 : object32.getDomain()) {
            for (Object object22 : object32.getImage(object4)) {
                if (!object32.containsPair(object22, object4)) continue;
                unionFind.union(object4, object22);
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.getLogger().debug((Object)"Stopped in generateBuchiAutomatonFromGraph/marking table");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, this.mBuechi.getVpAlphabet(), this.mStateFactory);
        HashSet hashSet = new HashSet();
        for (Object object22 : this.mBuechi.getInitialStates()) {
            hashSet.add(unionFind.find(object22));
        }
        object22 = new HashMap(this.mBuechi.size());
        for (Iterator<Object> iterator : unionFind.getAllRepresentatives()) {
            boolean bl = hashSet.contains(iterator);
            boolean bl2 = this.mBuechi.isFinal(iterator);
            ImmutableSet immutableSet = unionFind.getEquivalenceClassMembers(iterator);
            object = this.mStateFactory.merge((Collection<STATE>)immutableSet);
            nestedWordAutomaton.addState(bl, bl2, object);
            Iterator iterator2 = immutableSet.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                object22.put(e, object);
            }
        }
        for (Iterator<Object> iterator : unionFind.getAllRepresentatives()) {
            Object v = object22.get(iterator);
            for (OutgoingInternalTransition outgoingInternalTransition : this.mBuechi.internalSuccessors(iterator)) {
                object = object22.get(outgoingInternalTransition.getSucc());
                nestedWordAutomaton.addInternalTransition(v, outgoingInternalTransition.getLetter(), object);
            }
        }
        if (simulationPerformance != null) {
            simulationPerformance.stopTimeMeasure(TimeMeasure.BUILD_RESULT);
            simulationPerformance.addTimeMeasureValue(TimeMeasure.BUILD_GRAPH, this.mGraphBuildTime);
        }
        if (this.getProgressTimer() != null && !this.getProgressTimer().continueProcessing()) {
            this.getLogger().debug((Object)"Stopped in generateBuchiAutomatonFromGraph/states added to result BA");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        return nestedWordAutomaton;
    }

    @Override
    public void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException {
        Object object;
        Object object222;
        long l = System.currentTimeMillis();
        for (Object object222 : this.mBuechi.getStates()) {
            for (STATE STATE : this.mBuechi.getStates()) {
                object = new SpoilerVertex(0, false, object222, STATE);
                this.addSpoilerVertex(object);
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.getLogger().debug((Object)"Stopped in generateGameGraphFromBuechi/calculating v1");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        for (Object object222 : this.mBuechi.getStates()) {
            for (STATE STATE : this.mBuechi.getStates()) {
                object = new HashSet<LETTER>(this.mBuechi.lettersInternalIncoming(object222));
                object.addAll(this.mBuechi.lettersInternal(STATE));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    STATE STATE2;
                    Object e = iterator.next();
                    DuplicatorVertex duplicatorVertex = new DuplicatorVertex(0, false, object222, STATE, e);
                    this.addDuplicatorVertex(duplicatorVertex);
                    for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.mBuechi.internalPredecessors(object222, e)) {
                        STATE2 = incomingInternalTransition.getPred();
                        if (this.mBuechi.isFinal(STATE2) && !this.mBuechi.isFinal(STATE)) continue;
                        this.addEdge(this.getSpoilerVertex(STATE2, STATE, false), duplicatorVertex);
                    }
                    for (OutgoingInternalTransition outgoingInternalTransition : this.mBuechi.internalSuccessors(STATE, e)) {
                        STATE2 = outgoingInternalTransition.getSucc();
                        if (this.mBuechi.isFinal(object222) && !this.mBuechi.isFinal(STATE2)) continue;
                        this.addEdge(duplicatorVertex, this.getSpoilerVertex(object222, STATE2, false));
                    }
                }
                if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
                this.getLogger().debug((Object)"Stopped in generateGameGraphFromBuechi/calculating v0 and edges");
                throw new AutomataOperationCanceledException(this.getClass());
            }
        }
        this.increaseGlobalInfinity();
        object222 = this.getLogger();
        if (object222.isDebugEnabled()) {
            object222.debug((Object)("Infinity is " + this.getGlobalInfinity()));
            object222.debug((Object)("Number of vertices in game graph: " + (this.getDuplicatorVertices().size() + this.getSpoilerVertices().size())));
            object222.debug((Object)("Number of vertices in v0: " + this.getDuplicatorVertices().size()));
            object222.debug((Object)("Number of vertices in v1: " + this.getSpoilerVertices().size()));
        }
        this.setGraphBuildTime(System.currentTimeMillis() - l);
    }

    protected void setGraphBuildTime(long l) {
        this.mGraphBuildTime = l;
    }
}

