/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ActionUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IcfgDuplicator {
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final BlockEncodingBacktranslator mBacktranslator;
    private final Map<IIcfgCallTransition<IcfgLocation>, IIcfgCallTransition<IcfgLocation>> mCallCache = new HashMap<IIcfgCallTransition<IcfgLocation>, IIcfgCallTransition<IcfgLocation>>();
    private Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> mOld2NewEdgeMap;
    private Map<IcfgLocation, IcfgLocation> mOld2NewLocationMap;

    public IcfgDuplicator(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BlockEncodingBacktranslator blockEncodingBacktranslator) {
        this.mLogger = iLogger;
        this.mManagedScript = Objects.requireNonNull(managedScript);
        this.mBacktranslator = blockEncodingBacktranslator;
    }

    public BasicIcfg<IcfgLocation> copy(IIcfg<?> iIcfg, String string, boolean bl) {
        Object object;
        this.mOld2NewLocationMap = new HashMap<IcfgLocation, IcfgLocation>();
        this.mOld2NewEdgeMap = new HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>>();
        BasicIcfg<IcfgLocation> basicIcfg = new BasicIcfg<IcfgLocation>(iIcfg.getIdentifier() + string, iIcfg.getCfgSmtToolkit(), IcfgLocation.class);
        ModelUtils.copyAnnotations(iIcfg, basicIcfg);
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg.getProcedureEntryNodes().values());
        HashSet<Pair> hashSet = new HashSet<Pair>();
        while (icfgLocationIterator.hasNext()) {
            object = icfgLocationIterator.next();
            String object2 = ((IcfgLocation)object).getProcedure();
            IcfgLocation icfgLocation = this.createLocCopy((IcfgLocation)object);
            boolean bl2 = iIcfg.getProcedureErrorNodes().get(object2) != null && iIcfg.getProcedureErrorNodes().get(object2).contains(object);
            basicIcfg.addLocation(icfgLocation, iIcfg.getInitialNodes().contains(object), bl2, ((IcfgLocation)object).equals(iIcfg.getProcedureEntryNodes().get(object2)), ((IcfgLocation)object).equals(iIcfg.getProcedureExitNodes().get(object2)), iIcfg.getLoopLocations().contains(object), iIcfg.getLocationsOfInterest().contains(object));
            this.mOld2NewLocationMap.put((IcfgLocation)object, icfgLocation);
        }
        assert (this.noEdges(basicIcfg)) : "Icfg contains edges but should not";
        object = basicIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
        for (Map.Entry entry : this.mOld2NewLocationMap.entrySet()) {
            IcfgLocation icfgLocation = (IcfgLocation)entry.getValue();
            for (IcfgEdge icfgEdge : ((IcfgLocation)entry.getKey()).getOutgoingEdges()) {
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    hashSet.add(new Pair((Object)icfgLocation, (Object)icfgEdge));
                    continue;
                }
                if (bl && icfgEdge instanceof IIcfgSummaryTransition && ((IIcfgSummaryTransition)((Object)icfgEdge)).calledProcedureHasImplementation()) continue;
                this.createEdgeCopy(icfgLocation, icfgEdge, (IcfgEdgeFactory)object);
            }
        }
        hashSet.stream().forEach(arg_0 -> this.lambda$0((IcfgEdgeFactory)object, arg_0));
        this.mBacktranslator.removeIntermediateMappings();
        return basicIcfg;
    }

    private IcfgLocation createLocCopy(IcfgLocation icfgLocation) {
        IcfgLocation icfgLocation2 = new IcfgLocation(icfgLocation.getDebugIdentifier(), icfgLocation.getProcedure());
        ModelUtils.copyAnnotations((IElement)icfgLocation, (IElement)icfgLocation2);
        this.mBacktranslator.mapLocations(icfgLocation2, icfgLocation);
        return icfgLocation2;
    }

    private boolean noEdges(IIcfg<IcfgLocation> iIcfg) {
        Set set = iIcfg.getProgramPoints().entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).map(Map.Entry::getValue).collect(Collectors.toSet());
        for (IcfgLocation icfgLocation : set) {
            if (icfgLocation.getOutgoingEdges().isEmpty() && icfgLocation.getIncomingEdges().isEmpty()) continue;
            this.mLogger.fatal((Object)("Location " + String.valueOf(icfgLocation) + " contains incoming or outgoing edges"));
            this.mLogger.fatal((Object)("Incoming: " + String.valueOf(icfgLocation.getIncomingEdges())));
            this.mLogger.fatal((Object)("Outgoing: " + String.valueOf(icfgLocation.getOutgoingEdges())));
            return false;
        }
        return true;
    }

    private IcfgEdge createEdgeCopy(IcfgLocation icfgLocation, IcfgEdge icfgEdge, IcfgEdgeFactory icfgEdgeFactory) {
        IcfgLocation icfgLocation2 = this.mOld2NewLocationMap.get(icfgEdge.getTarget());
        assert (icfgLocation2 != null);
        IcfgEdge icfgEdge2 = this.createUnconnectedCopy(icfgLocation, icfgLocation2, icfgEdge, icfgEdgeFactory);
        icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgEdge2);
        icfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgEdge2);
        ModelUtils.copyAnnotations((IElement)icfgEdge, (IElement)icfgEdge2);
        this.mBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)icfgEdge2, icfgEdge);
        this.mOld2NewEdgeMap.put(icfgEdge, icfgEdge2);
        return icfgEdge2;
    }

    private IcfgEdge createUnconnectedCopy(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgTransition<?> iIcfgTransition, IcfgEdgeFactory icfgEdgeFactory) {
        IcfgEdge icfgEdge;
        IAction iAction = ActionUtils.constructCopy(this.mManagedScript, iIcfgTransition);
        if (iIcfgTransition instanceof IIcfgInternalTransition) {
            UnmodifiableTransFormula unmodifiableTransFormula = iIcfgTransition instanceof IActionWithBranchEncoders ? TransFormulaBuilder.constructCopy(this.mManagedScript, ((IActionWithBranchEncoders)((Object)iIcfgTransition)).getTransitionFormulaWithBranchEncoders(), Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()) : iAction.getTransformula();
            icfgEdge = icfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, null, iAction.getTransformula(), unmodifiableTransFormula);
        } else if (iIcfgTransition instanceof IIcfgCallTransition) {
            icfgEdge = this.createCopyCall(icfgLocation, icfgLocation2, (IIcfgCallTransition)iIcfgTransition, iAction, icfgEdgeFactory);
        } else if (iIcfgTransition instanceof IIcfgReturnTransition) {
            IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)iIcfgTransition;
            Object t = iIcfgReturnTransition.getCorrespondingCall();
            IIcfgCallTransition iIcfgCallTransition = this.mCallCache.get(t);
            if (iIcfgCallTransition == null) {
                this.mLogger.warn((Object)("Creating raw copy for unreachable call because return is reachable in graph view: " + String.valueOf(t)));
                iIcfgCallTransition = (IIcfgCallTransition)((Object)this.createUnconnectedCopy(null, null, (IIcfgTransition<?>)t, icfgEdgeFactory));
            }
            IReturnAction iReturnAction = (IReturnAction)iAction;
            icfgEdge = icfgEdgeFactory.createReturnTransition(icfgLocation, icfgLocation2, iIcfgCallTransition, null, iReturnAction.getAssignmentOfReturn(), iReturnAction.getLocalVarsAssignmentOfCall());
        } else if (iIcfgTransition instanceof IIcfgForkTransitionThreadCurrent) {
            IForkActionThreadCurrent iForkActionThreadCurrent = (IForkActionThreadCurrent)iAction;
            icfgEdge = icfgEdgeFactory.createForkThreadCurrentTransition(icfgLocation, icfgLocation2, null, iForkActionThreadCurrent.getTransformula(), iForkActionThreadCurrent.getForkSmtArguments(), iForkActionThreadCurrent.getNameOfForkedProcedure());
        } else if (iIcfgTransition instanceof IIcfgJoinTransitionThreadCurrent) {
            IJoinActionThreadCurrent iJoinActionThreadCurrent = (IJoinActionThreadCurrent)iAction;
            icfgEdge = icfgEdgeFactory.createJoinThreadCurrentTransition(icfgLocation, icfgLocation2, null, iJoinActionThreadCurrent.getTransformula(), iJoinActionThreadCurrent.getJoinSmtArguments());
        } else {
            throw new UnsupportedOperationException("Unknown IcfgEdge subtype: " + String.valueOf(iIcfgTransition.getClass()));
        }
        return icfgEdge;
    }

    private IcfgEdge createCopyCall(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgCallTransition<IcfgLocation> iIcfgCallTransition, IAction iAction, IcfgEdgeFactory icfgEdgeFactory) {
        ICallAction iCallAction = (ICallAction)iAction;
        IcfgCallTransition icfgCallTransition = icfgEdgeFactory.createCallTransition(icfgLocation, icfgLocation2, null, iCallAction.getLocalVarsAssignment());
        this.mCallCache.put(iIcfgCallTransition, icfgCallTransition);
        return icfgCallTransition;
    }

    public Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> getOld2NewEdgeMapping() {
        return Collections.unmodifiableMap(this.mOld2NewEdgeMap);
    }

    public Map<IcfgLocation, IcfgLocation> getOld2NewLocationMapping() {
        return Collections.unmodifiableMap(this.mOld2NewLocationMap);
    }

    private /* synthetic */ void lambda$0(IcfgEdgeFactory icfgEdgeFactory, Pair pair) {
        IcfgEdge icfgEdge = this.createEdgeCopy((IcfgLocation)pair.getFirst(), (IcfgEdge)pair.getSecond(), icfgEdgeFactory);
    }
}

