/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import java.util.Set;

public class EventDecision
extends Decision<EventDecision> {
    private final String mEvent;

    public EventDecision(String string) {
        this.mEvent = string;
    }

    public static CDD create(Set<String> set, Set<String> set2) {
        CDD cDD = CDD.TRUE;
        for (String string : set) {
            cDD = cDD.and(EventDecision.create(string));
        }
        for (String string : set2) {
            cDD = cDD.and(EventDecision.createNeg(string));
        }
        return cDD;
    }

    public static CDD createNeg(String string) {
        return CDD.create(new EventDecision(string), CDD.FALSE_CHILDS);
    }

    public static CDD create(String string) {
        return CDD.create(new EventDecision(string), CDD.TRUE_CHILDS);
    }

    @Override
    public String toString(int n) {
        return n == 0 ? this.mEvent : "/" + this.mEvent;
    }

    @Override
    public String toSmtString(int n) {
        return this.toString(n);
    }

    @Override
    public String toTexString(int n) {
        return n == 0 ? this.mEvent : "\\neg" + this.mEvent;
    }

    @Override
    public String toBoogieString(int n) {
        return n == 0 ? this.mEvent : "!" + this.mEvent;
    }

    @Override
    public String toUppaalString(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toUppaalStringDOM(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVar() {
        return "";
    }

    public String getEvent() {
        return this.mEvent;
    }

    @Override
    public EventDecision prime(Set<String> set) {
        return this;
    }

    @Override
    public EventDecision unprime(Set<String> set) {
        return this;
    }

    @Override
    public int compareToSimilar(Decision<?> decision) {
        return this.mEvent.compareTo(((EventDecision)decision).mEvent);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mEvent == null ? 0 : this.mEvent.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventDecision eventDecision = (EventDecision)object;
        return !(this.mEvent == null ? eventDecision.mEvent != null : !this.mEvent.equals(eventDecision.mEvent));
    }
}

