/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeIncremental;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.HelpHopcroft;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.IMinimize;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaHopcroftParallel;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.Tuple;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.Interrupt;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class MinimizeDfaIncrementalParallel<LETTER, STATE>
extends AbstractMinimizeIncremental<LETTER, STATE>
implements IMinimize {
    public static final boolean HELP_HOPCROFT = true;
    private static final boolean OPTION_NEQ_TRANS = false;
    private static boolean sParallel = false;
    private int mSize;
    private int mHashCapNoTuples;
    private HashMap<STATE, Integer> mState2int;
    private ArrayList<STATE> mInt2state;
    private int[] mUnionFind;
    private SetList mEquiv;
    private SetList mPath;
    private Set<Tuple> mNeq;
    private ArrayDeque<StackElem> mStack;
    private double mRunTime;
    private LinkedBlockingQueue<Runnable> mTaskQueue;
    private MinimizeDfaHopcroftParallel<LETTER, STATE> mHopcroftAlgorithm;
    private boolean mInitialized = false;

    public MinimizeDfaIncrementalParallel(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, new Interrupt());
    }

    public MinimizeDfaIncrementalParallel(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Interrupt interrupt) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, interrupt);
        this.initialize();
        assert (this.mInt2state == null && this.mState2int == null);
        if (!sParallel) {
            this.executeAlgorithm();
        }
        assert (this.mInt2state != null && this.mState2int != null);
    }

    public MinimizeDfaIncrementalParallel(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Interrupt interrupt, ArrayList<STATE> arrayList, HashMap<STATE, Integer> hashMap) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, interrupt);
        this.mInt2state = arrayList;
        this.mState2int = hashMap;
        this.initialize();
        assert (this.mInt2state != null && this.mState2int != null);
        if (!sParallel) {
            this.executeAlgorithm();
        }
    }

    public double getRunTime() {
        return this.mRunTime;
    }

    public static void setParallelFlag(boolean bl) {
        sParallel = bl;
    }

    public Set<Tuple> getNeq() {
        return this.mNeq;
    }

    public boolean getInitialized() {
        return this.mInitialized;
    }

    private void executeAlgorithm() throws AutomataOperationCanceledException {
        this.printStartMessage();
        this.initialize();
        this.printExitMessage();
    }

    private void initialize() throws AutomataOperationCanceledException {
        assert (super.isDfa()) : "The input automaton is no DFA.";
        this.mSize = this.mOperand.size();
        assert (this.mSize >= 0) : "The automaton size must be nonnegative.";
        if (this.mSize <= 1) {
            this.mUnionFind = null;
            this.mNeq = null;
            this.mEquiv = null;
            this.mPath = null;
            this.mStack = null;
            this.mHashCapNoTuples = 0;
            this.directResultConstruction(this.mOperand);
        } else {
            this.mUnionFind = new int[this.mSize];
            int n = this.mSize * (this.mSize - 1) / 2;
            this.mHashCapNoTuples = n > 0 ? ((n = MinimizeDfaIncrementalParallel.computeHashCap(n)) > 0 ? n : Integer.MAX_VALUE) : Integer.MAX_VALUE;
            this.mNeq = Collections.synchronizedSet(new HashSet(this.mHashCapNoTuples));
            this.mEquiv = new SetList();
            this.mPath = new SetList();
            this.mStack = new ArrayDeque();
            if (this.mInt2state == null && this.mState2int == null) {
                this.mLogger.info((Object)"preprocessing");
                this.preprocess();
            }
            if (!sParallel) {
                this.minimize();
            }
        }
    }

    protected void minimizeParallel(LinkedBlockingQueue<Runnable> linkedBlockingQueue, MinimizeDfaHopcroftParallel<LETTER, STATE> minimizeDfaHopcroftParallel) throws AutomataOperationCanceledException {
        this.mLogger.info((Object)"Inc: started");
        this.mTaskQueue = linkedBlockingQueue;
        this.mHopcroftAlgorithm = minimizeDfaHopcroftParallel;
        this.findEquiv();
    }

    private void minimize() throws AutomataOperationCanceledException {
        this.findEquiv();
        this.constructResult();
    }

    private void preprocess() {
        this.mState2int = new HashMap(this.mSize);
        this.mInt2state = new ArrayList(this.mSize);
        int n = -1;
        for (Object STATE : this.mOperand.getStates()) {
            this.mInt2state.add(STATE);
            assert (this.mState2int.get(STATE) == null) : "The state is already in the map.";
            this.mState2int.put(STATE, ++n);
        }
        assert (this.mState2int.size() == this.mInt2state.size() && this.mState2int.size() == this.mSize) : "The mappings do not have the same size as the input automaton";
    }

    private void findEquiv() {
        this.initializeUnionFind();
        this.intializeTupleSet();
        int n = 0;
        while (n < this.mSize) {
            int n2 = n + 1;
            while (n2 < this.mSize) {
                if (this.mInterrupt != null && this.mInterrupt.getStatus()) {
                    return;
                }
                Tuple tuple = new Tuple(n, n2);
                if (!this.mNeq.contains(tuple) && this.find(n) != this.find(n2)) {
                    this.mEquiv.clean();
                    this.mPath.clean();
                    if (this.isPairEquiv(tuple)) {
                        var4_4 = this.mEquiv.iterator();
                        while (var4_4.hasNext()) {
                            this.union(var4_4.next());
                        }
                        if (sParallel) {
                            assert (this.mHopcroftAlgorithm != null);
                            try {
                                this.mTaskQueue.put(new HelpHopcroft(this, this.mHopcroftAlgorithm, tuple.mFirst, tuple.mSecond));
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    } else {
                        var4_4 = this.mPath.iterator();
                        while (var4_4.hasNext()) {
                            this.mNeq.add(var4_4.next());
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void intializeTupleSet() {
        int n = 0;
        while (n < this.mSize) {
            STATE STATE = this.mInt2state.get(n);
            boolean bl = this.mOperand.isFinal(STATE);
            int n2 = n + 1;
            while (n2 < this.mSize) {
                STATE STATE2 = this.mInt2state.get(n2);
                if (this.mOperand.isFinal(STATE2) ^ bl) {
                    this.mNeq.add(new Tuple(n, n2));
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean isPairEquiv(Tuple tuple) {
        assert (this.mStack.isEmpty()) : "The stack must be empty.";
        this.mStack.add(new StackElem(tuple));
        this.mEquiv.add(tuple);
        assert (!this.mStack.isEmpty()) : "The stack must not be empty.";
        do {
            StackElem stackElem = this.mStack.peekLast();
            Tuple tuple2 = stackElem.mTuple;
            if (stackElem.mExpanded) {
                this.mStack.pollLast();
                this.mPath.remove(tuple2);
                continue;
            }
            stackElem.mExpanded = true;
            if (this.mNeq.contains(tuple2)) {
                this.mStack.clear();
                return false;
            }
            if (this.mPath.contains(tuple2)) continue;
            this.mPath.add(tuple2);
            if (this.putSuccOnStack(tuple2)) continue;
            this.mStack.clear();
            return false;
        } while (!this.mStack.isEmpty());
        return true;
    }

    private boolean putSuccOnStack(Tuple tuple) {
        STATE STATE = this.mInt2state.get(tuple.mFirst);
        STATE STATE2 = this.mInt2state.get(tuple.mSecond);
        for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
            Tuple tuple2;
            Object LETTER = outgoingInternalTransition.getLetter();
            assert (this.mOperand.internalSuccessors(STATE2, LETTER) != null);
            Iterator iterator = this.mOperand.internalSuccessors(STATE2, LETTER).iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            int n = this.find(this.mState2int.get(iterator.next().getSucc()));
            int n2 = this.find(this.mState2int.get(outgoingInternalTransition.getSucc()));
            if (n2 == n) continue;
            if (n2 > n) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            if (this.mEquiv.contains(tuple2 = new Tuple(n2, n))) continue;
            this.mEquiv.add(tuple2);
            this.mStack.add(new StackElem(tuple2));
        }
        for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE2)) {
            if (this.mOperand.internalSuccessors(STATE, outgoingInternalTransition.getLetter()).iterator().hasNext()) continue;
            return false;
        }
        return true;
    }

    private void constructResult() {
        HashMap<Integer, Collection<STATE>> hashMap = this.computeMapState2Equiv();
        HashMap hashMap2 = new HashMap(MinimizeDfaIncrementalParallel.computeHashCap(hashMap.size()));
        assert (this.mOperand.getInitialStates().iterator().hasNext()) : "There is no initial state in the automaton.";
        int n = this.find(this.mState2int.get(this.mOperand.getInitialStates().iterator().next()));
        this.startResultConstruction();
        for (Map.Entry<Integer, Collection<STATE>> object : hashMap.entrySet()) {
            boolean bl;
            int n2 = object.getKey();
            Collection<STATE> collection = object.getValue();
            boolean bl2 = bl = n2 == n;
            assert (collection.iterator().hasNext()) : "There is no equivalent state in the collection.";
            boolean bl3 = this.mOperand.isFinal(collection.iterator().next());
            Object STATE = this.addState(bl, bl3, collection);
            hashMap2.put(n2, STATE);
        }
        for (Integer n3 : hashMap.keySet()) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(this.mInt2state.get(n3))) {
                this.addInternalTransition(hashMap2.get(n3), outgoingInternalTransition.getLetter(), hashMap2.get(this.find(this.mState2int.get(outgoingInternalTransition.getSucc()))));
            }
        }
        this.finishResultConstruction(null, false);
    }

    private HashMap<Integer, ? extends Collection<STATE>> computeMapState2Equiv() {
        HashMap<Integer, LinkedList<STATE>> hashMap = new HashMap<Integer, LinkedList<STATE>>(MinimizeDfaIncrementalParallel.computeHashCap(this.mSize));
        int n = this.mSize - 1;
        while (n >= 0) {
            int n2 = this.find(n);
            LinkedList<STATE> linkedList = (LinkedList<STATE>)hashMap.get(n2);
            if (linkedList == null) {
                linkedList = new LinkedList<STATE>();
                hashMap.put(n2, linkedList);
            }
            linkedList.add(this.mInt2state.get(n));
            --n;
        }
        return hashMap;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        if (sParallel) {
            this.constructResult();
        }
        return super.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeUnionFind() {
        int[] nArray = this.mUnionFind;
        synchronized (this.mUnionFind) {
            int n = this.mUnionFind.length - 1;
            while (n >= 0) {
                this.mUnionFind[n] = n;
                this.mInitialized = true;
                --n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int find(int n) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (true) {
            int[] nArray = this.mUnionFind;
            // MONITORENTER : this.mUnionFind
            int n2 = this.mUnionFind[n];
            // MONITOREXIT : nArray
            if (n == n2) {
                nArray = this.mUnionFind;
                // MONITORENTER : this.mUnionFind
                Iterator iterator = linkedList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        // MONITOREXIT : nArray
                        return n2;
                    }
                    int n3 = (Integer)iterator.next();
                    this.mUnionFind[n3] = n2;
                }
            }
            linkedList.add(n);
            n = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void union(Tuple tuple) {
        int[] nArray = this.mUnionFind;
        synchronized (this.mUnionFind) {
            this.mUnionFind[tuple.mSecond] = this.find(tuple.mFirst);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final class SetList {
        private HashMap<Tuple, de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode> mMap;
        private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.DoublyLinkedList mList;
        private boolean mIsInitialized = false;

        void add(Tuple tuple) {
            assert (!this.mMap.containsKey(tuple)) : "Elements should not be contained twice.";
            this.mMap.put(tuple, (de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode)this.mList.add(tuple));
        }

        void remove(Tuple tuple) {
            assert (this.mMap.containsKey(tuple)) : "Only elements contained should be removed.";
            this.mList.remove((ListNode)this.mMap.remove(tuple));
        }

        boolean contains(Tuple tuple) {
            return this.mMap.containsKey(tuple);
        }

        Iterator<Tuple> iterator() {
            return this.mList.iterator(this.mMap.size());
        }

        void clean() {
            if (this.mIsInitialized) {
                Iterator<Tuple> iterator = this.mList.iterator(this.mMap.size());
                while (iterator.hasNext()) {
                    Tuple tuple = iterator.next();
                    assert (this.mMap.containsKey(tuple)) : "The element was not in the map: " + tuple.toString();
                    this.mMap.remove(tuple);
                }
                assert (this.mMap.isEmpty()) : "There are elements left in the map after cleaning.";
            } else {
                this.mIsInitialized = true;
                this.mMap = new HashMap(MinimizeDfaIncrementalParallel.this.mHashCapNoTuples);
            }
            this.mList = new DoublyLinkedList();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(this.mMap);
            stringBuilder.append(", ");
            stringBuilder.append(this.mList);
            stringBuilder.append(", ");
            stringBuilder.append(this.mIsInitialized);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private final class DoublyLinkedList {
            private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode mFirst = null;
            private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode mLast = null;

            de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode add(Tuple tuple) {
                assert (tuple != null) : "null should not be inserted in the list.";
                if (this.mLast == null) {
                    assert (this.mFirst == null) : "The last list element is null unexpectedly.";
                    this.mFirst.mPrev = this.mFirst = new ListNode(SetList.this, tuple, null, null);
                    this.mFirst.mNext = this.mFirst;
                    this.mLast = this.mFirst;
                } else {
                    assert (this.mFirst != null) : "The first list element is null unexpectedly.";
                    de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode listNode = this.mLast;
                    listNode.mNext = this.mLast = new ListNode(SetList.this, tuple, (ListNode)listNode, (ListNode)this.mFirst);
                    this.mFirst.mPrev = this.mLast;
                }
                return this.mLast;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            void remove(ListNode listNode) {
                assert (listNode != null) : "null cannot not be removed from the list.";
                if (listNode.mNext == listNode) {
                    this.mFirst = null;
                    this.mLast = null;
                } else {
                    de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode listNode2;
                    de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode listNode3 = listNode.mPrev;
                    listNode3.mNext = listNode2 = listNode.mNext;
                    listNode2.mPrev = listNode3;
                    if (listNode == this.mFirst) {
                        this.mFirst = listNode2;
                        assert (listNode != this.mLast) : "The node must not be first and last element.";
                    } else if (listNode == this.mLast) {
                        this.mLast = listNode3;
                    }
                }
            }

            Iterator<Tuple> iterator(int n) {
                return new Iterator<Tuple>(n){
                    private int mItSize;
                    private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode mItNext;
                    {
                        this.mItSize = n;
                        this.mItNext = DoublyLinkedList.this.mLast;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mItSize > 0;
                    }

                    @Override
                    public Tuple next() {
                        if (!$assertionsDisabled && this.mItSize <= 0) {
                            throw new AssertionError((Object)"The next method must not be called when finished.");
                        }
                        --this.mItSize;
                        if (!$assertionsDisabled && this.mItNext == null) {
                            throw new AssertionError((Object)"An empty list should not be asked for the next element.");
                        }
                        this.mItNext = this.mItNext.mNext;
                        if (!$assertionsDisabled && this.mItNext == null) {
                            throw new AssertionError((Object)"An empty list should not be asked for the next element.");
                        }
                        return this.mItNext.mTuple;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal is not supported.");
                    }
                };
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{");
                if (this.mFirst != null) {
                    stringBuilder.append(this.mFirst.toString());
                    de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode listNode = this.mFirst.mNext;
                    while (listNode != this.mFirst) {
                        stringBuilder.append(", ");
                        stringBuilder.append(listNode.toString());
                        listNode = listNode.mNext;
                    }
                }
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
        }

        private static final class ListNode {
            private final Tuple mTuple;
            private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode mNext;
            private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode mPrev;
            final /* synthetic */ SetList this$1;

            public ListNode(Tuple tuple, de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode listNode, de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel$SetList.ListNode listNode2) {
                this.this$1 = var1_1;
                this.mTuple = tuple;
                this.mPrev = listNode;
                this.mNext = listNode2;
            }

            public String toString() {
                return this.mTuple.toString();
            }
        }
    }

    private static class StackElem {
        private final Tuple mTuple;
        private boolean mExpanded;

        public StackElem(Tuple tuple) {
            this.mTuple = tuple;
            this.mExpanded = false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(this.mTuple);
            stringBuilder.append(", ");
            stringBuilder.append(this.mExpanded);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

