/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStore;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStoreFactory;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MayAlias;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySegment;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceException;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceUtils;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySlicer;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBase;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBaseIntLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBaseVariable;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AliasAnalysis {
    private final AddressStoreFactory mAsfac;
    private final Set<PointerBase> mWriteAddresses;
    private final Set<PointerBase> mAccessAddresses;
    private final Map<String, Procedure> mProcedureToImplementation;
    private Procedure mCurrentProcedure;
    private final HashRelation<String, String> mReverseCallgraph = new HashRelation();
    private final HashRelation<String, PointerBase> mProcedureToWritePointers = new HashRelation();

    public AliasAnalysis(AddressStoreFactory addressStoreFactory, Map<String, Procedure> map) {
        this.mAsfac = addressStoreFactory;
        this.mWriteAddresses = new HashSet<PointerBase>();
        this.mAccessAddresses = new HashSet<PointerBase>();
        this.mProcedureToImplementation = map;
    }

    public Set<PointerBase> getWriteAddresses() {
        return this.mWriteAddresses;
    }

    public Set<PointerBase> getAccessAddresses() {
        return this.mAccessAddresses;
    }

    public HashRelation<String, String> getReverseCallgraph() {
        return this.mReverseCallgraph;
    }

    public HashRelation<String, PointerBase> getProcedureToWritePointers() {
        return this.mProcedureToWritePointers;
    }

    public MayAlias aliasAnalysis(Unit unit) {
        MayAlias mayAlias = new MayAlias();
        Declaration[] declarationArray = unit.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray[n2];
            if (declaration instanceof Procedure) {
                var7_7 = (Procedure)declaration;
                if (var7_7.getBody() != null && !MemorySlicer.isUltimateMemoryReadWriteProcedureWithImplementation(var7_7)) {
                    this.mCurrentProcedure = var7_7;
                    this.processBody(mayAlias, var7_7.getBody());
                }
            } else if (declaration instanceof Axiom) {
                var7_7 = (Axiom)declaration;
                this.analyzeExpression(mayAlias, var7_7.getFormula());
            }
            ++n2;
        }
        return mayAlias;
    }

    private void processBody(MayAlias mayAlias, Body body) {
        this.processStatementList(mayAlias, body.getBlock());
    }

    private void processStatementList(MayAlias mayAlias, Statement[] statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement;
            Statement statement2 = statementArray2[n2];
            Objects.requireNonNull(statement2);
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GotoStatement.class, Label.class, HavocStatement.class, ReturnStatement.class, BreakStatement.class, CallStatement.class, AssignmentStatement.class, AssumeStatement.class, AssertStatement.class, IfStatement.class, WhileStatement.class, ForkStatement.class, JoinStatement.class, AtomicStatement.class}, (Object)statement, 0)) {
                case 0: {
                    GotoStatement gotoStatement = (GotoStatement)statement;
                    break;
                }
                case 1: {
                    Label label = (Label)statement;
                    break;
                }
                case 2: {
                    HavocStatement havocStatement = (HavocStatement)statement;
                    break;
                }
                case 3: {
                    ReturnStatement returnStatement = (ReturnStatement)statement;
                    break;
                }
                case 4: {
                    BreakStatement breakStatement = (BreakStatement)statement;
                    break;
                }
                case 5: {
                    CallStatement callStatement = (CallStatement)statement;
                    this.processCallStatement(mayAlias, callStatement);
                    break;
                }
                case 6: {
                    AssignmentStatement assignmentStatement = (AssignmentStatement)statement;
                    this.processAssignmentStatement(mayAlias, assignmentStatement);
                    break;
                }
                case 7: {
                    AssumeStatement assumeStatement = (AssumeStatement)statement;
                    this.processAssumeStatement(mayAlias, assumeStatement);
                    break;
                }
                case 8: {
                    AssertStatement assertStatement = (AssertStatement)statement;
                    this.processAssertStatement(mayAlias, assertStatement);
                    break;
                }
                case 9: {
                    IfStatement ifStatement = (IfStatement)statement;
                    this.analyzeExpression(mayAlias, ifStatement.getCondition());
                    this.processStatementList(mayAlias, ifStatement.getThenPart());
                    this.processStatementList(mayAlias, ifStatement.getElsePart());
                    break;
                }
                case 10: {
                    WhileStatement whileStatement = (WhileStatement)statement;
                    this.analyzeExpression(mayAlias, whileStatement.getCondition());
                    this.processStatementList(mayAlias, whileStatement.getBody());
                    break;
                }
                case 11: {
                    ForkStatement forkStatement = (ForkStatement)statement;
                    this.processForkStatement(mayAlias, forkStatement);
                    break;
                }
                case 12: {
                    JoinStatement joinStatement = (JoinStatement)statement;
                    this.processJoinStatement(mayAlias, joinStatement);
                    break;
                }
                case 13: {
                    AtomicStatement atomicStatement = (AtomicStatement)statement;
                    this.processStatementList(mayAlias, atomicStatement.getBody());
                    break;
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
            ++n2;
        }
    }

    private void processJoinStatement(MayAlias mayAlias, JoinStatement joinStatement) {
        Object object;
        Procedure procedure = joinStatement.getThreadID();
        int n = ((Expression[])procedure).length;
        int n2 = 0;
        while (n2 < n) {
            object = procedure[n2];
            this.analyzeExpression(mayAlias, (Expression)object);
            ++n2;
        }
        if (joinStatement.getLhs().length != 0 && AliasAnalysis.isPointerType(joinStatement.getLhs()[0].getType())) {
            object = this.extractPointerBaseFromVariableLhs(this.mAsfac, joinStatement.getLhs()[0]);
            mayAlias.addPointerBase(this.mAsfac, (PointerBase)object);
            for (Map.Entry<String, Procedure> entry : this.mProcedureToImplementation.entrySet()) {
                VarList varList;
                procedure = entry.getValue();
                VarList[] varListArray = procedure.getOutParams();
                if (varListArray.length != 1 || !AliasAnalysis.isPointerType((varList = varListArray[0]).getType().getBoogieType())) continue;
                DeclarationInformation.StorageClass storageClass = procedure.getSpecification() == null ? DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM : DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM;
                PointerBase pointerBase = AliasAnalysis.extractPointerBaseFromVarlist(this.mAsfac, varList, new DeclarationInformation(storageClass, procedure.getIdentifier()));
                mayAlias.reportEquivalence(this.mAsfac, (AddressStore)object, pointerBase);
            }
        }
    }

    private void processForkStatement(MayAlias mayAlias, ForkStatement forkStatement) {
        Expression expression;
        DeclarationInformation.StorageClass storageClass = forkStatement.getArguments();
        int n = ((Expression[])storageClass).length;
        int n2 = 0;
        while (n2 < n) {
            expression = storageClass[n2];
            this.analyzeExpression(mayAlias, expression);
            ++n2;
        }
        expression = this.mProcedureToImplementation.get(forkStatement.getProcedureName());
        assert (forkStatement.getArguments().length == expression.getInParams().length);
        n2 = 0;
        while (n2 < forkStatement.getArguments().length) {
            Expression expression2 = forkStatement.getArguments()[n2];
            if (AliasAnalysis.isPointerType(expression2.getType())) {
                storageClass = expression.getSpecification() == null ? DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM : DeclarationInformation.StorageClass.PROC_FUNC_INPARAM;
                PointerBase pointerBase = AliasAnalysis.extractPointerBaseFromVarlist(this.mAsfac, expression.getInParams()[n2], new DeclarationInformation(storageClass, expression.getIdentifier()));
                List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, expression2);
                for (PointerBase pointerBase2 : list) {
                    mayAlias.reportEquivalence(this.mAsfac, pointerBase2, pointerBase);
                }
            }
            ++n2;
        }
    }

    private void processAssertStatement(MayAlias mayAlias, AssertStatement assertStatement) {
        this.analyzeExpression(mayAlias, assertStatement.getFormula());
    }

    private void processAssumeStatement(MayAlias mayAlias, AssumeStatement assumeStatement) {
        this.analyzeExpression(mayAlias, assumeStatement.getFormula());
    }

    private void analyzeExpression(MayAlias mayAlias, Expression expression) {
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(mayAlias);
        expressionAnalyzer.processExpression(expression);
    }

    private void processAssignmentStatement(MayAlias mayAlias, AssignmentStatement assignmentStatement) {
        FunctionApplication functionApplication;
        if (assignmentStatement.getRhs()[0] instanceof FunctionApplication && ((functionApplication = (FunctionApplication)assignmentStatement.getRhs()[0]).getIdentifier().equals("~initToZeroAtPointerBaseAddress~int") || functionApplication.getIdentifier().equals("~initToZeroAtPointerBaseAddress~$Pointer$"))) {
            PointerBase pointerBase = AliasAnalysis.extractPointerBaseFromBase(this.mAsfac, functionApplication.getArguments()[1]);
            mayAlias.addPointerBase(this.mAsfac, pointerBase);
            this.mAccessAddresses.add(pointerBase);
            this.mWriteAddresses.add(pointerBase);
            this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase);
            return;
        }
        functionApplication = assignmentStatement.getLhs();
        int n = 0;
        while (n < ((FunctionApplication)functionApplication).length) {
            if (functionApplication[n] instanceof VariableLHS) {
                var5_6 = (VariableLHS)functionApplication[n];
                if (AliasAnalysis.isPointerType(var5_6.getType())) {
                    var6_7 = this.extractPointerBaseFromVariableLhs(this.mAsfac, var5_6);
                    var7_8 = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, assignmentStatement.getRhs()[n]);
                    for (PointerBase pointerBase : var7_8) {
                        mayAlias.reportEquivalence(this.mAsfac, (AddressStore)var6_7, pointerBase);
                    }
                } else if (MemorySliceUtils.containsMemoryArrays((BoogieASTNode)var5_6)) {
                    throw new MemorySliceException("Unsupported: Memory array in LHS");
                }
            } else if (functionApplication[n] instanceof StructLHS) {
                var5_6 = (StructLHS)functionApplication[n];
                if (MemorySliceUtils.containsMemoryArrays((BoogieASTNode)var5_6)) {
                    throw new MemorySliceException("Unsupported: Memory array in LHS");
                }
                if (AliasAnalysis.isPointerType(var5_6.getType())) {
                    var6_7 = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, assignmentStatement.getRhs()[n]);
                    Iterator iterator = var6_7.iterator();
                    while (iterator.hasNext()) {
                        var7_8 = (PointerBase)iterator.next();
                        mayAlias.reportEquivalence(this.mAsfac, this.mAsfac.getStruct(), (AddressStore)((Object)var7_8));
                    }
                }
            } else if (functionApplication[n] instanceof ArrayLHS) {
                var5_6 = (ArrayLHS)functionApplication[n];
                var6_7 = var5_6.getArray();
                if (MemorySliceUtils.isPointerArray((LeftHandSide)var6_7)) {
                    assert (var5_6.getIndices().length == 1);
                    var7_8 = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, var5_6.getIndices()[0]);
                    List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, assignmentStatement.getRhs()[n]);
                    for (PointerBase pointerBase : var7_8) {
                        mayAlias.addPointerBase(this.mAsfac, pointerBase);
                        this.mAccessAddresses.add(pointerBase);
                        this.mWriteAddresses.add(pointerBase);
                        this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase);
                        MemorySegment memorySegment = this.mAsfac.getMemorySegment(pointerBase);
                        for (PointerBase pointerBase2 : list) {
                            mayAlias.reportEquivalence(this.mAsfac, memorySegment, pointerBase2);
                        }
                    }
                } else if (MemorySliceUtils.isIntArray((LeftHandSide)var6_7) || MemorySliceUtils.isRealArray((LeftHandSide)var6_7)) {
                    assert (var5_6.getIndices().length == 1);
                    var7_8 = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, var5_6.getIndices()[0]);
                    for (PointerBase pointerBase : var7_8) {
                        mayAlias.addPointerBase(this.mAsfac, pointerBase);
                        this.mAccessAddresses.add(pointerBase);
                        this.mWriteAddresses.add(pointerBase);
                        this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase);
                    }
                } else {
                    if (MemorySliceUtils.containsMemoryArrays((BoogieASTNode)var6_7)) {
                        throw new MemorySliceException("Unsupported: Memory array in LHS");
                    }
                    if (AliasAnalysis.isPointerType(var5_6.getType())) {
                        var7_8 = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, assignmentStatement.getRhs()[n]);
                        for (PointerBase pointerBase : var7_8) {
                            mayAlias.reportEquivalence(this.mAsfac, this.mAsfac.getArray(), pointerBase);
                        }
                    }
                }
                if (MemorySliceUtils.containsMemoryArrays((BoogieASTNode)assignmentStatement.getRhs()[n])) {
                    throw new MemorySliceException("Unsupported: Memory array in RHS");
                }
            } else {
                throw new MemorySliceException("LHS is " + String.valueOf(functionApplication[n].getClass()));
            }
            ++n;
        }
    }

    public static int getIndexOfFirstMatch(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static Expression unzipStructAccess(Expression expression) {
        if (expression instanceof StructAccessExpression) {
            StructConstructor structConstructor;
            int n;
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression;
            String string = structAccessExpression.getField();
            Expression expression2 = structAccessExpression.getStruct();
            if (expression2 instanceof StructConstructor && (n = AliasAnalysis.getIndexOfFirstMatch((structConstructor = (StructConstructor)expression2).getFieldIdentifiers(), string)) != -1) {
                return AliasAnalysis.unzipStructAccess(structConstructor.getFieldValues()[n]);
            }
        }
        return expression;
    }

    public static List<PointerBase> extractPointerBasesFromPointer(AddressStoreFactory addressStoreFactory, Expression expression) {
        Expression expression2 = AliasAnalysis.unzipStructAccess(expression);
        assert (AliasAnalysis.isPointerType(expression2.getType()));
        if (expression2 instanceof IfThenElseExpression) {
            IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression2;
            List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(addressStoreFactory, ifThenElseExpression.getThenPart());
            List<PointerBase> list2 = AliasAnalysis.extractPointerBasesFromPointer(addressStoreFactory, ifThenElseExpression.getElsePart());
            ArrayList<PointerBase> arrayList = new ArrayList<PointerBase>(list);
            arrayList.addAll(list2);
            return arrayList;
        }
        return Collections.singletonList(AliasAnalysis.extractPointerBaseFromPointer(addressStoreFactory, expression2));
    }

    public static PointerBase extractPointerBaseFromPointer(AddressStoreFactory addressStoreFactory, Expression expression) {
        Expression expression2 = AliasAnalysis.unzipStructAccess(expression);
        assert (AliasAnalysis.isPointerType(expression2.getType()));
        if (expression2 instanceof StructConstructor) {
            StructConstructor structConstructor = (StructConstructor)expression2;
            if (!structConstructor.getFieldIdentifiers()[0].equals("base")) {
                throw new MemorySliceException("Not pointer");
            }
            return AliasAnalysis.extractPointerBaseFromBase(addressStoreFactory, structConstructor.getFieldValues()[0]);
        }
        if (expression2 instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression2;
            return addressStoreFactory.getPointerBase(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation());
        }
        if (expression2 instanceof StructAccessExpression) {
            return addressStoreFactory.getStruct();
        }
        if (expression2 instanceof ArrayAccessExpression) {
            return addressStoreFactory.getArray();
        }
        throw new MemorySliceException("unknown PointerBase " + String.valueOf(expression2));
    }

    public static PointerBase extractPointerBaseFromBase(AddressStoreFactory addressStoreFactory, Expression expression) {
        assert (expression.getType() instanceof BoogiePrimitiveType);
        if (expression instanceof IntegerLiteral) {
            BigInteger bigInteger = new BigInteger(((IntegerLiteral)expression).getValue());
            return addressStoreFactory.getPointerBase(bigInteger);
        }
        if (expression instanceof BitvecLiteral) {
            BigInteger bigInteger = new BigInteger(((BitvecLiteral)expression).getValue());
            return addressStoreFactory.getPointerBase(bigInteger);
        }
        if (expression instanceof StructAccessExpression) {
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression;
            assert (structAccessExpression.getField().equals("base"));
            return AliasAnalysis.extractPointerBaseFromPointer(addressStoreFactory, structAccessExpression.getStruct());
        }
        throw new MemorySliceException("unknown PointerBase " + String.valueOf(expression));
    }

    public static PointerBase extractPointerBaseFromVarlist(AddressStoreFactory addressStoreFactory, VarList varList, DeclarationInformation declarationInformation) {
        assert (AliasAnalysis.isPointerType(varList.getType().getBoogieType()));
        assert (varList.getIdentifiers().length == 1);
        return addressStoreFactory.getPointerBase(varList.getIdentifiers()[0], declarationInformation);
    }

    private static boolean isPointerType(IBoogieType iBoogieType) {
        Object object = iBoogieType instanceof BoogieConstructedType ? ((BoogieConstructedType)iBoogieType).getUnderlyingType() : iBoogieType;
        if (object instanceof BoogieConstructedType) {
            BoogieConstructedType boogieConstructedType = (BoogieConstructedType)iBoogieType;
            return boogieConstructedType.getConstr().getName().equals("$Pointer$");
        }
        if (object instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)object;
            if (boogieStructType.getFieldCount() == 2 && boogieStructType.getFieldIds()[0].equals("base") && boogieStructType.getFieldIds()[1].equals("offset")) {
                return true;
            }
            if (boogieStructType.getFieldCount() == 1 && boogieStructType.getFieldIds()[0].equals("base")) {
                return true;
            }
        }
        return false;
    }

    private void processCallStatement(MayAlias mayAlias, CallStatement callStatement) {
        block23: {
            Object object;
            PointerBase pointerBase;
            DeclarationInformation.StorageClass storageClass;
            Expression expression;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block22: {
                                                this.mReverseCallgraph.addPair((Object)callStatement.getMethodName(), (Object)this.mCurrentProcedure.getIdentifier());
                                                if (!callStatement.getMethodName().equals("#Ultimate.allocInit")) break block22;
                                                assert (callStatement.getArguments().length == 2);
                                                Expression expression2 = callStatement.getArguments()[1];
                                                PointerBase pointerBase2 = AliasAnalysis.extractPointerBaseFromBase(this.mAsfac, expression2);
                                                mayAlias.addPointerBase(this.mAsfac, pointerBase2);
                                                break block23;
                                            }
                                            if (!callStatement.getMethodName().equals("#Ultimate.allocOnHeap") && !callStatement.getMethodName().equals("#Ultimate.allocOnStack")) break block24;
                                            assert (callStatement.getLhs().length == 1);
                                            PointerBase pointerBase3 = this.extractPointerBaseFromVariableLhs(this.mAsfac, callStatement.getLhs()[0]);
                                            mayAlias.addPointerBase(this.mAsfac, pointerBase3);
                                            break block23;
                                        }
                                        if (!callStatement.getMethodName().equals("write~$Pointer$") && !callStatement.getMethodName().equals("write~unchecked~$Pointer$") && !callStatement.getMethodName().startsWith("write~init~$Pointer$")) break block25;
                                        assert (callStatement.getArguments().length == 3);
                                        Expression expression3 = callStatement.getArguments()[0];
                                        Expression expression4 = callStatement.getArguments()[1];
                                        List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, expression3);
                                        List<PointerBase> list2 = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, expression4);
                                        for (PointerBase pointerBase4 : list2) {
                                            this.mAccessAddresses.add(pointerBase4);
                                            this.mWriteAddresses.add(pointerBase4);
                                            this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase4);
                                            mayAlias.addPointerBase(this.mAsfac, pointerBase4);
                                            MemorySegment memorySegment = this.mAsfac.getMemorySegment(pointerBase4);
                                            for (PointerBase pointerBase5 : list) {
                                                mayAlias.reportEquivalence(this.mAsfac, memorySegment, pointerBase5);
                                            }
                                        }
                                        break block23;
                                    }
                                    if (!callStatement.getMethodName().startsWith("read~$Pointer$") && !callStatement.getMethodName().startsWith("read~unchecked~$Pointer$")) break block26;
                                    assert (callStatement.getArguments().length == 2);
                                    assert (callStatement.getLhs().length == 1);
                                    Expression expression5 = callStatement.getArguments()[0];
                                    List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, expression5);
                                    PointerBase pointerBase6 = this.extractPointerBaseFromVariableLhs(this.mAsfac, callStatement.getLhs()[0]);
                                    for (PointerBase pointerBase7 : list) {
                                        mayAlias.addPointerBase(this.mAsfac, pointerBase7);
                                        MemorySegment memorySegment = this.mAsfac.getMemorySegment(pointerBase7);
                                        mayAlias.reportEquivalence(this.mAsfac, pointerBase6, memorySegment);
                                        this.mAccessAddresses.add(pointerBase7);
                                    }
                                    break block23;
                                }
                                if (!callStatement.getMethodName().startsWith("write~init~int") && !callStatement.getMethodName().startsWith("write~int") && !callStatement.getMethodName().startsWith("write~unchecked~int") && !callStatement.getMethodName().startsWith("write~init~real") && !callStatement.getMethodName().startsWith("write~real") && !callStatement.getMethodName().startsWith("write~unchecked~real")) break block27;
                                Expression expression6 = callStatement.getArguments()[1];
                                List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, expression6);
                                for (PointerBase pointerBase8 : list) {
                                    mayAlias.addPointerBase(this.mAsfac, pointerBase8);
                                    this.mAccessAddresses.add(pointerBase8);
                                    this.mWriteAddresses.add(pointerBase8);
                                    this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase8);
                                }
                                break block23;
                            }
                            if (!callStatement.getMethodName().startsWith("read~int") && !callStatement.getMethodName().startsWith("read~unchecked~int") && !callStatement.getMethodName().startsWith("read~real") && !callStatement.getMethodName().startsWith("read~unchecked~real")) break block28;
                            Expression expression7 = callStatement.getArguments()[0];
                            List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, expression7);
                            for (PointerBase pointerBase9 : list) {
                                mayAlias.addPointerBase(this.mAsfac, pointerBase9);
                                this.mAccessAddresses.add(pointerBase9);
                            }
                            break block23;
                        }
                        if (!callStatement.getMethodName().equals("#Ultimate.C_memset")) break block29;
                        assert (callStatement.getArguments().length == 3);
                        Expression expression8 = callStatement.getArguments()[0];
                        PointerBase pointerBase10 = AliasAnalysis.extractPointerBaseFromPointer(this.mAsfac, expression8);
                        this.mAccessAddresses.add(pointerBase10);
                        this.mWriteAddresses.add(pointerBase10);
                        this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase10);
                        assert (callStatement.getLhs().length == 1);
                        PointerBase pointerBase11 = this.extractPointerBaseFromVariableLhs(this.mAsfac, callStatement.getLhs()[0]);
                        mayAlias.reportEquivalence(this.mAsfac, pointerBase10, pointerBase11);
                        break block23;
                    }
                    if (!callStatement.getMethodName().equals("#Ultimate.C_memcpy") && !callStatement.getMethodName().equals("#Ultimate.C_memmove") && !callStatement.getMethodName().equals("#Ultimate.C_strcpy")) break block30;
                    assert (callStatement.getArguments().length == 3 || callStatement.getArguments().length == 2);
                    PointerBase pointerBase12 = AliasAnalysis.extractPointerBaseFromPointer(this.mAsfac, callStatement.getArguments()[0]);
                    PointerBase pointerBase13 = AliasAnalysis.extractPointerBaseFromPointer(this.mAsfac, callStatement.getArguments()[1]);
                    this.mAccessAddresses.add(pointerBase12);
                    this.mAccessAddresses.add(pointerBase13);
                    this.mWriteAddresses.add(pointerBase12);
                    this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase12);
                    mayAlias.reportEquivalence(this.mAsfac, pointerBase12, pointerBase13);
                    assert (callStatement.getLhs().length == 1);
                    PointerBase pointerBase14 = this.extractPointerBaseFromVariableLhs(this.mAsfac, callStatement.getLhs()[0]);
                    mayAlias.reportEquivalence(this.mAsfac, pointerBase12, pointerBase14);
                    break block23;
                }
                if (!callStatement.getMethodName().equals("#Ultimate.C_realloc")) break block31;
                assert (callStatement.getArguments().length == 2);
                PointerBase pointerBase15 = AliasAnalysis.extractPointerBaseFromPointer(this.mAsfac, callStatement.getArguments()[0]);
                this.mAccessAddresses.add(pointerBase15);
                assert (callStatement.getLhs().length == 1);
                PointerBase pointerBase16 = this.extractPointerBaseFromVariableLhs(this.mAsfac, callStatement.getLhs()[0]);
                this.mAccessAddresses.add(pointerBase16);
                this.mWriteAddresses.add(pointerBase16);
                this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), (Object)pointerBase16);
                mayAlias.reportEquivalence(this.mAsfac, pointerBase15, pointerBase16);
                break block23;
            }
            if (callStatement.getMethodName().equals("ULTIMATE.dealloc") || !this.mProcedureToImplementation.containsKey(callStatement.getMethodName())) break block23;
            Procedure procedure = this.mProcedureToImplementation.get(callStatement.getMethodName());
            assert (callStatement.getArguments().length == procedure.getInParams().length);
            int n = 0;
            while (n < callStatement.getArguments().length) {
                expression = callStatement.getArguments()[n];
                if (AliasAnalysis.isPointerType(expression.getType())) {
                    storageClass = procedure.getSpecification() == null ? DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM : DeclarationInformation.StorageClass.PROC_FUNC_INPARAM;
                    pointerBase = AliasAnalysis.extractPointerBaseFromVarlist(this.mAsfac, procedure.getInParams()[n], new DeclarationInformation(storageClass, procedure.getIdentifier()));
                    object = AliasAnalysis.extractPointerBasesFromPointer(this.mAsfac, expression);
                    Iterator<PointerBase> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        PointerBase pointerBase17 = iterator.next();
                        mayAlias.reportEquivalence(this.mAsfac, pointerBase17, pointerBase);
                    }
                }
                ++n;
            }
            n = 0;
            while (n < callStatement.getLhs().length) {
                expression = callStatement.getLhs()[n];
                if (AliasAnalysis.isPointerType(expression.getType())) {
                    storageClass = procedure.getSpecification() == null ? DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM : DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM;
                    pointerBase = AliasAnalysis.extractPointerBaseFromVarlist(this.mAsfac, procedure.getOutParams()[n], new DeclarationInformation(storageClass, procedure.getIdentifier()));
                    object = this.extractPointerBaseFromVariableLhs(this.mAsfac, (VariableLHS)expression);
                    mayAlias.reportEquivalence(this.mAsfac, (AddressStore)object, pointerBase);
                    this.mAccessAddresses.add((PointerBase)object);
                    this.mWriteAddresses.add((PointerBase)object);
                    this.mProcedureToWritePointers.addPair((Object)this.mCurrentProcedure.getIdentifier(), object);
                }
                ++n;
            }
        }
    }

    private PointerBase extractPointerBaseFromVariableLhs(AddressStoreFactory addressStoreFactory, VariableLHS variableLHS) {
        assert (AliasAnalysis.isPointerType(variableLHS.getType()));
        PointerBaseVariable pointerBaseVariable = this.mAsfac.getPointerBase(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation());
        return pointerBaseVariable;
    }

    public static boolean isNullPointer(PointerBase pointerBase) {
        if (pointerBase instanceof PointerBaseIntLiteral) {
            PointerBaseIntLiteral pointerBaseIntLiteral = (PointerBaseIntLiteral)pointerBase;
            return pointerBaseIntLiteral.getValue().equals(BigInteger.ZERO);
        }
        return false;
    }

    private class ExpressionAnalyzer
    extends BoogieVisitor {
        private final MayAlias mMa;

        public ExpressionAnalyzer(MayAlias mayAlias) {
            this.mMa = mayAlias;
        }

        protected Expression processExpression(Expression expression) {
            return super.processExpression(expression);
        }

        protected void visit(BinaryExpression binaryExpression) {
            if (binaryExpression.getOperator() == BinaryExpression.Operator.COMPEQ && AliasAnalysis.isPointerType(binaryExpression.getLeft().getType())) {
                List<PointerBase> list = AliasAnalysis.extractPointerBasesFromPointer(AliasAnalysis.this.mAsfac, binaryExpression.getLeft());
                List<PointerBase> list2 = AliasAnalysis.extractPointerBasesFromPointer(AliasAnalysis.this.mAsfac, binaryExpression.getRight());
                for (PointerBase pointerBase : list) {
                    for (PointerBase pointerBase2 : list2) {
                        this.mMa.reportEquivalence(AliasAnalysis.this.mAsfac, pointerBase, pointerBase2);
                    }
                }
            }
        }
    }
}

