/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.mcr;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IntersectNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.IInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class McrAutomatonBuilder<LETTER extends IIcfgTransition<?>> {
    private final List<LETTER> mOriginalTrace;
    private final IPredicateUnifier mPredicateUnifier;
    private final ILogger mLogger;
    private final AutomataLibraryServices mServices;
    private final IEmptyStackStateFactory<IPredicate> mEmptyStackFactory;
    private final VpAlphabet<LETTER> mAlphabet;
    private final VpAlphabet<Integer> mIntAlphabet;
    private List<INestedWordAutomaton<Integer, String>> mThreadAutomata;
    private final HashRelation<IProgramVar, Integer> mVariables2Writes;
    private final Map<LETTER, List<Integer>> mActions2Indices;
    private final Map<String, List<Integer>> mThreads2SortedActions;

    public McrAutomatonBuilder(List<LETTER> list, IPredicateUnifier iPredicateUnifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, ILogger iLogger, VpAlphabet<LETTER> vpAlphabet, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mOriginalTrace = list;
        this.mLogger = iLogger;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mServices = new AutomataLibraryServices(iUltimateServiceProvider);
        this.mEmptyStackFactory = iEmptyStackStateFactory;
        this.mAlphabet = vpAlphabet;
        this.mIntAlphabet = new VpAlphabet(IntStream.range(0, list.size()).boxed().collect(Collectors.toSet()));
        this.mVariables2Writes = new HashRelation();
        this.mThreads2SortedActions = new HashMap<String, List<Integer>>();
        this.mActions2Indices = new HashMap<LETTER, List<Integer>>();
        this.preprocess();
    }

    private void preprocess() {
        int n = 0;
        while (n < this.mOriginalTrace.size()) {
            String string2;
            IIcfgTransition iIcfgTransition = (IIcfgTransition)this.mOriginalTrace.get(n);
            McrAutomatonBuilder.addValue(this.mActions2Indices, iIcfgTransition, n);
            for (String string2 : iIcfgTransition.getTransformula().getAssignedVars()) {
                this.mVariables2Writes.addPair((Object)string2, (Object)n);
            }
            string2 = iIcfgTransition.getPrecedingProcedure();
            McrAutomatonBuilder.addValue(this.mThreads2SortedActions, string2, n);
            String string3 = iIcfgTransition.getSucceedingProcedure();
            if (string2 != string3) {
                McrAutomatonBuilder.addValue(this.mThreads2SortedActions, string3, n);
            }
            ++n;
        }
    }

    private static <K, V> void addValue(Map<K, List<V>> map, K k, V v) {
        List<V> list = map.get(k);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(k, list);
        }
        list.add(v);
    }

    private static String getState(int n) {
        return "q" + n;
    }

    private List<INestedWordAutomaton<Integer, String>> getThreadAutomata() {
        if (this.mThreadAutomata == null) {
            this.mThreadAutomata = new ArrayList<INestedWordAutomaton<Integer, String>>();
            StringFactory stringFactory = new StringFactory();
            for (List<Integer> list : this.mThreads2SortedActions.values()) {
                NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, this.mIntAlphabet, (IEmptyStackStateFactory)stringFactory);
                HashSet<Integer> hashSet = new HashSet<Integer>(list);
                int n = 0;
                while (n <= list.size()) {
                    nestedWordAutomaton.addState(n == 0, n == list.size(), (Object)McrAutomatonBuilder.getState(n));
                    if (n > 0) {
                        nestedWordAutomaton.addInternalTransition((Object)McrAutomatonBuilder.getState(n - 1), (Object)list.get(n - 1), (Object)McrAutomatonBuilder.getState(n));
                    }
                    int n2 = 0;
                    while (n2 < this.mOriginalTrace.size()) {
                        if (!hashSet.contains(n2)) {
                            nestedWordAutomaton.addInternalTransition((Object)McrAutomatonBuilder.getState(n), (Object)n2, (Object)McrAutomatonBuilder.getState(n));
                        }
                        ++n2;
                    }
                    ++n;
                }
                this.mThreadAutomata.add((INestedWordAutomaton<Integer, String>)nestedWordAutomaton);
            }
        }
        return this.mThreadAutomata;
    }

    public NestedWordAutomaton<LETTER, IPredicate> buildMhbAutomaton(PredicateFactory predicateFactory) throws AutomataLibraryException {
        INestedWordAutomaton<Integer, String> iNestedWordAutomaton = this.intersectNwa(this.getThreadAutomata());
        Term term = this.mPredicateUnifier.getTruePredicate().getFormula();
        Map<String, IPredicate> map = iNestedWordAutomaton.getStates().stream().collect(Collectors.toMap(string -> string, string -> predicateFactory.newSPredicate(null, term)));
        return this.transformAutomaton(iNestedWordAutomaton, map::get, this.mEmptyStackFactory);
    }

    private <STATE> NestedWordAutomaton<LETTER, STATE> transformAutomaton(INestedWordAutomaton<Integer, String> iNestedWordAutomaton, Function<String, STATE> function, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        Object object;
        Object object22;
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, this.mAlphabet, iEmptyStackStateFactory);
        Set set = iNestedWordAutomaton.getInitialStates().stream().map(function).collect(Collectors.toSet());
        for (Object object22 : iNestedWordAutomaton.getFinalStates()) {
            object = function.apply((String)object22);
            if (object == null) continue;
            nestedWordAutomaton.addState(set.contains(object), true, object);
        }
        object22 = new ArrayDeque(iNestedWordAutomaton.getFinalStates());
        HashSet hashSet = new HashSet();
        while (!((ArrayDeque)object22).isEmpty()) {
            object = (String)((ArrayDeque)object22).pop();
            STATE STATE = function.apply((String)object);
            if (!hashSet.add(object) || STATE == null) continue;
            for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalPredecessors(object)) {
                String string = (String)incomingInternalTransition.getPred();
                STATE STATE2 = function.apply(string);
                if (STATE2 == null) continue;
                if (!nestedWordAutomaton.contains(STATE2)) {
                    nestedWordAutomaton.addState(set.contains(STATE2), false, STATE2);
                }
                nestedWordAutomaton.addInternalTransition(STATE2, (Object)((IIcfgTransition)this.mOriginalTrace.get((Integer)incomingInternalTransition.getLetter())), STATE);
                ((ArrayDeque)object22).add(string);
            }
        }
        return nestedWordAutomaton;
    }

    private List<Integer> getIntTrace(List<LETTER> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        HashMap<IIcfgTransition, Integer> hashMap = new HashMap<IIcfgTransition, Integer>();
        for (IIcfgTransition iIcfgTransition : list) {
            int n = hashMap.getOrDefault(iIcfgTransition, 0);
            arrayList.add(this.mActions2Indices.get(iIcfgTransition).get(n));
            hashMap.put(iIcfgTransition, n + 1);
        }
        return arrayList;
    }

    private INestedWordAutomaton<Integer, String> buildMcrAutomaton(List<Integer> list) throws AutomataLibraryException {
        this.mLogger.info((Object)"Constructing automaton for MCR equivalence class.");
        ArrayList arrayList = new ArrayList(list.size());
        HashMap<Map, Integer> hashMap = new HashMap<Map, Integer>();
        StringFactory stringFactory = list.iterator();
        while (stringFactory.hasNext()) {
            int n = stringFactory.next();
            HashMap<Map, Integer> hashMap2 = new HashMap<Map, Integer>();
            UnmodifiableTransFormula unmodifiableTransFormula = ((IIcfgTransition)this.mOriginalTrace.get(n)).getTransformula();
            for (Map map : unmodifiableTransFormula.getInVars().keySet()) {
                hashMap2.put(map, (Integer)hashMap.get(map));
            }
            arrayList.add(hashMap2);
            for (Map map : unmodifiableTransFormula.getAssignedVars()) {
                hashMap.put(map, n);
            }
        }
        ArrayList<INestedWordAutomaton<Integer, String>> arrayList2 = new ArrayList<INestedWordAutomaton<Integer, String>>(this.getThreadAutomata());
        stringFactory = new StringFactory();
        int n = 0;
        while (n < this.mOriginalTrace.size()) {
            Map map;
            int n2 = list.get(n);
            map = (Map)arrayList.get(n);
            for (Map.Entry entry : map.entrySet()) {
                Integer n3 = (Integer)entry.getValue();
                IProgramVar iProgramVar = (IProgramVar)entry.getKey();
                NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, this.mIntAlphabet, (IEmptyStackStateFactory)stringFactory);
                Set set = this.mVariables2Writes.getImage((Object)iProgramVar);
                nestedWordAutomaton.addState(n3 == null, false, (Object)McrAutomatonBuilder.getState(1));
                nestedWordAutomaton.addState(false, true, (Object)McrAutomatonBuilder.getState(2));
                nestedWordAutomaton.addInternalTransition((Object)McrAutomatonBuilder.getState(1), (Object)n2, (Object)McrAutomatonBuilder.getState(2));
                if (n3 != null) {
                    nestedWordAutomaton.addState(true, false, (Object)McrAutomatonBuilder.getState(0));
                    nestedWordAutomaton.addInternalTransition((Object)McrAutomatonBuilder.getState(0), (Object)n3, (Object)McrAutomatonBuilder.getState(1));
                }
                int n4 = 0;
                while (n4 < this.mOriginalTrace.size()) {
                    if (n4 != n2 && (n3 == null || n4 != n3)) {
                        if (n3 != null) {
                            nestedWordAutomaton.addInternalTransition((Object)McrAutomatonBuilder.getState(0), (Object)n4, (Object)McrAutomatonBuilder.getState(0));
                        }
                        if (!set.contains(n4)) {
                            nestedWordAutomaton.addInternalTransition((Object)McrAutomatonBuilder.getState(1), (Object)n4, (Object)McrAutomatonBuilder.getState(1));
                        }
                        nestedWordAutomaton.addInternalTransition((Object)McrAutomatonBuilder.getState(2), (Object)n4, (Object)McrAutomatonBuilder.getState(2));
                    }
                    ++n4;
                }
                arrayList2.add((INestedWordAutomaton<Integer, String>)nestedWordAutomaton);
            }
            ++n;
        }
        return this.intersectNwa(arrayList2);
    }

    private INestedWordAutomaton<Integer, String> intersectNwa(Collection<INestedWordAutomaton<Integer, String>> collection) throws AutomataLibraryException {
        this.mLogger.info((Object)"Started intersection.");
        NestedWordAutomatonReachableStates nestedWordAutomatonReachableStates = new NestedWordAutomatonReachableStates(this.mServices, McrAutomatonBuilder.intersect(collection));
        this.mLogger.info((Object)("Finished intersection with " + nestedWordAutomatonReachableStates.sizeInformation()));
        return nestedWordAutomatonReachableStates;
    }

    private static INwaOutgoingLetterAndTransitionProvider<Integer, String> intersect(Collection<INestedWordAutomaton<Integer, String>> collection) throws AutomataLibraryException {
        StringFactory stringFactory = new StringFactory();
        IntersectNwa intersectNwa = null;
        for (IntersectNwa intersectNwa2 : collection) {
            intersectNwa = intersectNwa == null ? intersectNwa2 : new IntersectNwa(intersectNwa, intersectNwa2, (IIntersectionStateFactory)stringFactory, false);
        }
        return intersectNwa;
    }

    public NestedWordAutomaton<LETTER, IPredicate> buildInterpolantAutomaton(List<LETTER> list, List<IPredicate> list2, IInterpolantProvider<LETTER> iInterpolantProvider) throws AutomataLibraryException {
        List<Integer> list3 = this.getIntTrace(list);
        assert (this.isInterleaving(list3)) : "Can only create an automaton for interleavings";
        INestedWordAutomaton<Integer, String> iNestedWordAutomaton = this.buildMcrAutomaton(list3);
        this.mLogger.info((Object)("Constructing interpolant automaton by labelling MCR automaton with interpolants from " + iInterpolantProvider.getClass().getSimpleName()));
        IPredicate iPredicate = this.mPredicateUnifier.getTruePredicate();
        IPredicate iPredicate2 = this.mPredicateUnifier.getFalsePredicate();
        HashMap<String, IPredicate> hashMap = new HashMap<String, IPredicate>();
        String string2 = (String)iNestedWordAutomaton.getInitialStates().iterator().next();
        hashMap.put(string2, iPredicate);
        int n = 0;
        while (n < list.size()) {
            Iterator iterator = iNestedWordAutomaton.internalSuccessors((Object)string2, (Object)list3.get(n)).iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Trace is not present in the MCR automaton");
            }
            string2 = (String)((OutgoingInternalTransition)iterator.next()).getSucc();
            hashMap.put(string2, n < list2.size() ? list2.get(n) : iPredicate2);
            ++n;
        }
        iInterpolantProvider.addInterpolants(this.transformAutomaton(iNestedWordAutomaton, (Function)string -> string, (IEmptyStackStateFactory)new StringFactory()), hashMap);
        NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton = this.transformAutomaton(iNestedWordAutomaton, hashMap::get, this.mEmptyStackFactory);
        HashSet hashSet = new HashSet(nestedWordAutomaton.getStates());
        hashSet.remove(iPredicate);
        hashSet.remove(iPredicate2);
        hashSet.removeAll(list2);
        this.mLogger.info((Object)("Construction finished. MCR generated " + hashSet.size() + " new interpolants: " + String.valueOf(hashSet)));
        return nestedWordAutomaton;
    }

    private boolean isInterleaving(List<Integer> list) throws AutomataLibraryException {
        Word word = new Word((Object[])list.toArray(new Integer[list.size()]));
        return new Accepts(this.mServices, McrAutomatonBuilder.intersect(this.getThreadAutomata()), NestedWord.nestedWord((Word)word)).getResult();
    }
}

