/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CompatibleTypes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.ConstantArrayUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TypeHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.CStringLiteral;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.InitializerResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.InitializerResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.StringLiteralResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.OverapproxVariable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;

public class InitializationHandler {
    private static final int MINIMAL_NUMBER_CELLS_FOR_USING_CONSTARRAYS_FOR_ONHEAP_INIT = 10;
    private static final float MAXIMAL_EXPLICIT_TO_OVERALL_RATIO_FOR_USING_CONSTARRAYS_FOR_ONHEAP_INIT = 0.5f;
    private final boolean mUseSelectForArrayCellInitIfPossible;
    private final MemoryHandler mMemoryHandler;
    private final ExpressionTranslation mExpressionTranslation;
    private final ITypeHandler mTypeHandler;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final TypeSizeAndOffsetComputer mTypeSetAndOffsetComputer;
    private final TypeSizes mTypeSizes;
    private final CHandler mCHandler;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final boolean mUseConstantArrays;
    private final IMemoryPointer mMemoryPointer;

    public InitializationHandler(TranslationSettings translationSettings, MemoryHandler memoryHandler, ExpressionTranslation expressionTranslation, ITypeHandler iTypeHandler, AuxVarInfoBuilder auxVarInfoBuilder, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, TypeSizes typeSizes, CHandler cHandler, ExpressionResultTransformer expressionResultTransformer, IMemoryPointer iMemoryPointer) {
        this.mMemoryHandler = memoryHandler;
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeHandler = iTypeHandler;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mTypeSetAndOffsetComputer = typeSizeAndOffsetComputer;
        this.mTypeSizes = typeSizes;
        this.mCHandler = cHandler;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mUseConstantArrays = translationSettings.useConstantArrays();
        this.mUseSelectForArrayCellInitIfPossible = !translationSettings.useStoreChains();
        this.mMemoryPointer = iMemoryPointer;
    }

    public ExpressionResult initialize(ILocation iLocation, LeftHandSide leftHandSide, ICType iCType, InitializerResult initializerResult, IASTNode iASTNode) {
        boolean bl;
        if (leftHandSide instanceof VariableLHS) {
            VariableLHS variableLHS = (VariableLHS)leftHandSide;
            bl = this.mCHandler.isHeapVar(variableLHS.getIdentifier());
        } else {
            bl = false;
        }
        return this.initialize(iLocation, leftHandSide, iCType, initializerResult, bl, iASTNode);
    }

    public ExpressionResult initialize(ILocation iLocation, LeftHandSide leftHandSide, ICType iCType, InitializerResult initializerResult, boolean bl, IASTNode iASTNode) {
        ExpressionResult expressionResult;
        boolean bl2;
        LRValue lRValue;
        Object object;
        Object object2;
        if (bl) {
            object2 = (VariableLHS)leftHandSide;
            object = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)object2.getIdentifier(), (DeclarationInformation)object2.getDeclarationInformation());
            lRValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, (Expression)object, iCType, null);
        } else {
            LocalLValue localLValue = lRValue = leftHandSide == null ? null : new LocalLValue(leftHandSide, iCType, null);
        }
        object2 = initializerResult != null ? (initializerResult.getRootExpressionResult() == null && (initializerResult.getList() == null || initializerResult.getList().isEmpty()) ? null : this.constructInitializerInfo(iLocation, initializerResult, iCType, iASTNode)) : null;
        object = new ExpressionResultBuilder();
        boolean bl3 = bl2 = object2 != null && ((InitializerInfo)object2).isMakeNondeterministicInitialization();
        assert (!(bl && bl2 && ((InitializerInfo)object2).getOverapprs().isEmpty())) : "on heap variables get intitialized to 0, so they are never nondeterministically initialized, except when they areoverapproximated string literals";
        boolean bl4 = bl2 = bl && this.useConstArrayInitialization(iCType, (InitializerInfo)object2, iASTNode);
        if (bl2) {
            expressionResult = this.makeOnHeapDefaultInitializationViaConstArray(iLocation, (HeapLValue)lRValue, iCType);
            ((ExpressionResultBuilder)object).addAllExceptLrValue(expressionResult);
        }
        expressionResult = this.initRec(iLocation, iCType, (InitializerInfo)object2, bl, bl2, lRValue, true, iASTNode);
        ((ExpressionResultBuilder)object).addAllExceptLrValue(expressionResult);
        if (expressionResult.hasLRValue()) {
            ((ExpressionResultBuilder)object).setLrValue(expressionResult.getLrValue());
        }
        return ((ExpressionResultBuilder)object).build();
    }

    public ExpressionResult writeStringLiteral(ILocation iLocation, RValue rValue, CStringLiteral cStringLiteral, IASTNode iASTNode) {
        CArray cArray = (CArray)rValue.getCType();
        assert (CTranslationUtil.getConstantFirstDimensionOfArray(cArray, this.mTypeSizes) == cStringLiteral.getByteValues().size());
        HeapLValue heapLValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, rValue.getValue(), cArray, null);
        InitializerInfo initializerInfo = this.constructInitInfoFromCStringLiteral(iLocation, cStringLiteral, cArray, iASTNode);
        boolean bl = this.useConstArrayInitialization(cArray, initializerInfo, iASTNode);
        return this.initCArray(iLocation, heapLValue, cArray, initializerInfo, true, bl, true, iASTNode);
    }

    private ExpressionResult initRec(ILocation iLocation, ICType iCType, InitializerInfo initializerInfo, boolean bl, boolean bl2, LRValue lRValue, boolean bl3, IASTNode iASTNode) {
        assert (!bl2 || bl);
        assert (lRValue == null || lRValue.getCType().getUnderlyingType().equals(iCType.getUnderlyingType()));
        assert (!bl || lRValue != null) : "we need a start address for on-heap initialization";
        ICType iCType2 = iCType.getUnderlyingType();
        if (initializerInfo == null) {
            if (bl && bl2) {
                return new ExpressionResultBuilder().build();
            }
            return this.makeDefaultOrNondetInitialization(iLocation, lRValue, iCType2, bl, false, iASTNode);
        }
        if (initializerInfo.isMakeNondeterministicInitialization()) {
            return this.makeNondetInitAndAddOverapprFromInitInfo(iLocation, initializerInfo, bl, lRValue, iCType2, iASTNode);
        }
        if (iCType2 instanceof CPrimitive || iCType2 instanceof CEnum || iCType2 instanceof CPointer) {
            return this.initExpressionWithExpression(iLocation, lRValue, bl, !bl2, iCType2, initializerInfo, iASTNode);
        }
        if (iCType2 instanceof CStructOrUnion) {
            return this.initCStruct(iLocation, lRValue, (CStructOrUnion)iCType2, initializerInfo, bl, bl2, iASTNode);
        }
        if (iCType2 instanceof CArray) {
            CArray cArray = (CArray)iCType2;
            return this.initCArray(iLocation, lRValue, cArray, initializerInfo, bl, bl2, bl3, iASTNode);
        }
        throw new UnsupportedOperationException("missing case for CType");
    }

    private ExpressionResult makeNondetInitAndAddOverapprFromInitInfo(ILocation iLocation, InitializerInfo initializerInfo, boolean bl, LRValue lRValue, ICType iCType, IASTNode iASTNode) {
        assert (initializerInfo != null);
        assert (initializerInfo.isMakeNondeterministicInitialization());
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.makeDefaultOrNondetInitialization(iLocation, lRValue, iCType, bl, true, iASTNode);
        for (Statement statement : expressionResult.getStatements()) {
            InitializationHandler.addOverApprToStatementAnnots(initializerInfo.getOverapprs(), statement);
        }
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        if (expressionResult.getLrValue() != null) {
            expressionResultBuilder.setLrValue(expressionResult.getLrValue());
        }
        expressionResultBuilder.addOverapprox(initializerInfo.getOverapprs());
        return expressionResultBuilder.build();
    }

    private ExpressionResult initExpressionWithExpression(ILocation iLocation, LRValue lRValue, boolean bl, boolean bl2, ICType iCType, InitializerInfo initializerInfo, IASTNode iASTNode) {
        assert (initializerInfo.hasExpressionResult());
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(initializerInfo.getExpressionResult());
        RValue rValue = initializerInfo.getRValue();
        if (lRValue != null) {
            List<Statement> list = this.makeAssignmentStatements(iLocation, lRValue, bl, bl2, iCType, rValue.getValue(), initializerInfo.getOverapprs(), iASTNode);
            list.forEach(statement -> InitializationHandler.addOverApprToStatementAnnots(initializerInfo.getOverapprs(), statement));
            expressionResultBuilder.addStatements(list);
        } else {
            expressionResultBuilder.setLrValue(rValue);
        }
        return expressionResultBuilder.build();
    }

    private ExpressionResult initCStruct(ILocation iLocation, LRValue lRValue2, CStructOrUnion cStructOrUnion, InitializerInfo initializerInfo, boolean bl, boolean bl2, IASTNode iASTNode) {
        LRValue lRValue3;
        ICType iCType;
        assert (!initializerInfo.isMakeNondeterministicInitialization()) : "catch nondeterministic case outside";
        if (initializerInfo.hasExpressionResult()) {
            return this.initExpressionWithExpression(iLocation, lRValue2, bl, !bl2, cStructOrUnion, initializerInfo, iASTNode);
        }
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ArrayList<LRValue> arrayList = new ArrayList<LRValue>();
        LRValue lRValue4 = this.obtainLhsToInitialize(iLocation, lRValue2, cStructOrUnion, bl, expressionResultBuilder);
        int n = 0;
        while (n < cStructOrUnion.getFieldCount()) {
            iCType = cStructOrUnion.getFieldTypes()[n].getUnderlyingType();
            if (!(iCType instanceof CArray && iCType.isIncomplete() || CStructOrUnion.isUnion(cStructOrUnion) && bl && !initializerInfo.hasInitInfoForIndex(n))) {
                ExpressionResult expressionResult;
                InitializerInfo initializerInfo2;
                if (bl) {
                    assert (lRValue2 instanceof HeapLValue);
                    lRValue3 = this.constructAddressForStructField(iLocation, (HeapLValue)lRValue4, n);
                } else {
                    lRValue3 = lRValue2 != null ? CTranslationUtil.constructOffHeapStructAccessLhs(iLocation, (LocalLValue)lRValue4, n) : null;
                }
                InitializerInfo initializerInfo3 = initializerInfo2 = initializerInfo.hasInitInfoForIndex(n) ? initializerInfo.getInitInfoForIndex(n) : null;
                if (CStructOrUnion.isUnion(cStructOrUnion) && !initializerInfo.hasInitInfoForIndex(n)) {
                    assert (!bl);
                    expressionResult = this.makeDefaultOrNondetInitialization(iLocation, lRValue3, iCType, bl, true, iASTNode);
                } else {
                    expressionResult = this.initRec(iLocation, iCType, initializerInfo2, bl, bl2, lRValue3, true, iASTNode);
                }
                expressionResultBuilder.addAllExceptLrValue(expressionResult);
                if (expressionResult.getLrValue() != null) {
                    arrayList.add(expressionResult.getLrValue());
                }
                if (CStructOrUnion.isUnion(cStructOrUnion) && bl && initializerInfo.hasInitInfoForIndex(n)) break;
            }
            ++n;
        }
        if (!bl && lRValue2 == null) {
            List<Expression> list = arrayList.stream().map(lRValue -> lRValue.getValue()).collect(Collectors.toList());
            iCType = ExpressionFactory.constructStructConstructor((ILocation)iLocation, (String[])cStructOrUnion.getFieldIds(), (Expression[])list.toArray(new Expression[list.size()]));
            lRValue3 = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{((LocalLValue)lRValue4).getLhs()}, (Expression[])new Expression[]{iCType});
            InitializationHandler.addOverApprToStatementAnnots(initializerInfo.getOverapprs(), (Statement)lRValue3);
            expressionResultBuilder.addStatement((Statement)lRValue3);
        }
        return expressionResultBuilder.build();
    }

    private ExpressionResult initCArray(ILocation iLocation, LRValue lRValue, CArray cArray, InitializerInfo initializerInfo, boolean bl, boolean bl2, boolean bl3, IASTNode iASTNode) {
        boolean bl4;
        assert (!bl2 || bl);
        assert (!initializerInfo.isMakeNondeterministicInitialization()) : "catch nondeterministic case outside";
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        if (initializerInfo.hasExpressionResult()) {
            expressionResultBuilder.addAllExceptLrValue(initializerInfo.getExpressionResult());
        }
        LRValue lRValue2 = this.obtainLhsToInitialize(iLocation, lRValue, cArray, bl, expressionResultBuilder);
        boolean bl5 = bl4 = !bl && bl3 && this.useConstArrayInitialization(cArray, initializerInfo, iASTNode);
        if (bl4) {
            ExpressionResult expressionResult = this.makeDefaultOrNondetInitialization(iLocation, lRValue2, cArray, bl, false, iASTNode);
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
        }
        if (CTranslationUtil.isToplevelVarlengthArray(cArray, this.mTypeSizes)) {
            throw new UnsupportedOperationException("handling varlength arrays not implemented for this case");
        }
        int n = CTranslationUtil.getConstantFirstDimensionOfArray(cArray, this.mTypeSizes);
        int n2 = 0;
        while (n2 < n) {
            InitializerInfo initializerInfo2 = initializerInfo.hasInitInfoForIndex(n2) ? initializerInfo.getInitInfoForIndex(n2) : null;
            if (!bl4 && !bl2 || initializerInfo2 != null) {
                int n3 = n2;
                ICType iCType = cArray.getValueType();
                LRValue lRValue3 = bl ? this.constructAddressForArrayAtIndex(iLocation, (HeapLValue)lRValue2, n3) : CTranslationUtil.constructArrayAccessLhs(iLocation, (LocalLValue)lRValue2, n3, this.mTypeSizes);
                ExpressionResult expressionResult = this.initRec(iLocation, iCType, initializerInfo2, bl, bl2, lRValue3, false, iASTNode);
                expressionResultBuilder.addAllExceptLrValue(expressionResult);
            }
            ++n2;
        }
        return expressionResultBuilder.build();
    }

    private ExpressionResult makeDefaultOrNondetInitialization(ILocation iLocation, LRValue lRValue, ICType iCType, boolean bl, boolean bl2, IASTNode iASTNode) {
        assert (!bl || lRValue != null) : "for on-heap initialization we need a start address";
        ICType iCType2 = iCType.getUnderlyingType();
        if (!bl && !(iCType2 instanceof CArray)) {
            return this.makeOffHeapDefaultOrNondetInitializationForType(iLocation, iCType2, (LocalLValue)lRValue, bl2, iASTNode);
        }
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        LRValue lRValue2 = this.obtainLhsToInitialize(iLocation, lRValue, iCType2, bl, expressionResultBuilder);
        if (bl) {
            ExpressionResult expressionResult = this.makeNaiveOnHeapDefaultInitializationForType(iLocation, (HeapLValue)lRValue2, iCType2, iASTNode);
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
            assert (expressionResult.getLrValue() == null) : "on-heap initialization does not need a return value";
        } else {
            ExpressionResult expressionResult = this.makeOffHeapDefaultOrNondetInitializationForType(iLocation, iCType2, (LocalLValue)lRValue2, bl2, iASTNode);
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
            if (expressionResult.getLrValue() != null) {
                assert (lRValue2 == null);
                expressionResultBuilder.setLrValue(expressionResult.getLrValue());
            }
        }
        return expressionResultBuilder.build();
    }

    private ExpressionResult makeNaiveOnHeapDefaultInitializationForType(ILocation iLocation, HeapLValue heapLValue, ICType iCType, IASTNode iASTNode) {
        ICType iCType2 = iCType.getUnderlyingType();
        if (iCType2 instanceof CPrimitive || iCType2 instanceof CEnum || iCType2 instanceof CPointer) {
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
            List<Statement> list = this.makeAssignmentStatements(iLocation, heapLValue, true, true, iCType2, this.getDefaultValueForSimpleType(iLocation, iCType2), Collections.emptyList(), iASTNode);
            expressionResultBuilder.addStatements(list);
            return expressionResultBuilder.build();
        }
        if (iCType2 instanceof CStructOrUnion) {
            CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType2;
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
            String[] stringArray = cStructOrUnion.getFieldIds();
            int n = 0;
            while (n < stringArray.length) {
                HeapLValue heapLValue2 = this.constructAddressForStructField(iLocation, heapLValue, n);
                ExpressionResult expressionResult = this.makeNaiveOnHeapDefaultInitializationForType(iLocation, heapLValue2, cStructOrUnion.getFieldTypes()[n], iASTNode);
                expressionResultBuilder.addAllExceptLrValue(expressionResult);
                if (CStructOrUnion.isUnion(iCType2)) break;
                ++n;
            }
            return expressionResultBuilder.build();
        }
        if (iCType2 instanceof CArray) {
            CArray cArray = (CArray)iCType2;
            return this.makeNaiveOnHeapDefaultInitializationForArray(iLocation, heapLValue, cArray, iASTNode);
        }
        throw new UnsupportedOperationException("missing case?");
    }

    private ExpressionResult makeOffHeapDefaultOrNondetInitializationForType(ILocation iLocation, ICType iCType, LocalLValue localLValue, boolean bl, IASTNode iASTNode) {
        ICType iCType2 = iCType.getUnderlyingType();
        if (iCType2 instanceof CPrimitive || iCType2 instanceof CEnum || iCType2 instanceof CPointer) {
            LRValue lRValue;
            Object object;
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
            if (bl) {
                object = this.makeUnionAuxVarExpressionResult(iLocation, iCType2);
                expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
                lRValue = ((ExpressionResult)object).getLrValue();
            } else {
                lRValue = new RValue(this.getDefaultValueForSimpleType(iLocation, iCType2), iCType2);
            }
            if (localLValue != null) {
                object = this.makeAssignmentStatements(iLocation, localLValue, false, false, iCType2, lRValue.getValue(), Collections.emptyList(), iASTNode);
                expressionResultBuilder.addStatements(object);
            } else {
                expressionResultBuilder.setLrValue(lRValue);
            }
            return expressionResultBuilder.build();
        }
        if (iCType2 instanceof CStructOrUnion) {
            Object object;
            CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType2;
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
            ArrayList<LRValue> arrayList = new ArrayList<LRValue>();
            int n = 0;
            while (n < cStructOrUnion.getFieldCount()) {
                Object object2;
                if (localLValue == null) {
                    object = null;
                } else {
                    object2 = cStructOrUnion.getFieldIds()[n];
                    StructLHS structLHS = ExpressionFactory.constructStructAccessLhs((ILocation)iLocation, (LeftHandSide)localLValue.getLhs(), (String)object2);
                    object = new LocalLValue((LeftHandSide)structLHS, cStructOrUnion.getFieldTypes()[n], null);
                }
                object2 = CStructOrUnion.isUnion(iCType2) && n != 0 ? this.makeOffHeapDefaultOrNondetInitializationForType(iLocation, cStructOrUnion.getFieldTypes()[n], (LocalLValue)object, true, iASTNode) : this.makeOffHeapDefaultOrNondetInitializationForType(iLocation, cStructOrUnion.getFieldTypes()[n], (LocalLValue)object, bl, iASTNode);
                expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object2);
                arrayList.add(((ExpressionResult)object2).getLrValue());
                ++n;
            }
            if (localLValue == null) {
                List<Expression> list = arrayList.stream().map(LRValue::getValue).collect(Collectors.toList());
                object = ExpressionFactory.constructStructConstructor((ILocation)iLocation, (String[])cStructOrUnion.getFieldIds(), (Expression[])list.toArray(new Expression[list.size()]));
                expressionResultBuilder.setLrValue(new RValue((Expression)object, iCType2));
            }
            return expressionResultBuilder.build();
        }
        if (iCType2 instanceof CArray) {
            CArray cArray = (CArray)iCType2;
            assert (localLValue != null);
            if (this.useConstArrayInitialization(iCType2, null, iASTNode) && !(CTranslationUtil.getValueTypeOfNestedArray(cArray) instanceof CStructOrUnion)) {
                return this.makeSophisticatedOffHeapDefaultInitializationForArray(iLocation, cArray, localLValue);
            }
            return this.makeNaiveOffHeapDefaultOrNondetInitForArray(iLocation, cArray, localLValue, bl, iASTNode);
        }
        throw new UnsupportedOperationException("missing case?");
    }

    private ExpressionResult makeUnionAuxVarExpressionResult(ILocation iLocation, ICType iCType) {
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.NONDET);
        return new ExpressionResultBuilder().setLrValue(new RValue((Expression)auxVarInfo.getExp(), iCType)).addAuxVarWithDeclaration(auxVarInfo).addOverapprox(new Overapprox("initialize union -- havoccing a field without explictit initializer", iLocation)).build();
    }

    private ExpressionResult makeNaiveOnHeapDefaultInitializationForArray(ILocation iLocation, HeapLValue heapLValue, CArray cArray, IASTNode iASTNode) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        List list = CrossProducts.crossProductOfSetsOfFirstNaturalNumbers(Collections.singletonList(CTranslationUtil.getConstantFirstDimensionOfArray(cArray, this.mTypeSizes)));
        for (List list2 : list) {
            HeapLValue heapLValue2 = this.constructAddressForArrayAtIndex(iLocation, heapLValue, list2);
            ExpressionResult expressionResult = this.makeNaiveOnHeapDefaultInitializationForType(iLocation, heapLValue2, cArray.getValueType(), iASTNode);
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
        }
        return expressionResultBuilder.build();
    }

    private ExpressionResult makeOnHeapDefaultInitializationViaConstArray(ILocation iLocation, HeapLValue heapLValue, ICType iCType) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        List<Statement> list = this.mMemoryHandler.getInitializationForOnHeapVariableOfAggregateOrUnionType(iLocation, heapLValue, iCType);
        expressionResultBuilder.addStatements(list);
        return expressionResultBuilder.build();
    }

    private ExpressionResult makeNaiveOffHeapDefaultOrNondetInitForArray(ILocation iLocation, CArray cArray, LocalLValue localLValue, boolean bl, IASTNode iASTNode) {
        assert (localLValue != null);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        LocalLValue localLValue2 = localLValue;
        ICType iCType = cArray.getValueType().getUnderlyingType();
        while (iCType instanceof CArray) {
            CArray cArray2 = (CArray)iCType;
            iCType = cArray2.getValueType().getUnderlyingType();
        }
        List list = CrossProducts.crossProductOfSetsOfFirstNaturalNumbers(CTranslationUtil.getConstantDimensionsOfArray(cArray, this.mTypeSizes));
        for (List list2 : list) {
            LocalLValue localLValue3 = CTranslationUtil.constructArrayAccessLhs(iLocation, localLValue2, list2, this.mTypeSizes);
            ExpressionResult expressionResult = this.makeOffHeapDefaultOrNondetInitializationForType(iLocation, iCType, localLValue3, bl, iASTNode);
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
        }
        return expressionResultBuilder.build();
    }

    private ExpressionResult makeSophisticatedOffHeapDefaultInitializationForArray(ILocation iLocation, CArray cArray, LocalLValue localLValue) {
        assert (this.mUseConstantArrays);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        BoogieArrayType boogieArrayType = (BoogieArrayType)this.mTypeHandler.getBoogieTypeForCType(cArray);
        Expression expression = ConstantArrayUtil.getZeroArray(this.mExpressionTranslation.getFunctionDeclarations(), iLocation, boogieArrayType);
        AssignmentStatement assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{localLValue.getLhs()}, (Expression[])new Expression[]{expression});
        expressionResultBuilder.addStatement((Statement)assignmentStatement);
        return expressionResultBuilder.build();
    }

    private LRValue obtainLhsToInitialize(ILocation iLocation, LRValue lRValue, ICType iCType, boolean bl, ExpressionResultBuilder expressionResultBuilder) {
        LRValue lRValue2;
        if (bl) {
            assert (lRValue instanceof HeapLValue);
            lRValue2 = lRValue;
        } else {
            lRValue2 = this.obtainLocalLValueToInitialize(iLocation, (LocalLValue)lRValue, iCType, expressionResultBuilder);
        }
        return lRValue2;
    }

    private LocalLValue obtainLocalLValueToInitialize(ILocation iLocation, LocalLValue localLValue, ICType iCType, ExpressionResultBuilder expressionResultBuilder) {
        LocalLValue localLValue2 = localLValue != null ? localLValue : this.obtainAuxVarLocalLValue(iLocation, iCType, expressionResultBuilder);
        return localLValue2;
    }

    private LocalLValue obtainAuxVarLocalLValue(ILocation iLocation, ICType iCType, ExpressionResultBuilder expressionResultBuilder) {
        SFO.AUXVAR aUXVAR;
        if (iCType instanceof CArray) {
            aUXVAR = SFO.AUXVAR.ARRAYINIT;
        } else if (iCType instanceof CStructOrUnion) {
            aUXVAR = SFO.AUXVAR.STRUCTINIT;
        } else {
            throw new UnsupportedOperationException();
        }
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, aUXVAR);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        LocalLValue localLValue = new LocalLValue((LeftHandSide)auxVarInfo.getLhs(), iCType, null);
        expressionResultBuilder.setLrValue(localLValue);
        return localLValue;
    }

    private static void addOverApprToStatementAnnots(Collection<Overapprox> collection, Statement statement) {
        if (collection == null) {
            return;
        }
        for (Overapprox overapprox : collection) {
            new OverapproxVariable(overapprox.getOverapproximatedLocations()).annotate((IElement)statement);
        }
    }

    private List<Statement> makeAssignmentStatements(ILocation iLocation, LRValue lRValue, boolean bl, boolean bl2, ICType iCType, Expression expression, Collection<Overapprox> collection, IASTNode iASTNode) {
        List<Statement> list;
        assert (lRValue != null);
        if (bl) {
            list = bl2 && this.mUseSelectForArrayCellInitIfPossible ? this.mMemoryHandler.getInitCall(iLocation, (HeapLValue)lRValue, expression, iCType, iASTNode) : this.mMemoryHandler.getWriteCall(iLocation, (HeapLValue)lRValue, expression, iCType, true);
        } else {
            AssignmentStatement assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{((LocalLValue)lRValue).getLhs()}, (Expression[])new Expression[]{expression});
            InitializationHandler.addOverApprToStatementAnnots(collection, (Statement)assignmentStatement);
            list = Collections.singletonList(assignmentStatement);
        }
        return list;
    }

    private Expression getDefaultValueForSimpleType(ILocation iLocation, ICType iCType) {
        ICType iCType2 = iCType.getUnderlyingType();
        if (iCType2 instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType2;
            return switch (cPrimitive.getGeneralType()) {
                case CPrimitive.CPrimitiveCategory.INTTYPE -> this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
                case CPrimitive.CPrimitiveCategory.FLOATTYPE -> this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ZERO);
                case CPrimitive.CPrimitiveCategory.VOID -> throw new AssertionError((Object)"cannot initialize something that has type void");
                default -> throw new MatchException(null, null);
            };
        }
        if (iCType2 instanceof CEnum) {
            return this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), BigInteger.ZERO);
        }
        if (iCType2 instanceof CPointer) {
            return this.mMemoryPointer.constructNullPointer(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents());
        }
        throw new UnsupportedOperationException("missing case?");
    }

    private boolean useConstArrayInitialization(ICType iCType, InitializerInfo initializerInfo, IASTNode iASTNode) {
        BigDecimal bigDecimal;
        if (!this.mUseConstantArrays) {
            return false;
        }
        BigInteger bigInteger = this.countNumberOfPrimitiveElementInType(iCType, iASTNode);
        if (bigInteger.compareTo(BigInteger.valueOf(10L)) < 0) {
            return false;
        }
        BigDecimal bigDecimal2 = initializerInfo == null ? BigDecimal.ZERO : BigDecimal.valueOf(initializerInfo.getNumberOfValues());
        return bigDecimal2.compareTo(bigDecimal = new BigDecimal(bigInteger).multiply(BigDecimal.valueOf(0.5))) > 0;
    }

    private BigInteger countNumberOfPrimitiveElementInType(ICType iCType2, IASTNode iASTNode) {
        ICType iCType3 = iCType2.getUnderlyingType();
        if (iCType3 instanceof CPrimitive || iCType3 instanceof CEnum || iCType3 instanceof CPointer) {
            return BigInteger.ONE;
        }
        if (iCType3 instanceof CStructOrUnion) {
            if (CStructOrUnion.isUnion(iCType3)) {
                return BigInteger.ONE;
            }
            return Arrays.stream(((CStructOrUnion)iCType3).getFieldTypes()).map(iCType -> this.countNumberOfPrimitiveElementInType((ICType)iCType, iASTNode)).reduce(BigInteger.ZERO, BigInteger::add);
        }
        if (iCType3 instanceof CArray) {
            CArray cArray = (CArray)iCType3;
            if (iCType3.isIncomplete()) {
                return BigInteger.ZERO;
            }
            BigInteger bigInteger = this.countNumberOfPrimitiveElementInType(cArray.getValueType(), iASTNode);
            BigInteger bigInteger2 = this.mTypeSizes.extractIntegerValue(cArray.getBound());
            return bigInteger.multiply(bigInteger2);
        }
        throw new AssertionError((Object)("Cannot count the primitive elements in type " + iCType3.getClass().getSimpleName()));
    }

    public HeapLValue constructAddressForArrayAtIndex(ILocation iLocation, HeapLValue heapLValue, List<Integer> list) {
        CArray cArray = (CArray)heapLValue.getCType().getUnderlyingType();
        List<Integer> list2 = CTranslationUtil.getConstantDimensionsOfArray(cArray, this.mTypeSizes);
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            int n3 = n2 == list.size() - 1 ? 1 : list2.get(n2 + 1);
            n += n3 * list.get(n2);
            ++n2;
        }
        CPrimitive cPrimitive = this.mTypeSetAndOffsetComputer.getSizeT();
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, new BigInteger(Integer.toString(n)));
        Expression expression2 = this.mMemoryHandler.doPointerArithmetic(4, iLocation, heapLValue.getAddress(), new RValue(expression, cPrimitive), cArray.getValueType(), cPrimitive);
        return LRValueFactory.constructHeapLValue(this.mTypeHandler, expression2, cArray.getValueType(), null);
    }

    public HeapLValue constructAddressForArrayAtIndex(ILocation iLocation, HeapLValue heapLValue, Integer n) {
        CArray cArray = (CArray)heapLValue.getCType().getUnderlyingType();
        CPrimitive cPrimitive = this.mExpressionTranslation.getCTypeOfPointerComponents();
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, new BigInteger(n.toString()));
        RValue rValue = heapLValue.getAddressAsPointerRValue(this.mTypeHandler.getBoogiePointerType());
        ICType iCType = cArray.getValueType();
        Expression expression2 = this.mMemoryHandler.doPointerArithmetic(4, iLocation, rValue.getValue(), new RValue(expression, cPrimitive), cArray.getValueType(), cPrimitive);
        return LRValueFactory.constructHeapLValue(this.mTypeHandler, expression2, iCType, null);
    }

    public HeapLValue constructAddressForStructField(ILocation iLocation, HeapLValue heapLValue, int n) {
        CStructOrUnion cStructOrUnion = (CStructOrUnion)heapLValue.getCType().getUnderlyingType();
        TypeSizeAndOffsetComputer.Offset offset = this.mTypeSetAndOffsetComputer.constructOffsetForField(iLocation, cStructOrUnion, n);
        Expression expression = this.mMemoryHandler.constructAddressForStructField(iLocation, heapLValue.getAddress(), offset, this.mTypeSetAndOffsetComputer.getSizeT());
        return LRValueFactory.constructHeapLValue(this.mTypeHandler, expression, cStructOrUnion.getFieldTypes()[n], null);
    }

    public InitializerInfo constructInitializerInfo(ILocation iLocation, InitializerResult initializerResult, ICType iCType, IASTNode iASTNode) {
        ICType iCType2 = iCType.getUnderlyingType();
        if (initializerResult.hasRootExpressionResult()) {
            ExpressionResult expressionResult = initializerResult.getRootExpressionResult();
            if (expressionResult instanceof StringLiteralResult) {
                StringLiteralResult stringLiteralResult = (StringLiteralResult)expressionResult;
                if (iCType instanceof CArray) {
                    if (!stringLiteralResult.getOverapprs().isEmpty()) {
                        Overapprox overapprox = new Overapprox("large string literal", iLocation);
                        ArrayList<Overapprox> arrayList = new ArrayList<Overapprox>();
                        arrayList.add(overapprox);
                        return new InitializerInfo(overapprox);
                    }
                    HashMap<Integer, InitializerInfo> hashMap = new HashMap<Integer, InitializerInfo>();
                    int n = 0;
                    while (n < stringLiteralResult.getLiteralString().getByteValues().size()) {
                        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.CHAR);
                        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, stringLiteralResult.getLiteralString().getByteValues().get(n));
                        ExpressionResult expressionResult2 = new ExpressionResultBuilder().setLrValue(new RValue(expression, cPrimitive)).build();
                        hashMap.put(n, new InitializerInfo(expressionResult2, Collections.emptyList()));
                        ++n;
                    }
                    return new InitializerInfo(hashMap, Collections.emptyList());
                }
            }
            if (initializerResult.getRootExpressionResult() instanceof StringLiteralResult && iCType instanceof CPointer) {
                ExpressionResult expressionResult3 = this.convertInitResultWithExpressionResult(iLocation, iCType2, initializerResult, iASTNode);
                assert (expressionResult3.getDeclarations().isEmpty()) : "the declarations necessary for a StringLiteral  should be registered in StaticObjectsHandler directly (because the need to be globalboogie declarations)";
                assert (expressionResult3.getStatements().isEmpty()) : "the statements necessary for a StringLiteral  should be registered in StaticObjectsHandler directly (because the need to be globalboogie declarations)";
                ExpressionResult expressionResult4 = new ExpressionResultBuilder().setLrValue(expressionResult3.getLrValue()).addOverapprox(expressionResult3.getOverapprs()).build();
                return new InitializerInfo(expressionResult4, Collections.emptyList());
            }
            ExpressionResult expressionResult5 = this.convertInitResultWithExpressionResult(iLocation, iCType2, initializerResult, iASTNode);
            return new InitializerInfo(expressionResult5, Collections.emptyList());
        }
        if (iCType2 instanceof CArray || iCType2 instanceof CStructOrUnion) {
            return this.constructIndexToInitInfo(iLocation, initializerResult.getList(), iCType2, iASTNode);
        }
        ArrayDeque<InitializerResult> arrayDeque = new ArrayDeque<InitializerResult>(initializerResult.getList());
        InitializerResult initializerResult2 = (InitializerResult)arrayDeque.pollFirst();
        ExpressionResult expressionResult = this.convertInitResultWithExpressionResult(iLocation, iCType2, initializerResult2, iASTNode);
        return new InitializerInfo(expressionResult, new ArrayList<InitializerResult>(arrayDeque));
    }

    protected ExpressionResult convertInitResultWithExpressionResult(ILocation iLocation, ICType iCType, InitializerResult initializerResult, IASTNode iASTNode) {
        ExpressionResult expressionResult = initializerResult.getRootExpressionResult();
        ExpressionResult expressionResult2 = this.mExprResultTransformer.makeRepresentationReadyForConversionAndRexBoolToInt(expressionResult, iLocation, iCType, iASTNode);
        if (iCType instanceof CArray) {
            return expressionResult2;
        }
        return this.mExprResultTransformer.performImplicitConversion(expressionResult2, iCType, iLocation);
    }

    private InitializerInfo constructIndexToInitInfo(ILocation iLocation, List<InitializerResult> list, ICType iCType, IASTNode iASTNode) {
        int n;
        assert (iCType instanceof CArray || iCType instanceof CStructOrUnion);
        ICType iCType2 = null;
        if (iCType instanceof CArray) {
            CArray cArray = (CArray)iCType;
            iCType2 = cArray.getValueType();
            n = CTranslationUtil.getConstantFirstDimensionOfArray(cArray, this.mTypeSizes);
            if (CTranslationUtil.isToplevelVarlengthArray(cArray, this.mTypeSizes)) {
                throw new UnsupportedOperationException("varlength not yet supported here");
            }
        } else {
            n = ((CStructOrUnion)iCType).getFieldCount();
        }
        HashMap<Integer, InitializerInfo> hashMap = new HashMap<Integer, InitializerInfo>();
        ArrayDeque<InitializerResult> arrayDeque = new ArrayDeque<InitializerResult>(list);
        int n2 = -1;
        while (!arrayDeque.isEmpty() && (n2 < n - 1 || ((InitializerResult)arrayDeque.peekFirst()).hasRootDesignator())) {
            Object object;
            InitializerResult initializerResult = (InitializerResult)arrayDeque.peekFirst();
            n2 = initializerResult.hasRootDesignator() ? InitializationHandler.getCellIndex(iCType, initializerResult.getRootDesignator()) : ++n2;
            if (iCType instanceof CStructOrUnion) {
                CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType;
                iCType2 = cStructOrUnion.getFieldTypes()[n2];
            }
            if (initializerResult.isInitializerList() || initializerResult.hasRootExpressionResult() && InitializationHandler.areCompatibleStructOrUnionTypes(iCType2, initializerResult.getRootExpressionResult().getLrValue().getCType()) || initializerResult.getRootExpressionResult() instanceof StringLiteralResult && TypeHandler.isCharArray(iCType2)) {
                object = (InitializerResult)arrayDeque.pollFirst();
                InitializerInfo initializerInfo = this.constructInitializerInfo(iLocation, (InitializerResult)object, iCType2, iASTNode);
                hashMap.put(n2, initializerInfo);
                continue;
            }
            object = new InitializerResultBuilder();
            arrayDeque.forEach(((InitializerResultBuilder)object)::addChild);
            InitializerInfo initializerInfo = this.constructInitializerInfo(iLocation, ((InitializerResultBuilder)object).build(), iCType2, iASTNode);
            hashMap.put(n2, initializerInfo);
            arrayDeque = new ArrayDeque<InitializerResult>(initializerInfo.getUnusedListEntries());
        }
        return new InitializerInfo(hashMap, new ArrayList<InitializerResult>(arrayDeque));
    }

    private static int getCellIndex(ICType iCType, InitializerResult.Designator designator) {
        InitializerResult.Designator designator2 = designator;
        Objects.requireNonNull(designator2);
        InitializerResult.Designator designator3 = designator2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InitializerResult.ArrayDesignator.class, InitializerResult.StructDesignator.class}, (Object)designator3, 0)) {
            case 0 -> {
                InitializerResult.ArrayDesignator var3_3 = (InitializerResult.ArrayDesignator)designator3;
                if (!$assertionsDisabled && !(iCType instanceof CArray)) {
                    throw new AssertionError((Object)("Expected CArray, but got " + iCType.getClass().getSimpleName() + " (" + String.valueOf(iCType) + ")"));
                }
                yield var3_3.getArrayCellId();
            }
            case 1 -> {
                InitializerResult.StructDesignator var4_4 = (InitializerResult.StructDesignator)designator3;
                if (!$assertionsDisabled && !(iCType instanceof CStructOrUnion)) {
                    throw new AssertionError((Object)("Expected CStructOrUnion, but got " + iCType.getClass().getSimpleName() + " (" + String.valueOf(iCType) + ")"));
                }
                yield CTranslationUtil.findIndexOfStructField((CStructOrUnion)iCType, var4_4.getStructFieldId());
            }
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean areCompatibleStructOrUnionTypes(ICType iCType, ICType iCType2) {
        return iCType.getUnderlyingType() instanceof CStructOrUnion && iCType2.getUnderlyingType() instanceof CStructOrUnion && CompatibleTypes.areCompatible(iCType, iCType2);
    }

    public InitializerInfo constructInitInfoFromCStringLiteral(ILocation iLocation, CStringLiteral cStringLiteral, ICType iCType, IASTNode iASTNode) {
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.CHAR);
        InitializerResultBuilder initializerResultBuilder = new InitializerResultBuilder();
        for (BigInteger object2 : cStringLiteral.getByteValues()) {
            InitializerResultBuilder initializerResultBuilder2 = new InitializerResultBuilder();
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
            Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, object2);
            expressionResultBuilder.setLrValue(new RValue(expression, cPrimitive));
            initializerResultBuilder2.setRootExpressionResult(expressionResultBuilder.build());
            initializerResultBuilder.addChild(initializerResultBuilder2.build());
        }
        InitializerResult initializerResult = initializerResultBuilder.build();
        return this.constructInitializerInfo(iLocation, initializerResult, iCType, iASTNode);
    }

    public Result handleDesignatedInitializer(IDispatcher iDispatcher, LocationFactory locationFactory, ICASTDesignatedInitializer iCASTDesignatedInitializer) {
        ICASTDesignator iCASTDesignator;
        ICASTDesignator iCASTDesignator2;
        CACSLLocation cACSLLocation = locationFactory.createCLocation((IASTNode)iCASTDesignatedInitializer);
        if (iCASTDesignatedInitializer.getDesignators().length == 1 && (iCASTDesignator2 = iCASTDesignatedInitializer.getDesignators()[0]) instanceof ICASTFieldDesignator) {
            ICASTFieldDesignator iCASTFieldDesignator = (ICASTFieldDesignator)iCASTDesignator2;
            String string = iCASTFieldDesignator.getName().toString();
            Result result = iDispatcher.dispatch((IASTNode)iCASTDesignatedInitializer.getOperand());
            if (result instanceof InitializerResult) {
                InitializerResult initializerResult = (InitializerResult)result;
                assert (!initializerResult.hasRootDesignator());
                InitializerResultBuilder initializerResultBuilder = new InitializerResultBuilder(initializerResult);
                initializerResultBuilder.setRootDesignator(string);
                return initializerResultBuilder.build();
            }
            if (result instanceof ExpressionResult) {
                ExpressionResult expressionResult = (ExpressionResult)result;
                return new InitializerResultBuilder().setRootExpressionResult(expressionResult).setRootDesignator(string).build();
            }
            throw new UnsupportedSyntaxException(cACSLLocation, "Unexpected result");
        }
        if (iCASTDesignatedInitializer.getDesignators().length == 1 && (iCASTDesignator = iCASTDesignatedInitializer.getDesignators()[0]) instanceof ICASTArrayDesignator) {
            ICASTArrayDesignator iCASTArrayDesignator = (ICASTArrayDesignator)iCASTDesignator;
            int n = this.getArrayCellNrFromArrayDesignator(iDispatcher, cACSLLocation, iCASTArrayDesignator, iCASTDesignatedInitializer);
            Result result = iDispatcher.dispatch((IASTNode)iCASTDesignatedInitializer.getOperand());
            if (result instanceof InitializerResult) {
                InitializerResult initializerResult = (InitializerResult)result;
                assert (!initializerResult.hasRootDesignator());
                InitializerResultBuilder initializerResultBuilder = new InitializerResultBuilder(initializerResult);
                initializerResultBuilder.setRootDesignator(n);
                return initializerResultBuilder.build();
            }
            if (result instanceof ExpressionResult) {
                ExpressionResult expressionResult = (ExpressionResult)result;
                return new InitializerResultBuilder().setRootExpressionResult(expressionResult).setRootDesignator(n).build();
            }
            throw new UnsupportedSyntaxException(cACSLLocation, "Unexpected result");
        }
        throw new UnsupportedSyntaxException(cACSLLocation, "Designators in initializers beyond simple designators are currently unsupported: " + iCASTDesignatedInitializer.getRawSignature());
    }

    private int getArrayCellNrFromArrayDesignator(IDispatcher iDispatcher, ILocation iLocation, ICASTArrayDesignator iCASTArrayDesignator, ICASTDesignatedInitializer iCASTDesignatedInitializer) {
        Result result = iDispatcher.dispatch((IASTNode)iCASTArrayDesignator.getSubscriptExpression());
        if (!(result instanceof ExpressionResult)) {
            throw new UnsupportedSyntaxException(iLocation, "Designators in initializers beyond simple designators are currently unsupported: " + iCASTDesignatedInitializer.getRawSignature());
        }
        ExpressionResult expressionResult = (ExpressionResult)result;
        ExpressionResult expressionResult2 = this.mExprResultTransformer.switchToRValue(expressionResult, iLocation, (IASTNode)iCASTDesignatedInitializer);
        return this.mTypeSizes.extractIntegerValue((RValue)expressionResult2.getLrValue()).intValueExact();
    }

    private static class InitializerInfo {
        private final ExpressionResult mExpressionResult;
        private final Collection<Overapprox> mOverApprs;
        private final Map<Integer, InitializerInfo> mElementInitInfos;
        private final boolean mMakeNondeterministicInitialization;
        private final List<InitializerResult> mUnusedListEntries;

        private InitializerInfo(ExpressionResult expressionResult, List<InitializerResult> list) {
            assert (expressionResult.getLrValue() == null || expressionResult.getLrValue() instanceof RValue) : "switch to RValue first!";
            this.mExpressionResult = expressionResult;
            this.mOverApprs = expressionResult.getOverapprs();
            this.mElementInitInfos = Collections.emptyMap();
            this.mUnusedListEntries = list;
            this.mMakeNondeterministicInitialization = false;
        }

        public InitializerInfo(Map<Integer, InitializerInfo> map, List<InitializerResult> list) {
            this.mExpressionResult = null;
            this.mOverApprs = Collections.emptyList();
            this.mElementInitInfos = map;
            this.mUnusedListEntries = list;
            this.mMakeNondeterministicInitialization = false;
        }

        public InitializerInfo(Overapprox overapprox) {
            this.mExpressionResult = null;
            this.mOverApprs = Collections.singletonList(overapprox);
            this.mElementInitInfos = Collections.emptyMap();
            this.mUnusedListEntries = Collections.emptyList();
            this.mMakeNondeterministicInitialization = true;
        }

        private List<InitializerResult> getUnusedListEntries() {
            return Collections.unmodifiableList(this.mUnusedListEntries);
        }

        public boolean hasExpressionResult() {
            return this.mExpressionResult != null;
        }

        public RValue getRValue() {
            return (RValue)this.mExpressionResult.getLrValue();
        }

        public ExpressionResult getExpressionResult() {
            return this.mExpressionResult;
        }

        public boolean hasInitInfoForIndex(Integer n) {
            return this.mElementInitInfos.containsKey(n);
        }

        public InitializerInfo getInitInfoForIndex(Integer n) {
            assert (this.mElementInitInfos.get(n) != null);
            return this.mElementInitInfos.get(n);
        }

        public Collection<Overapprox> getOverapprs() {
            return this.mOverApprs;
        }

        public int getNumberOfValues() {
            int n = 0;
            if (this.hasExpressionResult()) {
                ++n;
            }
            for (Map.Entry<Integer, InitializerInfo> entry : this.mElementInitInfos.entrySet()) {
                n += entry.getValue().getNumberOfValues();
            }
            return n;
        }

        public boolean isMakeNondeterministicInitialization() {
            return this.mMakeNondeterministicInitialization;
        }

        public String toString() {
            if (this.mExpressionResult != null) {
                return this.mExpressionResult.toString();
            }
            if (this.mElementInitInfos != null) {
                return this.mElementInitInfos.toString();
            }
            if (this.mMakeNondeterministicInitialization) {
                return "nondeterministic initinfo";
            }
            return "?";
        }
    }
}

