/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRestoreNodesBeforeRemove;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.RemoveCcElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RemoveWeqCcElement<NODE extends IEqNodeIdentifier<NODE>>
implements IRemovalInfo<NODE>,
IRestoreNodesBeforeRemove<NODE> {
    private final NODE mElem;
    private final boolean mIntroduceNewNodes;
    private final boolean mMadeChanges;
    private Set<NODE> mElementsToRemove;
    private final Set<NODE> mElementsAlreadyRemoved = new HashSet<NODE>();
    private final Set<NODE> mAddedNodes;
    private boolean mDidRemoval = false;
    private WeqCongruenceClosure<NODE> mWeqCc;

    public RemoveWeqCcElement(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, boolean bl) {
        assert (!NODE.isFunctionApplication()) : "unexpected..";
        if (weqCongruenceClosure.isInconsistent(false)) {
            throw new IllegalStateException();
        }
        if (weqCongruenceClosure.isDebugMode()) {
            weqCongruenceClosure.getLogger().debug((Object)("RemoveElement " + this.hashCode() + " : removing " + String.valueOf(NODE) + " from " + weqCongruenceClosure.hashCode()));
        }
        if (!weqCongruenceClosure.hasElement(NODE)) {
            this.mElem = null;
            this.mMadeChanges = false;
            this.mAddedNodes = Collections.emptySet();
            this.mIntroduceNewNodes = false;
            this.mDidRemoval = true;
            return;
        }
        this.mWeqCc = weqCongruenceClosure;
        this.mElem = NODE;
        this.mIntroduceNewNodes = bl;
        this.mMadeChanges = false;
        this.mAddedNodes = !this.mIntroduceNewNodes ? null : new HashSet();
    }

    public Set<NODE> getAddedNodes() {
        assert (this.mDidRemoval);
        return this.mAddedNodes;
    }

    public Collection<NODE> getAlreadyRemovedElements() {
        return this.mElementsAlreadyRemoved;
    }

    public void doRemoval() {
        IEqNodeIdentifier iEqNodeIdentifier2;
        assert (!this.mDidRemoval);
        Set<NODE> set = this.mWeqCc.collectElementsToRemove(this.mElem);
        this.mElementsToRemove = Collections.unmodifiableSet(set);
        assert (set.stream().allMatch(iEqNodeIdentifier -> CongruenceClosure.dependsOnAny((ICongruenceClosureElement)iEqNodeIdentifier, Collections.singleton(this.mElem))));
        HashMap<IEqNodeIdentifier, IEqNodeIdentifier> hashMap = new HashMap<IEqNodeIdentifier, IEqNodeIdentifier>();
        for (IEqNodeIdentifier iEqNodeIdentifier3 : set) {
            iEqNodeIdentifier2 = this.mWeqCc.getOtherEquivalenceClassMember(iEqNodeIdentifier3, set);
            if (iEqNodeIdentifier2 == null) continue;
            hashMap.put(iEqNodeIdentifier3, iEqNodeIdentifier2);
        }
        assert (DataStructureUtils.intersection(new HashSet(hashMap.values()), set).isEmpty());
        assert (this.nodeAndReplacementAreEquivalent(hashMap, this.mWeqCc));
        assert (!this.mWeqCc.isInconsistent(false));
        boolean bl = false;
        bl = RemoveCcElement.addNodesToKeepInformation((IRestoreNodesBeforeRemove)this, set, hashMap);
        this.mWeqCc.reportAllConstraintsFromWeqGraph(false);
        if (bl) {
            assert (this.mWeqCc.isInconsistent(false));
            this.mDidRemoval = true;
            return;
        }
        assert (this.nodeAndReplacementAreEquivalent(hashMap, this.mWeqCc));
        assert (!this.mWeqCc.isInconsistent(false));
        assert (!this.mWeqCc.isInconsistent(false));
        this.mWeqCc.fatten();
        Set<NODE> set2 = this.mWeqCc.removeElementAndDependents(this.mElem, set, hashMap);
        this.mWeqCc.thin();
        if (!this.mWeqCc.getManager().getSettings().omitSanitycheckFineGrained1()) assert (this.mWeqCc.getCongruenceClosure().sanityCheck());
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            iEqNodeIdentifier2 = (IEqNodeIdentifier)iterator.next();
            this.mWeqCc.addElementRec(iEqNodeIdentifier2);
            if (!this.mWeqCc.isInconsistent(false)) continue;
            if (this.mWeqCc.isDebugMode()) {
                this.mWeqCc.getLogger().debug((Object)("RemoveElement: " + this.mWeqCc.hashCode() + " became inconsistent when adding" + String.valueOf(iEqNodeIdentifier2)));
            }
            this.mDidRemoval = true;
            return;
        }
        assert (this.mWeqCc.sanityCheck());
        this.mWeqCc.extAndTriangleClosure(false);
        if (this.mWeqCc.isDebugMode() && this.mWeqCc.isInconsistent(false)) {
            this.mWeqCc.getLogger().debug((Object)("RemoveElement: " + this.mWeqCc.hashCode() + " became inconsistent during closure operation"));
        }
        this.mDidRemoval = true;
        assert (this.mWeqCc.sanityCheck());
        if (this.mWeqCc.isDebugMode()) {
            this.mWeqCc.getLogger().debug((Object)("RemoveElement " + this.hashCode() + " finished normally"));
        }
    }

    private boolean nodeAndReplacementAreEquivalent(Map<NODE, NODE> map, WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        for (Map.Entry<NODE, NODE> entry : map.entrySet()) {
            if (weqCongruenceClosure.getEqualityStatus((IEqNodeIdentifier)entry.getKey(), (IEqNodeIdentifier)entry.getValue()) == EqualityStatus.EQUAL) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean madeChanges() {
        assert (this.mDidRemoval);
        return this.mMadeChanges;
    }

    public Set<NODE> getRemovedElements() {
        return this.mElementsToRemove;
    }

    public String toString() {
        return this.mElementsToRemove.toString();
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> void removeSimpleElement(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE) {
        RemoveWeqCcElement.removeSimpleElement(weqCongruenceClosure, NODE, true);
    }

    private static <NODE extends IEqNodeIdentifier<NODE>> RemoveWeqCcElement<NODE> removeSimpleElement(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, boolean bl) {
        if (NODE.isFunctionApplication()) {
            throw new IllegalArgumentException();
        }
        if (weqCongruenceClosure.isInconsistent(false)) {
            throw new IllegalStateException();
        }
        assert (weqCongruenceClosure.getElementCurrentlyBeingRemoved() == null);
        RemoveWeqCcElement<NODE> removeWeqCcElement = new RemoveWeqCcElement<NODE>(weqCongruenceClosure, NODE, bl);
        if (!weqCongruenceClosure.hasElement(NODE)) {
            assert (!removeWeqCcElement.madeChanges());
            assert (removeWeqCcElement.getAddedNodes().isEmpty());
            return removeWeqCcElement;
        }
        weqCongruenceClosure.setElementCurrentlyBeingRemoved(removeWeqCcElement);
        removeWeqCcElement.doRemoval();
        assert (weqCongruenceClosure.assertSimpleElementIsFullyRemoved(NODE));
        if (!weqCongruenceClosure.getManager().getSettings().omitSanitycheckFineGrained1()) assert (weqCongruenceClosure.sanityCheck());
        weqCongruenceClosure.setElementCurrentlyBeingRemoved(null);
        assert (weqCongruenceClosure.assertSimpleElementIsFullyRemoved(NODE));
        assert (weqCongruenceClosure.sanityCheck());
        return removeWeqCcElement;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> Set<NODE> removeSimpleElementDontUseWeqGpaTrackAddedNodes(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE) {
        RemoveWeqCcElement<NODE> removeWeqCcElement = RemoveWeqCcElement.removeSimpleElement(weqCongruenceClosure, NODE, true);
        return removeWeqCcElement.getAddedNodes();
    }

    public boolean isIntroduceNewNodes() {
        return this.mIntroduceNewNodes;
    }

    public NODE getElem() {
        return this.mElem;
    }

    public IElementRemovalTarget<NODE> getElementContainer() {
        return this.mWeqCc;
    }

    public void registerAddedNodes(Set<NODE> set) {
        this.mAddedNodes.addAll(set);
    }
}

