/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.util;

import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class UnionFindBackedSetOfPairs<E>
implements ISetOfPairs<E, Collection<Set<E>>> {
    private final UnionFind<E> mUnionFind = new UnionFind();
    private Collection<Set<E>> mPartition;
    private PartitionBackedSetOfPairs.PartitionSizeInformation mPartitionSizeInformation;

    @Override
    public Iterator<Pair<E, E>> iterator() {
        Iterator<Set<E>> iterator;
        if (this.mPartition == null) {
            this.mPartition = this.mUnionFind.getAllEquivalenceClasses();
        }
        if ((iterator = this.mPartition.iterator()).hasNext()) {
            return new PartitionBackedSetOfPairs.IteratorFromPartition<E>(iterator);
        }
        return Collections.emptyIterator();
    }

    @Override
    public void addPair(E e, E e2) {
        if (this.mPartition != null) {
            throw new IllegalStateException("final partition already constructed, unable to add new pairs");
        }
        this.mUnionFind.findAndConstructEquivalenceClassIfNeeded(e);
        this.mUnionFind.findAndConstructEquivalenceClassIfNeeded(e2);
        this.mUnionFind.union(e, e2);
    }

    @Override
    public boolean containsPair(E e, E e2) {
        Object object = this.mUnionFind.find(e);
        Object object2 = this.mUnionFind.find(e2);
        return object.equals(object2);
    }

    @Override
    public Collection<Set<E>> getRelation() {
        if (this.mPartition == null) {
            this.mPartition = this.mUnionFind.getAllEquivalenceClasses();
        }
        return this.mPartition;
    }

    public PartitionBackedSetOfPairs.PartitionSizeInformation getOrConstructPartitionSizeInformation() {
        if (this.mPartition == null) {
            this.mPartition = this.mUnionFind.getAllEquivalenceClasses();
        }
        if (this.mPartitionSizeInformation == null) {
            this.mPartitionSizeInformation = new PartitionBackedSetOfPairs.PartitionSizeInformation(this.mPartition);
        }
        return this.mPartitionSizeInformation;
    }

    public String toString() {
        return this.mUnionFind.toString();
    }

    @Deprecated
    public UnionFind<E> getUnionFind() {
        return this.mUnionFind;
    }
}

