/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class AtomicStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(AtomicStatement.class);
    Statement[] body;

    public AtomicStatement(ILocation iLocation, Statement[] statementArray) {
        super(iLocation);
        this.body = statementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid AtomicStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AtomicStatement").append('[');
        if (this.body == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.body.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.body[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Statement[] getBody() {
        return this.body;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.body != null) {
            list.addAll(Arrays.asList(this.body));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.body != null) {
            Statement[] statementArray = this.body;
            int n = this.body.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                statement.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (this.body != null) {
            Statement[] statementArray = this.body;
            int n = this.body.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement2 = statementArray[n2];
                Statement statement3 = statement2.accept(generatedBoogieAstTransformer);
                bl = bl || statement3 != statement2;
                arrayList.add(statement3);
                ++n2;
            }
        }
        if (bl) {
            return new AtomicStatement(this.loc, arrayList.toArray(new Statement[0]));
        }
        return this;
    }
}

