/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationResultReporter;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.MainDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.BoogieProcedureInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.LocalLValueILocationPair;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryArea;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureSignature;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.SymbolTableValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ContractResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.SkipResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.OverapproxVariable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.ASTNameCollector;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;

public class FunctionHandler {
    private final LinkedHashSet<ProcedureSignature> mFunctionSignaturesThatHaveAFunctionPointer;
    private final ExpressionTranslation mExpressionTranslation;
    private final ProcedureManager mProcedureManager;
    private final ILogger mLogger;
    private final INameHandler mNameHandler;
    private final ITypeHandler mTypeHandler;
    private final CTranslationResultReporter mReporter;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final CHandler mCHandler;
    private final LocationFactory mLocationFactory;
    private final FlatSymbolTable mSymboltable;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final Set<IASTNode> mVariablesOnHeap;
    private final Set<String> mCalledFunctions;
    private final Set<String> mDefinedFunctions;
    private final IMemoryPointer mMemoryPointer;

    public FunctionHandler(ILogger iLogger, INameHandler iNameHandler, ExpressionTranslation expressionTranslation, ProcedureManager procedureManager, ITypeHandler iTypeHandler, CTranslationResultReporter cTranslationResultReporter, AuxVarInfoBuilder auxVarInfoBuilder, CHandler cHandler, LocationFactory locationFactory, FlatSymbolTable flatSymbolTable, ExpressionResultTransformer expressionResultTransformer, Set<IASTNode> set, IMemoryPointer iMemoryPointer) {
        this.mLogger = iLogger;
        this.mNameHandler = iNameHandler;
        this.mExpressionTranslation = expressionTranslation;
        this.mProcedureManager = procedureManager;
        this.mTypeHandler = iTypeHandler;
        this.mReporter = cTranslationResultReporter;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mCHandler = cHandler;
        this.mLocationFactory = locationFactory;
        this.mFunctionSignaturesThatHaveAFunctionPointer = new LinkedHashSet();
        this.mSymboltable = flatSymbolTable;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mVariablesOnHeap = set;
        this.mCalledFunctions = new HashSet<String>();
        this.mDefinedFunctions = new HashSet<String>();
        this.mMemoryPointer = iMemoryPointer;
    }

    public Result handleFunctionDeclarator(IDispatcher iDispatcher, ILocation iLocation, List<ACSLNode> list, CDeclaration cDeclaration, IASTDeclarator iASTDeclarator) {
        String string = cDeclaration.getName();
        de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction = (de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction)cDeclaration.getType();
        this.registerFunctionDeclaration(iDispatcher, iLocation, list, string, cFunction, iASTDeclarator);
        this.mNameHandler.addFunction(string, cFunction.getResultType());
        return new SkipResult();
    }

    public Result handleFunctionDefinition(IDispatcher iDispatcher, MemoryHandler memoryHandler, IASTFunctionDefinition iASTFunctionDefinition, CDeclaration cDeclaration, List<ACSLNode> list, boolean bl) {
        Object object;
        Object object2;
        Procedure procedure;
        Specification[] specificationArray;
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTFunctionDefinition);
        String string = cDeclaration.getName();
        this.mDefinedFunctions.add(string);
        BoogieProcedureInfo boogieProcedureInfo = this.mProcedureManager.getOrConstructProcedureInfo(string);
        this.mProcedureManager.beginProcedureScope(this.mCHandler, boogieProcedureInfo);
        de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction = (de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction)cDeclaration.getType();
        de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction2 = FunctionHandler.updateVarArgsUsage(cACSLLocation, iASTFunctionDefinition, cFunction, string);
        ICType iCType = cFunction2.getResultType();
        this.mNameHandler.addFunction(string, iCType);
        boogieProcedureInfo.updateCFunction(cFunction2);
        boolean bl2 = iCType.isVoidType();
        VarList[] varListArray = this.processInParams(cACSLLocation, cFunction2, boogieProcedureInfo, (IASTNode)iASTFunctionDefinition);
        if (FunctionHandler.isInParamVoid(varListArray)) {
            varListArray = new VarList[]{};
        }
        VarList[] varListArray2 = new VarList[1];
        ASTType aSTType = this.mTypeHandler.cType2AstType(cACSLLocation, iCType);
        if (bl2) {
            varListArray2 = new VarList[]{};
        } else if (this.mProcedureManager.isCalledBeforeDeclared(boogieProcedureInfo)) {
            specificationArray = new CPrimitive(CPrimitive.CPrimitives.INT);
            varListArray2[0] = new VarList((ILocation)cACSLLocation, new String[]{"#res"}, this.mTypeHandler.cType2AstType(cACSLLocation, (ICType)specificationArray));
        } else {
            assert (aSTType != null);
            varListArray2[0] = new VarList((ILocation)cACSLLocation, new String[]{"#res"}, aSTType);
        }
        specificationArray = this.makeBoogieSpecFromACSLContract(iDispatcher, list, boogieProcedureInfo, (IASTDeclarator)iASTFunctionDefinition.getDeclarator());
        if (!boogieProcedureInfo.hasDeclaration()) {
            procedure = new Procedure[]{};
            object2 = new String[]{};
            object = new Procedure((ILocation)cACSLLocation, (Attribute[])procedure, string, (String[])object2, varListArray, varListArray2, specificationArray, null);
            boogieProcedureInfo.setDeclaration((Procedure)object);
        } else {
            Object object3;
            procedure = boogieProcedureInfo.getDeclaration();
            object2 = procedure.getInParams();
            boolean bl3 = true;
            if (varListArray.length != procedure.getInParams().length || varListArray2.length != procedure.getOutParams().length || FunctionHandler.isInParamVoid(procedure.getInParams())) {
                if (procedure.getInParams().length != 0 && !cFunction2.hasVarArgs()) {
                    throw new IncorrectSyntaxException(cACSLLocation, "Implementation does not match declaration!");
                }
                bl3 = false;
                object2 = varListArray;
            }
            if (bl3) {
                object3 = new ASTTypeComparisonVisitor();
                int n = 0;
                while (n < varListArray.length) {
                    boolean bl4 = ((ASTTypeComparisonVisitor)((Object)object3)).isSimilar(varListArray[n], procedure.getInParams()[n]);
                    if (!bl4) {
                        String string2 = "Implementation does not match declaration! Type missmatch on in-parameters! " + varListArray.length + " arguments, " + procedure.getInParams().length + " parameters, first missmatch at position " + n + ", argument type " + BoogiePrettyPrinter.print((ASTType)varListArray[n].getType()) + ", param type " + BoogiePrettyPrinter.print((VarList)procedure.getInParams()[n]);
                        throw new IncorrectSyntaxException(cACSLLocation, string2);
                    }
                    ++n;
                }
            }
            object3 = Arrays.asList(procedure.getSpecification());
            ArrayList<Specification> arrayList = new ArrayList<Specification>(Arrays.asList(specificationArray));
            arrayList.addAll((Collection<Specification>)object3);
            specificationArray = arrayList.toArray(new Specification[arrayList.size()]);
            procedure = new Procedure(procedure.getLocation(), procedure.getAttributes(), procedure.getIdentifier(), procedure.getTypeParams(), (VarList[])object2, procedure.getOutParams(), specificationArray, null);
            boogieProcedureInfo.resetDeclaration(procedure);
        }
        procedure = boogieProcedureInfo.getDeclaration();
        object2 = new Procedure(procedure.getLocation(), procedure.getAttributes(), procedure.getIdentifier(), procedure.getTypeParams(), varListArray, procedure.getOutParams(), procedure.getSpecification(), null);
        boogieProcedureInfo.resetDeclaration((Procedure)object2);
        object2 = new ExpressionResultBuilder();
        this.handleFunctionsInParams(iDispatcher, cACSLLocation, memoryHandler, (ExpressionResultBuilder)object2, iASTFunctionDefinition, bl);
        object = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTFunctionDefinition.getBody());
        ((ExpressionResultBuilder)object2).addAllExceptLrValue((ExpressionResult)object);
        this.mCHandler.updateStmtsAndDeclsAtScopeEnd((ExpressionResultBuilder)object2, (IASTNode)iASTFunctionDefinition);
        assert (((ExpressionResultBuilder)object2).getAuxVars().isEmpty()) : String.format("Body still contains aux vars: %s", ((ExpressionResultBuilder)object2).getAuxVars());
        assert (((ExpressionResultBuilder)object2).getOverappr().isEmpty());
        assert (((ExpressionResultBuilder)object2).getLrValue() == null);
        procedure = this.mProcedureManager.constructBody(cACSLLocation, ((ExpressionResultBuilder)object2).getDeclarations().toArray(new VariableDeclaration[((ExpressionResultBuilder)object2).getDeclarations().size()]), ((ExpressionResultBuilder)object2).getStatements().toArray(new Statement[((ExpressionResultBuilder)object2).getStatements().size()]), this.mProcedureManager.getCurrentProcedureID());
        object2 = boogieProcedureInfo.getDeclaration();
        object = new Procedure((ILocation)cACSLLocation, object2.getAttributes(), string, object2.getTypeParams(), varListArray, object2.getOutParams(), null, (Body)procedure);
        this.mProcedureManager.endProcedureScope(this.mCHandler);
        return new Result((BoogieASTNode)object);
    }

    private static de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction updateVarArgsUsage(ILocation iLocation, IASTFunctionDefinition iASTFunctionDefinition, de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction, String string) {
        if (cFunction.hasVarArgs() && cFunction.getVarArgsUsage() == CFunction.VarArgsUsage.UNKNOWN) {
            ASTNameCollector aSTNameCollector = new ASTNameCollector("va_start");
            iASTFunctionDefinition.getBody().accept((ASTVisitor)aSTNameCollector);
            ASTNameCollector aSTNameCollector2 = new ASTNameCollector("__builtin_va_start");
            iASTFunctionDefinition.getBody().accept((ASTVisitor)aSTNameCollector2);
            int n = aSTNameCollector.getNames().length + aSTNameCollector2.getNames().length;
            if (n > 1) {
                throw new UnsupportedSyntaxException(iLocation, string + " has multiple calls to va_start.");
            }
            return cFunction.updateVarArgsUsage(n != 0);
        }
        return cFunction;
    }

    private Result handleFunctionPointerCall(ILocation iLocation, IDispatcher iDispatcher, IASTExpression iASTExpression, IASTInitializerClause[] iASTInitializerClauseArray, MemoryHandler memoryHandler) {
        Object object;
        Object object2;
        assert (iASTExpression != null) : "functionName is null";
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTExpression);
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        if (!(iCType instanceof de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction) && iCType instanceof CPointer) {
            iCType = ((CPointer)iCType).getPointsToType().getUnderlyingType();
        }
        assert (iCType instanceof de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction) : "We need to unpack it further, right?";
        de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction = (de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction)iCType;
        if (cFunction.getParameterTypes().length == 0 && iASTInitializerClauseArray.length > 0) {
            object2 = new CDeclaration[iASTInitializerClauseArray.length];
            int n = 0;
            while (n < iASTInitializerClauseArray.length) {
                object = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[n]);
                object2[n] = new CDeclaration(((ExpressionResult)object).getLrValue().getCType(), "#param" + n);
                ++n;
            }
            cFunction = cFunction.newParameter((CDeclaration[])object2);
        }
        object2 = new ProcedureSignature(this.mTypeHandler, cFunction);
        this.mFunctionSignaturesThatHaveAFunctionPointer.add((ProcedureSignature)object2);
        String string = ((ProcedureSignature)object2).toString();
        object = FunctionHandler.addFPParamToCFunction(cFunction);
        this.registerFunctionDeclaration(iDispatcher, iLocation, null, string, (de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction)object, null);
        IASTInitializerClause[] iASTInitializerClauseArray2 = new IASTInitializerClause[iASTInitializerClauseArray.length + 1];
        System.arraycopy(iASTInitializerClauseArray, 0, iASTInitializerClauseArray2, 0, iASTInitializerClauseArray.length);
        iASTInitializerClauseArray2[iASTInitializerClauseArray2.length - 1] = iASTExpression;
        return this.handleFunctionCallGivenNameAndArguments(iDispatcher, iLocation, string, iASTInitializerClauseArray2, memoryHandler);
    }

    public Result handleFunctionCallExpression(IDispatcher iDispatcher, ILocation iLocation, IASTExpression iASTExpression, IASTInitializerClause[] iASTInitializerClauseArray, MemoryHandler memoryHandler) {
        if (!(iASTExpression instanceof IASTIdExpression)) {
            return this.handleFunctionPointerCall(iLocation, iDispatcher, iASTExpression, iASTInitializerClauseArray, memoryHandler);
        }
        String string = ((IASTIdExpression)iASTExpression).getName().toString();
        String string2 = this.mSymboltable.applyMultiparseRenaming(iASTExpression.getContainingFilename(), string);
        SymbolTableValue symbolTableValue = this.mSymboltable.findCSymbol((IASTNode)iASTExpression, string2);
        if (symbolTableValue != null && !(symbolTableValue.getDeclarationNode().getParent() instanceof IASTFunctionDefinition)) {
            return this.handleFunctionPointerCall(iLocation, iDispatcher, iASTExpression, iASTInitializerClauseArray, memoryHandler);
        }
        this.mCalledFunctions.add(string);
        return this.handleFunctionCallGivenNameAndArguments(iDispatcher, iLocation, string2, iASTInitializerClauseArray, memoryHandler);
    }

    public Result handleReturnStatement(IDispatcher iDispatcher, MemoryHandler memoryHandler, IASTReturnStatement iASTReturnStatement) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTReturnStatement);
        VarList[] varListArray = this.mProcedureManager.getCurrentProcedureInfo().getDeclaration().getOutParams();
        if (this.mProcedureManager.isCalledBeforeDeclared(this.mProcedureManager.getCurrentProcedureInfo()) && this.mProcedureManager.getCurrentProcedureInfo().getDeclaration().getOutParams().length == 0) {
            entry = varListArray[0].getIdentifiers()[0];
            var8_8 = ExpressionFactory.constructVariableLHS((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(varListArray[0].getType()), entry, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, this.mProcedureManager.getCurrentProcedureID()));
            var9_9 = new HavocStatement((ILocation)cACSLLocation, new VariableLHS[]{var8_8});
            expressionResultBuilder.addStatement((Statement)var9_9);
        } else if (iASTReturnStatement.getReturnValue() != null) {
            entry = CTranslationUtil.convertExpressionListToExpressionResultIfNecessary(this.mExprResultTransformer, cACSLLocation, iDispatcher.dispatch((IASTNode)iASTReturnStatement.getReturnValue()), (IASTNode)iASTReturnStatement.getReturnValue());
            entry = this.mExprResultTransformer.transformDecaySwitchRexBoolToInt((ExpressionResult)((Object)entry), cACSLLocation, (IASTNode)iASTReturnStatement.getReturnValue());
            var8_8 = this.mProcedureManager.getCurrentProcedureInfo().getCType().getResultType();
            if (!((ExpressionResult)((Object)entry)).getLrValue().getCType().equals(var8_8) && var8_8 instanceof CPointer && ((ExpressionResult)((Object)entry)).getLrValue().getCType() instanceof CPrimitive && ((ExpressionResult)((Object)entry)).getLrValue().getValue() instanceof IntegerLiteral && "0".equals(((IntegerLiteral)((ExpressionResult)((Object)entry)).getLrValue().getValue()).getValue())) {
                entry = new ExpressionResultBuilder().addAllExceptLrValue((ExpressionResult)((Object)entry)).setLrValue(new RValue(this.mMemoryPointer.constructNullPointer(cACSLLocation, this.mExpressionTranslation.getCTypeOfPointerComponents()), (ICType)var8_8)).build();
            }
            if (varListArray.length == 0) {
                this.mReporter.syntaxError(cACSLLocation, "This method is declared to be void, but returning a value!");
            } else {
                if (varListArray.length != 1) {
                    throw new UnsupportedSyntaxException(cACSLLocation, "We do not support several output parameters for functions");
                }
                var9_9 = varListArray[0].getIdentifiers()[0];
                VariableLHS variableLHS = ExpressionFactory.constructVariableLHS((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForCType((ICType)var8_8), (String)var9_9, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, this.mProcedureManager.getCurrentProcedureID()));
                VariableLHS[] variableLHSArray = new VariableLHS[]{variableLHS};
                entry = this.mExprResultTransformer.performImplicitConversion((ExpressionResult)((Object)entry), (ICType)var8_8, cACSLLocation);
                expressionResultBuilder.addAllIncludingLrValue((ExpressionResult)((Object)entry));
                RValue rValue = (RValue)((ExpressionResult)((Object)entry)).getLrValue();
                expressionResultBuilder.addStatementAndAnnotateOverapprox((Statement)StatementFactory.constructAssignmentStatement((ILocation)cACSLLocation, (LeftHandSide[])variableLHSArray, (Expression[])new Expression[]{rValue.getValue()}));
            }
        }
        expressionResultBuilder.addStatements(CTranslationUtil.createHavocsForAuxVars(expressionResultBuilder.getAuxVars()));
        for (Map.Entry<LocalLValueILocationPair, Integer> entry : memoryHandler.getVariablesToBeFreed().entrySet()) {
            if (entry.getValue() < 1) continue;
            expressionResultBuilder.addStatement((Statement)memoryHandler.getDeallocCall(entry.getKey().mLlv, entry.getKey().mLoc));
            expressionResultBuilder.addStatement((Statement)new HavocStatement((ILocation)cACSLLocation, new VariableLHS[]{(VariableLHS)entry.getKey().mLlv.getLhs()}));
        }
        expressionResultBuilder.addStatement((Statement)new ReturnStatement((ILocation)cACSLLocation));
        return expressionResultBuilder.build();
    }

    /*
     * Unable to fully structure code
     */
    private Result handleFunctionCallGivenNameAndArguments(IDispatcher var1_1, ILocation var2_2, String var3_3, IASTInitializerClause[] var4_4, MemoryHandler var5_5) {
        if (!this.mProcedureManager.hasProcedure(var3_3)) {
            this.mLogger.warn((Object)("implicit declaration of function " + var3_3));
            this.mProcedureManager.registerProcedure(var3_3);
            var6_6 = this.mProcedureManager.getProcedureInfo(var3_3);
            var6_6.setDefaultDeclarationAndCType(var2_2, this.mTypeHandler.cType2AstType(var2_2, new CPrimitive(CPrimitive.CPrimitives.INT)));
        } else {
            var6_6 = this.mProcedureManager.getProcedureInfo(var3_3);
        }
        var7_7 = var6_6.getDeclaration();
        var8_8 = var6_6.getCType();
        if (!FunctionHandler.$assertionsDisabled && var7_7 == null) {
            throw new AssertionError();
        }
        var9_9 = var6_6.hasImplementation() == false && var7_7.getInParams().length == 0;
        FunctionHandler.checkNumberOfArguments(var2_2, var3_3, var4_4, var7_7, var8_8, var9_9);
        var10_10 = new ArrayList<Expression>();
        var11_11 = new ExpressionResultBuilder();
        var12_12 = new ArrayList<Object>();
        var13_13 = 0;
        while (var13_13 < var4_4.length) {
            block17: {
                var14_16 = var4_4[var13_13];
                var15_19 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(var1_1, var2_2, (IASTInitializerClause)var14_16);
                if (var15_19.getLrValue().getValue() == null) {
                    var16_20 = "Incorrect or invalid in-parameter! " + var2_2.toString();
                    throw new IncorrectSyntaxException(var2_2, (String)var16_20);
                }
                if (!var9_9) break block17;
                var6_6.updateCFunctionAddParam(new CDeclaration(var15_19.getLrValue().getCType(), "#in~" + var13_13));
                ** GOTO lbl45
            }
            if (var6_6.getCType() == null) ** GOTO lbl45
            if (var13_13 >= var8_8.getParameterTypes().length && var8_8.hasVarArgs()) {
                var16_20 = this.mExprResultTransformer.promoteToIntegerIfNecessary(var2_2, (ExpressionResult)var15_19);
                var12_12.add(var16_20);
                var11_11.addAllExceptLrValue((ExpressionResult)var16_20);
            } else {
                var16_20 = var6_6.getCType().getParameterTypes()[var13_13].getType().getUnderlyingType();
                if (var16_20 instanceof CPrimitive && (var17_21 = (CPrimitive)var16_20).getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE || var16_20 instanceof CEnum) {
                    var15_19 = this.mExprResultTransformer.rexBoolToInt((ExpressionResult)var15_19, var2_2);
                }
                if (var16_20 instanceof de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction) {
                    var16_20 = new CPointer((ICType)var16_20);
                }
                if (var16_20 instanceof CArray) {
                    var18_22 = (CArray)var16_20;
                    var16_20 = new CPointer(var18_22.getValueType());
                }
                var15_19 = this.mExprResultTransformer.performImplicitConversion((ExpressionResult)var15_19, (ICType)var16_20, var2_2);
lbl45:
                // 3 sources

                var11_11.addAllExceptLrValueAndOverapproximation((ExpressionResult)var15_19);
                var16_20 = var15_19.getLrValue();
                if (var15_19.getOverapprs().isEmpty()) {
                    var10_10.add(var16_20.getValue());
                } else {
                    var17_21 = this.mAuxVarInfoBuilder.constructAuxVarInfo(var2_2, var16_20.getCType(), SFO.AUXVAR.RETURNED);
                    var11_11.addAuxVarWithDeclaration((AuxVarInfo)var17_21);
                    var18_22 = StatementFactory.constructSingleAssignmentStatement((ILocation)var2_2, (LeftHandSide)var17_21.getLhs(), (Expression)var16_20.getValue());
                    for (Overapprox var19_23 : var15_19.getOverapprs()) {
                        new OverapproxVariable(var19_23.getOverapproximatedLocations()).annotate((IElement)var18_22);
                    }
                    var11_11.addStatement((Statement)var18_22);
                    var10_10.add((Expression)var17_21.getExp());
                }
            }
            ++var13_13;
        }
        if (var8_8 != null && var8_8.getVarArgsUsage() == CFunction.VarArgsUsage.USED) {
            var13_14 = this.mAuxVarInfoBuilder.constructAuxVarInfo(var2_2, this.mTypeHandler.constructPointerType(var2_2), SFO.AUXVAR.VARARGS_POINTER);
            var11_11.addAuxVarWithDeclaration(var13_14);
            var14_16 = new ArrayList<E>();
            var15_19 = this.mExpressionTranslation.getCTypeOfPointerComponents();
            var16_20 = this.mExpressionTranslation.constructLiteralForIntegerType(var2_2, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
            var17_21 = var5_5.addExpressionToPointer(var2_2, (Expression)var13_14.getExp(), (Expression)var16_20);
            for (Object var18_22 : var12_12) {
                var20_24 = var18_22.getCType().getUnderlyingType();
                var21_25 = var5_5.calculateSizeOf(var2_2, var20_24);
                var14_16.addAll(var5_5.getWriteCall(var2_2, new HeapLValue((Expression)var17_21, var20_24, null), var18_22.getLrValue().getValue(), var20_24, false));
                var17_21 = var5_5.addExpressionToPointer(var2_2, (Expression)var17_21, var21_25);
                var16_20 = this.mExpressionTranslation.constructArithmeticExpression(var2_2, 4, (Expression)var16_20, (CPrimitive)var15_19, var21_25, (CPrimitive)var15_19);
            }
            var11_11.addStatement((Statement)var5_5.getUltimateMemAllocCall((Expression)var16_20, var13_14.getLhs(), var2_2, MemoryArea.HEAP));
            var11_11.addStatements(var14_16);
            var10_10.add((Expression)var13_14.getExp());
        }
        if (var9_9) {
            var13_15 = new VarList[var6_6.getCType().getParameterTypes().length];
            var14_17 = 0;
            while (var14_17 < var13_15.length) {
                var13_15[var14_17] = new VarList(var2_2, new String[]{var6_6.getCType().getParameterTypes()[var14_17].getName()}, this.mTypeHandler.cType2AstType(var2_2, var6_6.getCType().getParameterTypes()[var14_17].getType()));
                ++var14_17;
            }
            var14_18 = new Procedure(var7_7.getLocation(), var7_7.getAttributes(), var7_7.getIdentifier(), var7_7.getTypeParams(), var13_15, var7_7.getOutParams(), var7_7.getSpecification(), var7_7.getBody());
            var6_6.resetDeclaration(var14_18);
        }
        return this.createFunctionCall(var2_2, var3_3, var11_11, var10_10);
    }

    private static void checkNumberOfArguments(ILocation iLocation, String string, IASTInitializerClause[] iASTInitializerClauseArray, Procedure procedure, de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction, boolean bl) {
        if (bl || iASTInitializerClauseArray.length == procedure.getInParams().length) {
            return;
        }
        if (procedure.getInParams().length == 1 && procedure.getInParams()[0].getType() == null && iASTInitializerClauseArray.length == 0) {
            return;
        }
        if (cFunction.hasVarArgs()) {
            return;
        }
        throw new IncorrectSyntaxException(iLocation, "Function call has incorrect number of in-params: " + string);
    }

    private Specification[] makeBoogieSpecFromACSLContract(IDispatcher iDispatcher, List<ACSLNode> list, BoogieProcedureInfo boogieProcedureInfo, IASTDeclarator iASTDeclarator) {
        Result result;
        if (list == null || list.isEmpty()) {
            return new Specification[0];
        }
        ArrayList<Specification> arrayList = new ArrayList<Specification>();
        for (ACSLNode aCSLNode : list) {
            result = iDispatcher.dispatch(aCSLNode, (IASTNode)iASTDeclarator);
            assert (result instanceof ContractResult);
            ContractResult contractResult = (ContractResult)result;
            arrayList.addAll(Arrays.asList(contractResult.getSpecs()));
        }
        for (Specification specification : arrayList) {
            if (!(specification instanceof ModifiesSpecification)) continue;
            boogieProcedureInfo.setModifiedGlobalsIsUsedDefined(true);
            result = (ModifiesSpecification)specification;
            boogieProcedureInfo.addModifiedGlobals(Arrays.asList(result.getIdentifiers()));
        }
        this.mCHandler.clearContract();
        return (Specification[])arrayList.toArray(Specification[]::new);
    }

    private VarList[] processInParams(ILocation iLocation, de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction, BoogieProcedureInfo boogieProcedureInfo, IASTNode iASTNode) {
        CDeclaration[] cDeclarationArray = cFunction.getParameterTypes();
        boolean bl = cFunction.hasVarArgs() && cFunction.getVarArgsUsage() == CFunction.VarArgsUsage.USED;
        int n = bl ? cDeclarationArray.length + 1 : cDeclarationArray.length;
        VarList[] varListArray = new VarList[n];
        int n2 = 0;
        while (n2 < cDeclarationArray.length) {
            CDeclaration cDeclaration = cDeclarationArray[n2];
            ASTType aSTType = cDeclaration.getType() instanceof CArray ? this.mTypeHandler.constructPointerType(iLocation) : this.mTypeHandler.cType2AstType(iLocation, cDeclaration.getType().getUnderlyingType());
            DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, boogieProcedureInfo.getProcedureName());
            String string = this.mNameHandler.getInParamIdentifier(cDeclaration.getName(), cDeclaration.getType(), declarationInformation);
            varListArray[n2] = new VarList(iLocation, new String[]{string}, aSTType);
            if (iASTNode != null) {
                this.mSymboltable.storeCSymbol(iASTNode, cDeclaration.getName(), new SymbolTableValue(string, null, aSTType, cDeclaration, declarationInformation, null, false));
            }
            ++n2;
        }
        if (bl) {
            varListArray[cDeclarationArray.length] = new VarList(iLocation, new String[]{"#varArgs"}, this.mTypeHandler.constructPointerType(iLocation));
        }
        boogieProcedureInfo.updateCFunctionReplaceParams(cDeclarationArray);
        return varListArray;
    }

    private void handleFunctionsInParams(IDispatcher iDispatcher, ILocation iLocation, MemoryHandler memoryHandler, ExpressionResultBuilder expressionResultBuilder, IASTFunctionDefinition iASTFunctionDefinition, boolean bl) {
        IASTDeclarator[] iASTDeclaratorArray;
        VarList[] varListArray = this.mProcedureManager.getCurrentProcedureInfo().getDeclaration().getInParams();
        if (varListArray.length == 0) {
            var10_8 = iASTFunctionDefinition.getDeclarator();
            if (var10_8 instanceof IASTStandardFunctionDeclarator) {
                var9_9 = (IASTStandardFunctionDeclarator)var10_8;
                assert (var9_9.getParameters().length == 0 || var9_9.getParameters().length == 1 && "".equals(var9_9.getParameters()[0].getDeclarator().getName().toString()));
            }
            iASTDeclaratorArray = new IASTDeclarator[]{};
        } else {
            var10_8 = iASTFunctionDefinition.getDeclarator();
            if (var10_8 instanceof IASTStandardFunctionDeclarator) {
                var9_9 = (IASTStandardFunctionDeclarator)var10_8;
                iASTDeclaratorArray = (IASTDeclarator[])Arrays.stream(var9_9.getParameters()).map(iASTParameterDeclaration -> iASTParameterDeclaration.getDeclarator()).toArray(IASTDeclarator[]::new);
            } else {
                IASTFunctionDeclarator iASTFunctionDeclarator = iASTFunctionDefinition.getDeclarator();
                if (iASTFunctionDeclarator instanceof ICASTKnRFunctionDeclarator) {
                    ICASTKnRFunctionDeclarator iCASTKnRFunctionDeclarator = (ICASTKnRFunctionDeclarator)iASTFunctionDeclarator;
                    iASTDeclaratorArray = (IASTDeclarator[])Arrays.stream(iCASTKnRFunctionDeclarator.getParameterNames()).map(iASTName -> iCASTKnRFunctionDeclarator.getDeclaratorForParameterName(iASTName)).toArray(IASTDeclarator[]::new);
                } else {
                    iASTDeclaratorArray = null;
                    assert (false) : "are we missing a type of function declarator??";
                }
            }
        }
        int n = 0;
        while (n < iASTDeclaratorArray.length) {
            VarList varList = varListArray[n];
            IASTDeclarator iASTDeclarator = iASTDeclaratorArray[n];
            String[] stringArray = varList.getIdentifiers();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                String string2 = this.mSymboltable.getCIdForBoogieId(string);
                ASTType aSTType = varList.getType();
                ICType iCType = this.mSymboltable.findCSymbol((IASTNode)iASTDeclarator, string2).getCType();
                if ("main".equals(this.mProcedureManager.getCurrentProcedureInfo().getProcedureName()) && (iCType instanceof CPointer || iCType instanceof CArray)) {
                    this.mSymboltable.removeCSymbol((IASTNode)iASTDeclarator, string2);
                } else {
                    boolean bl2 = false;
                    if (iDispatcher instanceof MainDispatcher) {
                        bl2 = this.mVariablesOnHeap.contains(iASTDeclarator.getParent());
                    }
                    DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.mProcedureManager.getCurrentProcedureInfo().getProcedureName());
                    String string3 = this.mNameHandler.getUniqueIdentifier((IASTNode)iASTFunctionDefinition, string2, 0, bl2, iCType, declarationInformation);
                    BoogieType boogieType = this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType);
                    if (bl2 || iCType instanceof CArray) {
                        aSTType = this.mTypeHandler.constructPointerType(iLocation);
                        this.mCHandler.addBoogieIdsOfHeapVars(string3);
                    }
                    VarList varList2 = new VarList(iLocation, new String[]{string3}, aSTType);
                    VariableDeclaration variableDeclaration = new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList2});
                    IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieType, (String)string, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, this.mProcedureManager.getCurrentProcedureInfo().getProcedureName()));
                    if (bl) {
                        this.mExpressionTranslation.addAssumeValueInRangeStatements(iLocation, (Expression)identifierExpression, iCType, expressionResultBuilder);
                    }
                    CACSLLocation cACSLLocation = LocationFactory.createIgnoreLocation(iLocation);
                    if (bl2 && !(iCType instanceof CArray)) {
                        var31_31 = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)string3, (DeclarationInformation)declarationInformation);
                        LocalLValue localLValue = new LocalLValue((LeftHandSide)var31_31, iCType, null);
                        memoryHandler.addVariableToBeFreed(new LocalLValueILocationPair(localLValue, cACSLLocation));
                        HeapLValue heapLValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, localLValue.getValue(), iCType, null);
                        ExpressionResult expressionResult = this.mCHandler.makeAssignment(cACSLLocation, heapLValue, Collections.emptyList(), new ExpressionResultBuilder().setLrValue(new RValue((Expression)identifierExpression, iCType)).build(), (IASTNode)iASTDeclarator);
                        expressionResultBuilder.addStatement((Statement)memoryHandler.getUltimateMemAllocCall(localLValue, cACSLLocation, MemoryArea.STACK));
                        expressionResultBuilder.addAllExceptLrValue(expressionResult);
                    } else {
                        var31_31 = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)boogieType, (String)string3, (DeclarationInformation)declarationInformation);
                        expressionResultBuilder.addStatement((Statement)StatementFactory.constructAssignmentStatement((ILocation)cACSLLocation, (LeftHandSide[])new LeftHandSide[]{var31_31}, (Expression[])new Expression[]{identifierExpression}));
                    }
                    assert (this.mSymboltable.containsCSymbol((IASTNode)iASTDeclarator, string2));
                    this.mSymboltable.storeCSymbol((IASTNode)iASTFunctionDefinition, string2, new SymbolTableValue(string3, (Declaration)variableDeclaration, aSTType, new CDeclaration(iCType, string2), declarationInformation, iASTDeclarator.getParent(), false));
                }
                ++n3;
            }
            ++n;
        }
    }

    private void registerFunctionDeclaration(IDispatcher iDispatcher, ILocation iLocation, List<ACSLNode> list, String string, de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction, IASTDeclarator iASTDeclarator) {
        Object object;
        BoogieProcedureInfo boogieProcedureInfo = this.mProcedureManager.getOrConstructProcedureInfo(string);
        this.mProcedureManager.beginProcedureScope(this.mCHandler, boogieProcedureInfo);
        VarList[] varListArray = this.processInParams(iLocation, cFunction, boogieProcedureInfo, (IASTNode)iASTDeclarator);
        boogieProcedureInfo.updateCFunction(FunctionHandler.updateVarArgsForDeclaration((IASTNode)iASTDeclarator, cFunction, iLocation, string));
        VarList[] varListArray2 = new VarList[1];
        Attribute[] attributeArray = new Attribute[]{};
        String[] stringArray = new String[]{};
        Specification[] specificationArray = this.makeBoogieSpecFromACSLContract(iDispatcher, list, boogieProcedureInfo, iASTDeclarator);
        if (cFunction.getResultType().isVoidType()) {
            if (this.mProcedureManager.isCalledBeforeDeclared(boogieProcedureInfo)) {
                varListArray2[0] = new VarList(iLocation, new String[]{"#res"}, (ASTType)new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_INT, "int"));
            } else {
                varListArray2 = new VarList[]{};
            }
        } else {
            object = this.mTypeHandler.cType2AstType(iLocation, cFunction.getResultType());
            varListArray2[0] = new VarList(iLocation, new String[]{"#res"}, object);
        }
        if (boogieProcedureInfo.hasDeclaration()) {
            object = Arrays.asList(boogieProcedureInfo.getDeclaration().getSpecification());
            ArrayList<Specification> arrayList = new ArrayList<Specification>(Arrays.asList(specificationArray));
            arrayList.addAll((Collection<Specification>)object);
            specificationArray = arrayList.toArray(new Specification[arrayList.size()]);
        }
        object = new Procedure(iLocation, attributeArray, boogieProcedureInfo.getProcedureName(), stringArray, varListArray, varListArray2, specificationArray, null);
        boogieProcedureInfo.resetDeclaration((Procedure)object);
        this.mProcedureManager.endProcedureScope(this.mCHandler);
    }

    private static de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction updateVarArgsForDeclaration(IASTNode iASTNode, de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction, ILocation iLocation, String string) {
        IBinding iBinding;
        IASTFunctionDeclarator iASTFunctionDeclarator;
        if (iASTNode instanceof IASTDeclarator && cFunction.hasVarArgs() && cFunction.getVarArgsUsage() == CFunction.VarArgsUsage.UNKNOWN && (iASTFunctionDeclarator = ((CFunction)(iBinding = ((IASTDeclarator)iASTNode).getName().resolveBinding())).getDefinition()) != null) {
            return FunctionHandler.updateVarArgsUsage(iLocation, (IASTFunctionDefinition)iASTFunctionDeclarator.getParent(), cFunction, string);
        }
        return cFunction;
    }

    public ExpressionResult createFunctionCall(ILocation iLocation, String string, List<Expression> list) {
        return this.createFunctionCall(iLocation, string, new ExpressionResultBuilder(), list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ExpressionResult createFunctionCall(ILocation iLocation, String string, ExpressionResultBuilder expressionResultBuilder, List<Expression> list) {
        ICType iCType;
        IdentifierExpression identifierExpression;
        CallStatement callStatement;
        BoogieProcedureInfo boogieProcedureInfo;
        if (this.mProcedureManager.hasProcedure(string)) {
            boogieProcedureInfo = this.mProcedureManager.getProcedureInfo(string);
            VarList[] varListArray = boogieProcedureInfo.getDeclaration().getOutParams();
            if (varListArray.length == 0) {
                callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[0], (String)string, (Expression[])list.toArray(new Expression[list.size()]));
                identifierExpression = null;
            } else {
                if (varListArray.length != 1) {
                    String string2 = "Cannot handle multiple out params! (makes no sense in the translation of a C program) " + iLocation.toString();
                    throw new AssertionError((Object)string2);
                }
                ASTType aSTType = varListArray[0].getType();
                AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, aSTType, SFO.AUXVAR.RETURNED);
                identifierExpression = auxVarInfo.getExp();
                VariableLHS variableLHS = auxVarInfo.getLhs();
                expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
                callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{variableLHS}, (String)string, (Expression[])list.toArray(new Expression[list.size()]));
            }
        } else {
            boogieProcedureInfo = this.mProcedureManager.getOrConstructProcedureInfo(string);
            this.mProcedureManager.registerCalledBeforeDeclaredFunction(boogieProcedureInfo);
            String string3 = "Method was called before it was declared: '" + string + "' unknown! Return value is assumed to be int ...";
            this.mReporter.warn(iLocation, string3);
            CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
            AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
            identifierExpression = auxVarInfo.getExp();
            expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
            callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{auxVarInfo.getLhs()}, (String)string, (Expression[])list.toArray(new Expression[list.size()]));
        }
        if (FunctionHandler.isSvcompAtomicallyExecutedFunction(string)) {
            expressionResultBuilder.addStatement((Statement)new AtomicStatement(iLocation, new Statement[]{callStatement}));
        } else {
            expressionResultBuilder.addStatement((Statement)callStatement);
        }
        ICType iCType2 = iCType = this.mProcedureManager.isCalledBeforeDeclared(boogieProcedureInfo) ? new CPrimitive(CPrimitive.CPrimitives.INT) : boogieProcedureInfo.getCType().getResultType();
        if (identifierExpression != null) {
            this.mExpressionTranslation.addAssumeValueInRangeStatements(iLocation, (Expression)identifierExpression, iCType, expressionResultBuilder);
        }
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResultBuilder.getDeclarations(), expressionResultBuilder.getAuxVars()));
        if (identifierExpression != null) {
            expressionResultBuilder.setLrValue(new RValue((Expression)identifierExpression, iCType));
        }
        return expressionResultBuilder.build();
    }

    private static boolean isSvcompAtomicallyExecutedFunction(String string) {
        return string.startsWith("__VERIFIER_atomic_") && !string.equals("__VERIFIER_atomic_begin") && !string.equals("__VERIFIER_atomic_end");
    }

    public Set<ProcedureSignature> getFunctionsSignaturesWithFunctionPointers() {
        return Collections.unmodifiableSet(this.mFunctionSignaturesThatHaveAFunctionPointer);
    }

    private Optional<Declaration> getDefaultImplementation(String string, CACSLPreferenceInitializer.UndefinedFunctionBehaviour undefinedFunctionBehaviour) {
        Procedure procedure = this.mProcedureManager.getProcedureDeclaration(string);
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreLocation(procedure.getLoc());
        return switch (undefinedFunctionBehaviour) {
            case CACSLPreferenceInitializer.UndefinedFunctionBehaviour.CRASH -> throw new IllegalArgumentException("Calls to undefined functions are not supported.");
            case CACSLPreferenceInitializer.UndefinedFunctionBehaviour.NON_DETERMINISTIC_RETURN -> Optional.empty();
            case CACSLPreferenceInitializer.UndefinedFunctionBehaviour.OVERAPPROXIMATE_BEHAVIOUR -> {
                Statement var5_5 = ExpressionTranslation.modelUnsupportedFeature(cACSLLocation, "undefined function " + string);
                Body var6_6 = this.mProcedureManager.constructBody(cACSLLocation, new VariableDeclaration[0], new Statement[]{var5_5}, string);
                Procedure var7_7 = new Procedure((ILocation)cACSLLocation, procedure.getAttributes(), string, procedure.getTypeParams(), procedure.getInParams(), procedure.getOutParams(), null, var6_6);
                yield Optional.of(var7_7);
            }
            default -> throw new MatchException(null, null);
        };
    }

    public Set<Declaration> handleFunctionsWithoutDefinitions(CACSLPreferenceInitializer.UndefinedFunctionBehaviour undefinedFunctionBehaviour) {
        Set set = DataStructureUtils.difference(this.mCalledFunctions, this.mDefinedFunctions);
        if (set.isEmpty()) {
            return Set.of();
        }
        this.mLogger.warn((Object)("The following functions are not defined or handled internally: " + String.join((CharSequence)", ", set)));
        return set.stream().flatMap(string -> this.getDefaultImplementation((String)string, undefinedFunctionBehaviour).stream()).collect(Collectors.toSet());
    }

    private static final boolean isInParamVoid(VarList[] varListArray) {
        if (varListArray.length > 0 && varListArray[0] == null) {
            throw new IllegalArgumentException("In-param cannot be null!");
        }
        return varListArray.length == 1 && varListArray[0].getType() == null;
    }

    private static de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction addFPParamToCFunction(de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction cFunction) {
        CDeclaration[] cDeclarationArray = new CDeclaration[cFunction.getParameterTypes().length + 1];
        int n = 0;
        while (n < cDeclarationArray.length - 1) {
            cDeclarationArray[n] = cFunction.getParameterTypes()[n];
            ++n;
        }
        cDeclarationArray[cDeclarationArray.length - 1] = new CDeclaration(CPointer.voidPointer(), "#fp");
        return cFunction.newParameter(cDeclarationArray);
    }

    private static final class ASTTypeComparisonVisitor
    extends GeneratedBoogieAstVisitor {
        private ASTType mOther;
        private boolean mResult;
        private boolean mIsFinished;

        private ASTTypeComparisonVisitor() {
        }

        public boolean isSimilar(ASTType aSTType, ASTType aSTType2) {
            if (!ASTTypeComparisonVisitor.isNonNull(aSTType, aSTType2)) {
                return ASTTypeComparisonVisitor.compareNull(aSTType, aSTType2);
            }
            this.mOther = aSTType2;
            this.mIsFinished = false;
            this.mResult = true;
            aSTType.accept((GeneratedBoogieAstVisitor)this);
            return this.mResult;
        }

        public boolean isSimilar(VarList varList, VarList varList2) {
            if (!ASTTypeComparisonVisitor.isNonNull(varList, varList2)) {
                return ASTTypeComparisonVisitor.compareNull(varList, varList2);
            }
            if (varList.getWhereClause() != null || varList2.getWhereClause() != null) {
                throw new UnsupportedOperationException("Not yet implemented: isSimilar for where clauses");
            }
            return this.isSimilar(varList.getType(), varList2.getType());
        }

        public boolean visit(ArrayType arrayType) {
            if (this.mIsFinished) {
                return false;
            }
            if (!(this.mOther instanceof ArrayType)) {
                return this.finishFalse();
            }
            ArrayType arrayType2 = (ArrayType)this.mOther;
            ASTType[] aSTTypeArray = arrayType.getIndexTypes();
            ASTType[] aSTTypeArray2 = arrayType2.getIndexTypes();
            ASTType aSTType = arrayType.getValueType();
            ASTType aSTType2 = arrayType2.getValueType();
            if (!ASTTypeComparisonVisitor.isNonNull(aSTTypeArray, aSTTypeArray2)) {
                if (ASTTypeComparisonVisitor.isNonNull(aSTType, aSTType2)) {
                    this.updateResult(ASTTypeComparisonVisitor.compareNull(aSTTypeArray, aSTTypeArray2) && ASTTypeComparisonVisitor.compareNull(aSTType, aSTType2));
                } else {
                    this.updateResult(false);
                }
                this.mIsFinished = true;
                return false;
            }
            if (this.visit(aSTTypeArray, aSTTypeArray2)) {
                this.mOther = aSTType2;
                aSTType.accept((GeneratedBoogieAstVisitor)this);
                if (this.mIsFinished) {
                    return false;
                }
            }
            this.mOther = arrayType2;
            return false;
        }

        public boolean visit(NamedType namedType) {
            if (this.mIsFinished) {
                return false;
            }
            if (!(this.mOther instanceof NamedType)) {
                return this.finishFalse();
            }
            NamedType namedType2 = (NamedType)this.mOther;
            if (!Objects.equals(namedType.getName(), namedType2.getName())) {
                return this.finishFalse();
            }
            ASTType[] aSTTypeArray = namedType.getTypeArgs();
            ASTType[] aSTTypeArray2 = namedType2.getTypeArgs();
            this.visit(aSTTypeArray, aSTTypeArray2);
            return false;
        }

        public boolean visit(PrimitiveType primitiveType) {
            if (this.mIsFinished) {
                return false;
            }
            if (!(this.mOther instanceof PrimitiveType)) {
                return this.finishFalse();
            }
            PrimitiveType primitiveType2 = (PrimitiveType)this.mOther;
            this.updateResult(Objects.equals(primitiveType.getName(), primitiveType2.getName()));
            return false;
        }

        public boolean visit(StructType structType) {
            VarList[] varListArray;
            if (this.mIsFinished) {
                return false;
            }
            if (!(this.mOther instanceof StructType)) {
                return this.finishFalse();
            }
            StructType structType2 = (StructType)this.mOther;
            VarList[] varListArray2 = structType.getFields();
            if (!ASTTypeComparisonVisitor.isNonNull(varListArray2, varListArray = structType2.getFields())) {
                this.updateResult(ASTTypeComparisonVisitor.compareNull(varListArray2, varListArray));
                this.mIsFinished = true;
                return false;
            }
            if (varListArray2.length != varListArray.length) {
                return this.finishFalse();
            }
            int n = 0;
            while (n < varListArray2.length) {
                VarList varList = varListArray2[n];
                VarList varList2 = varListArray[n];
                if (varList.getWhereClause() != null || varList2.getWhereClause() != null) {
                    throw new UnsupportedOperationException("Not yet implemented: where-clauses for struct nodes");
                }
                if (!ASTTypeComparisonVisitor.isNonNull(varList, varList2)) {
                    if (!ASTTypeComparisonVisitor.compareNull(varList, varList2)) {
                        return this.finishFalse();
                    }
                } else {
                    ASTType aSTType;
                    ASTType aSTType2 = varList.getType();
                    if (!ASTTypeComparisonVisitor.isNonNull(aSTType2, aSTType = varList2.getType())) {
                        if (!ASTTypeComparisonVisitor.compareNull(aSTType2, aSTType)) {
                            return this.finishFalse();
                        }
                    } else {
                        this.mOther = aSTType;
                        aSTType2.accept((GeneratedBoogieAstVisitor)this);
                        if (this.mIsFinished) {
                            return false;
                        }
                    }
                }
                ++n;
            }
            this.mOther = structType2;
            return false;
        }

        private boolean visit(ASTType[] aSTTypeArray, ASTType[] aSTTypeArray2) {
            if (aSTTypeArray.length != aSTTypeArray2.length) {
                return this.finishFalse();
            }
            ASTType aSTType = this.mOther;
            int n = 0;
            while (n < aSTTypeArray.length) {
                ASTType aSTType2 = aSTTypeArray[n];
                ASTType aSTType3 = aSTTypeArray2[n];
                if (!ASTTypeComparisonVisitor.isNonNull(aSTType2, aSTType3)) {
                    if (!ASTTypeComparisonVisitor.compareNull(aSTType2, aSTType3)) {
                        return this.finishFalse();
                    }
                } else {
                    this.mOther = aSTType3;
                    aSTType2.accept((GeneratedBoogieAstVisitor)this);
                    if (this.mIsFinished) {
                        return false;
                    }
                }
                ++n;
            }
            this.mOther = aSTType;
            return true;
        }

        private boolean finishFalse() {
            this.mResult = false;
            this.mIsFinished = true;
            return false;
        }

        private void updateResult(boolean bl) {
            boolean bl2 = this.mResult = this.mResult && bl;
            if (!this.mResult) {
                this.mIsFinished = true;
            }
        }

        private static boolean isNonNull(Object object, Object object2) {
            return object != null && object2 != null;
        }

        private static boolean compareNull(Object object, Object object2) {
            if (object == null && object2 == null) {
                return true;
            }
            if (object == null || object2 == null) {
                return false;
            }
            throw new IllegalArgumentException("Both arguments are non-null");
        }
    }
}

