/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CfgSmtToolkit {
    private final ManagedScript mManagedScript;
    private final ModifiableGlobalsTable mModifiableGlobalsTable;
    private final IIcfgSymbolTable mSymbolTable;
    private final OldVarsAssignmentCache mOldVarsAssignmentCache;
    private final Set<String> mProcedures;
    private final Map<String, List<ILocalProgramVar>> mInParams;
    private final Map<String, List<ILocalProgramVar>> mOutParams;
    private final IcfgEdgeFactory mIcfgEdgeFactory;
    private final ConcurrencyInformation mConcurrencyInformation;
    private final SmtFunctionsAndAxioms mSmtFunctionsAndAxioms;

    public CfgSmtToolkit(ModifiableGlobalsTable modifiableGlobalsTable, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, Set<String> set, Map<String, List<ILocalProgramVar>> map, Map<String, List<ILocalProgramVar>> map2, IcfgEdgeFactory icfgEdgeFactory, ConcurrencyInformation concurrencyInformation, SmtFunctionsAndAxioms smtFunctionsAndAxioms) {
        this.mManagedScript = managedScript;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mModifiableGlobalsTable = modifiableGlobalsTable;
        this.mOldVarsAssignmentCache = new OldVarsAssignmentCache(this.mManagedScript, this.mModifiableGlobalsTable);
        this.mProcedures = set;
        this.mInParams = map;
        this.mOutParams = map2;
        this.mIcfgEdgeFactory = icfgEdgeFactory;
        this.mConcurrencyInformation = concurrencyInformation;
        this.mSmtFunctionsAndAxioms = smtFunctionsAndAxioms;
    }

    public ManagedScript getManagedScript() {
        return this.mManagedScript;
    }

    public ManagedScript createFreshManagedScript(IUltimateServiceProvider iUltimateServiceProvider, SolverBuilder.SolverSettings solverSettings) {
        return this.createFreshManagedScript(iUltimateServiceProvider, solverSettings, solverSettings.getBaseNameOfDumpedScript());
    }

    public ManagedScript createFreshManagedScript(IUltimateServiceProvider iUltimateServiceProvider, SolverBuilder.SolverSettings solverSettings, String string) {
        Script script = SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)iUltimateServiceProvider, (SolverBuilder.SolverSettings)solverSettings, (String)string);
        ManagedScript managedScript = new ManagedScript(iUltimateServiceProvider, script);
        this.getSmtFunctionsAndAxioms().transferAllSymbols(script);
        return managedScript;
    }

    public ModifiableGlobalsTable getModifiableGlobalsTable() {
        return this.mModifiableGlobalsTable;
    }

    public OldVarsAssignmentCache getOldVarsAssignmentCache() {
        return this.mOldVarsAssignmentCache;
    }

    public IIcfgSymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public SmtFunctionsAndAxioms getSmtFunctionsAndAxioms() {
        return this.mSmtFunctionsAndAxioms;
    }

    public Set<String> getProcedures() {
        return this.mProcedures;
    }

    public Map<String, List<ILocalProgramVar>> getInParams() {
        return this.mInParams;
    }

    public Map<String, List<ILocalProgramVar>> getOutParams() {
        return this.mOutParams;
    }

    public IcfgEdgeFactory getIcfgEdgeFactory() {
        return this.mIcfgEdgeFactory;
    }

    public ConcurrencyInformation getConcurrencyInformation() {
        return this.mConcurrencyInformation;
    }
}

