/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProjectToSubnet<LETTER, PLACE> {
    private final BoundedPetriNet<LETTER, PLACE> mResult;
    private final Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> mInput2Projected;

    public ProjectToSubnet(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation, Set<PLACE> set) {
        this.mResult = new BoundedPetriNet(automataLibraryServices, iPetriNet.getAlphabet(), false);
        this.mInput2Projected = new HashMap<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>>();
        for (Object object : iPetriNet.getPlaces()) {
            if (set.contains(object)) continue;
            this.mResult.addPlace(object, iPetriNet.getInitialPlaces().contains(object), iPetriNet.isAccepting(object));
        }
        for (Transition transition : iPetriNet.getTransitions()) {
            HashSet hashSet = new HashSet(transition.getPredecessors());
            hashSet.removeAll(hashRelation.getImage((Object)transition));
            hashSet.removeAll(set);
            HashSet hashSet2 = new HashSet(transition.getSuccessors());
            hashSet2.removeAll(hashRelation.getImage((Object)transition));
            hashSet2.removeAll(set);
            Transition<LETTER, PLACE> transition2 = this.mResult.addTransition(transition.getSymbol(), ImmutableSet.of(hashSet), ImmutableSet.of(hashSet2));
            this.mInput2Projected.put(transition, transition2);
        }
    }

    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    public Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> getTransitionMapping() {
        return this.mInput2Projected;
    }
}

