/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;

public class MinimalProofChecker
extends NonRecursive {
    HashSet<Term> mAssertions;
    Script mSkript;
    LogProxy mLogger;
    ProofRules mProofRules;
    HashMap<Term, ProofLiteral[]> mCacheConv;
    HashMap<FunctionSymbol, LambdaTerm> mFunctionDefinitions;
    Stack<ProofLiteral[]> mStackResults = new Stack();
    int mNumOracles;
    int mNumAxioms;
    int mNumResolutions;
    int mNumAssertions;
    int mNumDefineFun;

    public MinimalProofChecker(Script script, LogProxy logProxy) {
        this.mSkript = script;
        this.mLogger = logProxy;
        this.mProofRules = new ProofRules(script.getTheory());
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        Term[] termArray = this.mSkript.getAssertions();
        this.mAssertions = new HashSet(termArray.length);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            this.mAssertions.add(formulaUnLet.transform(term));
            ++n2;
        }
    }

    public boolean check(Term term) {
        this.mNumDefineFun = 0;
        this.mNumAssertions = 0;
        this.mNumAxioms = 0;
        this.mNumResolutions = 0;
        this.mNumOracles = 0;
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        ProofLiteral[] proofLiteralArray = this.getProvedClause(formulaUnLet.unlet(term));
        if (proofLiteralArray != null && proofLiteralArray.length > 0) {
            this.reportError("The proof did not yield a contradiction but %s", Arrays.asList(proofLiteralArray));
            return false;
        }
        return true;
    }

    public int getNumberOfHoles() {
        return this.mNumOracles;
    }

    public int getNumberOfResolutions() {
        return this.mNumResolutions;
    }

    public int getNumberOfAxioms() {
        return this.mNumAxioms;
    }

    public int getNumberOfAssertions() {
        return this.mNumAssertions;
    }

    public int getNumberOfDefineFun() {
        return this.mNumDefineFun;
    }

    public ProofLiteral[] getProvedClause(Term term) {
        return this.getProvedClause(null, term);
    }

    public ProofLiteral[] getProvedClause(Map<FunctionSymbol, LambdaTerm> map, Term term) {
        this.mCacheConv = new HashMap();
        this.mFunctionDefinitions = new HashMap();
        if (map != null) {
            for (Map.Entry<FunctionSymbol, LambdaTerm> entry : map.entrySet()) {
                FunctionSymbol functionSymbol = entry.getKey();
                LambdaTerm lambdaTerm = entry.getValue();
                if (!(functionSymbol.isIntern() || functionSymbol.getDefinition() == null || functionSymbol.getDefinition() == lambdaTerm.getSubterm() && Arrays.equals(functionSymbol.getDefinitionVars(), lambdaTerm.getVariables()))) {
                    throw new AssertionError((Object)"Inconsistent function definition.");
                }
                this.mFunctionDefinitions.put(functionSymbol, lambdaTerm);
            }
        }
        this.run(new ProofWalker(term));
        assert (this.mStackResults.size() == 1);
        this.mCacheConv = null;
        return this.stackPop();
    }

    private void reportError(String string, Object ... objectArray) {
        this.mLogger.error(string, objectArray);
    }

    private void reportWarning(String string, Object ... objectArray) {
        this.mLogger.warn(string, objectArray);
    }

    void walk(Term term) {
        while (term instanceof AnnotatedTerm && !ProofRules.isAxiom(term) && !ProofRules.isDefineFun(term)) {
            term = ((AnnotatedTerm)term).getSubterm();
        }
        if (this.mCacheConv.containsKey(term)) {
            this.stackPush(this.mCacheConv.get(term), term);
            return;
        }
        if (ProofRules.isDefineFun(term)) {
            new DefineFunWalker((AnnotatedTerm)term).enqueue(this);
        } else if (ProofRules.isAxiom(term)) {
            this.stackPush(this.computeAxiom(term), term);
        } else if (ProofRules.isProofRule("res", term)) {
            new ResolutionWalker((ApplicationTerm)term).enqueue(this);
        } else {
            this.stackPush(this.checkAssert(term), term);
        }
    }

    ProofLiteral[] walkResolution(ApplicationTerm applicationTerm, ProofLiteral[] proofLiteralArray, ProofLiteral[] proofLiteralArray2) {
        ProofLiteral proofLiteral;
        ++this.mNumResolutions;
        HashSet<ProofLiteral> hashSet = new HashSet<ProofLiteral>();
        Term term = applicationTerm.getParameters()[0];
        ProofLiteral proofLiteral2 = new ProofLiteral(term, true);
        ProofLiteral proofLiteral3 = new ProofLiteral(term, false);
        boolean bl = false;
        ProofLiteral[] proofLiteralArray3 = proofLiteralArray;
        int n = proofLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            proofLiteral = proofLiteralArray3[n2];
            if (proofLiteral.equals(proofLiteral2)) {
                bl = true;
            } else {
                hashSet.add(proofLiteral);
            }
            ++n2;
        }
        if (!bl) {
            this.reportWarning("Could not find pivot %s in %s", proofLiteral2, Arrays.asList(proofLiteralArray));
        }
        bl = false;
        proofLiteralArray3 = proofLiteralArray2;
        n = proofLiteralArray2.length;
        n2 = 0;
        while (n2 < n) {
            proofLiteral = proofLiteralArray3[n2];
            if (proofLiteral.equals(proofLiteral3)) {
                bl = true;
            } else {
                hashSet.add(proofLiteral);
            }
            ++n2;
        }
        if (!bl) {
            this.reportWarning("Could not find pivot %s in %s", proofLiteral3, Arrays.asList(proofLiteralArray2));
        }
        return hashSet.toArray(new ProofLiteral[hashSet.size()]);
    }

    void stackPush(ProofLiteral[] proofLiteralArray, Term term) {
        this.mCacheConv.put(term, proofLiteralArray);
        this.mStackResults.push(proofLiteralArray);
    }

    ProofLiteral[] stackPop() {
        return this.mStackResults.pop();
    }

    public ProofLiteral[] computeAxiom(Term term) {
        ++this.mNumAxioms;
        Theory theory = term.getTheory();
        assert (ProofRules.isAxiom(term));
        Annotation[] annotationArray = ((AnnotatedTerm)term).getAnnotations();
        switch (annotationArray[0].getKey()) {
            case ":oracle": {
                ++this.mNumOracles;
                --this.mNumAxioms;
                this.reportWarning("Used oracle: %s", Arrays.asList(annotationArray).subList(1, annotationArray.length));
                ProofLiteral[] proofLiteralArray = ProofRules.proofLiteralsFromAnnotation((Object[])annotationArray[0].getValue());
                LinkedHashSet<ProofLiteral> linkedHashSet = new LinkedHashSet<ProofLiteral>(Arrays.asList(proofLiteralArray));
                return linkedHashSet.toArray(new ProofLiteral[linkedHashSet.size()]);
            }
            case ":true+": {
                return new ProofLiteral[]{new ProofLiteral(theory.term("true", new Term[0]), true)};
            }
            case ":false-": {
                return new ProofLiteral[]{new ProofLiteral(theory.term("false", new Term[0]), false)};
            }
            case ":not+": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("not")) {
                    this.reportError("Expected not application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, true), new ProofLiteral(applicationTerm.getParameters()[0], true)};
            }
            case ":not-": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("not")) {
                    this.reportError("Expected not application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, false), new ProofLiteral(applicationTerm.getParameters()[0], false)};
            }
            case ":or+": {
                assert (annotationArray.length == 2);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("or")) {
                    this.reportError("Expected or application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                assert (annotationArray[1].getKey().equals(":pos"));
                int n = (Integer)annotationArray[1].getValue();
                assert (n >= 0 && n < termArray.length);
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, true), new ProofLiteral(termArray[n], false)};
            }
            case ":or-": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("or")) {
                    this.reportError("Expected or application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                HashSet<ProofLiteral> hashSet = new HashSet<ProofLiteral>();
                hashSet.add(new ProofLiteral((Term)applicationTerm, false));
                Term[] termArray2 = termArray;
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray2[n2];
                    hashSet.add(new ProofLiteral(term2, true));
                    ++n2;
                }
                return hashSet.toArray(new ProofLiteral[hashSet.size()]);
            }
            case ":and+": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("and")) {
                    this.reportError("Expected and application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                HashSet<ProofLiteral> hashSet = new HashSet<ProofLiteral>();
                hashSet.add(new ProofLiteral((Term)applicationTerm, true));
                Term[] termArray3 = termArray;
                int n = termArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Term term3 = termArray3[n3];
                    hashSet.add(new ProofLiteral(term3, false));
                    ++n3;
                }
                return hashSet.toArray(new ProofLiteral[hashSet.size()]);
            }
            case ":and-": {
                assert (annotationArray.length == 2);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("and")) {
                    this.reportError("Expected and application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                assert (annotationArray[1].getKey().equals(":pos"));
                int n = (Integer)annotationArray[1].getValue();
                assert (n >= 0 && n < termArray.length);
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, false), new ProofLiteral(termArray[n], true)};
            }
            case ":=>+": {
                assert (annotationArray.length == 2);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=>")) {
                    this.reportError("Expected => application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                assert (annotationArray[1].getKey().equals(":pos"));
                int n = (Integer)annotationArray[1].getValue();
                assert (n >= 0 && n < termArray.length);
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, true), new ProofLiteral(termArray[n], n < termArray.length - 1)};
            }
            case ":=>-": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=>")) {
                    this.reportError("Expected => application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                HashSet<ProofLiteral> hashSet = new HashSet<ProofLiteral>();
                hashSet.add(new ProofLiteral((Term)applicationTerm, false));
                int n = 0;
                while (n < termArray.length) {
                    hashSet.add(new ProofLiteral(termArray[n], n == termArray.length - 1));
                    ++n;
                }
                return hashSet.toArray(new ProofLiteral[hashSet.size()]);
            }
            case ":=+1": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                if (termArray.length != 2 || termArray[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(term);
                }
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, true), new ProofLiteral(termArray[0], true), new ProofLiteral(termArray[1], true)};
            }
            case ":=+2": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                if (termArray.length != 2 || termArray[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(term);
                }
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, true), new ProofLiteral(termArray[0], false), new ProofLiteral(termArray[1], false)};
            }
            case ":=-1": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                if (termArray.length != 2 || termArray[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(term);
                }
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, false), new ProofLiteral(termArray[0], true), new ProofLiteral(termArray[1], false)};
            }
            case ":=-2": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                if (termArray.length != 2 || termArray[0].getSort().getName() != "Bool") {
                    return this.reportViolatedSideCondition(term);
                }
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, false), new ProofLiteral(termArray[0], false), new ProofLiteral(termArray[1], true)};
            }
            case ":xor+": {
                assert (annotationArray.length == 1);
                Term[][] termArray = (Term[][])annotationArray[0].getValue();
                assert (termArray.length == 3);
                if (!ProofRules.checkXorParams(termArray)) {
                    return this.reportViolatedSideCondition(term);
                }
                ProofLiteral[] proofLiteralArray = new ProofLiteral[3];
                int n = 0;
                while (n < 3) {
                    Term term4;
                    Term term5 = term4 = termArray[n].length == 1 ? termArray[n][0] : theory.term("xor", termArray[n]);
                    assert (term4 != null);
                    proofLiteralArray[n] = new ProofLiteral(term4, n < 2);
                    ++n;
                }
                return proofLiteralArray;
            }
            case ":xor-": {
                assert (annotationArray.length == 1);
                Term[][] termArray = (Term[][])annotationArray[0].getValue();
                assert (termArray.length == 3);
                if (!ProofRules.checkXorParams(termArray)) {
                    return this.reportViolatedSideCondition(term);
                }
                ProofLiteral[] proofLiteralArray = new ProofLiteral[3];
                int n = 0;
                while (n < 3) {
                    Term term6;
                    Term term7 = term6 = termArray[n].length == 1 ? termArray[n][0] : theory.term("xor", termArray[n]);
                    assert (term6 != null);
                    proofLiteralArray[n] = new ProofLiteral(term6, false);
                    ++n;
                }
                return proofLiteralArray;
            }
            case ":=+": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                ProofLiteral[] proofLiteralArray = new ProofLiteral[termArray.length];
                proofLiteralArray[0] = new ProofLiteral((Term)applicationTerm, true);
                int n = 0;
                while (n < termArray.length - 1) {
                    proofLiteralArray[n + 1] = new ProofLiteral(theory.term("=", new Term[]{termArray[n], termArray[n + 1]}), false);
                    ++n;
                }
                return proofLiteralArray;
            }
            case ":=-": {
                assert (annotationArray.length == 2);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("=")) {
                    this.reportError("Expected = application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                assert (annotationArray[1].getKey().equals(":pos"));
                Integer[] integerArray = (Integer[])annotationArray[1].getValue();
                assert (integerArray.length == 2);
                int n = integerArray[0];
                int n4 = integerArray[1];
                assert (n >= 0 && n < termArray.length && n4 >= 0 && n4 < termArray.length);
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, false), new ProofLiteral(theory.term("=", new Term[]{termArray[n], termArray[n4]}), true)};
            }
            case ":distinct+": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("distinct")) {
                    this.reportError("Expected distinct application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                ProofLiteral[] proofLiteralArray = new ProofLiteral[1 + n * (n - 1) / 2];
                proofLiteralArray[0] = new ProofLiteral((Term)applicationTerm, true);
                int n5 = 1;
                int n6 = 0;
                while (n6 < n - 1) {
                    int n7 = n6 + 1;
                    while (n7 < n) {
                        proofLiteralArray[n5++] = new ProofLiteral(theory.term("=", new Term[]{termArray[n6], termArray[n7]}), true);
                        ++n7;
                    }
                    ++n6;
                }
                assert (n5 == proofLiteralArray.length);
                return proofLiteralArray;
            }
            case ":distinct-": {
                assert (annotationArray.length == 2);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("distinct")) {
                    this.reportError("Expected distinct application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                assert (annotationArray[1].getKey().equals(":pos"));
                Integer[] integerArray = (Integer[])annotationArray[1].getValue();
                assert (integerArray.length == 2);
                int n = integerArray[0];
                int n8 = integerArray[1];
                assert (n >= 0 && n < termArray.length && n8 >= 0 && n8 < termArray.length);
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, false), new ProofLiteral(theory.term("=", new Term[]{termArray[n], termArray[n8]}), false)};
            }
            case ":ite1": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("ite")) {
                    this.reportError("Expected ite application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                assert (termArray.length == 3);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{applicationTerm, termArray[1]}), true), new ProofLiteral(termArray[0], false)};
            }
            case ":ite2": {
                assert (annotationArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)annotationArray[0].getValue();
                if (!applicationTerm.getFunction().isIntern() || !applicationTerm.getFunction().getName().equals("ite")) {
                    this.reportError("Expected ite application", new Object[0]);
                    return this.getTrueClause(applicationTerm.getTheory());
                }
                Term[] termArray = applicationTerm.getParameters();
                assert (termArray.length == 3);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{applicationTerm, termArray[2]}), true), new ProofLiteral(termArray[0], true)};
            }
            case ":del!": {
                assert (annotationArray.length == 1);
                Object[] objectArray = (Object[])annotationArray[0].getValue();
                assert (objectArray.length == 2);
                Term term8 = (Term)objectArray[0];
                Annotation[] annotationArray2 = ProofRules.convertSExprToAnnotation((Object[])objectArray[1]);
                Term term9 = theory.annotatedTerm(annotationArray2, term8);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term9, term8}), true)};
            }
            case ":refl": {
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 1);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{termArray[0], termArray[0]}), true)};
            }
            case ":symm": {
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 2);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", termArray), true), new ProofLiteral(theory.term("=", new Term[]{termArray[1], termArray[0]}), false)};
            }
            case ":trans": {
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length > 2);
                int n = termArray.length;
                ProofLiteral[] proofLiteralArray = new ProofLiteral[n];
                proofLiteralArray[0] = new ProofLiteral(theory.term("=", new Term[]{termArray[0], termArray[n - 1]}), true);
                int n9 = 0;
                while (n9 < n - 1) {
                    proofLiteralArray[n9 + 1] = new ProofLiteral(theory.term("=", new Term[]{termArray[n9], termArray[n9 + 1]}), false);
                    ++n9;
                }
                return proofLiteralArray;
            }
            case ":cong": {
                assert (annotationArray.length == 1);
                Object[] objectArray = (Object[])annotationArray[0].getValue();
                assert (objectArray.length == 3);
                FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
                Term[] termArray = (Term[])objectArray[1];
                Term[] termArray4 = (Term[])objectArray[2];
                assert (termArray.length == termArray4.length);
                Term term10 = theory.term(functionSymbol, termArray);
                Term term11 = theory.term(functionSymbol, termArray4);
                ProofLiteral[] proofLiteralArray = new ProofLiteral[termArray.length + 1];
                proofLiteralArray[0] = new ProofLiteral(theory.term("=", new Term[]{term10, term11}), true);
                int n = 0;
                while (n < termArray.length) {
                    proofLiteralArray[n + 1] = new ProofLiteral(theory.term("=", new Term[]{termArray[n], termArray4[n]}), false);
                    ++n;
                }
                return proofLiteralArray;
            }
            case ":expand": {
                Term term12;
                assert (annotationArray.length == 1);
                Object[] objectArray = (Object[])annotationArray[0].getValue();
                assert (objectArray.length == 2);
                FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
                Term[] termArray = (Term[])objectArray[1];
                Term term13 = theory.term(functionSymbol, termArray);
                if (this.mFunctionDefinitions.containsKey(functionSymbol)) {
                    LambdaTerm lambdaTerm = this.mFunctionDefinitions.get(functionSymbol);
                    term12 = theory.let(lambdaTerm.getVariables(), termArray, lambdaTerm.getSubterm());
                    term12 = new FormulaUnLet().unlet(term12);
                } else if (functionSymbol.getDefinition() != null) {
                    term12 = theory.let(functionSymbol.getDefinitionVars(), termArray, functionSymbol.getDefinition());
                    term12 = new FormulaUnLet().unlet(term12);
                } else if (functionSymbol.isLeftAssoc() && termArray.length > 2) {
                    term12 = termArray[0];
                    int n = 1;
                    while (n < termArray.length) {
                        term12 = theory.term(functionSymbol, new Term[]{term12, termArray[n]});
                        ++n;
                    }
                } else if (functionSymbol.isRightAssoc() && termArray.length > 2) {
                    term12 = termArray[termArray.length - 1];
                    int n = termArray.length - 2;
                    while (n >= 0) {
                        term12 = theory.term(functionSymbol, new Term[]{termArray[n], term12});
                        --n;
                    }
                } else if (functionSymbol.isChainable() && termArray.length > 2) {
                    Term[] termArray5 = new Term[termArray.length - 1];
                    int n = 0;
                    while (n < termArray5.length) {
                        termArray5[n] = theory.term(functionSymbol, new Term[]{termArray[n], termArray[n + 1]});
                        ++n;
                    }
                    term12 = theory.term("and", termArray5);
                } else {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term13, term12}), true)};
            }
            case ":exists-": 
            case ":forall+": {
                assert (annotationArray.length == 1);
                boolean bl = annotationArray[0].getKey().equals(":forall+");
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)annotationArray[0].getValue();
                if (quantifiedFormula.getQuantifier() != (bl ? 1 : 0)) {
                    this.reportError("Quantifier of wrong type", new Object[0]);
                    return this.getTrueClause(theory);
                }
                TermVariable[] termVariableArray = quantifiedFormula.getVariables();
                Term[] termArray = new ProofRules(theory).getSkolemVars(termVariableArray, quantifiedFormula.getSubformula(), bl);
                Term term14 = theory.let(termVariableArray, termArray, quantifiedFormula.getSubformula());
                return new ProofLiteral[]{new ProofLiteral((Term)quantifiedFormula, bl), new ProofLiteral(new FormulaUnLet().unlet(term14), !bl)};
            }
            case ":exists+": 
            case ":forall-": {
                assert (annotationArray.length == 2);
                boolean bl = annotationArray[0].getKey().equals(":forall-");
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)annotationArray[0].getValue();
                if (quantifiedFormula.getQuantifier() != (bl ? 1 : 0)) {
                    this.reportError("Quantifier of wrong type", new Object[0]);
                    return this.getTrueClause(theory);
                }
                TermVariable[] termVariableArray = quantifiedFormula.getVariables();
                assert (annotationArray[1].getKey() == ":values");
                Term[] termArray = (Term[])annotationArray[1].getValue();
                Term term15 = theory.let(termVariableArray, termArray, quantifiedFormula.getSubformula());
                return new ProofLiteral[]{new ProofLiteral((Term)quantifiedFormula, !bl), new ProofLiteral(new FormulaUnLet().unlet(term15), bl)};
            }
            case ":>def": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                if (termArray.length != 2) {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{theory.term(">", termArray), theory.term("<", new Term[]{termArray[1], termArray[0]})}), true)};
            }
            case ":>=def": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                if (termArray.length != 2) {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{theory.term(">=", termArray), theory.term("<=", new Term[]{termArray[1], termArray[0]})}), true)};
            }
            case ":trichotomy": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                if (termArray.length != 2) {
                    throw new AssertionError();
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("<", termArray), true), new ProofLiteral(theory.term("=", termArray), true), new ProofLiteral(theory.term("<", new Term[]{termArray[1], termArray[0]}), true)};
            }
            case ":total": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 2);
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", new Term[]{termArray[0], termArray[1]}), true), new ProofLiteral(theory.term("<", new Term[]{termArray[1], termArray[0]}), true)};
            }
            case ":total-int": {
                if (!theory.getLogic().hasIntegers() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Object[] objectArray = (Object[])annotationArray[0].getValue();
                assert (objectArray.length == 2);
                Term term16 = (Term)objectArray[0];
                BigInteger bigInteger = (BigInteger)objectArray[1];
                if (!term16.getSort().getName().equals("Int")) {
                    return this.reportViolatedSideCondition(term);
                }
                Rational rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
                Term term17 = rational.toTerm(term16.getSort());
                Term term18 = rational.add(Rational.ONE).toTerm(term16.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", new Term[]{term16, term17}), true), new ProofLiteral(theory.term("<=", new Term[]{term18, term16}), true)};
            }
            case ":farkas": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 2);
                assert (annotationArray[1].getKey() == ":coeffs");
                BigInteger[] bigIntegerArray = (BigInteger[])annotationArray[1].getValue();
                if (!ProofRules.checkFarkas(termArray, bigIntegerArray)) {
                    return this.reportViolatedSideCondition(term);
                }
                HashSet<ProofLiteral> hashSet = new HashSet<ProofLiteral>();
                int n = 0;
                while (n < termArray.length) {
                    hashSet.add(new ProofLiteral(termArray[n], false));
                    ++n;
                }
                return hashSet.toArray(new ProofLiteral[hashSet.size()]);
            }
            case ":mulpos": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 0);
                if (!ProofRules.checkMulPos(termArray)) {
                    return this.reportViolatedSideCondition(term);
                }
                HashSet<ProofLiteral> hashSet = new HashSet<ProofLiteral>();
                int n = 0;
                while (n < termArray.length) {
                    hashSet.add(new ProofLiteral(termArray[n], n == termArray.length - 1));
                    ++n;
                }
                return hashSet.toArray(new ProofLiteral[hashSet.size()]);
            }
            case ":poly+": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 2);
                if (!ProofRules.checkPolyAdd(termArray[0], termArray[1])) {
                    return this.reportViolatedSideCondition(term);
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{termArray[0], termArray[1]}), true)};
            }
            case ":poly*": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 2);
                if (!ProofRules.checkPolyMul(termArray[0], termArray[1])) {
                    return this.reportViolatedSideCondition(term);
                }
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{termArray[0], termArray[1]}), true)};
            }
            case ":to_real-def": {
                if (!theory.getLogic().isIRA()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 1);
                Term term19 = theory.term("to_real", new Term[]{termArray[0]});
                Term term20 = ProofRules.computePolyToReal(termArray[0]);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term19, term20}), true)};
            }
            case ":/def": {
                if (!theory.getLogic().hasReals()) {
                    this.reportError("Proof requires real arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length >= 2);
                Term term21 = theory.term("/", termArray);
                Term[] termArray6 = new Term[termArray.length];
                System.arraycopy(termArray, 1, termArray6, 0, termArray.length - 1);
                termArray6[termArray.length - 1] = term21;
                Term term22 = theory.term("*", termArray6);
                LinkedHashSet<ProofLiteral> linkedHashSet = new LinkedHashSet<ProofLiteral>();
                linkedHashSet.add(new ProofLiteral(theory.term("=", new Term[]{term22, termArray[0]}), true));
                int n = 1;
                while (n < termArray.length) {
                    linkedHashSet.add(new ProofLiteral(theory.term("=", new Term[]{termArray[n], Rational.ZERO.toTerm(termArray[n].getSort())}), true));
                    ++n;
                }
                return linkedHashSet.toArray(new ProofLiteral[linkedHashSet.size()]);
            }
            case ":-def": {
                if (!theory.getLogic().isArithmetic() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length >= 1);
                Term term23 = theory.term("-", termArray);
                Term term24 = ProofRules.computePolyMinus(term23);
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term23, term24}), true)};
            }
            case ":divisible-def": {
                if (!theory.getLogic().hasIntegers()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 2);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 1);
                assert (annotationArray[1].getKey() == ":divisor");
                BigInteger bigInteger = (BigInteger)annotationArray[1].getValue();
                Term term25 = termArray[0];
                if (bigInteger.signum() <= 0 || !term25.getSort().getName().equals("Int")) {
                    return this.reportViolatedSideCondition(term);
                }
                Term term26 = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE).toTerm(term25.getSort());
                Term term27 = theory.term("divisible", new String[]{bigInteger.toString()}, null, new Term[]{term25});
                Term term28 = theory.term("div", new Term[]{term25, term26});
                Term term29 = theory.term("*", new Term[]{term26, term28});
                Term term30 = theory.term("=", new Term[]{term25, term29});
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term27, term30}), true)};
            }
            case ":to_int-low": {
                if (!theory.getLogic().isIRA()) {
                    this.reportError("Proof requires integer and real arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 1);
                Term term31 = termArray[0];
                Term term32 = theory.term("to_real", new Term[]{theory.term("to_int", new Term[]{term31})});
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", new Term[]{term32, term31}), true)};
            }
            case ":to_int-high": {
                if (!theory.getLogic().isIRA()) {
                    this.reportError("Proof requires integer and real arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 1);
                Term term33 = termArray[0];
                Term term34 = theory.term("to_real", new Term[]{theory.term("to_int", new Term[]{term33})});
                Term term35 = theory.term("+", new Term[]{term34, Rational.ONE.toTerm(term33.getSort())});
                return new ProofLiteral[]{new ProofLiteral(theory.term("<", new Term[]{term33, term35}), true)};
            }
            case ":div-low": {
                if (!theory.getLogic().hasIntegers() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 2);
                Term term36 = termArray[0];
                Term term37 = termArray[1];
                Term term38 = theory.term("div", new Term[]{term36, term37});
                Term term39 = theory.term("*", new Term[]{term37, term38});
                Term term40 = Rational.ZERO.toTerm(term37.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("<=", new Term[]{term39, term36}), true), new ProofLiteral(theory.term("=", new Term[]{term37, term40}), true)};
            }
            case ":div-high": {
                if (!theory.getLogic().hasIntegers() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 2);
                Term term41 = termArray[0];
                Term term42 = termArray[1];
                Term term43 = theory.term("div", new Term[]{term41, term42});
                Term term44 = theory.term("*", new Term[]{term42, term43});
                Term term45 = theory.term("+", new Term[]{term44, theory.term("abs", new Term[]{term42})});
                Term term46 = Rational.ZERO.toTerm(term42.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("<", new Term[]{term41, term45}), true), new ProofLiteral(theory.term("=", new Term[]{term42, term46}), true)};
            }
            case ":mod-def": {
                if (!theory.getLogic().hasIntegers() && !theory.getLogic().isBitVector()) {
                    this.reportError("Proof requires integer arithmetic", new Object[0]);
                    return this.getTrueClause(theory);
                }
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (annotationArray.length == 1);
                assert (termArray.length == 2);
                Term term47 = termArray[0];
                Term term48 = termArray[1];
                Term term49 = theory.term("div", new Term[]{term47, term48});
                Term term50 = theory.term("*", new Term[]{term48, term49});
                Term term51 = theory.term("mod", new Term[]{term47, term48});
                Term term52 = theory.term("+", new Term[]{term50, term51});
                Term term53 = Rational.ZERO.toTerm(term48.getSort());
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term52, term47}), true), new ProofLiteral(theory.term("=", new Term[]{term48, term53}), true)};
            }
            case ":selectstore1": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 3);
                Term term54 = theory.term("store", new Term[]{termArray[0], termArray[1], termArray[2]});
                Term term55 = theory.term("select", new Term[]{term54, termArray[1]});
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term55, termArray[2]}), true)};
            }
            case ":selectstore2": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 4);
                Term term56 = theory.term("store", new Term[]{termArray[0], termArray[1], termArray[2]});
                Term term57 = theory.term("select", new Term[]{term56, termArray[3]});
                Term term58 = theory.term("select", new Term[]{termArray[0], termArray[3]});
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term57, term58}), true), new ProofLiteral(theory.term("=", new Term[]{termArray[1], termArray[3]}), true)};
            }
            case ":extdiff": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 2);
                Term term59 = theory.term("@diff", new Term[]{termArray[0], termArray[1]});
                Term term60 = theory.term("select", new Term[]{termArray[0], term59});
                Term term61 = theory.term("select", new Term[]{termArray[1], term59});
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{termArray[0], termArray[1]}), true), new ProofLiteral(theory.term("=", new Term[]{term60, term61}), false)};
            }
            case ":const": {
                if (!theory.getLogic().isArray()) {
                    this.reportError("Proof requires array theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 2);
                Term term62 = termArray[0];
                Term term63 = termArray[1];
                Sort sort = theory.getSort("Array", new Sort[]{term63.getSort(), term62.getSort()});
                Term term64 = theory.term("const", null, sort, new Term[]{term62});
                Term term65 = theory.term("select", new Term[]{term64, term63});
                return new ProofLiteral[]{new ProofLiteral(theory.term("=", new Term[]{term65, term62}), true)};
            }
            case ":dt-project": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)termArray[0];
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                assert (functionSymbol.isSelector());
                ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
                if (!applicationTerm2.getFunction().isConstructor()) {
                    return this.reportViolatedSideCondition(term);
                }
                DataType dataType = (DataType)applicationTerm2.getSort().getSortSymbol();
                DataType.Constructor constructor = dataType.getConstructor(applicationTerm2.getFunction().getName());
                int n = constructor.getSelectorIndex(functionSymbol.getName());
                Term term66 = applicationTerm2.getParameters()[n];
                Term term67 = theory.term("=", new Term[]{applicationTerm, term66});
                return new ProofLiteral[]{new ProofLiteral(term67, true)};
            }
            case ":dt-cons": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)termArray[0];
                if (!applicationTerm.getFunction().getName().equals("is")) {
                    return this.reportViolatedSideCondition(term);
                }
                Term term68 = applicationTerm.getParameters()[0];
                DataType dataType = (DataType)term68.getSort().getSortSymbol();
                DataType.Constructor constructor = dataType.getConstructor(applicationTerm.getFunction().getIndices()[0]);
                String[] stringArray = constructor.getSelectors();
                Term[] termArray7 = new Term[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    termArray7[n] = theory.term(stringArray[n], new Term[]{term68});
                    ++n;
                }
                Term term69 = theory.term(constructor.getName(), null, constructor.needsReturnOverload() ? term68.getSort() : null, termArray7);
                Term term70 = theory.term("=", new Term[]{term69, term68});
                return new ProofLiteral[]{new ProofLiteral((Term)applicationTerm, false), new ProofLiteral(term70, true)};
            }
            case ":dt-test+": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 1);
                ApplicationTerm applicationTerm = (ApplicationTerm)termArray[0];
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (!functionSymbol.isConstructor()) {
                    return this.reportViolatedSideCondition(term);
                }
                Term term71 = theory.term("is", new String[]{functionSymbol.getName()}, null, new Term[]{applicationTerm});
                return new ProofLiteral[]{new ProofLiteral(term71, true)};
            }
            case ":dt-test-": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Object[] objectArray = (Object[])annotationArray[0].getValue();
                assert (objectArray.length == 2);
                String string = (String)objectArray[0];
                ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[1];
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (!functionSymbol.isConstructor() || functionSymbol.getName().equals(string)) {
                    return this.reportViolatedSideCondition(term);
                }
                Term term72 = theory.term("is", new String[]{string}, null, new Term[]{applicationTerm});
                return new ProofLiteral[]{new ProofLiteral(term72, false)};
            }
            case ":dt-exhaust": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 1);
                Term term73 = termArray[0];
                DataType dataType = (DataType)term73.getSort().getSortSymbol();
                DataType.Constructor[] constructorArray = dataType.getConstructors();
                ProofLiteral[] proofLiteralArray = new ProofLiteral[constructorArray.length];
                int n = 0;
                while (n < proofLiteralArray.length) {
                    Term term74 = theory.term("is", new String[]{constructorArray[n].getName()}, null, new Term[]{term73});
                    proofLiteralArray[n] = new ProofLiteral(term74, true);
                    ++n;
                }
                return proofLiteralArray;
            }
            case ":dt-acyclic": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Object[] objectArray = (Object[])annotationArray[0].getValue();
                assert (objectArray.length == 2);
                Term term75 = (Term)objectArray[0];
                int[] nArray = (int[])objectArray[1];
                if (nArray.length == 0) {
                    return this.reportViolatedSideCondition(term);
                }
                Term term76 = term75;
                int[] nArray2 = nArray;
                int n = nArray.length;
                int n10 = 0;
                while (n10 < n) {
                    int n11 = nArray2[n10];
                    ApplicationTerm applicationTerm = (ApplicationTerm)term76;
                    if (!applicationTerm.getFunction().isConstructor()) {
                        return this.reportViolatedSideCondition(term);
                    }
                    term76 = applicationTerm.getParameters()[n11];
                    ++n10;
                }
                Term term77 = theory.term("=", new Term[]{term75, term76});
                return new ProofLiteral[]{new ProofLiteral(term77, false)};
            }
            case ":dt-match": {
                if (!theory.getLogic().isDatatype()) {
                    this.reportError("Proof requires data type theory", new Object[0]);
                    return this.getTrueClause(theory);
                }
                assert (annotationArray.length == 1);
                Term[] termArray = (Term[])annotationArray[0].getValue();
                assert (termArray.length == 1);
                if (!(termArray[0] instanceof MatchTerm)) {
                    return this.reportViolatedSideCondition(term);
                }
                MatchTerm matchTerm = (MatchTerm)termArray[0];
                Term term78 = MinimalProofChecker.buildIteForMatch(matchTerm);
                Term term79 = theory.term("=", new Term[]{matchTerm, term78});
                return new ProofLiteral[]{new ProofLiteral(term79, true)};
            }
        }
        this.reportError("Unknown axiom %s", term);
        return this.getTrueClause(term.getTheory());
    }

    private ProofLiteral[] reportViolatedSideCondition(Term term) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Side-condition violated in ");
        ProofRules.printProof(stringBuilder, term);
        this.reportError(stringBuilder.toString(), new Object[0]);
        return this.getTrueClause(term.getTheory());
    }

    private ProofLiteral[] getTrueClause(Theory theory) {
        return new ProofLiteral[]{new ProofLiteral((Term)theory.mTrue, true)};
    }

    private static Term buildLetForMatch(DataType.Constructor constructor, TermVariable[] termVariableArray, Term term, Term term2) {
        Theory theory = term.getTheory();
        Term[] termArray = new Term[termVariableArray.length];
        if (constructor == null) {
            assert (termVariableArray.length == 1);
            termArray[0] = term;
        } else {
            assert (constructor.getSelectors().length == termVariableArray.length);
            int n = 0;
            while (n < termVariableArray.length) {
                termArray[n] = theory.term(constructor.getSelectors()[n], new Term[]{term});
                ++n;
            }
        }
        return new FormulaUnLet().unlet(theory.let(termVariableArray, termArray, term2));
    }

    public static Term buildIteForMatch(MatchTerm matchTerm) {
        Theory theory = matchTerm.getTheory();
        Term term = matchTerm.getDataTerm();
        Term[] termArray = matchTerm.getCases();
        TermVariable[][] termVariableArray = matchTerm.getVariables();
        DataType.Constructor[] constructorArray = matchTerm.getConstructors();
        Term term2 = MinimalProofChecker.buildLetForMatch(constructorArray[constructorArray.length - 1], termVariableArray[constructorArray.length - 1], term, termArray[constructorArray.length - 1]);
        int n = constructorArray.length - 2;
        while (n >= 0) {
            Term term3 = MinimalProofChecker.buildLetForMatch(constructorArray[n], termVariableArray[n], term, termArray[n]);
            if (constructorArray[n] == null) {
                term2 = term3;
            } else {
                Term term4 = theory.term("is", new String[]{constructorArray[n].getName()}, null, new Term[]{term});
                term2 = theory.term("ite", new Term[]{term4, term3, term2});
            }
            --n;
        }
        return term2;
    }

    public ProofLiteral[] checkAssert(Term term) {
        ++this.mNumAssertions;
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term[] termArray = applicationTerm.getParameters();
        assert (applicationTerm.getFunction().getName() == "..assume");
        assert (termArray.length == 1);
        if (!this.mAssertions.contains(termArray[0])) {
            this.reportError("Unknown assumption: %s", termArray[0]);
            return this.getTrueClause(term.getTheory());
        }
        return new ProofLiteral[]{new ProofLiteral(termArray[0], true)};
    }

    static class DefineFunWalker
    implements NonRecursive.Walker {
        final AnnotatedTerm mProof;

        public DefineFunWalker(AnnotatedTerm annotatedTerm) {
            this.mProof = annotatedTerm;
        }

        public void enqueue(MinimalProofChecker minimalProofChecker) {
            ++minimalProofChecker.mNumDefineFun;
            Object[] objectArray = (Object[])this.mProof.getAnnotations()[0].getValue();
            FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
            LambdaTerm lambdaTerm = (LambdaTerm)objectArray[1];
            if (!(functionSymbol.isIntern() || functionSymbol.getDefinition() == null || functionSymbol.getDefinition() == lambdaTerm.getSubterm() && Arrays.equals(functionSymbol.getDefinitionVars(), lambdaTerm.getVariables()))) {
                throw new AssertionError((Object)"Inconsistent function definition.");
            }
            if (minimalProofChecker.mFunctionDefinitions.containsKey(functionSymbol)) {
                throw new AssertionError((Object)"Double function definition.");
            }
            minimalProofChecker.mFunctionDefinitions.put(functionSymbol, lambdaTerm);
            minimalProofChecker.enqueueWalker(this);
            minimalProofChecker.enqueueWalker(new ProofWalker(this.mProof.getSubterm()));
        }

        public void walk(NonRecursive nonRecursive) {
            MinimalProofChecker minimalProofChecker = (MinimalProofChecker)nonRecursive;
            Object[] objectArray = (Object[])this.mProof.getAnnotations()[0].getValue();
            FunctionSymbol functionSymbol = (FunctionSymbol)objectArray[0];
            minimalProofChecker.mFunctionDefinitions.remove(functionSymbol);
        }
    }

    static class ProofWalker
    implements NonRecursive.Walker {
        final Term mTerm;

        public ProofWalker(Term term) {
            assert (term.getSort().getName().equals("..Proof"));
            this.mTerm = term;
        }

        public void walk(NonRecursive nonRecursive) {
            ((MinimalProofChecker)nonRecursive).walk(this.mTerm);
        }
    }

    static class ResolutionWalker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public ResolutionWalker(ApplicationTerm applicationTerm) {
            this.mTerm = applicationTerm;
        }

        public void enqueue(MinimalProofChecker minimalProofChecker) {
            Term[] termArray = this.mTerm.getParameters();
            minimalProofChecker.enqueueWalker(this);
            minimalProofChecker.enqueueWalker(new ProofWalker(termArray[2]));
            minimalProofChecker.enqueueWalker(new ProofWalker(termArray[1]));
        }

        public void walk(NonRecursive nonRecursive) {
            MinimalProofChecker minimalProofChecker = (MinimalProofChecker)nonRecursive;
            ProofLiteral[] proofLiteralArray = minimalProofChecker.stackPop();
            ProofLiteral[] proofLiteralArray2 = minimalProofChecker.stackPop();
            minimalProofChecker.stackPush(minimalProofChecker.walkResolution(this.mTerm, proofLiteralArray2, proofLiteralArray), (Term)this.mTerm);
        }
    }
}

