/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCProofGenerator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.WeakCongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.Collection;

public class CCAnnotation
implements IAnnotation {
    final RuleKind mRule;
    final SymmetricPair<CCTerm> mDiseq;
    final CCTerm[][] mPaths;
    final CCTerm[] mWeakIndices;
    final DataTypeLemma mDTLemma;

    public CCAnnotation(SymmetricPair<CCTerm> symmetricPair, Collection<CongruencePath.SubPath> collection, RuleKind ruleKind) {
        this.mDiseq = symmetricPair;
        this.mPaths = new CCTerm[collection.size()][];
        this.mWeakIndices = new CCTerm[this.mPaths.length];
        int n = 0;
        for (CongruencePath.SubPath subPath : collection) {
            this.mPaths[n] = subPath.getTerms();
            this.mWeakIndices[n] = subPath instanceof WeakCongruencePath.WeakSubPath ? ((WeakCongruencePath.WeakSubPath)subPath).getIndex() : null;
            ++n;
        }
        this.mRule = ruleKind;
        this.mDTLemma = null;
    }

    public CCAnnotation(SymmetricPair<CCTerm> symmetricPair, Collection<CongruencePath.SubPath> collection, DataTypeLemma dataTypeLemma) {
        this.mDiseq = symmetricPair;
        this.mPaths = new CCTerm[collection.size()][];
        this.mWeakIndices = new CCTerm[this.mPaths.length];
        int n = 0;
        for (CongruencePath.SubPath subPath : collection) {
            this.mPaths[n] = subPath.getTerms();
            this.mWeakIndices[n] = subPath instanceof WeakCongruencePath.WeakSubPath ? ((WeakCongruencePath.WeakSubPath)subPath).getIndex() : null;
            ++n;
        }
        this.mRule = dataTypeLemma.getRule();
        this.mDTLemma = dataTypeLemma;
    }

    public SymmetricPair<CCTerm> getDiseq() {
        return this.mDiseq;
    }

    public CCTerm[][] getPaths() {
        return this.mPaths;
    }

    public CCTerm[] getWeakIndices() {
        return this.mWeakIndices;
    }

    @Override
    public Term toTerm(Clause clause, ProofRules proofRules) {
        return new CCProofGenerator(this).toTerm(clause, proofRules);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(this.mDiseq);
        int n = 0;
        while (n < this.mPaths.length) {
            if (this.mWeakIndices[n] != null) {
                stringBuilder.append(" :weak ").append(this.mWeakIndices[n]).append(' ');
            } else {
                stringBuilder.append(" :strong ");
            }
            stringBuilder.append("(");
            String string = "";
            CCTerm[] cCTermArray = this.mPaths[n];
            int n2 = cCTermArray.length;
            int n3 = 0;
            while (n3 < n2) {
                CCTerm cCTerm = cCTermArray[n3];
                stringBuilder.append(string).append(cCTerm);
                string = " ";
                ++n3;
            }
            stringBuilder.append(")");
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static enum RuleKind {
        TRANS(":trans"),
        CONG(":cong"),
        READ_OVER_WEAKEQ(":read-over-weakeq"),
        WEAKEQ_EXT(":weakeq-ext"),
        READ_CONST_WEAKEQ(":read-const-weakeq"),
        CONST_WEAKEQ(":const-weakeq"),
        DT_PROJECT(":dt-project"),
        DT_TESTER(":dt-tester"),
        DT_CONSTRUCTOR(":dt-constructor"),
        DT_CASES(":dt-cases"),
        DT_UNIQUE(":dt-unique"),
        DT_DISJOINT(":dt-disjoint"),
        DT_INJECTIVE(":dt-injective"),
        DT_CYCLE(":dt-cycle");

        String mKind;

        private RuleKind(String string2) {
            this.mKind = string2;
        }

        public String getKind() {
            return this.mKind;
        }
    }
}

