/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayMap<K, V>
extends AbstractMap<K, V> {
    private final K[] mKeys;
    private final V[] mValues;

    public ArrayMap(K[] KArray, V[] VArray) {
        if (KArray.length != VArray.length) {
            throw new IllegalArgumentException("Unequal array lengths");
        }
        this.mKeys = KArray;
        this.mValues = VArray;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private int mId = 0;

                    @Override
                    public boolean hasNext() {
                        return this.mId < (this).ArrayMap.this.mKeys.length;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new ArrayMapEntry(this.mId++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("No remove!");
                    }
                };
            }

            @Override
            public int size() {
                return ArrayMap.this.mKeys.length;
            }
        };
    }

    private class ArrayMapEntry
    implements Map.Entry<K, V> {
        private final int mId;

        public ArrayMapEntry(int n) {
            this.mId = n;
        }

        @Override
        public K getKey() {
            return ArrayMap.this.mKeys[this.mId];
        }

        @Override
        public V getValue() {
            return ArrayMap.this.mValues[this.mId];
        }

        @Override
        public V setValue(V v) {
            Object v2 = ArrayMap.this.mValues[this.mId];
            ArrayMap.this.mValues[this.mId] = v;
            return v2;
        }
    }
}

