/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout3d;

import edu.uci.ics.jung.algorithms.layout3d.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout3d.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BoundingSphere;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLayout<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    protected double stretch = 0.7;
    protected LengthFunction<E> lengthFunction;
    protected int repulsion_range = 100;
    protected double force_multiplier = 0.3333333333333333;
    int totalSteps = 2000;
    int step = 0;
    Map<E, SpringEdgeData<E>> springEdgeData = LazyMap.decorate(new HashMap(), new Transformer<E, SpringEdgeData<E>>(){

        @Override
        public SpringEdgeData<E> transform(E e) {
            return new SpringEdgeData(e);
        }
    });
    Map<V, SpringVertexData> springVertexData = LazyMap.decorate(new HashMap(), new Factory<SpringVertexData>(){

        @Override
        public SpringVertexData create() {
            return new SpringVertexData();
        }
    });
    public static final LengthFunction UNITLENGTHFUNCTION = new UnitLengthFunction(30);

    public SpringLayout(Graph<V, E> g) {
        this(g, UNITLENGTHFUNCTION);
    }

    public SpringLayout(Graph<V, E> g, LengthFunction<E> f) {
        super(g);
        this.lengthFunction = f;
    }

    public double getStretch() {
        return this.stretch;
    }

    @Override
    public void setSize(BoundingSphere bs) {
        RandomLocationTransformer rlt = new RandomLocationTransformer(bs);
        this.setInitializer(rlt);
        super.setSize(bs);
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public int getRepulsionRange() {
        return this.repulsion_range;
    }

    public void setRepulsionRange(int range) {
        this.repulsion_range = range;
    }

    public double getForceMultiplier() {
        return this.force_multiplier;
    }

    public void setForceMultiplier(double force) {
        this.force_multiplier = force;
    }

    @Override
    public void initialize() {
        Graph graph = this.getGraph();
        BoundingSphere d = this.getSize();
        if (graph != null && d != null) {
            try {
                for (Object e : graph.getEdges()) {
                    SpringEdgeData sed = this.getSpringData((E)e);
                    this.calcEdgeLength(sed, this.lengthFunction);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.initialize();
            }
        }
    }

    protected void calcEdgeLength(SpringEdgeData<E> sed, LengthFunction<E> f) {
        sed.length = f.getLength(sed.e);
    }

    @Override
    public void step() {
        ++this.step;
        try {
            for (Object v : this.getGraph().getVertices()) {
                SpringVertexData svd = this.getSpringData((V)v);
                if (svd == null) continue;
                svd.dx /= 4.0;
                svd.dy /= 4.0;
                svd.dz /= 4.0;
                svd.edgedz = 0.0;
                svd.edgedy = 0.0;
                svd.edgedx = 0.0;
                svd.repulsiondz = 0.0;
                svd.repulsiondy = 0.0;
                svd.repulsiondx = 0.0;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.step();
        }
        this.relaxEdges();
        this.calculateRepulsion();
        this.moveNodes();
    }

    protected V getAVertex(E e) {
        return this.getGraph().getIncidentVertices(e).iterator().next();
    }

    protected void relaxEdges() {
        try {
            for (Object e : this.getGraph().getEdges()) {
                V v1 = this.getAVertex(e);
                Object v2 = this.getGraph().getOpposite(v1, e);
                Object p1 = this.transform((Object)v1);
                Object p2 = this.transform(v2);
                if (p1 == null || p2 == null) continue;
                double vx = p1.getX() - p2.getX();
                double vy = p1.getY() - p2.getY();
                double vz = p1.getZ() - p2.getZ();
                double len = Math.sqrt(vx * vx + vy * vy + vz * vz);
                SpringEdgeData sed = this.getSpringData((E)e);
                if (sed == null) continue;
                double desiredLen = sed.length;
                len = len == 0.0 ? 1.0E-4 : len;
                double f = this.force_multiplier * (desiredLen - len) / len;
                double dx = (f *= Math.pow(this.stretch, this.getGraph().degree(v1) + this.getGraph().degree(v2) - 2)) * vx;
                double dy = f * vy;
                double dz = f * vz;
                SpringVertexData v1D = this.getSpringData(v1);
                SpringVertexData v2D = this.getSpringData((V)v2);
                sed.f = f;
                v1D.edgedx += dx;
                v1D.edgedy += dy;
                v1D.edgedz += dz;
                v2D.edgedx += -dx;
                v2D.edgedy += -dy;
                v2D.edgedz += -dz;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.relaxEdges();
        }
    }

    protected void calculateRepulsion() {
        try {
            for (Object v : this.getGraph().getVertices()) {
                SpringVertexData svd;
                if (this.isLocked(v) || (svd = this.getSpringData((V)v)) == null) continue;
                double dx = 0.0;
                double dy = 0.0;
                double dz = 0.0;
                for (Object v2 : this.getGraph().getVertices()) {
                    double vz;
                    double vy;
                    if (v == v2) continue;
                    Object p = this.transform(v);
                    Object p2 = this.transform(v2);
                    if (p == null || p2 == null) continue;
                    double vx = p.getX() - p2.getX();
                    double distance = vx * vx + (vy = (double)(p.getY() - p2.getY())) * vy + (vz = (double)(p.getZ() - p2.getZ())) * vz;
                    if (distance == 0.0) {
                        dx += Math.random();
                        dy += Math.random();
                        dz += Math.random();
                        continue;
                    }
                    if (!(distance < (double)(this.repulsion_range * this.repulsion_range))) continue;
                    double factor = 1.0;
                    dx += factor * vx / Math.pow(distance, 2.0);
                    dy += factor * vy / Math.pow(distance, 2.0);
                    dz += factor * vz / Math.pow(distance, 2.0);
                }
                double dlen = dx * dx + dy * dy + dz * dz;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += dx / dlen;
                svd.repulsiondy += dy / dlen;
                svd.repulsiondz += dz / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes() {
        BoundingSphere boundingSphere = this.getSize();
        synchronized (boundingSphere) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    SpringVertexData vd;
                    if (this.isLocked(v) || (vd = this.getSpringData((V)v)) == null) continue;
                    Object xyd = this.transform(v);
                    vd.dx += vd.repulsiondx + vd.edgedx;
                    vd.dy += vd.repulsiondy + vd.edgedy;
                    vd.dz += vd.repulsiondz + vd.edgedz;
                    ((Tuple3f)xyd).set((float)((double)xyd.getX() + Math.max(-5.0, Math.min(5.0, vd.dx))), (float)((double)xyd.getY() + Math.max(-5.0, Math.min(5.0, vd.dy))), (float)((double)xyd.getZ() + Math.max(-5.0, Math.min(5.0, vd.dz))));
                    BoundingSphere d = this.getSize();
                    float radius = (float)d.getRadius();
                    if (xyd.getX() < -radius) {
                        ((Tuple3f)xyd).set(-radius, xyd.getY(), xyd.getZ());
                    } else if (xyd.getX() > radius) {
                        ((Tuple3f)xyd).set(radius, xyd.getY(), xyd.getZ());
                    }
                    if (xyd.getY() < -radius) {
                        ((Tuple3f)xyd).set(xyd.getX(), -radius, xyd.getZ());
                    } else if (xyd.getY() > radius) {
                        ((Tuple3f)xyd).set(xyd.getX(), radius, xyd.getZ());
                    }
                    if (xyd.getZ() < -radius) {
                        ((Tuple3f)xyd).set(xyd.getX(), xyd.getY(), -radius);
                        continue;
                    }
                    if (!(xyd.getZ() > radius)) continue;
                    ((Tuple3f)xyd).set(xyd.getX(), xyd.getY(), radius);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.moveNodes();
            }
        }
    }

    public SpringVertexData getSpringData(V v) {
        return this.springVertexData.get(v);
    }

    public SpringEdgeData<E> getSpringData(E e) {
        return this.springEdgeData.get(e);
    }

    public double getLength(E e) {
        return this.springEdgeData.get(e).length;
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        return this.step > this.totalSteps;
    }

    @Override
    public void reset() {
        this.step = 0;
    }

    public class SpringDimensionChecker
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            SpringLayout.this.setSize(new BoundingSphere(new Point3d(), e.getComponent().getWidth()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SpringEdgeData<E> {
        public double f;
        E e;
        double length;

        public SpringEdgeData(E e) {
            this.e = e;
        }
    }

    protected static class SpringVertexData {
        public double edgedx;
        public double edgedy;
        public double edgedz;
        public double repulsiondx;
        public double repulsiondy;
        public double repulsiondz;
        public double dx;
        public double dy;
        public double dz;

        public String toString() {
            return "SVD[" + this.dx + "," + this.dy + "," + this.dz + "]" + "[" + this.repulsiondx + "," + this.repulsiondy + "," + this.repulsiondz + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UnitLengthFunction<E>
    implements LengthFunction<E> {
        int length;

        public UnitLengthFunction(int length) {
            this.length = length;
        }

        @Override
        public double getLength(E e) {
            return this.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LengthFunction<E> {
        public double getLength(E var1);
    }
}

