/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class XnfDer
extends XjunctPartialQuantifierElimination {
    private static final boolean EXTENDED_DEBUG_OUTPUT = false;

    public XnfDer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    public String getName() {
        return "destructive equality resolution";
    }

    @Override
    public String getAcronym() {
        return "DER";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    @Override
    public Term[] tryToEliminate(int n, Term[] termArray, Set<TermVariable> set) {
        Term[] termArray2 = this.tryToEliminate_SbrBased(n, termArray, set);
        return termArray2;
    }

    private Term[] tryToEliminate_EqInfoBased(int n, Term[] termArray, Set<TermVariable> set) {
        boolean bl;
        Term[] termArray2 = termArray;
        Set<TermVariable> set2 = SmtUtils.getFreeVars(Arrays.asList(termArray2));
        do {
            bl = false;
            Iterator<TermVariable> iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "eliminating " + set.size() + " quantified variables from " + termArray.length + " xjuncts");
                }
                TermVariable termVariable = iterator.next();
                if (!set2.contains(termVariable)) {
                    iterator.remove();
                    continue;
                }
                Term[] termArray3 = this.derSimple(this.mScript, n, termArray2, termVariable, this.mLogger);
                if (termArray3 == null) continue;
                termArray2 = termArray3;
                set2 = SmtUtils.getFreeVars(Arrays.asList(termArray2));
                iterator.remove();
                bl = true;
            }
        } while (bl);
        return termArray2;
    }

    private Term[] tryToEliminate_SbrBased(int n, Term[] termVariable, Set<TermVariable> set) {
        LinkedHashMap<Term, PolynomialRelation> linkedHashMap = new LinkedHashMap<Term, PolynomialRelation>();
        TermVariable termVariable2 = termVariable;
        int n2 = ((Term[])termVariable2).length;
        int n3 = 0;
        while (n3 < n2) {
            Term term = termVariable2[n3];
            linkedHashMap.put(term, null);
            ++n3;
        }
        boolean bl = true;
        Set<TermVariable> set2 = SmtUtils.getFreeVars(linkedHashMap.keySet());
        do {
            bl = false;
            Iterator<TermVariable> iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "eliminating " + set.size() + " quantified variables from " + ((TermVariable)termVariable).length + " xjuncts");
                }
                termVariable2 = iterator.next();
                if (!set2.contains(termVariable2)) {
                    iterator.remove();
                    continue;
                }
                LinkedHashMap<Term, PolynomialRelation> linkedHashMap2 = this.tryToEliminateOneVar(this.mScript, n, linkedHashMap, termVariable2);
                if (linkedHashMap2 == null) continue;
                linkedHashMap = linkedHashMap2;
                set2 = SmtUtils.getFreeVars(linkedHashMap.keySet());
                iterator.remove();
                bl = true;
            }
        } while (bl);
        return linkedHashMap.keySet().toArray(new Term[linkedHashMap.size()]);
    }

    private LinkedHashMap<Term, PolynomialRelation> tryToEliminateOneVar(Script script, int n, LinkedHashMap<Term, PolynomialRelation> linkedHashMap, TermVariable termVariable) {
        Pair<Term, SolvedBinaryRelation> pair = this.tryToSolveWithoutAssumptionsAndUpdateEntries(script, n, linkedHashMap, termVariable);
        if (pair == null) {
            return null;
        }
        return this.replace(script, linkedHashMap, (SolvedBinaryRelation)pair.getSecond(), (Term)pair.getFirst());
    }

    private Pair<Term, SolvedBinaryRelation> tryToSolveWithoutAssumptionsAndUpdateEntries(Script script, int n, LinkedHashMap<Term, PolynomialRelation> linkedHashMap, TermVariable termVariable) {
        for (Map.Entry<Term, PolynomialRelation> entry : linkedHashMap.entrySet()) {
            SolvedBinaryRelation solvedBinaryRelation;
            if (!Arrays.asList(entry.getKey().getFreeVars()).contains(termVariable) || (solvedBinaryRelation = this.tryToSolveAndUpdateEntry(script, n, termVariable, entry)) == null) continue;
            return new Pair((Object)entry.getKey(), (Object)solvedBinaryRelation);
        }
        return null;
    }

    private LinkedHashMap<Term, PolynomialRelation> replace(Script script, LinkedHashMap<Term, PolynomialRelation> linkedHashMap, SolvedBinaryRelation solvedBinaryRelation, Term term) {
        Map<Term, Term> map = Collections.singletonMap(solvedBinaryRelation.getLeftHandSide(), solvedBinaryRelation.getRightHandSide());
        LinkedHashMap<Term, PolynomialRelation> linkedHashMap2 = new LinkedHashMap<Term, PolynomialRelation>();
        for (Map.Entry<Term, PolynomialRelation> entry : linkedHashMap.entrySet()) {
            if (entry.getKey() == term) continue;
            if (Arrays.asList(entry.getKey().getFreeVars()).contains(solvedBinaryRelation.getLeftHandSide())) {
                Term term2 = this.substituteAndNormalize(map, entry.getKey());
                assert (UltimateNormalFormUtils.respectsUltimateNormalForm(term2)) : "Term not in UltimateNormalForm";
                linkedHashMap2.put(term2, null);
                continue;
            }
            linkedHashMap2.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap2;
    }

    private SolvedBinaryRelation tryToSolveAndUpdateEntry(Script script, int n, TermVariable termVariable, Map.Entry<Term, PolynomialRelation> entry) {
        SolvedBinaryRelation solvedBinaryRelation;
        if (entry.getValue() != null) {
            solvedBinaryRelation = !XnfDer.isDerRelation(n, entry.getValue().getRelationSymbol()) ? null : entry.getValue().solveForSubject(script, (Term)termVariable);
        } else {
            BinaryEqualityRelation binaryEqualityRelation = BinaryEqualityRelation.convert(entry.getKey());
            if (binaryEqualityRelation == null) {
                return null;
            }
            if (!XnfDer.isDerRelation(n, binaryEqualityRelation.getRelationSymbol())) {
                solvedBinaryRelation = null;
            } else {
                SolvedBinaryRelation solvedBinaryRelation2 = binaryEqualityRelation.solveForSubject(script, (Term)termVariable);
                if (solvedBinaryRelation2 != null) {
                    solvedBinaryRelation = solvedBinaryRelation2;
                } else {
                    PolynomialRelation polynomialRelation = PolynomialRelation.of(script, entry.getKey());
                    if (polynomialRelation == null) {
                        solvedBinaryRelation = null;
                    } else {
                        entry.setValue(polynomialRelation);
                        solvedBinaryRelation = polynomialRelation.solveForSubject(script, (Term)termVariable);
                    }
                }
            }
        }
        return solvedBinaryRelation;
    }

    private static boolean isDerRelation(int n, RelationSymbol relationSymbol) {
        if (n == 0) {
            return relationSymbol == RelationSymbol.EQ;
        }
        if (n == 1) {
            return relationSymbol == RelationSymbol.DISTINCT;
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    private SolvedBinaryRelation solveForTvBer(Script script, Term term, TermVariable termVariable) {
        BinaryEqualityRelation binaryEqualityRelation = BinaryEqualityRelation.convert(term);
        SolvedBinaryRelation solvedBinaryRelation = binaryEqualityRelation == null ? null : binaryEqualityRelation.solveForSubject(script, (Term)termVariable);
        return solvedBinaryRelation;
    }

    private Term[] derSimple(Script script, int n, Term[] termArray, TermVariable termVariable, ILogger iLogger) {
        Term[] termArray2;
        EqualityInformation equalityInformation = EqualityInformation.getEqinfo(script, (Term)termVariable, termArray, null, n);
        if (equalityInformation == null) {
            if (iLogger.isDebugEnabled()) {
                iLogger.debug((Object)new DebugMessage("not eliminated quantifier via DER for {0}", new Object[]{termVariable}));
            }
            termArray2 = null;
        } else {
            if (iLogger.isDebugEnabled()) {
                iLogger.debug((Object)new DebugMessage("eliminated quantifier via DER for {0}", new Object[]{termVariable}));
            }
            termArray2 = new Term[termArray.length - 1];
            Map<Term, Term> map = Collections.singletonMap(equalityInformation.getGivenTerm(), equalityInformation.getRelatedTerm());
            int n2 = 0;
            while (n2 < equalityInformation.getIndex()) {
                termArray2[n2] = this.substituteAndNormalize(map, termArray[n2]);
                assert (UltimateNormalFormUtils.respectsUltimateNormalForm(termArray2[n2])) : "Term not in UltimateNormalForm";
                ++n2;
            }
            n2 = equalityInformation.getIndex() + 1;
            while (n2 < termArray.length) {
                termArray2[n2 - 1] = this.substituteAndNormalize(map, termArray[n2]);
                assert (UltimateNormalFormUtils.respectsUltimateNormalForm(termArray2[n2 - 1])) : "Term not in UltimateNormalForm";
                ++n2;
            }
        }
        return termArray2;
    }

    private Term substituteAndNormalize(Map<Term, Term> map, Term term) {
        PolynomialRelation polynomialRelation;
        Term term2 = Substitution.apply(this.mMgdScript, map, term);
        if (term != term2 && (polynomialRelation = PolynomialRelation.of(this.mScript, term2)) != null) {
            term2 = polynomialRelation.toTerm(this.mScript);
        }
        return term2;
    }
}

