/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderReductionFacade;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class PartialOrderUtil {
    private PartialOrderUtil() {
    }

    public static <L> Word<L> makeWord(Class<L> clazz, Set<L> set, int ... nArray) {
        return NestedWord.nestedWord((Word)new Word((Object[])Arrays.stream(nArray).mapToObj(n -> set.stream().filter(object -> object.hashCode() == n).findAny().get()).toArray(n -> (Object[])Array.newInstance(clazz, n))));
    }

    public static <L> String printWordHashes(Word<L> word) {
        return "{ " + word.asList().stream().mapToInt(Object::hashCode).mapToObj(Integer::toString).collect(Collectors.joining(", ")) + " }";
    }

    public static <L, S> Word<L> computeRepresentative(Word<L> word, Class<L> clazz, INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IIndependenceRelation<S, L> iIndependenceRelation, IDfsOrder<L, S> iDfsOrder) {
        ArrayList<Object> arrayList = new ArrayList<Object>(word.length());
        ArrayList arrayList2 = new ArrayList(word.asList());
        Object object = iNwaOutgoingLetterAndTransitionProvider.getInitialStates().iterator().next();
        while (!arrayList2.isEmpty()) {
            ArrayList<OutgoingInternalTransition> arrayList3 = new ArrayList<OutgoingInternalTransition>();
            iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(object).forEach(arrayList3::add);
            arrayList3.sort(Comparator.comparing(OutgoingInternalTransition::getLetter, iDfsOrder.getOrder(object)));
            int n2 = arrayList2.size();
            for (OutgoingInternalTransition outgoingInternalTransition : arrayList3) {
                Object object2 = outgoingInternalTransition.getLetter();
                int n3 = arrayList2.indexOf(object2);
                if (n3 == -1) continue;
                boolean bl = true;
                int n4 = 0;
                while (n4 < n3) {
                    if (iIndependenceRelation.isIndependent(null, arrayList2.get(n4), object2) != IIndependenceRelation.Dependence.INDEPENDENT) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (!bl) continue;
                arrayList.add(object2);
                arrayList2.remove(n3);
                object = outgoingInternalTransition.getSucc();
                break;
            }
            assert (arrayList2.size() == n2 - 1) : "size must decrease in every iteration";
        }
        return new Word((Object[])arrayList.toArray(n -> (Object[])Array.newInstance(clazz, n)));
    }

    public static <L extends IIcfgTransition<?>> void checkFeasibleCounterexample(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Class<L> clazz, PartialOrderReductionFacade<L> partialOrderReductionFacade, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, Predicate<IPredicate> predicate, int[] nArray) throws AutomataOperationCanceledException {
        iLogger.warn((Object)"computing representative of feasible ctex");
        Word<L> word = PartialOrderUtil.makeWord(clazz, iNwaOutgoingLetterAndTransitionProvider.getAlphabet(), nArray);
        Word<L> word2 = PartialOrderUtil.computeRepresentative(word, clazz, iNwaOutgoingLetterAndTransitionProvider, partialOrderReductionFacade.getIndependence(0), partialOrderReductionFacade.getDfsOrder());
        iLogger.warn((Object)("Representative of feasible ctex is: " + PartialOrderUtil.printWordHashes(word2)));
        iLogger.warn((Object)"building reduced automaton");
        NestedWordAutomaton<L, IPredicate> nestedWordAutomaton = partialOrderReductionFacade.constructReduction(iNwaOutgoingLetterAndTransitionProvider, predicate);
        boolean bl = PartialOrderUtil.accepts(iUltimateServiceProvider, nestedWordAutomaton, word2);
        if (bl) {
            iLogger.warn((Object)"Representative of feasible ctex is accepted");
        }
        assert (bl) : "lost feas ctex";
    }

    private static <L> boolean accepts(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, Word<L> word) throws AutomataOperationCanceledException {
        try {
            return new Accepts(new AutomataLibraryServices(iUltimateServiceProvider), iNwaOutgoingLetterAndTransitionProvider, NestedWord.nestedWord(word), false, false).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            throw automataOperationCanceledException;
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException);
        }
    }
}

